function [Xtp1, dXt]=LogLinear(Xt,t,pourcentbruit,  ...
		      nomparam, nomparamS, paramS)
%LogLinear Compute LogLinear model = log10(Weibull)
% INPUT
% See BaranyiRoberts.m
% OUTPUT
% Xtp1(end, :) model output = log10(Nt)
% dXt: vector (number of particles)
%     derivatives of the model with respect to time.
%% ========================================================================


% Affectation des  paramètres à estimer 
lenp=length(nomparam);
for i=1:lenp
    var=Xt(i,:);
    eval([nomparam{i},'=var;'])
    clear var
end
clear lenp 
lens=length(nomparamS);
vect=ones(1,size(Xt,2));
for i=1:lens
    var=nomparamS{i};
    eval([var,'=paramS.(var).*vect;'])
end
clear vect lens

 
Xtp1=Xt;
Xtp1(end,:)=log10N0 -(t./D).^p;
%% Calcul de derivee de Nt par rapport au temps dans dXt
dXt = p .* (t./D).^ (p-1) .* (1./D);

if pourcentbruit>0
    pbruit=pourcentbruit/100;
    Xtp1(end,:)= normrnd(Xtp1(end, :), pbruit);
    clear pbruit
end
clear D  N0

%% Ramener les réponses non valides:
% log10(Nt) doit etre >0
Xtp1(end, Xtp1(end,:) < 0) = 0;

