function [Xtp1, dXt]=LogLinearT(Xt,t,pourcentbruit,  ...
		      nomparam, nomparamS, paramS)
%LogLinearT Compute LogLinearT model
% INPUT
% See BaranyiRoberts.m
% OUTPUT
% Xtp1(end, :) model output = log10(Nt)
% dXt: vector (number of particles)
%     derivatives of the model with respect to time.
%% ========================================================================


% Affectation des  paramètres à estimer 
lenp=length(nomparam);
for i=1:lenp
    var=Xt(i,:);
    eval([nomparam{i},'=var;'])
    clear var
end
clear lenp 
lens=length(nomparamS);
vect=ones(1,size(Xt,2));
for i=1:lens
    var=nomparamS{i};
    eval([var,'=paramS.(var).*vect;'])
end
clear vect lens 
Xtp1=Xt;

B= exp(-kmax.*t);
D= 10.^log10Nr;
A=10.^log10N0 - D; 
Xtp1(end,:)=log10((A.*B) + D);
%% derivée
dBt = - kmax .* B;
log10e= log10(exp(1));
num = log10e * A .* dBt;
dXt= num ./ (A .* B + D);


%% Bruiter
if pourcentbruit>0
    pbruit=pourcentbruit/100;
    Xtp1(end,:)= normrnd(Xtp1(end, :), pbruit);
    clear pbruit
end


%% Ramener les réponses non valides:
% log10(Nt) doit etre >0
Xtp1(end, Xtp1(end,:) < 0) = 0;

