function [Xtp1, dXt]=WeibullT(Xt,t,pourcentbruit,  ...
		      nomparam, nomparamS, paramS)
%WeibullT Compute WeibullT  model
% INPUT
% See BaranyiRoberts.m
% OUTPUT
% Xtp1(end, :) model output = log10(Nt)
% dXt: vector (number of particles)
%     derivatives of the model with respect to time.
%% ========================================================================


% Affectation des  paramètres à estimer 
lenp=length(nomparam);
for i=1:lenp
    var=Xt(i,:);
    eval([nomparam{i},'=var;'])
    clear var
end
clear lenp 
lens=length(nomparamS);
vect=ones(1,size(Xt,2));
for i=1:lens
    var=nomparamS{i};
    eval([var,'=paramS.(var).*vect;'])
end
clear vect lens 


Xtp1=Xt;

D = 10.^log10Nr;
fact = (t./delta).^p;
E= 10.^(-fact);
A = 10.^log10N0 -D;
Xtp1(end,:)=log10(A.*E + D);
%derivée
if t >0
  dEt = - (1/10) .^ fact .* (p/t)  * log(10) .* fact;
  log10e= log10(exp(1));
  num = log10e * A .*dEt;
  dXt = num ./ (A.*E + D);
else
    dXt=zeros(1, size(Xt,2));
end


%% Bruiter
if pourcentbruit>0
    pbruit=pourcentbruit/100;
    Xtp1(end,:)= normrnd(Xtp1(end, :), pbruit);
    clear pbruit
end

%% Ramener les réponses non valides:
% log10(Nt) doit etre >0
Xtp1(end, Xtp1(end,:) < 0) = 0;


