%% ======================================================
function  restore(obj,event)
%restore  Restaure une structure précédemment sauvegardée
% Restaure la structure qui avait été stockée
% dans un fichier de sauvegarde matlab
% INPUT
% si event est une chaine de caractères, elle contient le nom du fichier
% à restaurer. C'est le cas en mode non-interactif, où on restaure
% une précédente exécution pour la relancer, (pour comparer les
% résultats à ceux du fichier d'entrée, pour tester des modifs)
% Sinon, on est en mode interactif (cas usuel), et le nom du fichier à restaurer
% sera demandé à l'utilisateur
%% ======================================================
fileName = num2str(event);

% on sauve le nom du fichier test a cause du 'clear all' qui suit:
setenv('FILTREXTEST', fileName);

clear all; % Vider le workspace




%% Lecture du fichier de sauvegarde
fileName = getenv('FILTREXTEST');
test=0; % indique s'il s'agit d'exécuter un test


if isempty(fileName)
    [fileName, pathName] = uigetfile( ...
        [getenv('PROJECTDIR') '/IDENTIFICATION/*.mat'],  'Select a Matlab file');
    if isequal(fileName,0) || isequal(pathName,0)
        return;
    end
else
    pathName= [pwd '/'];
    setenv('FILTREXTEST', ''); %raz de la va d'environnement
    test=1;
end
chemin=fullfile(pathName, fileName);
drawnow


load(chemin);
%% Maintenant, la structure 'data' est chargée:
% on la garde dans datalu, et on charge dans 'data' ce qui est affiché
% i.e le cadre (handle) par défaut.
% On va le modifier en y mettant les valeurs lues
datalu=data;
data=guidata(1);

%% Nettoyer les eventuels résultats précédents
delete(get(data.hpanel_work,'children'))
% Nettoyer le cadre qui précise les études voulues
set(data.etude_stab_tag,'visible','on', 'value',0)
set(data.cvinparam_tag,'value',0)
set(data.hist_txt_tag, 'visible','off');
set(data.stab_txt_tag, 'visible','off');
set(data.stab_edit_tag, 'visible','off');
set(data.level_stab_txt_tag, 'visible','off');
set(data.level_stab_txt_tag, 'visible','off');
set(data.iclevel_tag, 'Visible','on');
set(data.iclevel_chaine, 'Visible','on');
set(data.hist_edit_tag,'visible','off')
set(data.hist_tag,'visible','on')
set(data.hist_tag,'value',0)
set(data.hist2_tag,'visible','off')
set(data.hist_edit_tag,'visible','off')


set(data.fichier_type_tag, 'visible', 'off');

% fichier_nom a été intoduit en oct 2014: c'est le nom du fichier des data
if isfield(datalu, 'fichier_nom')
    set(data.fichier_chemin_tag, 'string', ...
        [  datalu.fichier_nom, '  RESTORED FILENAME : ',  fileName ], 'Visible', 'on');
else
    set(data.fichier_chemin_tag, 'string', ...
['  RESTORED FILENAME : ',  fileName ], 'Visible', 'on');
end



%% Restauration du cadre qui concerne les observations
for i=1:length(data.CVs.nomparamS)
    var=data.CVs.nomparamS{i};
    tag=[var,'_tag'];
    % Quand les CVs sont a estimer, pas de valeur dans le panel du haut
    % sauf s'ils sont fixés
    try
        set(data.(tag), 'string', eval(['datalu.',var, '_in']),'backgroundcolor','w');
    end
end
% Restauration du  pas de temps des observations
set(data.uniteT_tag,'value', datalu.uniteT_in);
% Restauration de l'unite de temps
data.uniteT_pourcalcul=datalu.uniteT_pourcalcul_in;
data.uniteT_pourcalcul_libelle=datalu.uniteT_pourcalcul_libelle_in;
data.uniteT_libelle=datalu.uniteT_libelle;

data.tobsfactT = datalu.tobsfactT;
data=afficher_uniteT(data);

proposition = datalu.pas_tag_in;
set(data.pas_tag, 'string', proposition);
try
    if ( str2double(proposition) ~=1)
        set(data.deltaT_tag,'string',datalu.deltaT_in,  'enable', 'on');
    else
        set(data.deltaT_tag, 'string', '1', 'enable', 'off');
    end
end

%% Restauration du cadre qui concerne le filtre
for i=1:length(data.Filtre.nomparamS)
    var=data.Filtre.nomparamS{i};
    varin=[var, '_in'];
    if isfield(datalu, varin)
        data.(var)=datalu.(varin);
    else
        data.(var)=data.Filtre.valparamS{i}; %valeur par defaut
    end
    tag=[var,'_tag'];
    style=get(data.(tag),'style');
    if strcmpi(style, 'listbox')
        set(data.(tag),'value', data.(var),'backgroundcolor','w');
    else
        set(data.(tag),'string',data.(var),'backgroundcolor','w');
    end
end
%% Restauration des autres valeurs utiles:
data.releveobs=datalu.releveobs;
data.tobs=datalu.tobs;
data.yobs=datalu.yobs;
data.vobs_or=datalu.vobs_or;
data.nbrepet=datalu.nbrepet;
data.Nbestime=datalu.Nbestime;
data.logNbestime=datalu.logNbestime;
data.paramobs=datalu.paramobs;
data.modelepop=datalu.modelepop;


set(data.fichier_descr_tag, 'visible', 'on', ...
    'String', datalu.fichier_descr);

% rajouter la possibilite du plot des donnees
if isfield(data, 'plotdata_tag')
    set(data.plotdata_tag, 'visible', 'on');
    set(data.plotdata_tag, 'userdata', {data.tobs, data.logNbestime, fileName});
end

try
    %% Restauration du cadre qui concerne le modèle
    % D'abord, tracer le cadre avec les val par defaut:
    restore_dynamique(data,datalu);
    data=guidata(1);
    % Modification des val par defaut par celles lues sur le fichier:
    s=find(strcmpi(datalu.Basemodeles.nom,datalu.modelepop));
    
    %% Restauration de la valeur des paramètres fixes:
    nomparamfixes=datalu.Basemodeles.nomparamS{s};
    if ~isempty(nomparamfixes)
        for i=1:length(nomparamfixes)
            var=nomparamfixes{i};
            tag=[nomparamfixes{i},'_tag'];
            lin=[var,'_in'] ;
            set(data.(tag),'string',eval(['datalu.',lin]),'backgroundcolor','w');
            if any(strcmpi(nomparamfixes{i}, datalu.CVs.nomparamS))
                % le parametre est un CV
                set(data.([nomparamfixes{i},'_fixtag']), 'string',eval(['datalu.',lin]));
            end
        end
    end % length(nomparamfixes)>0
    
    %% Restauration de la valeur des paramètres à estimer:
    nomparamactifs=datalu.Basemodeles.nomparamP{s};
    
    %cocher si les CV sont estimés
    if (datalu.cvinparam_in==1)
        set(data.cvinparam_tag, 'value', 1);
    end
    if ~isempty(nomparamactifs)
        for i=1:length(nomparamactifs)
            
            var=[nomparamactifs{i},'min'];
            tag=[var,'_tag'];
            lin=[var,'_in'] ;
            set(data.(tag),'string',eval(['datalu.',lin]),'backgroundcolor','w');
            
            
            var=[nomparamactifs{i},'max'];
            tag=[var,'_tag'];
            lin=[var,'_in'] ;
            set(data.(tag),'string',eval(['datalu.',lin]),'backgroundcolor','w')
            
            var=[nomparamactifs{i},'_bruit'];
            tag=[var,'_tag'] ;
            lin=[var,'_in'] ;
            set(data.(tag),'value',eval(['datalu.',lin]),'backgroundcolor','w');
            
        end
        
    end %if paramactifs
    
end % try

%%  Restauration du panel des plots et résultats
indice_panel=0;
nombre_dynamique=datalu.stab_nombre_dynamique;
if isfield(datalu, 'level_stab')
    data.level_stab=datalu.level_stab;
else
    data.level_stab=2; %IC à 95% par defaut
end

if test==0
    if isfield(datalu,  'paramfin')
        % il y a des résultats: paramfin= valeurs estimées des parametres
        nbparam=length(datalu.nomparam);
        
        % pas d'etude de stabilité
        if nombre_dynamique <= 0
            % Pas d'étude de stabilité=> il y a des plots
            if isfield(datalu, 'structHisto') && ~isempty(datalu.structHisto)
                % On supprime l'etude de stabilite=> cacher ses cases
                set(data.stab_txt_tag,'visible','off')
                set(data.stab_edit_tag,'visible','off','string','')
                set(data.level_stab_txt_tag,'visible','off')
                set(data.level_stab_edit_tag,'visible','off','value',2)
                % il y a des histogrammes
                set(data.hist_edit_tag, 'Visible', 'on', ...
                    'String', num2str(length(datalu.structHisto)));
                set(data.hist2_tag, 'Visible', 'on', 'Value',1);
                set(data.hist_tag, 'Value',1, 'visible', 'off');
                set(data.hist_txt_tag, 'Visible', 'on');
                set(data.etude_stab_tag,'Visible', 'off', 'Position', [.38 0.05 .1 0.95]) ;
                for ihisto=1:length(datalu.structHisto)
                    [indice_panel, data] = histofiltre(indice_panel, '', data, ...
                        nbparam, datalu.nomparam, ...
                        datalu.structHisto{ihisto}{1}, datalu.structHisto{ihisto}{2});
                end
            end % fin des histo
            
            [data, indice_panel]= restore_panel_plot(data, indice_panel, datalu.filtrexplot);
            
            %% Restauration du panel des résultats
            % nmoda : les mod des parametres
            nmoda=datalu.nmoda;
            
            [data, indice_panel] = restore_panel_estimation(indice_panel, data, nbparam,...
                datalu.nomparam, datalu.paramfin, nmoda);
            data=put_indices_panels(data, indice_panel, data.hpanel_work);
        end % fin pas étude de stabilité
        
    end %fin restauration des resultats
end %fin test

%%  Restauration des panels d'étude de stabilite
%  Restauration du panel des entrées de stabilite
if nombre_dynamique > 0
    set(data.etude_stab_tag, 'value', 1, 'Position', [0.05 0.05 .1 0.95]);
    set(data.hist_tag,'visible','off')
    set(data.stab_edit_tag,'visible','on','string', nombre_dynamique)
    set(data.stab_txt_tag,'visible','on')
    set(data.level_stab_edit_tag,'visible','on', 'value', data.level_stab)
    set(data.level_stab_txt_tag,'visible','on')
    set(data.iclevel_tag', 'visible', 'off');
    set(data.iclevel_chaine', 'visible', 'off');
    
    set(data.hist_tag,'value',0)
    %  Restauration du panel des résultats  de stabilite
    if (test==0)
        if isfield(datalu, 'AC')
            % etude de stabilité et histogrammes
            m=floor(nbparam./2);
            if mod(nbparam,2)
                m=m+1;
            end
            indice_panel=indice_panel+1;
            tag=['panel' num2str(indice_panel) '_tag'];
            titre=['PARAMETER HISTOGRAMS', ' (',...
                datalu.stab_nombre_dynamique, ' dynamics)' ];
            hp2=uipanel('parent',data.hpanel_work,...
                'tag',tag,...
                'BorderType', 'none', ...
                'title', titre, ...
                'TitlePosition', 'centertop', ...
                'BackgroundColor',[1 1 1],...
                'Position',[0 .02 1 0.98]);
            data.(tag) = hp2; % 29/1/14
            for j=1:nbparam
                histostab(j, m, datalu.stab_nombre_dynamique, datalu.nomparam, datalu.AC, datalu.Basemodeles.type, hp2 );
            end
            indice_panel=indice_panel+1;
        end % fin etude de stabilité et histogrammes
        % Pour cacher le titre de l'eventuel panel précédent: un titre
        % blanc suffisamment long
        letitre='                                                                                  ';
        tag=['panel' num2str(indice_panel) '_tag'];
        hp3=uipanel('parent', data.hpanel_work,...
            'tag',tag,...
            'title', letitre, ...
            'BorderType', 'none', ...
            'TitlePosition', 'centertop', ...
            'BackgroundColor',[1 1 1],...
            'Position',[0 .02 1 0.98]);
        data.(tag) = hp3; % 29/1/14
        
        nbparammodel=length(nomparamactifs);
        nomparam=nomparamactifs;
        switch data.level_stab
            case 1
                niveau=90;
            case 2
                niveau=95;
            case 3
                niveau=99;
            otherwise
                errordlg(['INTERNAL ERROR: (etudestab) confidence level ', num2str(data.level_stab), ' unrecognized'])
        end
        nomfonction={'Parameters','Min','Max','Mean','Standard deviation', ...
            ['Statistical confidence interval (', num2str(niveau), '%)']};
        
        pasx=0.8/length(nomfonction);
        taille=length(nomfonction);
        for i=1:taille-1
            var_tag=['stab_gourpebutton' num2str(i) '_tag'];
            debutx=0.05+pasx*(i-1);
            hp=uibuttongroup('Parent', hp3,...
                'tag',var_tag,...
                'backgroundcolor',[1 1 1],...
                'Position',[debutx .1 pasx .8]);
            data.(var_tag) = hp; %29/1/14
        end
        i=taille;
        debutx=0.05+pasx*(i-1);
        pasx=pasx+0.1;
        var_tag=['stab_gourpebutton' num2str(i) '_tag'];
        hp = uibuttongroup('Parent', hp3,...
            'tag',var_tag,...
            'backgroundcolor',[1 1 1],...
            'Position',[debutx .1 pasx .8]);
        data.(var_tag) = hp; %29/1/14
        for i=1:taille
            var_tag=eval(['data.stab_gourpebutton' num2str(i) '_tag']);
            
            uicontrol('parent',var_tag,...
                'units','normalized',...
                'fontsize',13,...
                'position',[0 .95 1 .04],...
                'backgroundcolor',[1 1 1],...
                'foregroundcolor','k',...
                'style','text',...
                'string',nomfonction{i});
        end
        pasy=0.94/nbparammodel;
        for j=1:nbparammodel;
            debuty=0.94-j*pasy;
            uicontrol('parent',data.stab_gourpebutton1_tag,...
                'units','normalized',...
                'fontsize',13,...
                'position',[0 debuty 1 pasy],...
                'style','text',...
                'string',{'',traduc_nom(nomparam{j}, datalu.Basemodeles.type)});
        end
        
        
        for j=1:nbparammodel;
            for i=2:taille-1
                res=datalu.stab_res(j, i-1);
                debuty=0.94-j*pasy;
                var_tag=eval(['data.stab_gourpebutton' num2str(i) '_tag']);
                uicontrol('parent',var_tag,...
                    'units','normalized',...
                    'fontsize',15,...
                    'position',[0 debuty 1 pasy],...
                    'style','text',...
                    'string',{'',num2str(res,4)});
                
            end
            resinf=datalu.stab_res(j,5);
            ressup=datalu.stab_res(j,6);
            debuty=0.94-j*pasy;
            var_tag=eval(['data.stab_gourpebutton' num2str(taille) '_tag']);
            uicontrol('parent',var_tag,...
                'units','normalized',...
                'fontsize',15,...
                'position',[0 debuty 1 pasy],...
                'style','text',...
                'string',{'',['['   num2str(resinf,4),';',num2str(ressup,4) ']']});
            
            
        end
        data=put_indices_panels(data, indice_panel, data.hpanel_work);
    end %if test=0
end % fin etude_stab_tag



%% Affichage:
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(1, ndata)

% Si on veut se repositionner sur le 1ier panel
%  for i=1:(indice_panel - 1)
%    retrancher_tab();
%  end

end % restore

%% =================================================
function [data, indice_panel]=restore_panel_plot(data, indice_panel, ...
    filtrexplot)
%restore_panel_plot Restauration du panel des plots contenus dans une sauvegarde
% Appelé quand pas d'étude de stabilité
%% ======================================================
nbparammodel= length(filtrexplot.nomparam);

indice_panel=indice_panel+1;
tag=['panel' num2str(indice_panel) '_tag'];
data=plot_evolution_para(tag, data, ...
    nbparammodel, filtrexplot.nomparam, ...
    filtrexplot.abscisses, ...
    filtrexplot.Moyenne, ...
    filtrexplot.ICInf,  filtrexplot.ICSup, ...
    filtrexplot.nbparticules);

indice_panel=indice_panel+1;
tag=['panel' num2str(indice_panel) '_tag'];
data=plot_dyn_obs(tag, data, ...
    filtrexplot.temps, data.vobs_or, ...
    filtrexplot.pop, ...
    filtrexplot.logNbestime, ...
    filtrexplot.Moyenne, ...
    filtrexplot.ICInf, filtrexplot.ICSup);


end  % fin restore_panel_plot
%% =================================================
function [data, indice_panel]=restore_panel_estimation(indice_panel, ...
    data, nbparammodel, ...
    nomparam, paramfin, nmoda)
%restore_panel_estimation  Restauration du panel des résultats d'estimation contenus dans une sauvegarde
%% ======================================================
indice_panel=indice_panel+1;
tag=['panel' num2str(indice_panel) '_tag'];
hp2=uipanel('parent', data.hpanel_work,...
    'BorderType', 'none', ...
    'tag',tag,...
    'BackgroundColor',[1 1 1],...
    'Position',[0 .02 1 0.98]);
data.(tag) = hp2; % 29/1/14

if isnan(nmoda)
    nomfonction={'Parameters','Estimated means'};
else
    nomfonction={'Parameters','Estimated means', 'Estimated Mode'};
end
pasx=0.5/length(nomfonction);
debutx=0.25;
hp21= uibuttongroup('Parent',hp2,...
    'tag','valeur_gourpebutton1_tag',...
    'backgroundcolor',[1 1 1],...
    'Position',[debutx .1 pasx .8]);
debutx=0.25+pasx;
hp22= uibuttongroup('Parent',hp2,...
    'tag','valeur_gourpebutton2_tag',...
    'backgroundcolor',[1 1 1],...
    'Position',[debutx .1 pasx .8]);
if ~isnan(nmoda)
    debutx=0.25+2*pasx;
    hp23=uibuttongroup('Parent',hp2,...
        'tag','valeur_gourpebutton2_tag',...
        'backgroundcolor',[1 1 1],...
        'Position',[debutx .1 pasx .8]);
end

uicontrol('parent', hp21,...
    'units','normalized',...
    'fontsize',12,...
    'position',[0 .95 1 .04],...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'style','text',...
    'string','Parameters');
uicontrol('parent', hp22,...
    'units','normalized',...
    'fontsize',12,...
    'position',[0 .95 1 .04],...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'style','text',...
    'string','Estimated mean');
if ~isnan(nmoda)
    uicontrol('parent', hp23,...
        'units','normalized',...
        'fontsize',12,...
        'position',[0 .95 1 .04],...
        'backgroundcolor',[1 1 1],...
        'foregroundcolor','k',...
        'style','text',...
        'string','Estimated mode');
end
pasy=0.94/nbparammodel;
for j=1:nbparammodel;
    debuty=0.94-j*pasy;
    uicontrol('parent', hp21,...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text',...
        'string',{'',traduc_nom(nomparam{j}, data.Basemodeles.type)});
    uicontrol('parent',hp22,...
        'units','normalized',...
        'fontsize',15,...
        'position',[0 debuty 1 pasy],...
        'style','text',...
        'string',{'',num2str(paramfin(j),6)});
    
    if ~isnan(nmoda)
        uicontrol('parent',hp23,...
            'units','normalized',...
            'fontsize',15,...
            'position',[0 debuty 1 pasy],...
            'style','text',...
            'string',{'',num2str(nmoda(1,j), 6)});
    end
    
end



end % fin restore_panel_estimation
