function [ rep ]= simulvarnocte(logy,  biais0, noise, cpuis, gaussien, nrepet)
%simulvarnocte data set simulation, variance loi puissance de la réponse
% biais0=0 si pas de biais
%% ========================================================================
nobs=length(logy);

rep=zeros(nobs*nrepet, 1);
MAXRAN=1.0e+10; % il faut que 1/MAX ~=0 

iobs=1;
for i=1:nobs
    
    lesigne = randi(2, 1, 1);
     if lesigne==2
         lesigne=-1;
     end
    
    biais= lesigne*((biais0*logy(i))/100); 
    
    aux=(logy(i)*noise)/200;
        
    if ~gaussien
        %  tirage uniforme
        incer0=aux^cpuis;
        binf=logy(i)+biais-incer0;
        bsup=logy(i)+biais+incer0;
        alea = randi(MAXRAN, nrepet, 1); % nrepet nombres entre 1 et MAX
        alea=alea/MAXRAN; % nombres entre 1/MAX et 1 
        repal= binf+ (bsup-binf).*alea;
    else
        % Cas gaussien
        sig0=(aux/2)^cpuis;
        alea = normrnd(0, sig0, nrepet, 1) ;
        repal= alea+logy(i)+biais;
    end
    repal(repal<=0)=0.0001;
    rep(iobs:iobs+nrepet-1)=repal;
    iobs=iobs+nrepet;
    
end
end % fin function






                    
