
function main_modelcompar(obj,evnt)
% main_modelcompar Pilot the task "DYNAMICS COMPARISON OF TWO MODELS"
% INPUT
% 'obj' and 'evnt' are ignored, except in the non-interactive mode, i.e
% when a series of tests is run in non-interactive mode.
% In this case, 'evnt' is the name of a file which contains the results
% of a previous execution.
%% ======================================================
global input_error;
input_error=[];
% les fieldnames de cette structure seront les tags des panels où control_saisie a trouvé une erreur

bgcolor = [0.95 0.95 0.95 ];
h=figure('units','normalized',...
    'color',[1 1 1],...
    'position',[.1 .1 .8 .8],...
    'numbertitle','off',...
    'menubar','none',...
    'resize','off',...
    'tag','interface',...
    'keypressfcn',@raccourci_clavier);
if nargin ==0
    % mode interactif
    set(h,    'CloseRequestFcn',@my_closereq);
     set(h, 'userdata', {'dynamics comparison of two models', '1'});
else
    set(h,    'CloseRequestFcn',@batch_closereq);
end

% figure en plein ecran
maximize
% menus  en haut

% Pour centrer au-dessus du hpanel_control
for i=1:3
    uimenu(  'Label','      ');    
end

% Pour choisir le 1ier modèle
edit = uimenu('Label','Numerator dynamics');
% on ne laisse pas le choix du noyau a l'utilisateur car Picard a revoir
% config=uimenu(edit,'Label','Configuration');
% uimenu(config,'Label','Redistribution',...
%     'callback',@confuguration,...
%     'tag','redistribution1');
% uimenu(config,'Label','Noyau Picard','Separator','on',...
%     'callback',@confuguration,...
%     'tag','nlaplacien1');
uimenu(edit,'Label','Model equation',...
    'Accelerator','D',...
    'userdata', 1, ...
    'Callback',@dynamique)
uimenu(edit,'Label','Fix/unfix parameters',...
    'tag','dynamique1_tag',...
    'visible','off');
uimenu(edit,'Label','Set parameters to the maximal range', ...
    'tag', 'plagesmax1_tag', ...
    'userdata',1,...
    'Callback',@plagesmax_mod_comp, ...
    'visible','off');
uimenu(edit,'Label', ...
    'Reset parameters to default values', ...
    'userdata',1,...
    'visible','off', ...
    'tag', 'resetmod1_tag', ...
    'Callback',@reinit_mod_comp);
uimenu(edit,'Label','Help about model equations', ...
   'Separator','on',...
   'Callback',@help_dynamics);

% Pour choisir le 2ieme modèle
edit = uimenu('Label','Denominator dynamics');
% config=uimenu(edit,'Label','Configuration');
% uimenu(config,'Label','Redistribution',...
%     'callback',@confuguration,...
%     'tag','redistribution2');
% uimenu(config,'Label','Noyau Picard','Separator','on',...
%     'callback',@confuguration,...
%     'tag','nlaplacien2');
uimenu(edit,'Label','Model equation',...
    'Accelerator','E',...
    'userdata', 2, ...
    'Callback',@dynamique)
uimenu(edit,'Label','Fix/unfix parameters',...
    'tag','dynamique2_tag',...
    'visible','off');
uimenu(edit,'Label','Set parameters to the maximal range', ...
    'tag', 'plagesmax2_tag', ...
    'userdata',2,...
    'Callback',@plagesmax_mod_comp, ...
    'visible','off');
uimenu(edit,'Label', ...
    'Reset parameters to default values', ...
    'userdata',2,...
    'visible','off', ...
    'tag', 'resetmod2_tag', ...
    'Callback',@reinit_mod_comp);
uimenu(edit,'Label','Help about model equations', ...
   'Separator','on',...
   'Callback',@help_dynamics);

% Pour fixer les CVs
edit = uimenu('Label','CVs', 'tag', 'cv_tag', 'visible','off');
uimenu(edit,'Label','Fix/unfix CVs',...
    'tag','dynamiquecv_tag');
uimenu(edit,'Label','Set CVs to the maximal range', ...
    'tag', 'plagesmax_CV_tag', ...
    'Callback',@plagesmax_CV_comp, ...
    'visible','off');

% choix du fichier des observations
uimenu('Label','Data',...
    'Interruptible','off',...
    'Accelerator','O',...
    'Callback',@openfichier);

% Pour reinitialiser aux valeurs par défaut n'importe quelle entrée
edit = uimenu('Label','Reset to default values', 'visible','on');
uimenu(edit,'Label', ...
    'CVs', ...
    'Callback',@reinit_CV);
uimenu(edit,'Label', ...
    'Filter parameters', ...
    'Callback',@reinit_filtre);
uimenu(edit,'Label', ...
    'Numerator dynamics parameters', ...
    'userdata',1,...
       'tag', 'resetdparam1_tag', ...
       'Visible', 'off', ...
    'Callback',@reinit_mod_comp);
uimenu(edit,'Label', ...
    'Denominator dynamics parameters', ...
    'userdata',2,...
       'tag', 'resetdparam2_tag', ...
       'Visible', 'off', ...
    'Callback',@reinit_mod_comp);
uimenu(edit,'Label', 'All', ...
    'Accelerator','Z', ...
    'Callback',@reinitialiser_comparaison);


% sauvegarde/restauration
uimenu('Label','Save project',...
    'Interruptible','off',...
    'Accelerator','S',...
    'userdata', {1}, ...
    'Callback',@sauver_modele, ...
    'visible', 'on');
uimenu('Label','Restore project',...
    'Interruptible','off',...
    'Separator','on',...
    'Accelerator','R',...
    'Callback',@restore_2mod, ...
    'visible', 'on');


% Infos
helpm=uimenu('Label','Help');
uimenu(helpm, 'Label','Pratical Tips',...
    'Callback',@filtrexhelp,...
    'Accelerator','H');
uimenu(helpm, 'Label','Help about model equations', ...
   'Separator','on',...
   'Callback',@help_dynamics);

uimenu('Label','About',...
    'callback',@about);

%menus de sortie
uimenu('Label','Return to menu',...
    'Interruptible','off',...
    'userdata', {'' '2'}, ...
    'Callback',@my_closereq, ...
    'Separator','on');
uimenu('Label','Quit task',...
    'Interruptible','off',...
    'userdata', {'' '1'}, ...
    'Callback',@my_closereq, ...
    'Separator','on');
uimenu('Label','Quit FILTREX',...
    'Interruptible','off',...
    'Callback','delete(gcf)',...
    'Separator','on');
uimenu('Label','Quit Matlab',...
    'Interruptible','off',...
    'BusyAction','cancel',...
    'Callback','exit',...
    'Separator','on',...
    'Accelerator','Q');
%% fin des menus du haut
% création du panel pour les entrées
hpanel_control=uipanel('FontSize',30,...
    'borderWidth',3,...
    'backgroundcolor',bgcolor,...
    'Position',[.05 .05 0.4 .92]);
% création du panel pour l'affichage des sorties
hpanel_work=uipanel('FontSize',30,...
    'borderWidth',3,...
    'BackgroundColor',[1 1 1],...
    'Position',[.45 .05 0.5 .92]);
% titre de la figure
set(h, 'Name', sprintf('FILTREX: DYNAMICS COMPARISON OF TWO MODELS WITH THE BAYES FACTOR'));
%panels pour les entrées
groupebutton2 = uibuttongroup('Parent',hpanel_control,...
    'backgroundcolor',bgcolor,...
    'Position',[0 .5 1 .5]);
groupebutton_obs = uibuttongroup('Parent',groupebutton2,...
    'Position',[0 .85 .4 .15]);
groupebutton_filtre = uibuttongroup('Parent',groupebutton2,...
    'Position',[.4 .85 .6 .15]);
uicontrol('parent',groupebutton_obs,...
    'units','normalized',...
    'fontsize',10,...
    'foregroundcolor',[.3 .1 .5],...
    'backgroundcolor',bgcolor,...
    'position',[0 0 1 1],...
    'style','text',...
    'string',{'','OBSERVATION MODEL PARAMETERS',' '});
uicontrol('parent',groupebutton_filtre,...
    'units','normalized',...
    'fontsize',10,...
    'foregroundcolor',[.4 0 .2],...
    'backgroundcolor',bgcolor,...
    'position',[0 0 1 1],...
    'style','text',...
    'backgroundcolor',bgcolor,...
    'string',{' ','FILTER PARAMETERS',' '});
groupebutton21 = uibuttongroup('Parent',groupebutton2,...
    'Position',[0 .47 .25 .38]);
uicontrol('parent',groupebutton21,...
    'units','normalized',...
    'position',[0 0 1 1],...
    'backgroundcolor',bgcolor, ...
    'style','text');
groupebutton22 = uibuttongroup('Parent',groupebutton2,...
    'Position',[.25 .47 .15 .38]);
uicontrol('parent',groupebutton22,...
    'units','normalized',...
    'position',[0 0 1 1],...
    'backgroundcolor',bgcolor, ...
    'style','text');
groupebutton220 = uibuttongroup('Parent',groupebutton2,...
    'backgroundcolor','w', ...
    'Position',[0 .47 0.4 .1]);

groupebutton221 = uibuttongroup('Parent',groupebutton2,...
    'Position',[0.15 .47 .25 .1]);




uicontrol('parent',groupebutton221,...
    'units','normalized',...
    'foregroundcolor',[.3 .1 .5],...
    'position',[0 0 1 1],...
    'backgroundcolor',bgcolor,...
    'style','checkbox',...
    'tag','cvinparam_tag',...
    'callback',@modifier_estimer_CVs_comp,...
    'string', '     Estimate CV');
groupebutton23 = uibuttongroup('Parent',groupebutton2,...
    'Position',[.4 .47 .4 .38]);
uicontrol('parent',groupebutton23,...
    'units','normalized',...
    'position',[0 0 1 1],...
    'style','text');
groupebutton24 = uibuttongroup('Parent',groupebutton2,...
    'Position',[.8 .47 .2 .38]);
uicontrol('parent',groupebutton24,...
    'units','normalized',...
    'position',[0 0 1 1],...
    'style','text');
groupebuttontime= uibuttongroup('Parent',groupebutton2,...
    'backgroundcolor',bgcolor,...
    'Position',[0 .345 1 .13]);

groupebuttonfic= uibuttongroup('Parent',groupebutton2,...
    'backgroundcolor',bgcolor,...
    'Position',[0 0.245 1 .1]);

uicontrol('parent',groupebuttonfic,...
    'units','normalized',...
    'fontsize',11,...
    'position',[0 0 1 1],...
    'style','edit',...
    'tag','fichier_no_tag',...
    'backgroundcolor',bgcolor,...
    'string','NO DATA');
% Pour ecrire le nom du fichier de données
uicontrol('parent',groupebuttonfic,...
    'units','normalized',...
    'position',[0 0.5 1 0.5],...
    'FontSize', 11, ...
    'style','text',...
    'tag','fichier_chemin_tag',...
    'backgroundcolor',bgcolor,...
    'visible', 'off');
% Pour ecrire le nombre d'obs et repet des données
uicontrol('parent',groupebuttonfic,...
    'units','normalized',...
    'position',[0 0 1 0.5],...
    'FontSize', 10, ...
    'style','text',...
    'tag','fichier_descr_tag',...
    'backgroundcolor',bgcolor,...
    'visible', 'off');

% la case qui permet de faire le graphe des donnees lues
chart_line_icon=imread('SRC/IMG/chart_line.jpg', 'jpg');


uicontrol('parent',groupebutton2,...
    'units','normalized',...
    'position',[0.94 0.26 0.03  .06],...
    'style','pushbutton', ...
    'tag','plotdata_tag', ...
    'visible', 'off', ...
    'enable', 'inactive', ...
    'cdata', chart_line_icon, ...
    'ButtonDownFcn', @plot_obs);

uicontrol('parent',groupebutton2,...
    'units','normalized',...
    'fontsize',11,...
    'position',[0 0 1 0.245], ...
    'backgroundcolor', 'w');

% Rque 1: on ne donne pas la possibilité de faire une étude de stabilité
% car ne sert à rien dans la comparaison de modèles
% Utiliser la tâche "estimation modèle" pour cela
% Rque 2:  on ne donne pas la possibilité de demander des histogrammes
% car ne sert à rien dans la comparaison de modèles
% Utiliser "estimation modèle" pour cela



groupebutton3 = uibuttongroup('Parent',hpanel_control,...
    'Position',[0 0 1 .57],...
    'tag','groupebutton3_tag'); %1ier modele
groupebutton3b = uibuttongroup('Parent',hpanel_control,...
    'Position',[0 0 1 .57],...
    'background', 'w',...
    'tag','groupebutton3b_tag'); %2ieme modele
groupebutton3c = uibuttongroup('Parent',hpanel_control,...
    'Position',[0 0 1 .57],...
    'background', 'w',...
    'tag','groupebutton3c_tag'); % les CVs a estimer
uicontrol('parent',groupebutton3,...
    'units','normalized',...
    'fontsize',15,...
    'position',[0 0 1 1],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor',[0 0 0],...
    'tag','modele1_tag');
uicontrol('parent',groupebutton3b,...
    'units','normalized',...
    'fontsize',15,...
    'position',[0 0 1 1],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor',[0 0 0],...
    'visible','off',...
    'tag','modele2_tag');

uicontrol('parent',groupebutton3c,...
    'units','normalized',...
    'fontsize',15,...
    'position',[0 0 1 1],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor',[0 0 0],...
    'visible','off',...
    'tag','CVs_tag');
uibuttongroup('Parent',groupebutton3,...
    'Position',[.15 0 .25 .8],...
    'tag','groupebutton30_tag');
uibuttongroup('Parent',groupebutton3b,...
    'Position',[.15 0 .25 .8],...
    'tag','groupebutton30b_tag'); %pour le 2ieme modele
uibuttongroup('Parent',groupebutton3c,...
    'Position',[.15 0 .25 .8],...
    'tag','groupebutton30c_tag'); %pour les CVs

uicontrol('parent',groupebutton3,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.37 .8 .12 .05],...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'style','text',...
    'string','MIN',...
    'tag','min_tag',...
    'visible','off');
uicontrol('parent',groupebutton3b,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.37 .8 .12 .05],...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'style','text',...
    'string','MIN',...
    'tag','minb_tag',...
    'visible','off');
uicontrol('parent',groupebutton3c,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.37 .8 .12 .05],...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'style','text',...
    'string','MIN',...
    'tag','minc_tag',...
    'visible','off');
uibuttongroup('Parent',groupebutton3,...
    'Position',[.35 0 .15 .8],...
    'tag','groupebutton31_tag');
uibuttongroup('Parent',groupebutton3b,...
    'Position',[.35 0 .15 .8],...
    'tag','groupebutton31b_tag');%pour le 2ieme modele
uibuttongroup('Parent',groupebutton3c,...
    'Position',[.35 0 .15 .8],...
    'tag','groupebutton31c_tag');%pour les CVs
uicontrol('parent',groupebutton3,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.5 .8 .12 .05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'string','MAX',...
    'tag','max_tag',...
    'visible','off');
uicontrol('parent',groupebutton3b,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.5 .8 .12 .05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'string','MAX',...
    'tag','maxb_tag',...
    'visible','off');
uicontrol('parent',groupebutton3c,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.5 .8 .12 .05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'string','MAX',...
    'tag','maxc_tag',...
    'visible','off');
uibuttongroup('Parent',groupebutton3,...
    'Position',[.5 0 .15 .8],...
    'tag','groupebutton32_tag');
uibuttongroup('Parent',groupebutton3b,...
    'Position',[.5 0 .15 .8],...
    'tag','groupebutton32b_tag'); %pour le 2ieme modele
uibuttongroup('Parent',groupebutton3c,...
    'Position',[.5 0 .15 .8],...
    'tag','groupebutton32c_tag'); %pour les CVs
%le bruit
% dans cette version, il est non visible: il est fixé a la valeur par défaut
% On garde les uicontrol au cas ou on voudrait le remettre
uicontrol('parent',groupebutton3,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.6 .8 .15 .05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'string','NOISE TYPE',...
    'tag','bruit_tag',...
    'visible','off');
uicontrol('parent',groupebutton3b,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.6 .8 .15 .05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'string','NOISE TYPE',...
    'tag','bruitb_tag',...
    'visible','off');
uicontrol('parent',groupebutton3c,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.6 .8 .15 .05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'string','NOISE TYPE',...
    'tag','bruitc_tag',...
    'visible','off');
uibuttongroup('Parent',groupebutton3,...
    'Position',[.6 0 .15 .8],...
    'tag','groupebutton33_tag');
uibuttongroup('Parent',groupebutton3b,...
    'Position',[.6 0 .15 .8],...
    'tag','groupebutton33b_tag');%pour le 2ieme modele
uibuttongroup('Parent',groupebutton3c,...
    'Position',[.6 0 .15 .8],...
    'tag','groupebutton33c_tag');%pour les CVs
hgo=uicontrol('parent',hpanel_control,...
    'units','normalized',...
    'position',[ 0.92 0 0.08 0.05],...
    'FontUnits', 'normalized', ...
    'FontSize', 0.3, ...
    'interruptible','on',...
    'backgroundcolor','r',...
    'BusyAction','cancel',...
    'tag','estimation_tag',...
    'Style','pushbutton',...
    'String','GO',...
    'userdata',0,...
    'callback',@COMPARAISON_MODELE);


data = init_estimation(groupebutton21,groupebutton22,...
    groupebutton23,groupebutton24, groupebuttontime,...
    bgcolor);



% sauvegarde des identificateurs des composantes graphiques
% dans la structure handles
handles=guihandles(1);
% concatenation des deux structures handles et data
data=catstruct(handles,data);
% sauvegarde du panel d'affichage des resultats
data.hpanel_work=hpanel_work;
% sauvegarde du panel de controle
data.hpanel_control= hpanel_control;
% mise à jour de la structure principale data
guidata(1,data);
% cas non interactif d'exécution de test:
% charger un fichier de sauvegarde pour le faire réexecuter
if nargin>0
    restore_2mod(obj,evnt);
    % Execution si on a chargé un test
    COMPARAISON_MODELE(hgo,1);
end

end % fin main_modelcompar
%% ======================================================
function dynamique(obj,event)
%dynamique Choix de la dynamique d'un modele dans la comparaison de modèles
% INPUT
% Le no du modèle est dans la propriété 'userdata' de obj
% event est ignoré
%% ======================================================
global input_error;
data=guidata(gcf);
nmod=get(obj, 'userdata'); %no du modele à modifier: 1 ou 2

% Il faut choisir le modèle 1 avant de choisir le modèle 2
if nmod ~= 1 && ~isfield(data, 'modelepop1')
    errordlg('You have to select the numerator dynamics model before', 'Bad Input','modal')
    return
end


%% Se positionner sur le modèle dont on veut choisir la dynamique
try
    if str2double(get(data.num_tab_tag_control,'string')) ~= nmod
        objet=uicontrol('visible', 'off', ...
            'userdata', '_control');
        while (str2double(get(data.num_tab_tag_control,'string')) > nmod)
            retrancher_comparaison_tab(objet);
        end
        while (str2double(get(data.num_tab_tag_control,'string')) < nmod)
            ajouter_comparaison_tab(objet);
        end
    end
end


strnmod=num2str(nmod);

switch nmod
    case 1
        suffixe =''; % suffixe des groupebutton3 correspondant au modele
    case 2
        suffixe='b';
end


Basemodeles=init_Basemodeles();
data.Basemodeles=Basemodeles;


str=data.Basemodeles.nom;
[s,v] = listdlg('PromptString','Select model:',...
    'ListSize',[200 350],...
    'SelectionMode','single',...
    'ListString',str);

guidata(1,data);
if v
    input_error=[];
    
    %% stocker l'indice du panel
    indice_panel_control=nmod;
    
    tag=['panel_control' strnmod '_tag'];
    
    bouton = ['groupebutton3' suffixe '_tag'];
    set(data.(bouton),    'tag',tag);
    set(data.(bouton),  'visible', 'on')
    
    %% trace du modele
    data=trace_modele_comparaison(data, s, ...
        data.(['groupebutton30' suffixe '_tag']), ...
        data.(['groupebutton31' suffixe '_tag']), ...
        data.(['groupebutton32' suffixe '_tag']), ...
        data.(['groupebutton33' suffixe '_tag']), ...
        nmod);
    
    
    if nmod==2
        % afficher les indices des panels des modeles si non dèjà fait
        try
            get(data.num_tab_tag_control, 'string');
        catch
            
            data=put_indices_panels_comparaison (data, indice_panel_control, data.hpanel_control, '_control');
        end
	set(data.plagesmax2_tag, 'visible','on')
	set(data.resetmod2_tag, 'visible','on')
	set(data.resetdparam2_tag, 'visible','on')
    else
	set(data.plagesmax1_tag, 'visible','on')
	set(data.resetmod1_tag, 'visible','on')
	set(data.resetdparam1_tag, 'visible','on')

    end
    
    Basemodeles=data.Basemodeles;
    data.(['modelepop' strnmod])=Basemodeles.nom{s};
    nomparamP=data.Basemodeles.nomparamP{s};
    
    % detruire les parametres d'un éventuel choix précédent
    leparent = ['dynamique' strnmod '_tag'];
    delete(get(data.(leparent), 'children'));
    for i=1:length(nomparamP)
        uimenu(data.(leparent), ...
            'Label', traduc_nom(nomparamP{i}, Basemodeles.type),...
            'userdata', {nomparamP{i}, nmod}, ...
            'callback',@gestion_parametres_comparaison,...
            'checked','on');
        
    end
    if ~isfield(data, 'modelepop2')
        data.indice_panel_control= 1;
    else
        data.indice_panel_control= 2;
    end
    
    % Raz l'éventuelle estimation des Cvs précédente
    if get(data.cvinparam_tag, 'value')==1
        set(data.cvinparam_tag, 'value', 0);
        hd=uicontrol('visible', 'off', ...
            'value', 0);
        modifier_estimer_CVs_comp(hd);
        data=guidata(1);
    end
    
    set(data.(['dynamique' strnmod '_tag']),'visible','on');
    handles=guihandles;
    
    ndata=catstruct(data,handles);
    guidata(gcf,ndata)
end
end % fin dynamique
%% ======================================================
function reinit_mod_comp(obj,event)
%reinit_mod_comp Réinitialisation des valeurs  des paramètres d'un modèle
% excepté les paramètres du modèle qui sont des CVs
% INPUT
% Le no du modèle est dans la propriété 'userdata' de obj
% event est ignoré
%% ======================================================
global input_error;
data=guidata(1);
nmod=get(obj, 'userdata'); % le no du modèle
strnmod=num2str(nmod);
lemodele = ['modelepop', strnmod];

if ~isfield(data, lemodele) || isempty(data.(lemodele))
    return
end
%% Se positionner sur le modèle dont on veut réinitialiser les paramètres
try
    if str2double(get(data.num_tab_tag_control,'string')) ~= nmod
        objet=uicontrol('visible', 'off', ...
            'userdata', '_control');
        while (str2double(get(data.num_tab_tag_control,'string')) > nmod)
            retrancher_comparaison_tab(objet);
        end
        while (str2double(get(data.num_tab_tag_control,'string')) < nmod)
            ajouter_comparaison_tab(objet);
        end
    end
end

%% Reinit les paramètres du modèle

if isempty(data.(lemodele))
    return
end
modelecour=data.(lemodele);
nomCVs=data.CVs.nomparamS;
nomparam=data.(['nomparam', strnmod]);
s=find(strcmpi(data.Basemodeles.nom,modelecour));
nommodele=strrep(modelecour, '-',''); %le nom du modele sans tiret
Basemodeles=data.Basemodeles;




for i=1:length(nomparam)
    if ~isempty(nomparam{i})
        if any(strcmpi(nomparam{i},  nomCVs))
            % le parametre est  un CV: on le reinitialise via le bouton
            % spécifique
            continue
        end
        init=Basemodeles.init.(nommodele);
        % la val min
        valeur=init.(nomparam{i}){1};
        var=[nomparam{i},'min_mod', strnmod];
        tag=[var,'_tag'];
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparam{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            uniteT= get(data.uniteT_tag, 'value');
            fact=timemod2data(Basemodeles.unite.(nomparam{i}),...
                uniteT, ...
                Basemodeles.type.(nomparam{i}));
            valeur=str2double(valeur)*fact;
        end
        
        
        set(data.(tag),'string',num2str(valeur), 'backgroundcolor','w');
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        
        % la val max
        var=[nomparam{i},'max_mod', strnmod];
        tag=[var,'_tag'];
        valeur=init.(nomparam{i}){2};
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparam{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            valeur=str2double(valeur)*fact;
        end
        
        set(data.(tag),'string',num2str(valeur),'backgroundcolor','w');
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        var=[nomparam{i},'_bruit_mod', strnmod];
        tag=[var,'_tag'];
        set(data.(tag),'value',data.Basemodeles.initbruit.(nomparam{i}));
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
    end
end


nomparamS=data.Basemodeles.nomparamS{s};

for j=1:length(nomparamS)
    if ~isempty(nomparamS{j})
        if any(strcmpi(nomparamS{j},  nomCVs))
            % le parametre est  un CV: on le reinitialise via le bouton
            % spécifique
            continue
        end
        var=[nomparamS{j},'_mod', strnmod];
        tag=[var,'_tag'];
        valeur=data.Basemodeles.valparamS.(nommodele).(nomparamS{j});
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparamS{j})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            uniteT= get(data.uniteT_tag, 'value');
            fact=timemod2data(Basemodeles.unite.(nomparamS{j}),...
                uniteT, ...
                Basemodeles.type.(nomparamS{j}));
            val=data.Basemodeles.valparamS.(lemodele).(nomparamS{j});
            valeur=str2double(val)*fact;
        end
        set(data.(tag),'string',num2str(valeur), 'backgroundcolor','w')
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
    end
end
end % fin reinit_mod_comp
%% ======================================================
function reinit_CV(obj,event)
%reinit_CV  Réinitialisation des valeurs  des CVs aux valeurs par défaut
% INPUT
% obj et event sont ignorés
%% ======================================================
global input_error;

data=guidata(1);
CVs=data.CVs;

if ~isfield(data, 'num_tab_tag_control')
    return % le panel des entrées est vierge
end

if get(data.cvinparam_tag, 'value')==1
    % les CV sont a estimer
    % Se positionner sur le panel des CV  a estimer
    nmod=3;
    
    if str2double(get(data.num_tab_tag_control,'string')) ~= nmod
        objet=uicontrol('visible', 'off', ...
            'userdata', '_control');
        while (str2double(get(data.num_tab_tag_control,'string')) > nmod)
            retrancher_comparaison_tab(objet);
        end
        while (str2double(get(data.num_tab_tag_control,'string')) < nmod)
            ajouter_comparaison_tab(objet);
        end
    end
    s= find(strcmpi(data.Basemodeles.nom, data.modelepop1));
    % modèle dans lequel les CVs ont été rajoutés à la liste des paramètres à estimer
    Basemodeles=data.Basemodeles;
    nomparamP=Basemodeles.nomparamP{s};
    nomparamS=Basemodeles.nomparamS{s};
    init=Basemodeles.init;
    
    
    %% Les CV a estimer
    for i=1:length(nomparamP)
        if any(strcmpi(nomparamP{i}, CVs.nomparamS))
            % le CV est a estimer
            var=[nomparamP{i},'min'];
            tag=[var,'_tag'];
            set(data.(tag),'string',eval(init.(nomparamP{i}){1}));
            if ~isempty(input_error) && isfield(input_error, tag)
                input_error= rmfield(input_error, tag);
            end
            var=[nomparamP{i},'max'];
            tag=[var,'_tag'];
            set(data.(tag),'string',eval(init.(nomparamP{i}){2}));
            if ~isempty(input_error) && isfield(input_error, tag)
                input_error= rmfield(input_error, tag);
            end
            var=[nomparamP{i},'_bruit'];
            tag=[var,'_tag'];
            set(data.(tag),'value',Basemodeles.initbruit.(nomparamP{i}));
            if ~isempty(input_error) && isfield(input_error, tag)
                input_error= rmfield(input_error, tag);
            end
        end
    end
    
    
    %% Les CVs fixés
    for j=1:length(nomparamS)
        if  any(strcmpi(nomparamS{j}, CVs.nomparamS))
            k=find(strcmp(CVs.nomparamS, nomparamS{j}),1);
            tag=[nomparamS{j} '_tag'];
            set(data.(tag), 'string', CVs.valparamS{k});
            if ~isempty(input_error) && isfield(input_error, tag)
                input_error= rmfield(input_error, tag);
            end
            tag=[nomparamS{j} '_fixtag'];
            set(data.(tag), 'string', CVs.valparamS{k});
            if ~isempty(input_error) && isfield(input_error, tag)
                input_error= rmfield(input_error, tag);
            end
            
        end
    end
else
    % Aucun CV n'est à estimer
    for i=1:length(CVs.nomparamS)
        tag=[CVs.nomparamS{i} '_tag'];
        set(data.(tag), 'string', CVs.valparamS{i});
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
    end
end % fin CVs a estimer
end % fin reinit_CV

%% ======================================================
function reinitialiser_comparaison(obj,event)
%reinitialiser_comparaison  Réinitialisation des valeurs  de tous les champs de l'interface
% aux valeurs par défaut
%% ======================================================

data=guidata(1);


%% Reinit les paramètres du filtre et le pas de temps des calculs
reinit_filtre(obj,event);

%% reinit des modèles
for nmod=1:2
    
    
    hd=uimenu('visible', 'off', ...
        'userdata', nmod);
    reinit_mod_comp(hd);
    
end % fin nmod


%% reinit des CVs
hd=uimenu('visible', 'off');
reinit_CV(hd);

%% Affichage
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(1,ndata)


end %fin reinitialiser_comparaison
%% ======================================================
function modifier_estimer_CVs_comp(obj,event)
%modifier_estimer_CVs_comp Gestion de l'évenement "Estimer les CVs"
% INPUT
% La propriété value de obj est 1 si on veut ajouter
% l'estimation des CVs, et 0 si on veut ôter l'estimation des CVs
% event est ignoré
% OUTPUT
% En sortie, la propriété value de obj  est égale à 0 s'il y a un pbe
%% ======================================================

data=guidata(1);
try
    modelepop1=data.modelepop1;
    modelepop2=data.modelepop2;
catch
    errordlg('You have to select the dynamics models before', 'NO MODELE');
    set(obj,'value',0)
    return
end

Basemodeles=data.Basemodeles;
CVs=data.CVs;

if get(obj,'value')
    %% Ajout de l'estimation des CVs
    % Ajout de la possibilité de les fixer dans l'onglet du haut
    set(data.cv_tag, 'visible', 'on');
    % Maj de la liste des CVs dans l'onglet du haut
    leparent = 'dynamiquecv_tag';
    delete(get(data.(leparent), 'children'));
    for i=1:length(CVs.nomparamS)
        uimenu(data.(leparent), ...
	       'Label', traduc_nom(CVs.nomparamS{i}, Basemodeles.type),...
            'userdata', CVs.nomparamS{i}, ...
            'callback',@gestion_CVs,...
            'checked','on');
        
    end
    
    
    % dans le cadre des paramètres des observations, on les rend non
    % modifiables
    for c=1:length(CVs.nomparamS)
        var=[CVs.nomparamS{c},'_tag'];
        set(data.(var),'string', '-','enable','off');
    end
    
    % On rajoute les CVs à la liste des parametres de tous les modèles
    for i=1:length(Basemodeles.nomparamP)
        Basemodeles.nomparamP{i}=[Basemodeles.nomparamP{i},CVs.nomparamS];
    end
    
else
    %% On ote l'estimation des CVs
    % Ote la possibilité de les fixer
    set(data.cv_tag, 'visible', 'off');
    for c=1:length(CVs.nomparamS)
        var=[CVs.nomparamS{c},'_tag'];
        set(data.(var),'string', CVs.valparamS{c},'enable','on');
    end
    % Oter les CVs des parametres à estimer
    for i=1:length(Basemodeles.nomparamP)
        nomparam={};
        k=1;
        nomparamM=Basemodeles.nomparamP{i};
        for j=1:length(nomparamM)
            if find(strcmpi(nomparamM{j},CVs.nomparamS))
                continue
            end
            nomparam{k}=nomparamM{j};
            k=k+1;
        end
        Basemodeles.nomparamP{i}=nomparam;
    end
    
    
    % Oter les CVs des parametres fixés
    for i=1:length(Basemodeles.nomparamS)
        nomparam={};
        k=1;
        nomparamM=Basemodeles.nomparamS{i};
        for j=1:length(nomparamM)
            if find(strcmpi(nomparamM{j},CVs.nomparamS))
                continue
            end
            nomparam{k}=nomparamM{j};
            k=k+1;
        end
        Basemodeles.nomparamS{i}=nomparam;
    end
    
    
end
data.Basemodeles=Basemodeles;
guidata(1,data)

%% Affichage
if get(obj,'value')
    
    % Affichage
    indice_panel_control=3;
    data.indice_panel_control=indice_panel_control;
    tag=['panel_control' num2str(indice_panel_control) '_tag'];
    set(data.groupebutton3c_tag,    'tag',tag);
    set(data.groupebutton3c_tag,'visible', 'on');
    data=trace_CVs(data, ...
        modelepop1, modelepop2, ...
        data.groupebutton30c_tag, ...
        data.groupebutton31c_tag, data.groupebutton32c_tag, ...
        data.groupebutton33c_tag);
    data=put_indices_panels_comparaison ( data, indice_panel_control, data.hpanel_control, '_control');
    
else
    % Rendre invisible les CVs
    set(data.groupebutton3c_tag,'visible', 'off')
    set(data.groupebutton30c_tag,'visible', 'off')
    set(data.groupebutton31c_tag,'visible', 'off')
    set(data.groupebutton32c_tag,'visible', 'off')
    set(data.groupebutton33c_tag,'visible', 'off')
    % Remettre a jour les modeles
    %Afficher les modèles permet de remettre à jour la liste de leurs
    %paramètres
    
    % Rendre invisible le panel du modèle 2
    set(data.groupebutton3b_tag,'visible', 'off')
    set(data.groupebutton30b_tag,'visible', 'off')
    set(data.groupebutton31b_tag,'visible', 'off')
    set(data.groupebutton32b_tag,'visible', 'off')
    set(data.groupebutton33b_tag,'visible', 'off')
    set(data.modele2_tag, 'visible', 'off')
    
    indice_panel_control=1;
    data.indice_panel_control=indice_panel_control;
    tag=['panel_control' num2str(indice_panel_control) '_tag'];
    set(data.num_tab_tag_control,'string', '1');
    set(data.groupebutton3_tag,    'tag',tag);
    set(data.groupebutton3_tag,'visible', 'on')
    
    % Afficher le modele 1
    s=find(strcmpi(data.Basemodeles.nom,data.modelepop1));
    data=trace_modele_comparaison(data, s, data.groupebutton30_tag, ...
        data.groupebutton31_tag,data.groupebutton32_tag, ...
        data.groupebutton33_tag,1);
    
    
    drawnow
    
    % Se positionner sur le panel du modèle 2
    indice_panel_control=2;
    data.indice_panel_control=indice_panel_control;
    tag=['panel_control' num2str(indice_panel_control) '_tag'];
    set(data.num_tab_tag_control,'string', '2');
    set(data.groupebutton3b_tag,    'tag',tag);
    set(data.groupebutton3b_tag,'visible', 'on')
    
    % Afficher le modele 2
    s=find(strcmpi(data.Basemodeles.nom,data.modelepop2));
    data=trace_modele_comparaison(data, s, data.groupebutton30b_tag, ...
        data.groupebutton31b_tag,data.groupebutton32b_tag, ...
        data.groupebutton33b_tag,2);
end
%% Stocker les modifications de data
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(1,ndata)

end  %%fin modifier_estimer_CVs_comp
%% =================================================
function COMPARAISON_MODELE(obj, event)
%COMPARAISON_MODELE Pilote les calculs de la comparaison de modèles
% INPUT
% La propriété userdata de obj est 1 s'il faut arrêter
% les calculs, et 0 s'il faut les lancer
% event est ignoré
%% ======================================================
% Verifier que les entrees sont correctes
if verif_input(obj)==1
    return
end

% recuperation de la structure principale data
data=guidata(1);
% mettre le pointeur a l'etat occupe
Busy(1)
% changement de l'image du bouton d'estimation
if get(obj,'userdata')
    set(obj,'interruptible','off','userdata',0)
    return
else
    set(obj,'interruptible','on','userdata',1,'string','STOP')
end
% mise a jour des modifications graphiques
drawnow


% suppression des eventuels objets graphiques fils du panel d'affichage
delete(get(data.hpanel_work,'children'))

%% Recupération des entrées
try
    [data, tobs, deltaT, bruitetat,Fnoyau,Fpert, iclevel, ...
        tracehistogramme, nbparticules,...
        graineAlea] = recup_interface( data, event, 2);
catch
    % des entrées manquent ou sont mauvaises
    %errordlg('Des entrées manquent ou sont mauvaises');
    set(obj,'interruptible','on','userdata',0,'string','GO')
    Idle(1)
    return
end
data.nombre_dynamique=1;

%% Verifications
%  Interdire de fixer des parametres quand les modeles sont les memes
% car fixer des parametres entraine la modification de la liste des
% paramètres actifs et fixes dans l'élément de data.Basemodeles
% qui correspond au modèle
% Cette verif a déjà été faite par gestion_parametres mais il faut la refaire
% car l utilisateur peut avoir choisi un modèle 1, par exemple Barany,
% fixé des paramètres à ce modèle,
% choisi un modèle 2, puis modifié celui-ci en le fixant à Barany
% et alors la liste des paramètres du modèle Barany est modifiée
s1=find(strcmpi(data.Basemodeles.nom,data.modelepop1));
s2= find(strcmpi(data.Basemodeles.nom,data.modelepop2));
if s1==s2 && ...
        (~isempty(data.nomparamS1)|| ~isempty(data.nomparamS2) )
    errordlg('It is not possible to fix parameters when the models are identical', 'NO MODELE');
    
    set(obj,'interruptible','on','userdata',0,'string','GO')
    Idle(1)
    return
end



%% preparation de champ text pour la numerotation des panels
data.com_tab_tag = uicontrol('parent',data.hpanel_work,...
    'units','normalized',...
    'foregroundcolor','k',...
    'backgroundcolor',[1 1 1],...
    'position',[0 0  1 .02],...
    'tag','com_tab_tag',...
    'style','text');
%% modification de la couleur d'arriere-plan du panel d'affichage
set(data.hpanel_work,'backgroundcolor',[1 1 1])

%% mise a jour de la structure data
indice_panel=0;
data.indice_panel=indice_panel;

handles=guihandles;
ndata=catstruct(data,handles);
guidata(gcf,ndata);

%% Preparation des argu de filtre
vobs=0:deltaT:tobs(end); % computational times
vobs_or=convert_obs(vobs, data); % convert in the genuine time unit

%% le niveau des intervalles de confiance
switch iclevel
    case 1
        % 90%
        level=90;
    case 2
        level=95;
    case 3
        level=99;
end
icbinf=(1-level/100)/2;
icbsup= 1-icbinf;

%% Creation des structures a garder pour les plots finaux
Moyenne = { {}, {}};
temps= data.tobs; % les temps lus
pop={zeros(1,length(temps)), zeros(1,length(temps))};

%% On garde la graine aléatoire
graineAleasv = graineAlea;

%% estimation
for nmod=1:2
    strnmod=num2str(nmod);
    
    %% Effacer les éventuels résultats précédents
    if data.indice_panel>0
        for ind = data.indice_panel:-1:1
            tag = ['panel' num2str(ind) '_tag'];
            if ~isfield(data, tag)
                tag = ['panel' num2str(ind) '_mod1_tag'];
            end
            fils=allchild(data.(tag));
            for i=1:length(fils)
                set(fils(i), 'visible', 'off');
            end
            set(data.(tag), 'visible', 'off');
        end
    end
    
    
    %% random seed affectation
    % On reinitialise la graine: elle sera la même la même pour les 2 modèles
    graineAlea = graineAleasv;
    try
        RandStream.setGlobalStream(RandStream('mt19937ar','seed',graineAlea)) ; % version 2012a matlab
    catch
        try
            RandStream.setDefaultStream(RandStream('mt19937ar','seed',graineAlea)); % version 2008b-2011b matlab
        catch
            rand(graineAlea);% versions anterieures
        end
    end
    %% creation d'une barre de progression
    ssize=get(0,'screensize');
    jPb = javax.swing.JProgressBar;
    %9/1/2012    set(jPb,'StringPainted','on','Value',0,'Indeterminate','off');
    jPb.setIndeterminate(false);
    %9/1/2012    jPb.setStringpainted(true);
    hPb= javacomponent(jPb,[2*ssize(3)/4 4*ssize(4)/9 ssize(3)/3 ssize(4)/9],gcf);
    data.hPb=hPb;
    
    handles=guihandles;
    ndata=catstruct(data,handles);
    guidata(gcf,ndata);
    
    %% stockage de programme de calcul du modèle
    % Oter les eventuels  blancs dans le nom du modele
    lemodele = strrep(data.(['modelepop' strnmod]),' ', '');
    % Oter les eventuels  tirets dans le nom du modele
    lemodele = strrep(lemodele,'-', '');
    modelepop= eval(['@' lemodele]);
    
    
    %% Préparer les entrées de la fonction fetat (calcul de la dynamique)
    nomparam = data.(['nomparam' strnmod]);
    nomparamS = data.(['nomparamS' strnmod]);
    ajoutbruit = data.(['ajoutbruit' strnmod]);
    
    
    paramS={}; % paramètres fixes
    for i=1:length(nomparamS)
        paramS.(nomparamS{i}) = data.([nomparamS{i} '_mod' strnmod]);
    end
    nbrep=1;
    nbparammodel=0;
    
    
    while nbrep<=data.nombre_dynamique
        nessai=0;
        try
            if nessai >1
                errordlg(['Filtering fails at the dynamics ' ...
                    nbrep ' after ' nessai ' trials']);
                break;
            end
            nessai=nessai+1;
            [Moyenne{nmod},ET,ICInf,ICSup, nmoda, indice_panel, VraisM{nmod}, ignore ]=filtre_particulaire(modelepop,...
                @y_theorique, ...
                data.paramobs,data.yobs,nbparticules,tobs,...
                vobs, vobs_or,  deltaT, ...
                ajoutbruit,...
                bruitetat,Fnoyau,Fpert,icbinf, icbsup, ...
                indice_panel,...
                nbrep , nmod, nomparam, nomparamS, paramS, lemodele, ...
                tracehistogramme);
            
            
            
            % On regarde si l'utilisateur a demandé d'interrompre filtre
            if  (get(obj,'userdata')==0) || isempty(Moyenne)
                break
            end;
            
            nbparammodel=size(Moyenne{nmod},1)-1;
            paramfin=[Moyenne{nmod}(1:nbparammodel,end);0];
            
            nbrep=nbrep+1;
        catch err
            %DEBUG             err.identifier
            %DEBUG             err.message
            if ~ishandle(obj)% interruption via quitter
                return
            end
            
            % On regarde si l'utilisateur a demandé d'interrompre filtre
            if get(obj,'userdata')==0
                break;
            end;
            
            % changement de l'image de bouton en cas de debordement et
            % modification de la valeur de la graine
            set(obj,'backgroundcolor','r')
            drawnow
            
            graineAlea=graineAlea+nbrep;
            try
                RandStream.setGlobalStream(RandStream('mt19937ar','seed',graineAlea));% version 2012a matlab
            catch
                try
                    RandStream.setDefaultStream(RandStream('mt19937ar','seed',graineAlea));% version 2008b-2011b matlab
                catch
                    rand('state', graineAlea);% versions anterieures
                end
            end
        end
        
    end
    
    
    %% A-t-on réussi?
    if nbparammodel==0 || length(Moyenne{nmod})==0
        set(obj, 'userdata', 0)
    end
    
    %% affichage des resultats
    
    if get(obj,'userdata')==0
        % On enleve la barre de progression si elle existe
        try
            delete(data.hPb);
        end
        set(obj,'interruptible','on','userdata',0,'backgroundcolor','r','string','GO')
        return;
    end
    
    data=guidata(gcf);
    data.modelepop=lemodele; % rajouter le nom du modele pour plot_dyn_obs
    nbobs=1:size(Moyenne{nmod},2);
    m=floor(nbparammodel./2);
    if mod(nbparammodel,2)
        m=m+1;
    end
    
    % Detruire la barre de progression
    delete(data.hPb)
    
    
    
    indice_panel=indice_panel+1;
    tag=['panel' num2str(indice_panel) '_mod' strnmod '_tag'];
    
    data= plot_evolution_para(tag, data, ...
        nbparammodel, nomparam, ...
        vobs_or,Moyenne{nmod},ICInf,  ICSup, ...
        nbparticules, nmod);
    set(data.(tag), 'Visible', 'off')
    
    try
        
        for i=1:length(temps)
            t=temps(i);
            tempo=modelepop(paramfin,t,0, ...
                nomparam, nomparamS, paramS);
            pop{nmod}(i)=tempo(end);
        end
    catch
        hm=msgbox('Fail to compute the model');
        waitfor(hm);
    end % fin du try
    
    indice_panel=indice_panel+1;
    tag=['panel' num2str(indice_panel) '_mod' strnmod '_tag'];
    data=plot_dyn_obs(tag, data, ...
        temps, vobs_or, pop{nmod}, ...
         data.logNbestime, ...
        Moyenne{nmod}, ...
        ICInf, ICSup, nmod);
    set(data.com_tab_tag,'visible','off')
    indice_panel=indice_panel+1;
    tag=['panel' num2str(indice_panel) '_mod' strnmod '_tag'];
    
    
    %% Ecrire le panel des résultats
    data=ecrire_result(tag, data, ...
        nbparammodel, nomparam, paramfin, nmoda, strnmod);
    if nmod==1
        % le panel ou s'ecrit le nbre de particules retenues
        set(data.com_tab_tag,'Visible', 'on')
    end
    
    
    %% Sauvegarder les valeurs estimées des paramètres
    data.(['paramfin' strnmod]) = paramfin;
    data.(['nmod'  strnmod]) = nmoda;
    
end % fin boucle sur nmod
%% Afficher les valeurs estimées des paramètres des 2 modèles sur le même panel
indice_panel=indice_panel+1;
tag=['panel' num2str(indice_panel) '_mod12_tag'];
data=ecrire_les2mod(tag, data);

%% Calcul des facteurs de Bayes


V1surV2 = VraisM{1}./VraisM{2};
V1surV2(VraisM{2}==0)=0; 
% ajustement pb numerique
% Si l'un des rapports de vraisemblance est gros,
% le résultat de sa multiplication avec les autres deviendrait Inf
max_V=1e+20;
V1surV2(V1surV2>=max_V) = max_V;


% Facteur de Bayes
% On met les résultats dans data pour pouvoir éventuellement les restaurer
data.VraisM=VraisM;
clear VraisM;
data.FBayes=prod(V1surV2);
data.FBevolutif=cumprod(V1surV2);
clear V1surV2



%% Tracé graphique
%Effacer les sorties précédentes
fils=allchild(data.hpanel_work);
for i =1:length(fils)
    set(fils(i), 'visible','off')
end

% plot de l'évolution des estimations de chaque parametre
% commun dans les 2 modèles
[indice_panel, data]= plot_evolution_para_2mod(indice_panel, data, ...
    data.nomparam1, data.nomparam2, ...
    vobs_or,Moyenne,  nbparticules);


%plot  de l'évolution des dynamiques et de l'état
indice_panel=indice_panel+1;
tag=['panel' num2str(indice_panel) '_mod12_tag'];
data = plot_dyn_obs_2mod(tag, data, ...
    temps, vobs_or, pop, ...
    data.logNbestime, Moyenne);
%plot  de l'évolution du facteur de bayes
indice_panel=indice_panel+1;
tag=['panel' num2str(indice_panel) '_mod12_tag'];
% convertir dans l'unite de temps des donnees
tobs_or=convert_obs(tobs, data);
data=plot_fbayes(tag, data.hpanel_work, tobs_or,data.FBevolutif, data.uniteT_libelle, data);
 %% Store the calculation times in the data unit
    data.vobs_or = vobs_or;
    
%% Ecrire les facteurs de Bayes
% Mémoriser l'indice du panel courant pour pouvoir se repositionner sur la
% 1ière page des résultats en fin d'exécution, quand il y en a plusieurs
indice_cour=indice_panel+1;
[data indice_panel]=ecrire_fbayes(tag, indice_panel, data,  tobs);


%% Fin des affichages: mettre la numérotation des panels
data.indice_panel=indice_panel;
data=put_indices_panels_comparaison( data, indice_panel, data.hpanel_work,'');

handles=guihandles;
ndata=catstruct(data,handles);
guidata(gcf,ndata)

% Si on veut se remettre sur la 1iere page des résultats
% objet= uicontrol('visible', 'off', 'userdata', '');
% for i=1:(indice_panel - indice_cour)
%     retrancher_comparaison_tab(objet);
% end


%% fin Calculs des vraisemblances et du facteur de Bayes
set(obj,'interruptible','on','userdata',0,'backgroundcolor','r','string','GO')
drawnow
Idle(1)

end %    fin COMPARAISON_MODELE




%% =========================================================
function raccourci_clavier(obj,event)
% --------------------------------------
if strcmpi(event.Key,'return')
    COMPARAISON_MODELE()
end
end

%% =========================================================

