function gestion_CVs(obj,event)
% gestion_CVs
% Gérer l'evénement qui consiste à fixer ou défixer
% un CV (cas où les CVs sont à estimer) 
% INPUT
% La propriété userdata de obj doit contenir le nom du CV

%% ======================================================
data=guidata(1);

%% Interdire de fixer des parametres quand les modeles sont les memes
% car fixer des parametres entraine la modification de la liste des
% paramètres actifs et fixes dans le data.Basemodeles du modèle
% commun. Quand le modèle 1 et 2 sont les mêmes, la liste des
% paramètres actifs et fixes est donc unique.
s1=find(strcmpi(data.Basemodeles.nom,data.modelepop1));
s2= find(strcmpi(data.Basemodeles.nom,data.modelepop2));
if s1==s2 && strcmpi(get(obj,'checked'),'on')
    errordlg('You cannot fix parameters when the models are identical', 'NO MODELE');
    
    return
end


%% le nom du CV
lab=get(obj,'userdata'); %le nom du CV

%% Se positionner sur le panel des CVs a estimer
try
    if str2num(get(data.num_tab_tag_control,'string')) ~= 3
        objet=uicontrol('visible', 'off', ...
                     'userdata', '_control');
        while (str2num(get(data.num_tab_tag_control,'string')) > 3)
                    retrancher_comparaison_tab(objet);
        end
        while (str2num(get(data.num_tab_tag_control,'string')) < 3)            
                  ajouter_comparaison_tab(objet);
        end
    end
catch
 errordlg(['INTERNAL ERROR: no panel with the CVs to estimate' ]);
 
end


nomCVs=data.CVs.nomparamS;
% Les CVs ont déjà été rajoutés à la liste des paramètres à estimer des modèles
s1= find(strcmpi(data.Basemodeles.nom, data.modelepop1));
s2= find(strcmpi(data.Basemodeles.nom, data.modelepop2));

nomparamP=data.Basemodeles.nomparamP{s1};
nomparamS=data.Basemodeles.nomparamS{s1};


%% On garde les valeurs courantes des param pour pouvoir
%% rétablir celles qui n'ont pas été fixées/défixées
datalu=data;
ncv=0; % nbre de CV restant a estimer

for i=1:length(nomCVs)
    if any(strcmpi(nomCVs{i}, nomparamP))
        % le CV est a estimer
        ncv=ncv+1;
        var=[nomCVs{i},'max'];
        tag=[var,'_tag'];
        lin=[var,'_in'];        
        datalu.(lin)=str2double(get(data.(tag),'string'));

        var=[nomCVs{i},'min'];
        tag=[var,'_tag'];
        lin=[var,'_in'];
        datalu.(lin)=str2double(get(data.(tag),'string'));
        
        var=[nomCVs{i},'_bruit'];
        tag=[var,'_tag'];
        lin=[var,'_in'];
        datalu.(lin)=get(data.(tag),'value');
    end % fin CV a estimer
    if any(strcmpi(nomCVs{i}, nomparamS))
        % le CV est fixé
        tag=[nomCVs{i},'_tag'];
        lin=[nomCVs{i},'_in'];               
        datalu.(lin)=str2double(get(data.(tag),'string'));       
    end
end % fin i

%% fin sauvegarde
% Il faudra modifier la liste des paramètres à estimer/fixer
% des 2 modèles: listemod=leur liste
if s1 == s2
    listemod={s1};
else
listemod = {s1, s2};
end

if strcmpi(get(obj,'checked'),'on')
    % On fixe un CV
    if ncv==1
        errordlg('At least, one CV should be to estimated','Fixation limit','modal')
        return
    end
    
    for imod = 1:length(listemod)
        nmod=listemod{imod};
        % Maj de la liste des parametres a estimer des modeles
        nomparam={};
        nomparamP=data.Basemodeles.nomparamP{nmod};
        vp=find(strcmpi(nomparamP,lab));
        j=1;
        for i=1:length(nomparamP)
            if i==vp
                continue
            end
            nomparam{j}=nomparamP{i};
            j=j+1;
        end
        data.Basemodeles.nomparamP{nmod}=nomparam;
        % Maj de la liste des parametres fixes des modeles
        nomparamS=data.Basemodeles.nomparamS{nmod};
        nomparamS{end+1}=lab;
        data.Basemodeles.nomparamS{nmod}=nomparamS;
        
    end % fin nmod
    
    set(obj,'checked','off')
    
    
    % On met la valeur fixée dans le panel des parametres du modele
    % d'observations
    set(data.([lab '_tag']), 'string', num2str(data.(lab)));
    
   
else
    % on défixe un CV
    for imod = 1:length(listemod)
        nmod=listemod{imod};
        % Maj de la liste des parametres fixes des modeles
        nomparam={};
        nomparamS=data.Basemodeles.nomparamS{nmod};
        vp=find(strcmpi(nomparamS,lab));
        j=1;
        for i=1:length(nomparamS)
            if i==vp
                continue
            end
            nomparam{j}=nomparamS{i};
            j=j+1;
        end
        data.Basemodeles.nomparamS{nmod}=nomparam;
        % Maj de la liste des parametres a estimer
        vect={};
        nomparamP=data.Basemodeles.nomparamP{nmod};
        k=1;
        trouve=1;
        for i=1:length(nomparamP)
            if find(strcmpi(nomparamP{i},'CVpesee'))
                vect{k}=lab;
                k=k+1;
                trouve=0;
            end
            vect{k}=nomparamP{i};
            k=k+1;
        end
        if trouve
            vect{end+1}=lab;
        end
        data.Basemodeles.nomparamP{nmod}=vect;
    end % fin nmod
    % On met '-' dans le panel des parametres du modele
    % d'observations
    set(data.([lab '_tag']), 'string', '-');
    set(obj,'checked','on')
    
end
guidata(1,data);
data=trace_CVs(data, ...
    data.modelepop1, data.modelepop2, ...
    data.groupebutton30c_tag, ...
    data.groupebutton31c_tag, data.groupebutton32c_tag, ...
    data.groupebutton33c_tag);

guidata(1,data);
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(gcf,ndata)
data=guidata(1);

%% Restauration de la valeur des CVs non modifiés
nomparamP=data.Basemodeles.nomparamP{listemod{1}};
nomparamS=data.Basemodeles.nomparamS{listemod{1}};

%% On remet les valeurs des CVs qui n'ont pas été fixés
for i=1:length(nomCVs)
    if any(strcmpi(nomCVs{i}, nomparamP)) && strcmp(nomCVs{i}, lab)==0
        % le CV est a estimer
     var=[nomCVs{i},'min'];
    tag=[var,'_tag'];
    lin=[var '_in'] ;
    
    %On teste que la valeur min du parametre existe, car s'il s'agit
    % d'un CV précédemment fixé, celle-ci n'existe pas.
    % Dans ce cas, c'est le min par défaut qui s'affichera
    try
        set(data.(tag),'string', eval(['datalu.',lin]), 'backgroundcolor','w')
    end
    
    
    var=[nomCVs{i},'max'];
    tag=[var,'_tag'];
    lin=[var ,'_in'] ;
    try
        set(data.(tag),'string',eval(['datalu.',lin]),'backgroundcolor','w')
    end
    
    var=[nomCVs{i},'_bruit'];
    tag=[var,'_tag'] ;
    lin=[var '_in'] ;
    try
        set(data.(tag),'value',eval(['datalu.',lin]),'backgroundcolor','w');
    end
    end %  fin le CV est a estimer
end


%% On remet les valeurs des parametres qui n'ont pas été défixés
for i=1:length(nomCVs)
if any(strcmpi(nomCVs{i}, nomparamS)) && strcmp(nomCVs{i}, lab)==0
        % le CV est fixé
    tag=[nomCVs{i},'_tag'];
    lin=[nomCVs{i}, '_in'] ;
   
    try
  %On met la valeur dans le cadre du haut
      set(data.(tag),'string', eval(['datalu.',lin]), 'backgroundcolor','w')
     % on met la valeur dans le panel des CVs
     tag=[nomCVs{i},'_fixtag'];
     set(data.(tag),'string', eval(['datalu.',lin]), 'backgroundcolor','w')
     
    end
end % fin le CV est fixé
end



%% Affichage
  handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(1,ndata)


end % fin gestion_CVs

