
function gestion_parametres_comparaison(obj,event)
% gestion_parametres_comparaison
% Gérer l'evénement qui consiste à fixer ou défixer
% un paramètre du modèle
% INPUT
% Le nom du paramètre est dans la propriété 'userdata{1}' de obj
% Le no du modèle est dans la propriété 'userdata{2}' de obj
% event est ignoré

%% ======================================================
data=guidata(1);
userdata=get(obj, 'userdata');
lab=userdata{1}; %le nom du paramètre
nmod = userdata{2}; % no du modele


%% Interdire de fixer des parametres quand les modeles sont les memes
% car fixer des parametres entraine la modification de la liste des
% paramètres actifs et fixes dans le data.Basemodeles du modèle
% commun. Quand le modèle 1 et 2 sont les mêmes, la liste des
% paramètres actifs et fixes est donc unique.
s1=find(strcmpi(data.Basemodeles.nom,data.modelepop1));
if isfield(data, 'modelepop2')
s2= find(strcmpi(data.Basemodeles.nom,data.modelepop2));
if s1==s2 && strcmpi(get(obj,'checked'),'on')
    errordlg('You cannot fix parameters when the models are identical', 'NO MODELE');
    
    return
end
end

if nmod==1
    s=s1;
else
    s=s2;
end

strnmod = num2str(nmod);

%% Se positionner sur le modèle dont on veut fixer les paramètres
try
    if str2double(get(data.num_tab_tag_control,'string')) ~= nmod
       objet=uicontrol('visible', 'off', ...
                     'userdata', '_control');
        while (str2double(get(data.num_tab_tag_control,'string')) > nmod)
                    retrancher_comparaison_tab(objet);
        end
        while (str2double(get(data.num_tab_tag_control,'string')) < nmod)            
                  ajouter_comparaison_tab(objet);
        end
    end
end

data=guidata(1);    
nomCVs=data.CVs.nomparamS;
nomparamP=data.Basemodeles.nomparamP{s};
nomparamS=data.Basemodeles.nomparamS{s};
nomparam={};
vect={};

%% On garde les valeurs courantes des param pour pouvoir
% rétablir celles qui n'ont pas été fixées/défixées
datalu=data;

for i=1:length(nomparamP)
     if any(strcmpi(nomparamP{i}, nomCVs))
        % le parametre est un CV a estimer
        cv=1;
        var= [nomparamP{i},'max'];
     else
    var=[nomparamP{i},'max_mod', strnmod];
    cv=0;
     end
    tag=[var,'_tag'];
    lin=[var,'_in'];
        
    eval(['datalu.',lin,'=eval(get(data.(tag),''string''));']);
    
    if cv==1
        var=[nomparamP{i},'min'];
    else
    var=[nomparamP{i},'min_mod', strnmod];
    end
    tag=[var,'_tag'];
    lin=[var,'_in'];
    eval(['datalu.',lin,'=eval(get(data.(tag),''string''));']);
    
    if cv==1
        var=[nomparamP{i},'_bruit'];
    else
    var=[nomparamP{i},'_bruit_mod', strnmod];
    end
    tag=[var,'_tag'];
    lin=[var,'_in'];
    eval(['datalu.',lin,'=get(data.(tag),''value'');']);
end
for i=1:length(nomparamS)
    if any(strcmpi(nomparamS{i}, nomCVs))
        % le parametre est un CV 
        var=nomparamS{i};
    else
    var=[nomparamS{i}, '_mod', strnmod];
    end
    tag=[var,'_tag'];
    lin=[var,'_in'];
        eval(['datalu.',lin,'=eval(get(data.(tag),''string''));']);
end
%% fin sauvegarde

if strcmpi(get(obj,'checked'),'on')
    if length(nomparamP)==1
        errordlg('At least one parameter should be to estimated','Fixation limit','modal')
        return
    end
    vp=find(strcmpi(nomparamP,lab));
    j=1;
    for i=1:length(nomparamP)
        if i==vp
            continue
        end
        nomparam{j}=nomparamP{i};
        j=j+1;
    end
    set(obj,'checked','off')
    data.Basemodeles.nomparamP{s}=nomparam;
    nomparamS{end+1}=lab;
    data.Basemodeles.nomparamS{s}=nomparamS;
    guidata(1,data);
    if nmod==1
     data=trace_modele_comparaison(data, s, data.groupebutton30_tag, ...
        data.groupebutton31_tag, data.groupebutton32_tag, ...
        data.groupebutton33_tag,    nmod);
    else
       data= trace_modele_comparaison(data,s, data.groupebutton30b_tag, ...
        data.groupebutton31b_tag, data.groupebutton32b_tag, ...
        data.groupebutton33b_tag,    nmod);
    end
    
else
    vp=find(strcmpi(nomparamS,lab));
    j=1;
    for i=1:length(nomparamS)
        if i==vp
            continue
        end
        nomparam{j}=nomparamS{i};
        j=j+1;
    end
    set(obj,'checked','on')
    data.Basemodeles.nomparamS{s}=nomparam;
    k=1;
    trouve=1;
    for i=1:length(nomparamP)
        if find(strcmpi(nomparamP{i},'CVpesee'))
            vect{k}=lab;
            k=k+1;
            trouve=0;
        end
        vect{k}=nomparamP{i};
        k=k+1;
    end
    if trouve
        vect{end+1}=lab;
    end
    data.Basemodeles.nomparamP{s}=vect;
end
guidata(1,data);
if nmod==1
data=trace_modele_comparaison(data,s, data.groupebutton30_tag, ...
        data.groupebutton31_tag, data.groupebutton32_tag, ...
        data.groupebutton33_tag,    nmod);
else
 data=   trace_modele_comparaison(data,s, data.groupebutton30b_tag, ...
        data.groupebutton31b_tag, data.groupebutton32b_tag, ...
        data.groupebutton33b_tag,    nmod);
end
    
data=guidata(gcf);


%% Restauration de la valeur des paramètres
%% qui n'ont pas été modifiés
nomparamP=data.Basemodeles.nomparamP{s};
nomparamS=data.Basemodeles.nomparamS{s};

%% On remet les valeurs des parametres qui n'ont pas été fixés
for i=1:length(nomparamP)
    var=[nomparamP{i},'min_mod', strnmod];
    tag=[var,'_tag'];
    lin=[var,'_in'] ;
    
    %On teste que la valeur min du parametre, car s'il s'agit
    % d'un parametre précédemment fixé, celle-ci n'existe pas.
    % Dans ce cas, c'est le min par défaut qui s'affichera
    try
        set(data.(tag),'string', eval(['datalu.',lin]), 'backgroundcolor','w')
    end
    
    
    var=[nomparamP{i},'max_mod', strnmod];
    tag=[var,'_tag'];
    lin=[var,'_in'] ;
    try
        set(data.(tag),'string',eval(['datalu.',lin]),'backgroundcolor','w')
    end
    
    var=[nomparamP{i},'_bruit_mod', strnmod];
    tag=[var,'_tag'] ;
    lin=[var,'_in'] ;
    try
        set(data.(tag),'value',eval(['datalu.',lin]),'backgroundcolor','w');
    end
    
end


%% On remet les valeurs des parametres qui n'ont pas été défixés
for i=1:length(nomparamS)
    var=[nomparamS{i}, '_mod', strnmod];
    tag=[var,'_tag'];
    lin=[var,'_in'] ;
    
    %On teste que la valeur min du parametre, car s'il s'agit
    % d'un parametre précédemment a estimer, celle-ci n'existe pas.
    % Dans ce cas, c'est la val min par défaut qui s'affichera
    try
        set(data.(tag),'string', eval(['datalu.',lin]), 'backgroundcolor','w')
    end
end

%% Affichage
guidata(1,data);



end % fin gestion_parametres_comparaison
