function [indice_panel, data]= plot_evolution_para_2mod(indice_panel, data, ...
    nomparam1, nomparam2, ...
    abscisses,Moyenne,  nbparticules)
% plot_evolution_para_2mod
% Trace graphique des evolutions des estimations des paramètres
% par les 2 modèles pour les paramètres communs
% Fonction appelée quand pas d'étude de stabilité
% (Cas de la comparaison de modèles)
% INPUT/OUTPUT
% indice_panel: indice du dernier panel écrit

%% ======================================================

%% Determiner les paramètres communs
nbparam=0;
indice1=[];
indice2=[];
for i=1:length(nomparam1)
   j=find(strcmp(nomparam1{i}, nomparam2));
   if ~isempty(j)
      % parametre en commun
       nbparam=nbparam+1;
      indice1(nbparam) = i;
      indice2(nbparam)= j;
  end
end

if nbparam==0
% aucun parametre commun
  return
end


% Mettre dans une structure 'filtrexplot' situé dans 'base'
% ce qui est nécessaire aux graphiques de façon à pouvoir
% les retracer si clic droit dessus ou restauration de data
sauve_hp('filtrexplot', 2,  'nbparticules', nbparticules, ...
   'nomparam1', nomparam1, ...
   'nomparam2', nomparam2, ...
    'abscisses' , abscisses,...
    'uniteT_libelle', data.uniteT_libelle, ...
'indice1', indice1, ...
'indice2', indice2, ...
 'Moyenne1',Moyenne{1},'Moyenne2',Moyenne{2} );

m=floor(nbparam./2);
if mod(nbparam,2)
    m=m+1;
end

% Fixer les couleurs
couleur1='b'; % bleu pour le modèle 1
couleur2=[0 128 0]/255; %un vert pour le modèle 2

indice_panel=indice_panel+1;
 tag=['panel' num2str(indice_panel) '_mod12_tag'];


hp2=uipanel('parent',data.hpanel_work,...
    'tag',tag,...
    'BorderType', 'none', ...
    'BackgroundColor',[1 1 1],...
    'Position',[0 .02 1 0.98]);
titre='Both models: PARTICLE ESTIMATION EVOLUTION ';
hptitre= uipanel('parent',hp2,...
    'BackgroundColor',[1 1 1],...
    'BorderType', 'none', ...
    'Position', [0 0.965 1 0.035]);


for numfig=1:nbparam
        descript=traduc_nom(nomparam1{indice1(numfig)}, data.Basemodeles.type);
    subplot(m,2,numfig,'parent',hp2)
    
    plot(abscisses,Moyenne{1}(indice1(numfig),:), 'Color', couleur1);
    hold on
    plot(abscisses,Moyenne{2}(indice2(numfig),:), 'Color', couleur2);
    
    set(gca,'buttondownfcn',{@dessin_hp2_2mod, numfig})
    
% title(['EVOLUTION DES ESTIMATIONS DU PARAMÈTRE '    descript]);
title(['PARAMETER '    descript]);
    xlabel(['time (' data.uniteT_libelle ')'])
%    ylabel([num2str(nbparticules) ' particules'])
end % fin numfig
%legend('Moyenne 1 (modèle au numérateur)','Moyenne 2 (modèle au dénominateur)',0,'location',[.79 .01 .2 .05])

legend('numerator model', 'denominator model', ...
 0,'location',[.4 .018 .2 .05])
hax= axes('Position', [0 0 1 1],'parent',hptitre, 'Visible', 'off');
text(0.5, 0.08, titre, 'FontSize',12,'HorizontalAlignment','center', 'Parent', hax)

data.(tag)=hp2; % 29/1/2014, Matlab R2013a

end % fin plot_evolution_para_mod2
%% ======================================================
function  dessin_hp2_2mod(obj, evt, numfig)
% dessin_hp2_2mod
% Tracé graphique dans une fenêtre graphique Matlab du panel hp2
% (cas de la comparaison de modèles)

%% ======================================================
donnees = evalin('base', 'filtrexplot');

hfig=figure('Name', 'Evolution');
hax =   axes( 'parent', hfig);

descript=traduc_nom(donnees.nomparam1{donnees.indice1(numfig)});
% Fixer les couleurs
couleur1='b'; % bleu pour le modèle 1
couleur2=[0 128 0]/255; %un vert pour le modèle 2

plot(hax, donnees.abscisses,...
     donnees.Moyenne1(donnees.indice1(numfig),:), 'Color', couleur1);
 hold on
 plot(hax,    donnees.abscisses,...
     donnees.Moyenne2(donnees.indice2(numfig),:),'-', 'Color', couleur2)
title(['ESTIMATION EVOLUTION OF '    descript]);
%title(['EVOLUTION DES ESTIMATIONS DU PARAMÈTRE ' descript])
xlabel(['time (' donnees.uniteT_libelle ')'])
%ylabel([num2str(donnees.nbparticules) ' particules'])

legend('numerator model', 'denominator model', 0)

end % dessin_hp2_2mod
