function data = plot_fbayes( tag, hpanel_work,tobs_or, bayes, uniteT_libelle, data)
% plot_fbayes
% Trace graphique des facteurs de Bayes en fonction des temps d'observations
% Cette fonction est appelée directement par COMPARAISON_MODELE pour faire
% le tracé graphique. L'utilisateur peut cliquer sur la figure
% affichée pour reproduire le dessin dans une figure Matlab (ce qui lui
% permet de la sauver dans un fichier, par exemple). Quand la fonction est
% invoquée via un double-clic, elle n'a que 3 arguments: les 2 premiers
% arguments sont l'objet appelant et l'évenement associé. Le 3ième est une
% structure contenant les entrées nécessaires au tracé graphique
% Quand elle est appelée par programme, elle a tous ses arguments.

%% =================================================
direct=(nargin==6);

if (direct==1)
    hp3=uipanel('parent', hpanel_work,...
        'tag',tag,...
        'Bordertype', 'none', ...
        'BackgroundColor',[1 1 1],...
        'Position',[0 .02 1 0.98]);
    data.(tag) = hp3; % 29/1/2014, Matlab R2013a
    hg=subplot(1,1,1, 'parent', hp3);
else %appel par double-clic
    figure('Name', 'Bayes factors');
    % tobs_or est une structure contenant les entrées
    entrees=tobs_or;
    fields= fieldnames(entrees);
    for i=1:length(fields)
        eval([fields{i} '=entrees.' fields{i} ';']);
    end
    
end


fbayes=bayes;
%% Les Bornes
% <10e-5: Not applicable
% [10e-5, 1/3[ : Not equivalent models
% [1/3, 3[ : Equivalent models
% [3, 20[: Not equivalent models
% [20, 150[: Strong different models
% [150, 1000[: Very strong differences
% >= 1000: outliers 
max_appli=10e-5;
min_equi=1/3;

% On ramènera sur la ligne max_diff ceux qui dépassent max_diff
min_diff=3;
max_diff=20;
max_fort_diff=150;
min_err=1e+3;

%%

taille = 8;  % taille des points

ylegend={};
%% Les points <10e-5 (max_appli)
if any(bayes<max_appli)
    ylegend{length(ylegend)+1} = ['BF <' num2str(max_appli) ': not applicable '];
    plot( tobs_or(bayes<max_appli), bayes(bayes<max_appli), 'ok', 'MarkerSize', taille)
    hold on
end

xlabel( ['time (' uniteT_libelle ')']);

%% Colorier les zones
clair=([250 237 215]-10)/255;
fonce=(5+[250 250 222])/255;
% le faire avant de tracer les points, sinon ceux-ci seront cachés
% colorer la zone des modèles équivalents  ([min_equi,min_diff[)
minb= min(bayes);
maxb=max(bayes);
 if (minb < min_diff) && (maxb >=min_equi)
    % il y a des points entre [min_equi,min_diff[
    bt = max(min_equi, minb);
    ht=min(min_diff, maxb) -bt;
    if ht>0
        rectangle( 'Position',[0, bt, tobs_or(end), ht], 'FaceColor', clair)
    end
end


% colorer la zone des modèles différents (entre 3 et 20)
 if (minb < max_diff) && (maxb >= min_diff)
 % il y a des points entre [min_diff, max_diff[
    bt = max(min_diff, minb);
    ht= min(max_diff, maxb) -bt;
    if ht>0
        rectangle('Position',[0, bt, tobs_or(end), ht], ...
        'FaceColor',fonce);
    end
end


% colorer la zone des modèles différents (entre 10e-5 et 1/3)
 if (minb < min_equi) && (maxb >= max_appli)
 % il y a des points entre [min_equi, max_appli[
    bt = max(max_appli, minb);
    ht= min(min_equi, maxb) -bt;
    if ht>0
        rectangle('Position',[0, bt, tobs_or(end), ht], ...
        'FaceColor',fonce);
    end
 end

hold on

%% Tracé des points correspondant aux modèles équivalents
% (entre min_equi=1/3 et min_diff=3)
if any(bayes>=min_equi & bayes<min_diff)
    ylegend{length(ylegend)+1} = ['BF in [1/3, ' ...
    num2str(min_diff) '[: ' ...
        'equivalent models'];
    plot(tobs_or(bayes>=min_equi&bayes<min_diff) , ...
        bayes(bayes>=min_equi&bayes<min_diff), '*b', 'MarkerSize', taille);
    hold on
end

%% Tracé des points correspondant aux modèles différents
% (entre max_appli=10e-5 et min_equi=1/3)
if any(bayes>=max_appli&bayes<min_equi)
    % les modèles différents
 ylegend{length(ylegend)+1} =  ['BF in [' num2str(max_appli) ...
        ', 1/3', '[: not equivalent models '];
    plot(tobs_or(bayes>=max_appli&bayes<min_equi),...
     bayes(bayes>=max_appli&bayes<min_equi), ...
        'pk', 'MarkerSize', taille);
    hold on
end

%% Tracé des points correspondant aux modèles différents
% (entre min_diff=3 et max_diff=20)
if any(bayes>=min_diff&bayes<max_diff)
    % les modèles différents
    ylegend{length(ylegend)+1} =  ['BF in [' num2str(min_diff) ...
        ', ',num2str(max_diff) '[: not equivalent models '];
    plot(tobs_or(bayes>=min_diff&bayes<max_diff),...
     bayes(bayes>=min_diff&bayes<max_diff), ...
        '+k', 'MarkerSize', taille);
    hold on
end



% Il y a des points très différents ou pires
% Ligne où on les ramène par défaut
max_ligne=20;
if any(bayes>=max_diff)
    %  Les modèles fortement ou très fortement différents et ceux non calculables
    % sont ramenés sur une même ligne (max_ligne)
    fbayes = bayes;
    fbayes(bayes>=max_diff) =max_ligne;

    % Trace des points  fortement differents (entre max_diff=20 et max_fort_diff=150)
    if any(bayes>=max_diff&bayes<max_fort_diff)
        ylegend{length(ylegend)+1} =  ['BF in [' num2str(max_diff) ...
            ', ',num2str(max_fort_diff) '[: strong difference (points are replaced on the plot)'];
        plot(tobs_or(bayes>=max_diff&bayes<max_fort_diff) , ...
            fbayes(bayes>max_diff&bayes<max_fort_diff), 'xk', 'MarkerSize', taille);
        hold on
    end

    % Trace des points tres  fortement differents (entre max_fort_diff=150 et min_err=1000)
    if any(bayes>=max_fort_diff&bayes<min_err)
        ylegend{length(ylegend)+1} = ['BF in [' num2str(max_fort_diff)...
            ', ',num2str(min_err)  '[: very strong difference (points are replaced on the plot)'];
        plot(tobs_or(bayes>=max_fort_diff&bayes<min_err), ...
            fbayes(bayes>=max_fort_diff&bayes<min_err), 'dk', 'MarkerSize', taille);
        hold on
    end
    
 % Trace des points aberrants 
    if any(bayes>=min_err)
        ylegend{length(ylegend)+1} = ['BF >=' num2str(min_err) ...
            ': outliers (points are replaced on the plot)'];
        plot(tobs_or(bayes>=min_err), fbayes(bayes>=min_err), 'xr', 'MarkerSize', taille);
        hold on
    end
end

%% Pour construire les lignes des intervalles:
a=zeros(length(tobs_or));
%% on construit les yticklabels pour que 1/3 n'apparaisse pas sous la
    % forme '0.333' mais '1/3'
hold on
yticklabels= {'0'; '1/3'}; 
    for uny=1:max_ligne
        yticklabels{end+1}=num2str(uny);
    end
    set( gca,'YTick', [0 1/3 1:max_ligne], 'YTicklabel', yticklabels)
    hold on
    % FIN on construit les yticklabels

if any(bayes>=max_diff)
    % s'il y a des points qui dépassent le max des différents
    % i.e si on a ramené des points sur la ligne max_ligne, refaire les
    % tick marks toutes les unités et limiter l'axe des y à max_ligne
    %  Agrandir le cadre pour qu'on voit la ligne max_ligne
    rectangle('Position',[0, max_ligne, tobs_or(end),1], 'FaceColor','w')
    % Mettre des ticks marks toutes les unités sur l'axe des y
    axis([0 tobs_or(end) min(bayes) max_ligne])
    
    
    % mettre la ligne du max des différents
    plot(tobs_or, a+max_ligne,'-r',  'LineWidth', 2)
else
    % pas la peine de tracer la ligne du max des différents
    % tracer jusqu'au max des points
    max_cadre=max(bayes);
    min_cadre = min(bayes);
    % axis([0 tobs_or(end) -1 max_cadre])
    % Prévoir les modèles pour lesquels les bayes sont égaux partout
    if (min_cadre ~= max_cadre)
        axis([0 tobs_or(end) min_cadre max_cadre])
    else
        axis([0 tobs_or(end) min_cadre-1 max_cadre+1])
    end
    tick=round(min_cadre:max_cadre);
    if tick(end) ~= max_cadre
        %rajouter le maximum sur la graduation des y
        tick(end+1)=max_cadre;
    end
    set(gca, 'YTick', tick)
    
end
hold on


% mettre les lignes délimitant les modèles équivalents
plot(tobs_or, a+min_equi, '-k', tobs_or, a+min_diff,'-b',  'LineWidth', 2)


%% Joindre les points
plot(tobs_or, fbayes, '-k');

%% Si on a agrandi l'échelle, modifier les annotations
if max_ligne==10
   axis([0 tobs_or(end)  0 11])
    set(gca, 'Ytick', [0 min_equi 2 3 10], ...
        'Yticklabel', {'0', '1/3', '2', '3', ['BF>=' num2str(max_diff)]})
    
end


%% Pouvoir sauvegarder la figure quand on double-clique dessus
% NOTE: le double-clic sur le graphique permet de le sauver
if direct==1 % appel explicite
    % La légende
    legend(gca, ylegend, 'location', 'Best')
    % mettre les entrées dans une structure pour pouvoir retracer le graphe par
    % double-clic
    structbayes={};
    structbayes.tobs_or=tobs_or;
    structbayes.bayes=bayes;
    structbayes.uniteT_libelle= uniteT_libelle;
    set(gca,'buttondownfcn',{@plot_fbayes, structbayes})
    
    a=allchild(gca);
    for i=1:length(a)
        
        set(a(i),'buttondownfcn', {@plot_fbayes, structbayes})
    end
end
hold on

%Pour la sauvegarde/restauration
sauve_hp('filtrexplot',2,...
	 'tobs_or', tobs_or);


% On met le titre 
title( hg, 'EVOLUTION OF THE BAYES FACTOR', 'FontSize', 12);
end % fin plot_fbayes
