function [data]=trace_CVs(data, modelepop1, modelepop2, hd30, hd31, hd32, hd33)
% trace_CVs
% Affichage des CVs initiaux (valeurs par défaut) quand ils sont à estimer
% Les valeurs initiales des CVs sont dans data.Basemodeles.DF (ceux à
% estimer) et dans data.CVs (ceux fixés)
% INPUT
% Les CVs à estimer ont déjà été rajoutés à la liste des paramètres à
% estimer des 2 modèles (i.e dans data.Basemodeles.nomparamP{du modele 1} et
% dans celui du modèle 2) et dand la liste des paramètres fixes s'il y en a
% (i.e dans les data.Basemodeles.nomparamS)
% OUTPUT
% On rajoute à data, nomparam1 et nomparam2 (noms des paramètres à estimer
% des 2 modèles) et nomparamS1, nomparamS2 (noms des paramètres fixes) pour
% faciliter les manipulations ultérieures
% NOTE dans cette version, le bruit est non visible: il est fixé a la valeur par défaut.
% pour réautoriser le choix du bruit par l'utilisateur, décommenter
% les phrases commençant par % visible noise
%% ------------------------------------------------------------------------
s= find(strcmpi(data.Basemodeles.nom,modelepop1));
% modèle dans lequel les CVs ont été rajoutés à la liste des paramètres à estimer

Basemodeles=data.Basemodeles;
nomparamP=Basemodeles.nomparamP{s};
nomparamS=Basemodeles.nomparamS{s};
init=Basemodeles.init;

set(data.CVs_tag, 'string', 'CVs');
set(data.CVs_tag, 'visible', 'on');
CVs=data.CVs;
set(data.minc_tag,'visible','on')
set(data.maxc_tag,'visible','on')
% visible noise:  set(data.bruitc_tag,'visible','on')
set(data.plagesmax_CV_tag, 'visible','on')

pasy=1/8;
if length(CVs.nomparamS)>7
    pasy=0.98/(length(CVs.nomparamS));
end

%% Effacer l'éventuel choix précédent
delete(get(hd30, 'children'));
delete(get(hd31, 'children'));
delete(get(hd32, 'children'));
delete(get(hd33, 'children'));
set(hd30, 'visible', 'on');
set(hd31, 'visible', 'on');
set(hd32, 'visible', 'on');
set(hd33, 'visible', 'on');



%% Affichage des valeurs min et max et bruit par défaut des CVs actifs
%  idem que trace_modele en ne faisant apparaitre que
% les parametres dont le nom est dans CVs.nomparamS
iver=0; %initialiser le déplacement vertical

for i=1:length(nomparamP)
    if any(strcmpi(nomparamP{i}, CVs.nomparamS))
        % Maj des tags s'il avait été précedemment fixé
        if isfield(data, [nomparamP{i} '_fixtag'])
            % détruire le tag nomparamS_fixtag
            % (nécessaire pour ytheorique), qui indique que le CV est fixé
            data=rmfield(data, [nomparamP{i} '_fixtag']);
        end
        % maj sa valeur dans le panel du haut
        set(data.([nomparamP{i} '_tag']), 'string', '-', 'enable','off');
        
        
        iver= iver+1; %le déplacement vertical
        % le nom du CV
        uicontrol('parent',hd30,...
            'units','normalized',...
            'position',[0 .96-pasy*iver 1 pasy],...
            'style','text',...
            'backgroundcolor',[1 1 1],...
            'foregroundcolor','k',...
		  'string', traduc_nom(nomparamP(i)));
        % le min
        nomvar=[nomparamP{i},'min'];
        data.(nomvar)=eval(init.(nomparamP{i}){1});
        tag=[nomvar,'_tag'];
        hd=uicontrol('parent',hd31,...
            'units','normalized',...
            'position',[0 1-pasy*iver 1 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'callback',@control_saisie,...
		     'userdata',{data.Basemodeles.DF.(nomparamP{i}),traduc_nom(nomparamP(i))}, ...
            'style','edit');
        set(hd,'string',eval(['data.',nomvar]))
        data.(tag)=hd; % Matlab13a 29/1/14
        
        % le max
        nomvar=[nomparamP{i},'max'];
        data.(nomvar)=eval(init.(nomparamP{i}){2});
        tag=[nomvar,'_tag'];
        hd=uicontrol('parent',hd32,...
            'units','normalized',...
            'position',[0 1-pasy*iver 1 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'callback',@control_saisie,...
		     'userdata',{data.Basemodeles.DF.(nomparamP{i}),traduc_nom(nomparamP(i))}, ...
            'style','edit');
        set(hd,'string',eval(['data.',nomvar]))
        data.(tag)=hd; % Matlab13a 29/1/14
        
        %le bruit
% dans cette version, il est non visible: il est fixé a la valeur par défaut
	  % visible noise: 'Visible', 'on', ...
        decal=0.02;
        nomvar=[nomparamP{i},'_bruit'];
        data.(nomvar)=data.Basemodeles.initbruit.(nomparamP{i});
        tag=[nomvar,'_tag'];
        br=uicontrol('parent',hd33,...
            'Visible', 'off', ...
            'units','normalized',...
            'position',[0 1-decal-pasy*iver 1 pasy-decal],...
             'tag',tag,...
            'style','popupmenu',...
           'string','   Poisson|   Gaussian');
 %           'string','   Poisson|   Gaussian|Binomial');
        set(br,'value',data.Basemodeles.initbruit.(nomparamP{i}))
        data.(tag)=br; % Matlab13a 29/1/14
        
    end %if any
    
end
%% Les CVs fixés

for j=1:length(nomparamS)
    if  any(strcmpi(nomparamS{j}, CVs.nomparamS))
        
        k=find(strcmp(CVs.nomparamS, nomparamS{j}),1);
        iver=iver+1; % incrémenter le déplacement vertical
        uicontrol('parent',hd30,...
            'units','normalized',...
            'position',[0 0.96-pasy*iver 1 pasy],...
            'style','text',...
            'backgroundcolor',[1 1 1],...
            'foregroundcolor','k',...
		  'string', traduc_nom(nomparamS(j)));
        tag=[nomparamS{j},'_fixtag'];
        nomvar=nomparamS{j};
        data.(nomvar)=data.CVs.valparamS{k};
        % Maj de la valeur du CV dans le panel des paramètres du modèle d'observations
        set(data.([nomparamS{j},'_tag']), 'string', data.CVs.valparamS{k}, 'enable', 'off');
        hd=uicontrol('parent',hd31,...
            'units','normalized',...
            'position',[0 1-pasy*iver 2.02 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'userdata', {data.Basemodeles.DF.(nomparamS{j}), ...
            nomparamS{j}, data.CVs.valparamS{k}}, ...
            'callback',@fix_CV,...
            'style','edit');
        set(hd,'string',data.CVs.valparamS{k});
         data.(tag)=hd; % Matlab13a 29/1/14
    end %if any
    
end % fin j
drawnow

%% Stocker le nom des parametres de chacun des 2 modèles
data.nomparam1=nomparamP;
data.nomparamS1=nomparamS;
s= find(strcmpi(data.Basemodeles.nom,modelepop2));
data.nomparam2=Basemodeles.nomparamP{s};
data.nomparamS2=Basemodeles.nomparamS{s};

%% affichage
  handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(1,ndata)

end %fin trace_CVs



