function control_saisie_an(obj, event)
%control_saisie_an Check an alpha-numeric parameter
% If it is numeric, its valid bounds are in userdata{1} and  userdata{2}
% If it is alpha, its valid value is in userdata{3}
% If there is an error, add to the global variable input_error, a
% field whose name is equal to the tag of the calling handle
%% ======================================================
global input_error;
letag = get(obj, 'tag');

% Il y avait une erreur précédemment sur le tag courant et l'utilisateur le modifie
if ~isempty(input_error) && isfield(input_error, letag)
    input_error= rmfield(input_error, letag);
end

userdata=get(obj,'userdata');
% userdata contient les bornes valides, suivies
% si userdata  est de type cell, du libelle a écrire si erreur
if iscell(userdata)
    DF=userdata{1};
    if iscell(userdata{2})
        % oter les composants vides
        for i=1:length(userdata{2})
            if ~isempty(userdata{2}{i})
                mess= userdata{2}{i};
             end
        end
    else
        mess= userdata{2} ;
    end
    libelle=['Error on ' mess  ': '];
else
    libelle='';
    mess=letag;
    DF=userdata;
end


user_entry =get(obj,'string');

if length(DF)>=3
    % il y a une val par defaut
    if isempty(user_entry)
        % si rien, on affecte automatiquement la val par def
        set(obj, 'String', DF{3})
        user_entry =DF{3};
    end
    if strcmpi(user_entry, DF{3})
        return
    end

end


user_entry = str2double(user_entry);

if isempty(user_entry)
    % valeur pas numérique
    errordlg([libelle, 'Enter a numerical value between ', ...
        DF{1} ' and ' DF{2} ' or "', ...
        DF{3}, ' "'],'Bad Input','modal')
    set(obj,'backgroundcolor',[1 1 1])
    input_error.(letag)=mess;
    uicontrol(obj)
    return
end
if isempty(DF)
    %     helpdlg('Cette variable peut être instanciée par la suite','Note');
    set(obj,'backgroundcolor','w')
    return
else
    
    if user_entry<=str2double(DF{2}) && user_entry>=str2double(DF{1})
        set(obj,'backgroundcolor','w')
    else
        message=[libelle, ...
'The value ',get(obj,'string'),' is not between ',DF{1},' and ',DF{2}];
        if length(DF)>=3
            message=[message ' or ' DF{3}];
        end
        errordlg(message ,'Bad Input','modal')
        set(obj,'backgroundcolor',[1 1 1])
        input_error.(letag)=mess;
        uicontrol(obj)
    end
    
    return
end

end %fin control_saisie_an
