
function data=ecrire_result(tag, data, ...
    nbparammodel, nomparam, paramfin, nmoda, strnmod)
%ecrire_result Display the estimated values of the parameters
% INPUT
% strnmod ='1' or '2' when they are several models (two models comparison)
% This is the index of the current model.
% strnmod does not exist when there is a single model (parametric identification)
%% ======================================================
%% Créer le panel
 hp2=uipanel('parent',data.hpanel_work,...
   'tag',tag,...
   'BorderType', 'none', ...
    'BackgroundColor',[1 1 1],...
    'Position',[0 .02 1 0.98]);


nomfonction={'Parameter','Estimated mean', 'Estimated mode'};
marge=0.2; % marge
pasx=(1-2*marge)/length(nomfonction);

if nargin >6
    hp22=uicontrol('parent', hp2,...
    'BackgroundColor','white',...
    'fontsize',12,...
    'foregroundcolor',[0 0 0],...
    'units','normalized',...
    'Position',[0 0.9 1 0.08], ...
    'style','text');
    suffixe = ['_mod' strnmod];
    if strcmp(strnmod, '1')
        quel='Numerator';
    else
        quel='Denominator';
    end
    
    set(hp22, 'String', [quel ' model: ESTIMATED RESULTS ']);
else
    suffixe='';
end



%% Mettre les titres des colonnes
for i=1:length(nomfonction)
    var_tag=['valeur_gourpebutton'   num2str(i) suffixe '_tag'];
    debutx=marge+pasx*(i-1);
    data.(var_tag)=uibuttongroup('Parent',hp2,...
        'tag',var_tag,...
        'backgroundcolor',[1 1 1],...
        'Position',[debutx .1 pasx .8]);
    
    
    
    uicontrol('parent',data.(var_tag),...
        'units','normalized',...
        'fontsize',12,...
        'position',[0 .95 1 .04],...
        'backgroundcolor',[1 1 1],...
        'foregroundcolor','k',...
        'style','text',...
        'string',nomfonction{i});
end
pasy=0.94/nbparammodel;

%% Mettre les valeurs des paramètres
for j=1:nbparammodel;
    debuty=0.94-j*pasy;
    leparent = ['valeur_gourpebutton1' suffixe '_tag'];
lastring = nomparam{j};
  % Traduction eventuelle des CV
  lastring = traduc_nom(lastring, data.Basemodeles.type);
    uicontrol('parent',data.(leparent),...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text',...
        'string',{'',lastring});
    
    leparent = ['valeur_gourpebutton2'  suffixe '_tag'];
    uicontrol('parent',data.(leparent),...
        'units','normalized',...
        'fontsize',15,...
        'position',[0 debuty 1 pasy],...
        'style','text',...
        'string',{'',num2str(paramfin(j),6)});
    
       leparent = ['valeur_gourpebutton3'  suffixe '_tag'];
    uicontrol('parent',data.(leparent),...
        'units','normalized',...
        'fontsize',15,...
        'position',[0 debuty 1 pasy],...
        'style','text',...
        'string',{'',num2str(nmoda(1,j),6)});
     
end

data.(tag)=hp2;  % 29/1/2014, Matlab R2013a

end % fin ecrire_result
