
function[indice_panel, data] = histofiltre(indice_panel, strnmod, data, ...
    nbparam, nomparam, indiceobs, Xt)
%histofiltre Histograms of each parameter, per observation
%% ===================================================================

indice_panel=indice_panel+1;
if strcmp(strnmod, '')==0
    tag=['panel' num2str(indice_panel) '_mod' strnmod '_tag'];
else
    tag=['panel' num2str(indice_panel) '_tag'];
end


hp=uipanel('parent',data.hpanel_work,...
    'tag',tag,...
    'BorderType', 'none', ...
    'BackgroundColor',[1 1 1],...
    'Position',[0 .02 1 0.98]);
titre=[ 'HISTOGRAMS AT OBSERVATION #', ...
        num2str(indiceobs)];
set(hp, 'title', titre, ...
    'TitlePosition', 'centertop');

m=floor(nbparam./2);
if mod(nbparam,2)
    m=m+1;
end

subplot(m,2,1,'parent',hp)

%% Boucle sur les parametres
for numparam=1:nbparam
    
    subplot(m,2,numparam);
    
    hist(Xt(numparam,:),20);
    
    if isempty(nomparam)
        descript=num2str(numparam);
    else
      descript=traduc_nom(nomparam{numparam}, data.Basemodeles.type);
    end
    %    title(['Distribution des estimations du paramètre ' ,...
    %     title(['Parameter ' ,...
    %         descript, ...
    %         ': distribution of the estimations at observation ' ...
    %         num2str(indiceobs)]);
    title(['PARAMETER ' descript]);
    % Argu pour dessin_histofiltre: clic sur le graphe pour le dessiner dans
    % une fenetre Matlab
    structarg = {numparam, descript, Xt};
    
    set(gca,'buttondownfcn',{@dessin_histofiltre, structarg});
    
end
%% fin boucle

    drawnow
set(hp,'visible','off')
%NB: Si on met      delete(hp); on peut faire défiler tous les histo mais
%ils ne seront pas stockés dans les panels

data.(tag)=hp; %29/1/14

end %% fin histofiltre

%% =====================================================================

function dessin_histofiltre(obj, evt, structarg)
% dessin_histofiltre Trace graphique d'une page d'histo dans une figure matlab
numparam = structarg{1};
descript = structarg{2};
Xt= structarg{3};

figure('Name', 'Histogram');


    hist(Xt(numparam,:),20);
    
     title(['PARAMETER ' descript]);

end % fin dessin_histofiltre
