
function Bstruct=init_Basemodeles()
%init_Basemodeles Initialization of the models database.
%% ======================================================
Basemodeles={};


%% Models names:
Basemodeles.nom={'Baranyi-Roberts','Rosso', ...
    'Weibull', 'WeibullT', ...
    'LogLinear', 'LogLinear2', 'LogLinearST','LogLinearS','LogLinearT', ...
    'BiPhasicS', 'BiPhasic',...
    'Double-Weibull', 'Leguerinel', ...
    'LnBaranyi-Roberts','LnRosso', ...
};
% To test    'LnEssai'}; 
%% Short models names:
Basemodeles.nomcourt={'BR','R', ...
    'W', 'WT', ...
    'LogL', 'LogL2', 'LogLST','LogLS','LogLT', ...
    'BiPS', 'BiP',...
    'DW', 'Leg', ...
    'LnBR','LnR', ...
};
% To test    'LnEssai'}; 


%% Models parameters:
Basemodeles.nomparamP={{'mumax','lambda','N0','Nmax'}, ... %Baranyi
    {'mumax','lambda','N0','Nmax'}, ... %Rosso
    {'D','p','N0'}, ... %Weibull
    { 'delta','p', 'log10N0', 'log10Nr'}, ... %WeibullT
    {'D','p','log10N0'}, ... %LogLinear
    { 'kmax', 'log10N0'}, ... %LogLinear2
    { 'kmax', 'S1', 'log10N0', 'log10Nr'}, ... %LogLinearST
    { 'kmax', 'S1', 'log10N0'}, ... %LogLinearS
    {'kmax', 'log10N0', 'log10Nr'}, ... %LogLinearT
    {'f', 'kmax1', 'kmax2', 'S1', 'log10N0'}, ... %BiPhasicS
    {'f', 'kmax1', 'kmax2', 'log10N0'}, ... %BiPhasic
    {'alpha', 'p', 'delta1', 'delta2', 'log10N0'}, ... % Double-Weibull
    {'delta', 'p'}, ... % Leguerinel
    {'mumax','lambda','lnN0','lnNmax'}, ... %LnBaranyi
    {'mumax','lambda','lnN0','lnNmax'}, ... %LnRosso
}; 
%LnEssai    {'mumax','lambda','N0','Nmax'}, ... %LnEssai


%% Anticipate fixed parameters
Basemodeles.nomparamS={{},{},{},{},{},{},{},{},{},{},{}, {},...
    {'K', 'pHopt', 'Awopt', 'ZpH', 'ZAw', 'pH', 'Aw'}, ...% Leguerinel
    {},{} , ...
};
% Last component for  LnEssai {}  }; 

%% Fixed parameters that cannot be unfixed
Basemodeles.nomparamH=Basemodeles.nomparamS;

%% CV
%Validity bounds DF
DF.CVpesee={'0.0015'  '0.4'};
DF.CVpipetee={'0.00015' '0.04'};
DF.CVdiluant={'0.0005' '0.15'};
%Init bounds
init.CVpesee={'0.015' '0.04'};
init.CVpipetee={'0.0015' '0.004'};
init.CVdiluant={'0.005' '0.015'};
%See init_CVs.m as to the fixed default values

%% BaranyiRoberts
DF.BaranyiRoberts.mumax={'0.0001' '10'}; %validity bounds
init.BaranyiRoberts.mumax={'0.01' '2'}; %default bounds
DF.BaranyiRoberts.lambda={'0.01' '1000'}; % En heures
init.BaranyiRoberts.lambda={'20' '60'};
DF.BaranyiRoberts.N0={'1' '1000'};
init.BaranyiRoberts.N0={'100' '400'};
DF.BaranyiRoberts.Nmax={'1e3' '1e12'};
init.BaranyiRoberts.Nmax={'1e8' '1e9'};
valparamS.BaranyiRoberts.mumax=0.05; %default fixed values
valparamS.BaranyiRoberts.lambda=40;
valparamS.BaranyiRoberts.N0=230;
valparamS.BaranyiRoberts.Nmax=4e8;

%% LnEssai 
%% DF.LnEssai.mumax={'0.0001' '10'}; %validity bounds
%% init.LnEssai.mumax={'0.01' '2'}; %default bounds
%% DF.LnEssai.lambda={'0.01' '1000'}; % En heures
%% init.LnEssai.lambda={'20' '60'};
%% DF.LnEssai.N0={'1' '1000'};
%% init.LnEssai.N0={'100' '400'};
%% DF.LnEssai.Nmax={'1e3' '1e12'};
%% init.LnEssai.Nmax={'1e8' '1e9'};
%% valparamS.LnEssai.mumax=0.05; %default fixed values
%% valparamS.LnEssai.lambda=40;
%% valparamS.LnEssai.N0=230;
%% valparamS.LnEssai.Nmax=4e8;


%% Rosso
DF.Rosso.mumax=DF.BaranyiRoberts.mumax;
init.Rosso.mumax=init.BaranyiRoberts.mumax;
DF.Rosso.lambda=DF.BaranyiRoberts.lambda;
init.Rosso.lambda=init.BaranyiRoberts.lambda;
DF.Rosso.N0=DF.BaranyiRoberts.N0;
init.Rosso.N0=init.BaranyiRoberts.N0;
DF.Rosso.Nmax= DF.BaranyiRoberts.Nmax;
init.Rosso.Nmax=init.BaranyiRoberts.Nmax;
valparamS.Rosso.mumax=valparamS.BaranyiRoberts.mumax;
valparamS.Rosso.lambda=valparamS.BaranyiRoberts.lambda;
valparamS.Rosso.N0=valparamS.BaranyiRoberts.N0;
valparamS.Rosso.Nmax=valparamS.BaranyiRoberts.Nmax;

%% Weibull
DF.Weibull.D={'0.033' '1e6'}; % {'1' '1e6'};
init.Weibull.D={'10' '1000'};
DF.Weibull.p={'0.01' '10'};
init.Weibull.p={'1' '8'};
DF.Weibull.N0={'100' '1e12'};
init.Weibull.N0={'1.0e6' '1.0e8'};
valparamS.Weibull.D=300;
valparamS.Weibull.p=3;
valparamS.Weibull.N0=1e5;


%% WeibullT
DF.WeibullT.log10N0=  {'3', '12'};
init.WeibullT.log10N0= DF.WeibullT.log10N0;
valparamS.WeibullT.log10N0=9.63;
DF.WeibullT.p={'0.01' '10'};
init.WeibullT.p={'1' '8'};
valparamS.WeibullT.p=1.8;
DF.WeibullT.log10Nr= {'-6', '0'};
init.WeibullT.log10Nr= DF.WeibullT.log10Nr;
valparamS.WeibullT.log10Nr=-4.08;
DF.WeibullT.delta= {'2', '20'};
init.WeibullT.delta=DF.WeibullT.delta;
valparamS.WeibullT.delta= 10.03; % en mn


%% LogLinear
DF.LogLinear.D={'0.033' '1e6'};
init.LogLinear.D={'100' '1000'};
DF.LogLinear.p={'0.01' '10'};
init.LogLinear.p={'1' '8'};
DF.LogLinear.log10N0=  {'2', '12'};
init.LogLinear.log10N0= DF.LogLinear.log10N0;
valparamS.LogLinear.D=300;
valparamS.LogLinear.p=3;
valparamS.LogLinear.log10N0=4;


%% LogLinear2
DF.LogLinear2.log10N0=  {'3', '12'};
init.LogLinear2.log10N0= DF.LogLinear2.log10N0;
DF.LogLinear2.kmax=  {'0.01' '2'}; % en mns
init.LogLinear2.kmax= DF.LogLinear2.kmax;
valparamS.LogLinear2.log10N0= 10.33;
valparamS.LogLinear2.kmax=0.51;


%% LogLinearST
DF.LogLinearST.log10N0=  {'3', '12'};
valparamS.LogLinearST.log10N0=9.47;
init.LogLinearST.log10N0= DF.LogLinearST.log10N0;
DF.LogLinearST.log10Nr= {'-4', '2'};
valparamS.LogLinearST.log10Nr= -1.10;
init.LogLinearST.log10Nr=DF.LogLinearST.log10Nr;
DF.LogLinearST.kmax=  {'0.01' '2'}; % mns-1
init.LogLinearST.kmax=DF.LogLinearST.kmax;
valparamS.LogLinearST.kmax= 0.71;
DF.LogLinearST.S1= {'4' '12'};
init.LogLinearST.S1= DF.LogLinearST.S1;
valparamS.LogLinearST.S1=8.63;


%% LogLinearS
DF.LogLinearS.log10N0=  DF.LogLinearST.log10N0;
init.LogLinearS.log10N0=DF.LogLinearS.log10N0;
valparamS.LogLinearS.log10N0=valparamS.LogLinearST.log10N0;
DF.LogLinearS.kmax=  DF.LogLinearST.kmax;
init.LogLinearS.kmax= DF.LogLinearS.kmax;
valparamS.LogLinearS.kmax= valparamS.LogLinearST.kmax;
DF.LogLinearS.S1= DF.LogLinearST.S1;
init.LogLinearS.S1= DF.LogLinearS.S1;
valparamS.LogLinearS.S1=valparamS.LogLinearST.S1;

%% LogLinearT
DF.LogLinearT.log10Nr= {'-5', '0'};
init.LogLinearT.log10Nr=DF.LogLinearT.log10Nr;
valparamS.LogLinearT.log10Nr=-3.04;
DF.LogLinearT.kmax=  {'0.01' '2'};
init.LogLinearT.kmax=DF.LogLinearT.kmax;
valparamS.LogLinearT.kmax= 0.51;
DF.LogLinearT.log10N0=  {'3', '12'};
init.LogLinearT.log10N0=DF.LogLinearT.log10N0;
valparamS.LogLinearT.log10N0= 10.33;


%% BiPhasicS
DF.BiPhasicS.log10N0=  {'3', '12'};
init.BiPhasicS.log10N0=DF.BiPhasicS.log10N0;
valparamS.BiPhasicS.log10N0=9.47;
DF.BiPhasicS.f={'0', '1'};
init.BiPhasicS.f=DF.BiPhasicS.f;
valparamS.BiPhasicS.f=0.77;
DF.BiPhasicS.kmax1= {'0.01' '2'};
init.BiPhasicS.kmax1=DF.BiPhasicS.kmax1;
valparamS.BiPhasicS.kmax1= 0.71; % mns-1
DF.BiPhasicS.kmax2= DF.BiPhasicS.kmax1;
init.BiPhasicS.kmax2=DF.BiPhasicS.kmax2;
valparamS.BiPhasicS.kmax2=valparamS.BiPhasicS.kmax1;
DF.BiPhasicS.S1= {'4' '12'};
init.BiPhasicS.S1=DF.BiPhasicS.S1;
valparamS.BiPhasicS.S1=8.63; % en mns


%% BiPhasic
DF.BiPhasic.log10N0=  {'3', '12'};
init.BiPhasic.log10N0=DF.BiPhasic.log10N0;
valparamS.BiPhasic.log10N0=10.33;
DF.BiPhasic.f=DF.BiPhasicS.f;
init.BiPhasic.f=DF.BiPhasic.f;
valparamS.BiPhasic.f=0;
DF.BiPhasic.kmax1= {'0.01' '5'};
init.BiPhasic.kmax1= DF.BiPhasic.kmax1;
valparamS.BiPhasic.kmax1= 2.92;
DF.BiPhasic.kmax2= DF.BiPhasicS.kmax2;
init.BiPhasic.kmax2=DF.BiPhasic.kmax2;
valparamS.BiPhasic.kmax2=0.51;

%% DoubleWeibull
DF.DoubleWeibull.log10N0=  {'3', '7'};
init.DoubleWeibull.log10N0= DF.DoubleWeibull.log10N0;
valparamS.DoubleWeibull.log10N0=5.45;
DF.DoubleWeibull.alpha= {'1', '6'};
init.DoubleWeibull.alpha= DF.DoubleWeibull.alpha;
valparamS.DoubleWeibull.alpha=3.15;
DF.DoubleWeibull.p={'1' '8'};
init.DoubleWeibull.p=DF.DoubleWeibull.p;
valparamS.DoubleWeibull.p=3.67;
DF.DoubleWeibull.delta1= {'2', '10'};
init.DoubleWeibull.delta1=DF.DoubleWeibull.delta1;
valparamS.DoubleWeibull.delta1=  5.45;
DF.DoubleWeibull.delta2= {'8', '25'};
init.DoubleWeibull.delta2=DF.DoubleWeibull.delta2;
valparamS.DoubleWeibull.delta2= 17.21;

%% Leguerinel
DF.Leguerinel.p= {'0' '7'}; 
init.Leguerinel.p={'0' '7'}; 
valparamS.Leguerinel.p=5;
DF.Leguerinel.delta= {'1', '3'};
init.Leguerinel.delta= DF.Leguerinel.delta;
valparamS.Leguerinel.delta= 1.8;
% Leguerinel parametres fixes
DF.Leguerinel.K=   {'2', '8'};
init.Leguerinel.K={'2', '8'}; 
valparamS.Leguerinel.K=5;
DF.Leguerinel.pHopt= {'5', '8'};
init.Leguerinel.pHopt=DF.Leguerinel.pHopt;
valparamS.Leguerinel.pHopt=6.96;
DF.Leguerinel.Awopt= {'0.985', '0.985'};
init.Leguerinel.Awopt= DF.Leguerinel.Awopt;
valparamS.Leguerinel.Awopt=0.985;
DF.Leguerinel.ZpH= {'2', '3'};
init.Leguerinel.ZpH= DF.Leguerinel.ZpH;
valparamS.Leguerinel.ZpH=2.18;
DF.Leguerinel.ZAw= {'0.05', '1.5'};
init.Leguerinel.ZAw=DF.Leguerinel.ZAw;
valparamS.Leguerinel.ZAw=0.092;
DF.Leguerinel.pH = {'3', '12'};
init.Leguerinel.pH = DF.Leguerinel.pH ;
valparamS.Leguerinel.pH = 6.96;
DF.Leguerinel.Aw = {'0.90', '0.998'};
init.Leguerinel.Aw = DF.Leguerinel.Aw ;
valparamS.Leguerinel.Aw =0.985;

%% LnBaranyiRoberts
DF.LnBaranyiRoberts.mumax=DF.BaranyiRoberts.mumax;
init.LnBaranyiRoberts.mumax=init.BaranyiRoberts.mumax;
DF.LnBaranyiRoberts.lambda=DF.BaranyiRoberts.lambda;
init.LnBaranyiRoberts.lambda=init.BaranyiRoberts.lambda;
DF.LnBaranyiRoberts.lnN0={'0', '6'};
init.LnBaranyiRoberts.lnN0={'4', '6'};
DF.LnBaranyiRoberts.lnNmax={'7', '28'};
init.LnBaranyiRoberts.lnNmax={'19', '21'};
valparamS.LnBaranyiRoberts.mumax=valparamS.BaranyiRoberts.mumax;
valparamS.LnBaranyiRoberts.lambda=valparamS.BaranyiRoberts.lambda;
valparamS.LnBaranyiRoberts.lnN0=5.4;
valparamS.LnBaranyiRoberts.lnNmax=20;

%% LnRosso
DF.LnRosso.mumax=DF.LnBaranyiRoberts.mumax;
init.LnRosso.mumax=init.LnBaranyiRoberts.mumax;
DF.LnRosso.lambda=DF.LnBaranyiRoberts.lambda;
init.LnRosso.lambda=init.LnBaranyiRoberts.lambda;
DF.LnRosso.lnN0=DF.LnBaranyiRoberts.lnN0;
init.LnRosso.lnN0=init.LnBaranyiRoberts.lnN0;
DF.LnRosso.lnNmax= DF.LnBaranyiRoberts.lnNmax;
init.LnRosso.lnNmax=init.LnBaranyiRoberts.lnNmax;
valparamS.LnRosso.mumax=valparamS.Rosso.mumax;
valparamS.LnRosso.lambda=valparamS.Rosso.lambda;
valparamS.LnRosso.lnN0=valparamS.LnBaranyiRoberts.lnN0;
valparamS.LnRosso.lnNmax=valparamS.LnBaranyiRoberts.lnNmax;


%%Noise of the parameters
% 2: Gaussien
% 1: Poisson
initbruit.mumax=2;
initbruit.lambda=2;
initbruit.N0=1;
initbruit.Nmax=1;
initbruit.lnN0=1;
initbruit.lnNmax=1;
initbruit.muopt=2;
initbruit.Tempmin=2;
initbruit.Tempopt=2;
initbruit.Tempmax=2;
initbruit.D=2;
initbruit.log10N0=2;
initbruit.log10Nr=2;
initbruit.p=2;
%WeibullT
initbruit.Nr=1;
% LogLinearST
initbruit.kmax=2;
initbruit.S1=2;
initbruit.delta=2;
%BiPhasicS
initbruit.f=2;
initbruit.kmax1=2;
initbruit.kmax2=2;
%Double-Weibull
initbruit.alpha=2;
initbruit.delta1=2;
initbruit.delta2=2;
%Leguerinel
initbruit.K=2;
initbruit.pHopt=2;
initbruit.Awopt=2;
initbruit.ZpH=2;
initbruit.ZAw=2;
initbruit.pH=2;
initbruit.Aw=2;

initbruit.CVpesee=2;
initbruit.CVpipetee=2;
initbruit.CVdiluant=2;


%% Type of the parameters when they are relative to time
type.mumax='[1/hour]';
unite.mumax='hour'; %hour
type.lambda='[hour]';
unite.lambda='hour'; %hour
type.kmax='[1/mn]';
unite.kmax='mn'; %mn
type.S1='[mn]';
unite.S1='mn'; %mn
type.kmax1='[1/mn]';
unite.kmax1='mn'; %mn
type.kmax2='[1/mn]';
unite.kmax2='mn'; %mn
type.D='[hour]';
unite.D='hour'; 
type.delta='[mn]';
unite.delta= 'mn'; %mn
type.delta1='[hour]';
unite.delta1='hour'; % hour
type.delta2='[hour]';
unite.delta2='hour'; % hour

%% Save the whole in the output structure
Basemodeles.DF=DF;
Basemodeles.init=init;
Basemodeles.valparamS=valparamS;
Basemodeles.initbruit=initbruit;
Basemodeles.type=type;
Basemodeles.unite=unite;
Bstruct=Basemodeles;
end
