function [data] = initdata(data, releveobs,  fileName)
% initdata Complete the data structure after the observations dataset file
% has been read
%  and uptodate the user interface
%% ======================================================
switch size(releveobs,2)
    case 9
        % tobs=temps d'observations - 1ere colonne du fichier
        tobs=releveobs(:,1);
        [tobs,I,J]=unique(tobs);
        nbobs=length(tobs); % nombre d'observations
        nbrepet=length(J)/nbobs; % nombre de repetitions
        set(data.deltaT_tag,'string','-')
        
        %% ------------Note: si on veut remettre le calcul de la fenetre selon le nombre de repet
        % noyau=get(data.F_noyau_tag,'string');
        % if iscell(noyau)
        %    noyau=noyau{1};
        % end
        %  fenetre=str2double(noyau);
        % if isnan(fenetre)||fenetre<1 || fenetre>2*(4+nbrepet)
        %    set(data.F_noyau_tag,'string',num2str(4+nbrepet))
        %  end
        % Calcul de la limite maxi du kernel selon le nbre de repet
        %        set(data.F_noyau_tag,'userdata',{'1' num2str(2*(4+nbrepet))})
        %        data.Filtre.valparamS{3}=num2str(4+nbrepet);
        % -------- FIN Note --------------------------------
        
        %% Transformer les données dans l'unité de temps pour
        % pouvoir calculer la proposition du pas de calcul
        uniteT=get(data.uniteT_tag,'value');
        if iscell(uniteT)
            uniteT=uniteT{1};
        end
        [tobs_maj, data.tobsfactT, data.uniteT_libelle, data.uniteT_pourcalcul, data.uniteT_pourcalcul_libelle] = ...
            convert_tps_decimaux(tobs, uniteT);
        
                
        deltaT=round(reg_deltaT(tobs_maj));
        set(data.deltaT_tag,'string','-', 'enable', 'on');
        if deltaT
            if (deltaT==1)
                set(data.deltaT_tag,'string','1', 'enable', 'off');
            else
                set(data.deltaT_tag,  'enable', 'on');
            end
            
            
            set(data.pas_tag,'string',deltaT);
            data.deltaT=deltaT;
        else
            set(data.pas_tag,'string','-', 'enable', 'on');
            set(data.deltaT_tag, 'enable', 'on');
        end
        
        
        % afficher l'unite de temps du pas de temps des calculs
        % et de sa proposition
                
        data=afficher_uniteT(data);
        
        %% ------------Note: si on veut remettre le calcul
        % de la limite maxi de la fenetre de perturbation selon le nbre de repet
        %        set(data.F_perturbation_tag,'userdata',{'1' num2str(2*(4+nbrepet))})
        %% ----------- Fin Note --------------------------------------------------
        
        m=releveobs(:,2); % masse prelevee - 2nde colonne du fichier
        a=releveobs(:,3); % facteur de dilution initial - 3eme colonne du fichier
        n=releveobs(:,4); % nombre de dilutions en tube - 4eme colonne du fichier
        F=releveobs(:,5); % facteur de dilution total - 5eme colonne du fichier
        v=releveobs(:,6); % volume ensemence - 6eme colonne du fichier
        nb=releveobs(:,7); % nb d'ufc comptees - 7eme colonne du fichier
        yestime=releveobs(:,8:9); % estimations nb total (nb et log) - 8 & 9eme colonnes du fichier
        % on rearrange les vecteurs en tableaux de taille nbrepet x nbobs
        % nb d'ufc comptees
        yobs=reshape(nb,nbrepet,nbobs);
        % parametres
        m2=reshape(m,nbrepet,nbobs);
        a2=reshape(a,nbrepet,nbobs);
        n2=reshape(n,nbrepet,nbobs);
        F2=reshape(F,nbrepet,nbobs);
        v2=reshape(v,nbrepet,nbobs);
        % estimations nb total (nb et log)
        Nbestime=reshape(yestime(:,1),nbrepet,nbobs);
        logNbestime=reshape(yestime(:,2),nbrepet,nbobs);
        
        % creation du tableau contenant les parametres de la fonction d'observation
        nbparam=5; % nombre de parametres
        paramobs=zeros(nbrepet,nbparam,nbobs); % format obligatoire pour passage dans la fonction de filtre
        paramobs(:,1,:)=m2; % masse prelevee
        paramobs(:,2,:)=a2; % facteur de dilution initial
        paramobs(:,3,:)=n2; % nombre de dilutions en tube
        paramobs(:,4,:)=F2; % facteur de dilution total
        paramobs(:,5,:)=v2; % volume ensemence
        
    otherwise
        
        Cin=find(releveobs(:,5)==0);
        Cin(end+1)=length(releveobs(:,5))+1;
        for c=1:length(Cin)-1
            tobs{c}=releveobs(Cin(c):Cin(c+1)-1,5);
            nbobs(c)=length(tobs{c});
            [tobs{c},I,J]=unique(tobs{c});
            nbrepet(c)=length(J)/nbobs(c);
            deltaT(c)=round(reg_deltaT(tobs{c}));
            m=releveobs(Cin(c):Cin(c+1)-1,6);
            a=releveobs(Cin(c):Cin(c+1)-1,7);
            n=releveobs(Cin(c):Cin(c+1)-1,8);
            F=releveobs(Cin(c):Cin(c+1)-1,9);
            v=releveobs(Cin(c):Cin(c+1)-1,10);
            nb=releveobs(Cin(c):Cin(c+1)-1,11);
            yestime{c}=releveobs(Cin(c):Cin(c+1)-1,12:13);
            yobs{c}=reshape(nb,nbrepet(c),nbobs(c));
            m2=reshape(m,nbrepet(c),nbobs(c));
            a2=reshape(a,nbrepet(c),nbobs(c));
            n2=reshape(n,nbrepet(c),nbobs(c));
            F2=reshape(F,nbrepet(c),nbobs(c));
            v2=reshape(v,nbrepet(c),nbobs(c));
            Nbestime{c}=reshape(yestime{c}(:,1),nbrepet(c),nbobs(c));
            logNbestime{c}=reshape(yestime{c}(:,2),nbrepet(c),nbobs(c));
            nbparam=5;
            paramobs{c}=zeros(nbrepet(c),nbparam,nbobs(c));
            paramobs{c}(:,1,:)=m2;
            paramobs{c}(:,2,:)=a2;
            paramobs{c}(:,3,:)=n2;
            paramobs{c}(:,4,:)=F2;
            paramobs{c}(:,5,:)=v2;
        end
        set(data.deltaT_tag,'string','-');
        set(data.pas_tag,'string',deltaT);
        data.deltaT=deltaT;
        
end

%% Stocker dans data
data.releveobs= releveobs;
data.tobs=tobs;
data.nbrepet=nbrepet;
data.yobs=yobs;
data.Nbestime=Nbestime;
data.logNbestime=logNbestime;
data.paramobs=paramobs;
guidata(gcf,data);



%% Afficher le nom du fichier lu
% ne pas oter pour garder le cadre	set(data.fichier_no_tag, 'visible', 'off');
set(data.fichier_chemin_tag,'visible', 'on', ...
    'string', ['DATA FILENAME : ', fileName]);

set(data.fichier_descr_tag,'visible', 'on', ...
    'String', ...
    [num2str(nbobs) ' observation times; ' ...
    num2str(nbrepet) ' replications; ' ...
    'Read time unit: ' data.uniteT_libelle, ...
    '; Computation time unit: ' data.uniteT_pourcalcul_libelle]);


%% Rajouter la possibilite du plot des donnees
if isfield(data, 'plotdata_tag')
    set(data.plotdata_tag, 'visible', 'on');
    set(data.plotdata_tag, 'userdata', {tobs, logNbestime, fileName});
end

%% Maj l'unite de temps dans l'affichage du modele, s'il a déjà été choisi
if isfield(data, 'nomparam1')
    % cas de la comparaison de modeles: le 1ier modele a ete choisi
    maj_timeparam(data, data.uniteT_pourcalcul, '1');
end
if isfield(data, 'nomparam2')
    % cas de la comparaison de modeles: le 2ieme modele a ete choisi
    maj_timeparam(data, data.uniteT_pourcalcul, '2');
end
% autres cas (en cas de comparaison de modeles, cette instruction est sans effet)
maj_timeparam(data, data.uniteT_pourcalcul);


end
%%============================================================
