function   maj_timeparam(data, uniteT, suf)
% maj_timeparam maj de l'affichage du modele selon l'unite de temps des données
% suf ='1' ou '2' en cas de comparaison de modele: suffixe du modele
% courant
% userdata is a cell structure which contains the bounds
%	of the valid parameter values, the second one contains
%	the parameter name.
%% ======================================================
if nargin <3
    suf='';
    sufmod='';
else    
    sufmod= ['_mod' suf];
end

nomparamstr=['nomparam' suf];
if isfield(data, nomparamstr) && ~isempty(data.(nomparamstr))
    nomparam=data.(nomparamstr);
    for i=1:length(nomparam)
        if isfield(data.Basemodeles.type, nomparam{i})
            % le parametre depend du temps
            letagtxt=[nomparam{i} sufmod '_txttag'];
            ch=get(data.(letagtxt), 'String');
            % Modifier la valmin
            letag=[nomparam{i} 'min'  sufmod '_tag'];
            fact=timemod2data(ch,...
                uniteT,...
                data.Basemodeles.type.(nomparam{i}));
            val=get(data.(letag), 'String');
            valout = str2double(val)*fact;
            % mettre assez de ch decimaux pour qu'il n'y ait pas d'arrondis
            % si on change ensuite d'unite de temps
            set(data.(letag), 'String', num2str(valout, 5));
            % Modifier les bornes valides
            valuserdata=get(data.(letag), 'userdata'); 
            valbornes=valuserdata{1};
            bornes={num2str(str2double(valbornes{1})*fact), ...
                num2str(str2double(valbornes{2})*fact)};
            valuserdata{1}=bornes;
            set(data.(letag), 'userdata', valuserdata);
                      
            % Modifier la valmax
            letag=[nomparam{i} 'max' sufmod '_tag'];
            val=get(data.(letag), 'String');
            valout = str2double(val)*fact;
            set(data.(letag), 'String', num2str(valout, 5));
            % Modifier les bornes valides
             set(data.(letag), 'userdata', valuserdata);
            % Modifier le label apres le nom du parametre
            chout=transfo_unite(ch, ...
                data.Basemodeles.type.(nomparam{i}), ...
                data.Basemodeles.unite.(nomparam{i}), ...
                data.uniteT_pourcalcul_libelle);
            set(data.(letagtxt), 'String', chout);
            
        end
    end
    
end
% les parametres fixes
nomparamSstr=['nomparamS' suf];

if isfield(data, nomparamSstr) && ~isempty(data.(nomparamSstr))
    nomparam=data.(nomparamSstr);
    for i=1:length(nomparam)
        if isfield(data.Basemodeles.type, nomparam{i})
            % le parametre depend du temps
            letagtxt=[nomparam{i} sufmod '_txttag'];
            ch=get(data.(letagtxt), 'String');
            % Modifier la val affichée
            letag=[nomparam{i} sufmod '_tag'];
            fact=timemod2data(ch,...
                uniteT,...
                data.Basemodeles.type.(nomparam{i}));
            val=get(data.(letag), 'String');
            valout = str2double(val)*fact;
            set(data.(letag), 'String', num2str(valout, 5));
            % Modifier les bornes valides
            valuserdata=get(data.(letag), 'userdata');
            valbornes=valuserdata{1};
            bornes={num2str(str2double(valbornes{1})*fact), ...
                num2str(str2double(valbornes{2})*fact)};
            valuserdata{1}=bornes;
            set(data.(letag), 'userdata', valuserdata);
            
            % Modifier le label apres le nom du parametre
            chout=transfo_unite(ch, ...
                data.Basemodeles.type.(nomparam{i}), ...
                data.Basemodeles.unite.(nomparam{i}), ...
                data.uniteT_pourcalcul_libelle);
            set(data.(letagtxt), 'String', chout);
        end
    end
end

end % fin maj_timeparam
