function data= plot_evolution_para(tag, data, ...
    nbparammodel, nomparam, ...
    abscisses,Moyenne,ICInf,  ICSup, ...
    nbparticules, nmod)
%plot_evolution_para Plot evolutions of the estimated values of the parameters
% Function called when there is not stability study (no CI required)

%% ======================================================


m=floor(nbparammodel./2);
if mod(nbparammodel,2)
    m=m+1;
end

if nargin > 9
    % comparaison de modeles
    if nmod==1
        quel='Numerator';
    else
        quel='Denominator';
    end
    titre=[ quel ' model: '];
    strnmod=num2str(nmod);
else
    titre='';
    strnmod='';
end
titre=[titre, 'PARTICLE ESTIMATION EVOLUTION '];

% Mettre dans une structure 'filtrexplot' situé dans 'base'
% ce qui est nécessaire aux graphiques de façon à pouvoir
% les retracer si clic gauche dessus
sauve_hp('filtrexplot', 2,  'nbparticules', nbparticules, 'nomparam', nomparam, ...
    'abscisses' , abscisses, ...
    'uniteT_libelle', data.uniteT_libelle, ...
    [ 'Moyenne' strnmod],Moyenne, ...
    ['ICInf' strnmod], ICInf, ['ICSup' strnmod], ICSup);


hp2=uipanel('parent',data.hpanel_work,...
    'tag',tag,...
    'BorderType', 'none', ...
    'BackgroundColor',[1 1 1],...
    'Position',[0 .02 1 0.98]);

hptitre= uipanel('parent',hp2,...
    'BackgroundColor',[1 1 1],...
    'BorderType', 'none', ...
    'Position', [0 0.965 1 0.035]);


for numfig=1:nbparammodel
    if isempty(nomparam)
        descript=num2str(numfig);
    else
        descript=traduc_nom(nomparam{numfig}, data.Basemodeles.type);
    end
    subplot(m,2,numfig,'parent',hp2)
    
    plot(abscisses,Moyenne(numfig,:),'-',abscisses,ICInf(numfig,:),'--',abscisses,ICSup(numfig,:),'-.')
    
    argudessin= {numfig, strnmod, data.Basemodeles.type};
    set(gca,'buttondownfcn',{@dessin_hp2, argudessin})
    
    
    title(['PARAMETER '    descript]);
    xlabel(['time (' data.uniteT_libelle ')'])
    %    ylabel([num2str(nbparticules) ' particles'])
end % fin numfig
icniveau=get(data.iclevel_tag(1), 'value');
strniveau=get(data.iclevel_tag(1), 'String');
niveau=strrep(strniveau{icniveau},' ',''); %enlever les blancs
legend('mean', ...
    ['lower bound of the particle confidence interval (' niveau, ')'], ...
    ['upper bound of the particle confidence interval (' niveau, ')'], ...
    0,'location',[.42 .018 .25 .05])


hax= axes('Position', [0 0 1 1],'parent',hptitre, 'Visible', 'off');
text(0.5, 0.08, titre, 'FontSize',12,'HorizontalAlignment','center', 'Parent', hax)

data.(tag)=hp2; % 29/1/2014, Matlab R2013a


end % fin plot_evolution_para


%% ==================================================
function  dessin_hp2(~, ~, argudessin)
% dessin_hp2
% Tracé graphique dans une fenêtre graphique Matlab du panel hp2

%% ======================================================
numfig = argudessin{1};
strnmod = argudessin{2};
type = argudessin{3};

donnees = evalin('base', 'filtrexplot');

hfig=figure('Name', 'Evolution');
hax =   axes( 'parent', hfig);

if  isempty(donnees.nomparam)
    descript=num2str(numfig);
else
  descript=traduc_nom(donnees.nomparam{numfig}, type);
end
Moyenne = eval(['donnees.Moyenne' strnmod]);
ICInf = eval(['donnees.ICInf' strnmod]);
ICSup = eval(['donnees.ICSup' strnmod]);

plot(hax, donnees.abscisses, Moyenne(numfig,:),'-', ...
    donnees.abscisses,...
    ICInf(numfig,:),'--',donnees.abscisses, ICSup(numfig,:),'-.')
title(['PARTICLE ESTIMATION EVOLUTION OF '    descript]);
%title(['EVOLUTION DES ESTIMATIONS DU PARAMÈTRE ' descript])
 xlabel(['time (' donnees.uniteT_libelle ')'])
%ylabel([num2str(donnees.nbparticules) ' particles'])
data=guidata(1);
icniveau=get(data.iclevel_tag, 'value');
strniveau=get(data.iclevel_tag, 'String');
niveau=strrep(strniveau{icniveau},' ',''); %enlever les blancs

legend('mean', ...
    ['lower bound of the particle confidence interval (' niveau, ')'], ...
    ['upper bound of the particle confidence interval (' niveau, ')'], 0)




end % dessin_hp2
