
function  sauve_hp(nomstruct, nosauve,  varargin)
%sauve_hp Save a panel
% Store what is necessary to make the plots of a panel again.
% INPUT
% nosauve: = 1, if the structure 'nomstruct' should be created
%         otherwise, it is completed. 
% See also recup_interface
%% ======================================================

%commande de creation de la structure
expr = [nomstruct '= struct();'];
if nosauve==1
    % on demande la creation de la structure de sauvegarde
    evalin('base', expr) ;
else
    % la structure exite-elle deja? si oui, il ne faut pas la demolir
    % si non, il faut la creer
    try
        donnees= evalin('base', nomstruct);
    catch 
        evalin('base', expr) ;
    end
end


nval= size(varargin,2);
for i=1:2:nval
         if ~iscell(varargin{i}) && ischar(varargin{i+1})
         % cas où la valeur est une chaine de car
         ssexpr=[varargin{i} '=''' varargin{i+1} '''' ];
     else
    ssexpr=ctr_ssexpr(varargin{i}, varargin{i+1});
     end
    expr =[nomstruct '.' ssexpr ';' ];
    evalin('base', expr) ;
end


end %  sauve_hp
%% ===========================================================
function  ssexpr= ctr_ssexpr(nom, valeur)
% ctr_ssexpr
% Construction d'une sous-expression de l'expression de sauvegarde
% d'une structure qui contient les donn�es n�cessaires aux graphiques
% APPELE PAR  sauve_hp*

%% ======================================================
s=size(valeur);
if iscell(valeur) && ischar(valeur{1})
    ssexpr=[nom '= {' ];
    for i=1:s(2)
        ssexpr=[ssexpr  ' ''' valeur{i} ''' '];
    end
    ssexpr=[ssexpr  '};'];
else
    ssexpr=[nom '= ['];
    
    
    for i=1:s(1)
        ssexpr=[ssexpr  num2str(valeur(i,:))  ';'];
    end
    ssexpr=[ssexpr ']'];
    
end
end % ctr_ssexpr

