
function fileSave = sauver_modele(obj,event)
%sauver_modele Save one or several models
% INPUT
% userdata is a structure
% - When the function is called by the task 'parametric identification',
%   userdata= {0}: case without any histogram
%   userdata= {0, structHisto} : case where histograms have been required.
%  structHisto is what is nessary to restore them
%   userdata= {0, ignored, AC}: case where there are histograms due to stability study
% (CI required)
% AC is what is nessary to restore them
%  - When the function is called by the task 'models comparison',
%    userdata={1}
% 'event' contains the name of a backup file, when execution is not interactive
% NB: In the task 'parametric identification', there is one model, only.
%  In the task 'models comparison', there are 2 models.
%% ======================================================
data=guidata(1);

impsave = 'it is not possible to save anything'; % message d'erreur

% On rajoute à data, dans des composants de suffixe _in,
%  tout ce qu'on ne peut pas rétablir à partir de ce
% que contient data
%% Sauvegarder les CV s'ils ne sont pas à estimer
% dans le cas général, les CVs sont dans data.([var,'_tag'])
% mais s'ils sont à estimer, ils sont traités comme les autres
% parametres, d'où le try
try
    for i=1:length(data.CVs.nomparamS)
        var=data.CVs.nomparamS{i};
        lin=[var,'_in'];
        vv=get(data.([var,'_tag']),'string');
        if iscell(vv)
            vv=vv{1};
        end
        data.(lin)=eval(vv);
    end
end

% Sauvegarde des parametres du filtre
for i=1:length(data.Filtre.nomparamS)
    if ~strcmp(data.Filtre.nomparamS{i}, 'graineAlea')
        varin=[data.Filtre.nomparamS{i} '_in'];
        tag=[data.Filtre.nomparamS{i} '_tag'];
        try
            style= get(data.(tag), 'style');
            if strcmpi(style, 'listbox')
                data.(varin) = get(data.(tag), 'value');
            else
                data.(varin) = eval(get(data.(tag), 'string'));
            end
        catch
            errordlg(['Input are not complete: ', tag, ' missing']);
        end
    end
end


% Sauvegarde des autres valeurs qui sont sous forme string:
try
    data.fichier_descr=get(data.fichier_descr_tag,'string');
end
try
    % sauvegarder le nom du fichier des données
    fc= get(data.fichier_chemin_tag,'string');
    data.fichier_nom= regexprep(fc, 'RESTORE.*', ''); 
end
try
    data.deltaT_in=eval(get(data.deltaT_tag,'string'));
    data.uniteT_in=get(data.uniteT_tag,'value');
    data.pas_tag_in = get(data.pas_tag, 'string');
    data.uniteT_pourcalcul_libelle_in = data.uniteT_pourcalcul_libelle;
    data.uniteT_pourcalcul_in = data.uniteT_pourcalcul;
catch
    errordlg(['Input are not complete: ' impsave] );
    return
end

%% stockage de la valeur de la graine aleatoire
try
    data.graineAlea_in=eval(get(data.graineAlea_tag,'string'));
catch
    data.graineAlea_in='CLOCK';
end

%% recuperer le programme qui a calcule et les eventuelles infos d'histo
userstruct = get(obj, 'userdata');
if length(userstruct) >=2
    data.structHisto=userstruct{2};
end
if length(userstruct) >=3
    data.AC=userstruct{3};
end
luserdata = userstruct{1};

%% sauvegarde du modele
switch luserdata
    case 0 %estimation
        % un seul modele
        if ~isfield(data, 'modelepop') || isempty(data.modelepop)
            errordlg(['No dynamics equation model has been selected: ' impsave]);
            return
        end
        [data, nomparamactifs]=sauver_mod(data, '');
    case 1 % comparaison
        % 2 modeles
        if ~isfield(data, 'modelepop1') || isempty(data.modelepop1) || ...
                ~isfield(data, 'modelepop2') || isempty(data.modelepop2)
            errordlg(['The both dynamics equation models have not been selected ' impsave]);
            return
        end
        
        % essayer de sauver chacun des modèles
        try
            [data, nomparamactifs]=sauver_mod(data, '1');
        end
        try
            [data, nomparamactifs]=sauver_mod(data, '2');
        end
        
        
end %fin switch


%% stockage des résultats de l'étude de stabilité éventuellement
try
    valfonction={'min','max','mean','std','tinv'};
    taille=length(valfonction);
    nbactifs = length(nomparamactifs);
    data.stab_res=zeros(nbactifs, taille+1);
    data.stab_nombre_dynamique= get(data.stab_edit_tag, 'string');
    data.level_stab=get(data.level_stab_edit_tag, 'value');
    
    for i=1:taille
        var_tag=['data.stab_gourpebutton' num2str(i+1) '_tag'];
        eval(['child = allchild(' var_tag ');']);
        for j=1:nbactifs
            a=get(child(j), 'string');
            b=cell2mat(a);
            instr='';
            for k=1:length(b)
                instr=[instr b(k)];
            end
            eval(['z=' instr ';']);
            % les paramètres sont rangés en ordre inverse des fils
            % le fils 1 de stab_gourpebutton2 correspond au min du dernier
            % paramètre
            l=nbactifs-j+1;
            if (i~=5)
                data.stab_res(l,i)= z;
            else
                data.stab_res(l,5:6)=z;
            end
        end %fin j
    end %fin i
catch
    data.stab_nombre_dynamique= 0;
end % fin du try


%% Sauvegarde des plots s'il y en a (i.e pas d'etude de stabilite)
try
    data.filtrexplot = evalin('base', 'filtrexplot');
end

% Event contient le nom d'un fichier restauré quand il s'agit
% d'une exécution d'estimation non-interactive
% En interactif, pas d'event
if isempty(event)
    % mode interactif
    % Extraire le nom du fichier des données
            [p,n,e]= fileparts(regexprep(data.fichier_nom, 'DATA.*:', ''));
            n=strrep(n, ' ','');
    switch luserdata
        case 0 % estimation
            %Version 2.0            uisave('data', [getenv('PROJECTDIR') '/IDENTIFICATION/estim' data.modelepop '.' date '.mat']);
                       
            uisave('data', [getenv('PROJECTDIR') '/IDENTIFICATION/id' ...
                datestr(now, 'yyyymmdd') data.shortmodel  '_' n '.mat']);
        case 1 % comparaison de modeles
           %Version 2.0   uisave('data', [getenv('PROJECTDIR') '/MODEL_COMPARISON/compar' data.modelepop1  data.modelepop2 '.' date '.mat']);
           uisave('data', [getenv('PROJECTDIR') '/MODEL_COMPARISON/cp' ...
             datestr(now, 'yyyymmdd')  data.shortmodel1 '_' data.shortmodel2 '_' n '.mat']);
    end %fin switch
else
    % mode batch (cas de l'estimation seulement)
    [~,n,~]=fileparts(event);
    fileSave = ['../RUNTESTS/RESULTTESTS/' n, '.test.' date '.mat'];
    save( fileSave, 'data');
end

end %fin sauver_modele


%% =============================================
