        

function data=trace_modele_simulation(s, meth )
% trace_modele_simulation Display a model with default values of its parameters
% in the task 'Simulation of an optimal design'
% INPUT
% s: number of the model among all the available ones
% meth: number of the method (1: sobol, 2: tornsey, 3:sivip)
% NOTE: this function is called by gestion_parametres
%% =======================================================================
% les bornes a partir desquelles on écrit en notation exponentielle
valinf=-1000;
valsup=+1000;

data=guidata(1);
Basemodeles=data.Basemodeles;
data.modelepop=Basemodeles.nom{s};
%nomcourt est introduit en oct 2014 (nom abrégé du modèle)
if isfield(Basemodeles, 'nomcourt')
    data.shortmodel=Basemodeles.nomcourt{s};
else
    data.shortmodel=Basemodeles.nom{s};
end
lemodele=strrep(data.modelepop, '-',''); %le nom du modele sans tiret
nomparamP=data.Basemodeles.nomparamP{s};
nomparamS=data.Basemodeles.nomparamS{s};

init=Basemodeles.init;
% suffixe des tags des boutongroups où on écrit
if meth ==3
    suf='s';
else
    suf='';
end

tag=['modele' suf '_tag'];

set(data.(tag),'string',[data.modelepop ' MODEL']);

set(data.(['min' suf '_tag']),'visible','on')
set(data.(['max' suf '_tag']),'visible','on')
%le bruit
% dans cette version, il est non visible: il est fixé a la valeur par défaut
% Au cas ou on veuille le remettre
% visible noise: if meth==3 % bruit sur les parametres que pour sivip
% visible noise:     set(data.(['button_bruit' suf ]),'visible','on')
% visible noise: end

pasy=1/8;
if length(nomparamS)+length(nomparamP)>7
    pasy=0.96/(length(nomparamS)+length(nomparamP));
end
delete(get(data.(['groupebutton30' suf '_tag']),'children'))
delete(get(data.(['groupebutton31' suf '_tag']),'children'))
delete(get(data.(['groupebutton32' suf '_tag']),'children'))
delete(get(data.(['groupebutton33' suf '_tag']),'children'))


%% Traitement des paramètres actifs
for i=1:length(nomparamP)
    iscv=0;
    %  cas ou il n'y a pas de paramètres actifs
    if ~isempty(nomparamP{i})
        if isfield(data, 'CVs') && ...
                any(strcmpi(nomparamP{i}, data.CVs.nomparamS))
            % le parametre est un CV
            iscv=1;
            if isfield(data, [nomparamP{i} '_fixtag'])
                % le CV avait été précdemment fixé:
                % détruire le tag nomparamS_fixtag
                % (nécessaire pour ytheorique), qui indique que le CV est fixé
                data=rmfield(data, [nomparamP{i} '_fixtag']);
            end
            % maj sa valeur dans le panel du haut
            set(data.([nomparamP{i}  '_tag']), 'string', '-', 'enable','off');
        end
        % Ecrire le nom du paramètre
        % Traduction eventuelle du nom des CV
        lastring=traduc_nom(nomparamP{i}, Basemodeles.type );
        letag=[nomparamP{i} '_txttag'];
        hd=uicontrol('parent',data.(['groupebutton30' suf  '_tag']),...
            'units','normalized',...
            'position',[0 0.96-pasy*i 1 pasy],...
            'style','text',...
            'tag', letag, ...
            'backgroundcolor','w',...
            'foregroundcolor','k',  'string', lastring);
        data.(letag)=hd;
        
        if iscv==1
            minmaxdef= init.(nomparamP{i});
            valbornes=Basemodeles.DF.(nomparamP{i});
        else
            minmaxdef= init.(lemodele).(nomparamP{i});
            valbornes=Basemodeles.DF.(lemodele).(nomparamP{i});
            if isfield(data, 'tobs') && ~isempty(data.tobs) && isfield(Basemodeles.type, nomparamP{i})
                % des donnees ont été lues: convertir les bornes du param selon leur unite de temps
                uniteT= get(data.uniteT_tag, 'value');
                
                fact=timemod2data(Basemodeles.unite.(nomparamP{i}),...
                    uniteT, ...
                    Basemodeles.type.(nomparamP{i}));

                a=str2double(minmaxdef{1})*fact;
                minmaxdef{1}=num2str(a);
                a=str2double(minmaxdef{2})*fact;
                minmaxdef{2}=num2str(a);
                a=str2double(valbornes{1})*fact;
                valbornes{1}=num2str(a);
                a=str2double(valbornes{2})*fact;
                valbornes{2}=num2str(a);
            end
            
        end
        
        % Ecrire son min
        var=[nomparamP{i},'min'];
        data.(var)=eval( minmaxdef{1});
        
        tag=[var,'_tag'];
        hd=uicontrol('parent',data.(['groupebutton31' suf  '_tag']),...
            'units','normalized',...
            'position',[0 1-pasy*i 1 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'callback',@control_saisie,...
            'userdata', {valbornes,traduc_nom(nomparamP{i})}, ...
            'style','edit');
        data.(tag)=hd; % Matlab2013a 29/1/14
        
        % ecrire les grosses ou petites valeurs en notation E
        val=data.(var);
        if val < valinf || val > valsup
            
            valstr=num2str(val, '%10.2e');
            set(hd,'string', valstr)
        else
            set(hd,'string',eval(['data.',var]))
        end
        
        
        
        % Ecrire son max
        var=[nomparamP{i},'max'];
        data.(var)=eval(minmaxdef{2});
        
        tag=[var, '_tag'];
        hd=uicontrol('parent',data.(['groupebutton32' suf  '_tag']),...
            'units','normalized',...
            'position',[0 1-pasy*i 1 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'callback',@control_saisie,...
            'userdata', {valbornes,traduc_nom(nomparamP{i})}, ...
            'style','edit');
        
        
        % ecrire les grosses ou petites valeurs en notation E
        val=data.(var);
        if val < valinf || val > valsup
            
            valstr=num2str(val, '%10.2e');
            set(hd,'string', valstr)
        else
            set(hd,'string',eval(['data.',var]))
        end
        data.(tag)=hd; % Matlab13a 29/1/14
        
        
        % Affecter  son bruit(pour sivip): on ne le fait pas apparaitre
        % dans cette version, toujours le bruit par défaut
        
        if meth==3
            decal=0.02;
            var=[nomparamP{i},'_bruit'];
            tag=[var, '_tag'];
            br=uicontrol('parent',data.(['groupebutton33' suf  '_tag']),...
                'Visible', 'off', ...
                'units','normalized',...
                'position',[0 1-decal-pasy*i 1 pasy],...
                ...%'backgroundcolor','w',...
                'tag',tag,...
                'style','popupmenu',...
                'string','   Poisson|   Gaussian');
            %           'string','   Poisson|   Gaussian|Binomial');
            if isfield(Basemodeles, 'initbruit')
                set(br,'value',Basemodeles.initbruit.(nomparamP{i}))
                
            end  %  fin isfield
            data.(tag)=br; % Matlab13a 29/1/14
        end % fin if meth==3
    end % fin ~isempty
end % fin i

if isempty(i) || isempty(nomparamP{1})
    % pas de parametres actifs
    i=0;
    set(data.(['min' suf  '_tag']), 'visible', 'off');
    set(data.(['max' suf  '_tag']), 'visible', 'off');
    uicontrol('parent',data.groupebutton3_tag,...
        'units','normalized',...
        'fontsize',10,...
        'position',[.35 .9 .30 .05],...
        'backgroundcolor',[1 1 1],...
        'foregroundcolor','k',...
        'style','text',...
        'tag', 'apriori_tag', ...
        'string','A PRIORI PARAMETER VALUES');
else
    set(data.(['min' suf  '_tag']), 'visible', 'on');
    set(data.(['max' suf  '_tag']), 'visible', 'on');
    
    if isfield(data, 'apriori_tag') && ishandle(data.apriori_tag(end))
        set(data.apriori_tag(end), 'Visible', 'off');
    end
end
%% Traitement des paramètres fixés
for j=1:length(nomparamS)
    if ~isempty(nomparamS{j})
        i=i+1; % incrémenter le déplacemant vertical
        
        % Dans le cas de la simulation de stragégie opt, méthode Tornsey,
        % mettre une marque devant les parametres constants
        %(dans  le cas de la simulation de stragégie opt, méthode Tornsey, tous les paramètres sont assimilés à des parametres fixés pour l'affichage)
        letag= [nomparamS{j} '_fix_tornsey'];
        hd= uicontrol('parent',data.(['groupebutton30' suf  '_tag']),...
            'units','normalized',...
            'position',[0.25 0.98-pasy*i 0.1 pasy],...
            'style','text',...
            'backgroundcolor',[1 1 1],...
            'foregroundcolor','k',...
            'visible', 'off', ...
            'String', '**',...
            'tag', letag);
        data.(letag)=hd; % Matlab2013a 29/1/14
        
        % Traduction eventuelle du nom des CV
        lastring=traduc_nom(nomparamS{j}, Basemodeles.type);
        letag=[nomparamS{j} '_txttag'];
        
        hd=uicontrol('parent',data.(['groupebutton30' suf  '_tag']),...
            'units','normalized',...
            'position',[0.1 0.96-pasy*i 0.9 pasy],...
            'style','text',...
            'tag', letag, ...
            'backgroundcolor',[1 1 1],...
            'foregroundcolor','k',...
            'string', lastring);
        
        % Ecrire sa valeur fixée
        if  isfield(data, 'CVs') && ...
                any(strcmpi(nomparamS{j}, data.CVs.nomparamS))
            % le parametre est un CV
            k=find(strcmp(data.CVs.nomparamS, nomparamS{j}),1);
            % mettre sa valeur dans un tag nomparamS_fixtag
            % (nécessaire pour ytheorique),
            %  nomparamS_tag étant le tag dans le panel des paramètres du modèle d'observations
            tag=[nomparamS{j},'_fixtag'];
            hd=uicontrol('parent',data.(['groupebutton31' suf  '_tag']),...
                'units','normalized',...
                'position',[0 1-pasy*i 2.0 pasy],...
                'backgroundcolor','w',...
                'tag',tag,...
                'userdata', {Basemodeles.DF.(nomparamS{j}), ...
                nomparamS{j}, data.CVs.valparamS{k}}, ...
                'callback',@fix_CV,...
                'style','edit');
            data.(tag)=hd; % Matlab2013a 29/1/14
            valeur = data.CVs.valparamS{k};
            
            data.(nomparamS{j})=valeur;
            % Maj de la valeur du CV dans le panel des paramètres du modèle d'observations
            set(data.([nomparamS{j},'_tag']), 'string', valeur, 'enable', 'off');
            
        else
            % le parametre n'est pas un CV
            valfix=Basemodeles.valparamS.(lemodele).(nomparamS{j});
            valbornes=Basemodeles.DF.(lemodele).(nomparamS{j});
            if isfield(data, 'tobs') && ~isempty(data.tobs) && isfield(Basemodeles.type, nomparamS{j})
                % des donnees ont été lues: convertir les bornes du param selon leur unite de temps
                uniteT= get(data.uniteT_tag, 'value');
                fact=timemod2data(Basemodeles.unite.(nomparamS{j}),...
                    uniteT, ...
                    Basemodeles.type.(nomparamS{j}));
                a=str2double(valbornes{1})*fact;
                valbornes{1}=num2str(a);
                a=str2double(valbornes{2})*fact;
                valbornes{2}=num2str(a);
                valfix=valfix*fact;
            end
            
            tag=[nomparamS{j},'_tag'];
            hd=uicontrol('parent',data.(['groupebutton31' suf  '_tag']),...
                'units','normalized',...
                'position',[0 1-pasy*i 2.0 pasy],...
                'backgroundcolor','w',...
                'tag',tag,...
            'userdata', {valbornes,traduc_nom(nomparamS{j})}, ...
                'callback',@control_saisie,...
                'style','edit');
            data.(tag)=hd; % Matlab2013a 29/1/14
            
            valeur=valfix;
            
        end
        
        if ischar(valeur)
            val=eval(valeur );
        else
            val=valeur;
        end
        
        
        if val < valinf || val > valsup
            
            valstr=num2str(val, '%10.2e');
            set(hd,'string', valstr)
        else
            set(hd,'string',valeur)
        end
        
        
        
    end %fin ~isempty
end % fin j

data.nomparam=nomparamP;
data.nomparamS=nomparamS;
data.nomparamH=Basemodeles.nomparamH{s};%%30/12

handles=guihandles;
ndata=catstruct(data,handles);
guidata(1,ndata)

end %fin trace_modele_simulation
%% ========================================================================
function [retour]=stocke_panel(data, nomparamP, nomparamS, init)
% stocke_panel
% Renvoie dans une structure les valeurs courantes, si elles existent
% dans le panel data, des paramètres, et si elles n'existent pas
% les val par défaut

%% ======================================================
lemodele=strrep(data.modelepop, '-',''); %le nom du modele sans tiret
for i=1:length(nomparamP)
    varmin=[nomparamP{i},'min'];
    varretmin = [varmin, '_tag'];
    varmax=[nomparamP{i},'max'];
    varretmax = [varmax, '_tag'];
    varbruit = [nomparamP{i},'_bruit'];
    varretbruit = [varbruit, '_tag'];
    try
        retour.(varmin)= get(data.(varretmin), 'string');
        retour.(varmax)= get(data.(varretmax), 'string');
        retour.(varbruit) = get(data.(varretbruit), 'value');
    catch
        if isempty(strfind(nomparamP{i},'CV'))
            % le parametre n'est pas un CV
            retour.(varmin)=eval(init.(lemodele).(nomparamP{i}){1});
            retour.(varmax)=eval(init.(lemodele).(nomparamP{i}){2});
        else
            retour.(varmin)=eval(init.(nomparamP{i}){1});
            retour.(varmax)=eval(init.(nomparamP{i}){2});
        end
        retour.(varbruit) = data.Basemodeles.initbruit.(nomparamP{i});
    end
end

for i=1:length(nomparamS)
    try
        varret= [nomparamS{i}, '_tag'];
        retour.(nomparamS{i})= get(data.(varret), 'string');
    catch
        if isempty(strfind(nomparamS{i},'CV'))
            % le parametre n'est pas un CV
            retour.(nomparamS{i})= data.Basemodeles.valparamS.(lemodele).(nomparamS{i});
        else
            retour.(nomparamS{i})= data.Basemodeles.valparamS.(nomparamS{i});
        end
    end
end


end % fin stocke_panel
