/*=================================================================
 * Modele BiPhasic en C et double precision
 * Pour la
 * Simulation de strategie optimale, version C
 * Voir BaranyiRoberts pour les E/S
 * COMPILATION sous matlab par: 
 * mex  /home/abouvier/MONFILTREX/v2013-1.0/SRC/SIMULATION_STRATEGIE/C/CBiPhasic.c

 *============================================================*/
#include <math.h>
#include "mex.h"
double exp( double base );
double log10 (double x);


  /* ============================================================== */      

void  CBiPhasicDP(double *param, double * temps, 
        double *valmin, double *valmax, double *rep,
        int ntemps, int N, int Ncur)
{

double f=(double) param[Ncur];
double kmax1=(double) param[N+Ncur];
double kmax2= (double) param[2*N+Ncur];
double log10N0= (double) param[3*N+Ncur];
 
 int i, ind, u;
 double aux1,  grandf, G, ti, Z;

 for ( i=0; i< ntemps; i++) {
   ti=temps[i];
   aux1=exp(-kmax1 * ti);
   grandf= f * aux1;
   G =(1-f) * exp(-kmax2 * ti);
   Z= log10N0+ log10(grandf +G);
   ind=N*i+Ncur;
    rep[ind]= Z;
 /* Ramener dans les bornes les réponses invalides */
    /*ATT: ce qu'on a calculé, c'est log10(Nt) */
   /*  Nt doit etre >0 => log10(Nt) >1 */

    if (rep[ind] < (*valmin)) {
      rep[ind]=(double)(*valmin);
    }
    if (rep[ind] > (*valmax)) {
      rep[ind]=(double)(*valmax);
    }
  
 } /* fin i */

}
/* ============================================================== */
void CBiPhasic(double *param,  double *temps, 
 double *valmin, double *valmax,
  double *rep,int ntemps,
  int N)
{

    /* boucle sur l'appel à BiPhasic */
    int u;
    for (u=0; u<N; u++) {
        CBiPhasicDP( param,  temps,valmin, valmax,  rep, ntemps, N, u);
    }

}

/* ================================================== */
/* The gateway function:
INPUT
nlhs: le nombre de sorties (la fonction a pls sorties quand
 l'utilisateur affecte une structure à pls composants
 à son appel a CBiPhasic)
plhs: les sorties
nrhs: le nombre d'arguments d'entrée
prhs: les arguments d'entrée
 */
void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double *rep, *param, *temps, *valmin, *valmax;
  int N, ntemps;

  

/* The first input argument param: 4 parameters */
  N = (int) mxGetM(prhs[0]);
 
   
/* create a pointer to the  input   */
param = mxGetPr(prhs[0]);

/* Second input argument: times is 1 x ntemps */
ntemps = (int) mxGetN(prhs[1]);

temps=mxGetPr(prhs[1]);

/* Third input argument:valmin */
    valmin=(double *)mxGetPr(prhs[2]);
/* Fourth input argument:valmax */
    valmax=(double *)mxGetPr(prhs[3]);

/* 5th input argument: result matrix */
    rep = (double *)mxGetPr(prhs[4]);

/* create the output matrix 
 plhs[0] = mxCreateDoubleMatrix((mwSize)N,(mwSize)ntemps,mxREAL);
rep = mxGetPr(plhs[0]);
*/

/* call the computational routine */
 CBiPhasic( param,  temps, valmin, valmax, rep,(int)ntemps, (int)N);

} 
