/*=================================================================
 * Modele LogLinearS en C et double precision
 * Pour la
 * Simulation de strategie optimale, version C
 * Voir BaranyiRoberts pour les E/S
 * COMPILATION sous matlab par: 
 * mex  /home/abouvier/MONFILTREX/v2013-1.0/SRC/SIMULATION_STRATEGIE/C/CLogLinearS.c

 *============================================================*/
#include <math.h>
#include "mex.h"
double pow( double base, double exponent );
double exp( double base);
double log10 (double x);

  /* ============================================================== */      

void  CLogLinearSDP(double *param, double * temps, 
         double *valmin, double *valmax, double *rep,
        int ntemps, int N, int Ncur)
{

double kmax = (double) param[Ncur];
double S1= (double) param[N+Ncur];
double log10N0= (double) param[2*N+Ncur];
 
 int i, ind, u;
 double B, aux1, C, ti;

 for ( i=0; i< ntemps; i++) {
   ti=temps[i];
   B= exp(-kmax * ti);
   aux1=exp(kmax * S1); 
   C=  aux1 / (1+ (aux1 -1) * B);
   ind=N*i+Ncur;
    rep[ind]=pow(10,  log10N0)*B*C;
 /* Ramener dans les bornes les réponses invalides */
 /*On renvoie un log10(Nt): Nt, soit l'argument du log10 doit etre >0*/

    if (rep[ind] <= 0) {
      rep[ind]=(double)1.0e-10;
    }

    rep[ind]=log10(rep[ind]);
    if (rep[ind] < (*valmin)) {
      rep[ind]=(double)(*valmin);
    }
    if (rep[ind] > (*valmax)) {
      rep[ind]=(double)(*valmax);
    }
     

 } /* fin i */

}
/* ============================================================== */
void CLogLinearS(double *param,  double *temps,
 double *valmin, double *valmax, double *rep,int ntemps,
  int N)
{

    /* boucle sur l'appel à LogLinearSDP */
    int u;
    for (u=0; u<N; u++) {
        CLogLinearSDP( param,  temps,valmin, valmax,  rep, ntemps, N, u);
    }

}

/* ================================================== */
/* The gateway function:
INPUT
nlhs: le nombre de sorties (la fonction a pls sorties quand
 l'utilisateur affecte une structure à pls composants
 à son appel a CLogLinearS)
plhs: les sorties
nrhs: le nombre d'arguments d'entrée
prhs: les arguments d'entrée
 */
void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double *rep, *param, *temps, *valmin, *valmax;
  int N, ntemps;

  

  N = (int) mxGetM(prhs[0]);
   
/* create a pointer to the  input   */
/* First argument: param (3 parameters) */
param = mxGetPr(prhs[0]);

/* Second input argument: times is 1 x ntemps */
ntemps = (int) mxGetN(prhs[1]);

temps=mxGetPr(prhs[1]);

/* Third input argument:valmin */
    valmin=(double *)mxGetPr(prhs[2]);
/* Fourth input argument:valmax */
    valmax=(double *)mxGetPr(prhs[3]);

/* 5th input argument: result matrix */
    rep = (double *)mxGetPr(prhs[4]);

/* create the output matrix 
 plhs[0] = mxCreateDoubleMatrix((mwSize)N,(mwSize)ntemps,mxREAL);
rep = mxGetPr(plhs[0]);
*/

/* call the computational routine */
 CLogLinearS( param,  temps,valmin, valmax,  rep,(int)ntemps, (int)N);

} 
