/*=================================================================
 * Calibration d'un plan 
 * Pour la
 * Simulation de strategie optimale, version C
 * INPUT
 * nmoda: valeur de N
 * nf: nombre de paramètres
 * pas: vecteur double (nf)
 * alea: nombres aléatoires entre [0 1], ('double',  nmoda, nf)
 * binf: valeur min des paramètres (nf)
 * planin: le plan  (nmoda, nf)
 * OUTPUT
 * planout: le plan calibré (nmoda, nf)
 * COMPILATION sous matlab par:
 * mex  /home/abouvier/MONFILTREX/v2013-1.0/SRC/SIMULATION_STRATEGIE/C/CcalibS.c
 * TEST
 * graine=117; rng(graine);
 * planin=[1 4; 3 3; 5 1; 2 5; 4 2]; binf=[12, 16]; bsup=[20, 24];
 * nmoda=size(planin,1); nf=size(planin, 2);
 * pas= (bsup - binf)/(nmoda-1);
 * alea= rand(nmoda,  nf, 'double')
 * CcalibS( nmoda, nf,pas, alea, binf, planin)
 *============================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "mex.h"

void CcalibS(int nmoda, int nf, double *pas, double *alea,
        double *binf,  double *planin, float *planout)
{
    int u,j, ind;
    double delta;
 
    for (u=0; u< nmoda; u++) {
        for (j=0; j<nf; j++) {
            ind=j*nmoda+u;
            planout[ind] = (float)binf[j] + (planin[ind]-1) *pas[j];
                       
            delta=alea[ind]*pas[j];
            if (planin[ind]< nmoda) {
                planout[ind] += (float)delta;
            } else {
                planout[ind] -=(float)delta;
            }
        } /* fin j */
    }/* fin u  */
} /* fin CcalibS */

/* ================================================== */
/* The gateway function:
 * INPUT
 * nlhs: le nombre de sorties (la fonction a pls sorties quand
 * l'utilisateur affecte une structure à pls composants
 * à son appel a loopBaranyi)
 * plhs: les sorties
 * nrhs: le nombre d'arguments d'entrée
 * prhs: les arguments d'entrée
 */
void mexFunction( int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[] )
{
    double *nmoda, *nf;
    double *pas, *alea, *binf, *planin;
    float *planout;
   
    /* create a pointer to the input */
    nmoda = mxGetPr(prhs[0]);
    nf = mxGetPr(prhs[1]);
    pas =  mxGetPr(prhs[2]);
    alea = mxGetPr(prhs[3]);
    binf = mxGetPr(prhs[4]);
    planin= mxGetPr(prhs[5]);
    /* acces the output matrix */
    /* VERIF AU CAS OU
 if(mxGetM(prhs[6]) != (*nmoda)) {

   mexErrMsgIdAndTxt("CcalibS: mat should have N rows", "Input error");
 }
 if(mxGetN(prhs[6]) != (*nf)) {
   mexErrMsgIdAndTxt("CcalibS: mat should have nf columns", "Input error");
 }

 FIN VERIF */

    planout=(float *)mxGetPr(prhs[6]);
  
    /* call the computational routine */
    CcalibS((int)*nmoda, (int)* nf, pas, alea, binf,planin,planout);
}
