/*=================================================================
 * Calcul le nombre de monomes du polynomes dans l'Algorithme NIPALS
 * COMPILATION sous matlab par:
 * mex  /home/abouvier/MONFILTREX/trunk/SRC/SIMULATION_STRATEGIE/C/calcTaille.c
 *============================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "mex.h"

/*=================================================================*/

int calcTaille(int p, int degre)
{
/* -------------------------------------------------------- */
/* Calculer la taille du tableau resultat de la génération du polynomes
 * c.a.d le nombre de monomes
 * ENTREES
 * p: nombre de parametres
 * degre: degre du polynome entre 2 et 4
 * SORTIE
 * nombre de monomes
 * --------------------------------------------------------- */
  int taille=0;
  int i, j,l,m;
  for (i=0; i<p; i++) {
    taille++;
    for (j=i; j<p; j++) {
      taille++;
      if (degre >2) {
	for (l=j; l<p; l++) {
	  taille++;
	  if (degre >3) {
	    for (m=l; m<p; m++) {
	      taille++;
	    }
	  } /* fin (degre >3) */
	}
      } /* fin (degre >2) */
    }
  }
  return taille;
} /* fin calcTaille */
/* -------------------------------------------------------- */
/* ================================================== */
/* The gateway function:
 * ENTREES
 * nlhs: le nombre de sorties
 * nrhs: le nombre d'arguments d'entrée
 * prhs: les arguments d'entrée
 * SORTIE
 * plhs: les sorties
 * prhs: les arguments d'entrée
 * TEST
 * p=4; degre=2;
 * taille = calcTaille(p, degre)
 ------------------------------------------------- */
void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  int  np,  degre, taille;
  double *rep;
   np=(int ) mxGetScalar(prhs[0]);
   degre=(int) mxGetScalar(prhs[1]);

 taille= calcTaille( np,  degre);

/* create the output matrix */
 plhs[0] = mxCreateDoubleMatrix((mwSize)1,(mwSize)1,mxREAL);

/* get a pointer to the real data in the output matrix */
rep = mxGetPr(plhs[0]);
 *rep=(double)taille;
 
} /* fin mexFunction */


