function annotGraphe(optima, nomparam, titregraphe, ...
    xlab, ylab, h, hp)
% annotGraphe
% Annotation du graphique
% INPUT
% optima: les optima (valeurs uniques et triées)
% nomparam: noms des paramètres ou structure vide (pas de légende)
% titregraphe: titre du graphique
% xlab, ylab: label des axes
% h: handle du plot
% hp: le panel de tracé (facultatif: sinon les temps optimaux sont
% tracés sur la figure)
% =================================================================

title(titregraphe, 'HorizontalAlignment', 'center');
xlabel(xlab);
ylabel(ylab);
if ~isempty(nomparam)
    ch=get(h, 'Children');
    % Je reordonne les enfants du graphe, pour que ceux qui correspondent aux
    % courbes soient en 1ier et ceux qui correespondent aux optima soient en
    % dernier. Ainsi, on pourra limiter la légende aux courbes, qui seront
    % alors les nf 1iers enfants, la légende qui concerne les optima
    % n'apparaitra pas
    nch=length(ch);
    cch = ch(1:2:nch);
    cch(end+1:nch)=ch(2:2:nch);
    
    set(h, 'Children', cch);
    lastring=traduc_nom(nomparam);
    legend(lastring, 'Location', 'Best');
end


%% Ecrire les optima
if nargin >6
    %% Ecrire la liste des optima
    % determiner si les optima sont des entiers
    testi=rem(optima*10,10);
    if any(testi) ~=0
        format='%6.2f';
    else
        format='%6d';
    end
    chaine=' ';
    for i=1:length(optima)
        chaine=[chaine '  ' num2str(optima(i), format)];
    end
    
    % panel pour mettre la liste des optima
    hp3=uicontrol('parent',hp,...
        'units','normalized',...
        'fontsize',10,...
        'style','text',...
        'tag', 'tps_tag', ...
        'FontWeight', 'bold', ...
        'BackgroundColor','w',...
        'Position',[0 0.02 1 0.1]);
    
    set(hp3,  ...
        'string', {['OPTIMAL TIMES (', num2str(length(optima)), ' points)'] ,...
        '',chaine});
end
% Maj de data
data=guidata(1);
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(gcf,ndata)

end % fin annotGraphe
