function [ evoldet, dx, proba, iter,  optima, titregraphe, soustitre, indice_panel, data ] = ...
    calcStrategieOptTornsey(reseau, nf, paramfixes, theta0, ...
    maxiter, epscal, uniteT_libelle, seuil, ...
    modelepop, data, obj, evnt )
%calcStrategieOptTornsey calcul d'une stratégie optimale par la methode Tornsey
% INPUT
%    reseau: temps de calcul
%    nf: nombre de paramètres
%    paramfixes: vecteur de longueur nf. Si le parametre i est constant,
%    paramfixes(i)=1
%    theta0: val. init. des parametres du modèle
%    maxiter: nombre maxi d'itérations
%    epscal dans l'algorithme tornsey
%    seuil: minimal step time (longueur mini des plateaux)
%    modelepop: le programme de calcul du modèle
%    data.hpanel_work: handle de la figure parent du graphe
%    obj: handle du uicontrol appelant
%    evnt: 1 quand on fait passer des tests
% OUTPUT
%    evoldet: matrice d'autant de lignes que d'iterations effectuées
% et de 2 colonnes:
% 1iere colonne: les déterminants des matrices d'information
% 2ieme colonne: le log de ces determinants ou 0 s'ils ne sont pas >0
%    dx: les valeurs de la fonction de variance (ntot+1, +1 car )
%    proba: les proba (autant que de points du réseau)
%    titregraphe: titre du graphe
%    soustitre: libellé contenant les parametres de l'étude
%    indice_panel: indice du dernier panel écrit
% GRAPHES
% Tracé de dx en fonction des points du réseau
% Trace du log des déterminants en fonction de itérations
%% ========================================================================
%% Calcul d'un plan D-optimal local continu par Tornsey
%% Initialisation des sorties
evoldet={};
dx={}; proba={};  optima={}; indice_panel=0; titregraphe=''; soustitre='';


%% Creation d'une barre de progression 'Wait'
hbar = waitbar(0,'1','Name','Please wait...', ...
    'CreateCancelBtn', ...
    'setappdata(gcbf,''canceling'',1)');% User can click Cancel or close button
% nbre d'etapes de calcul
nsteps=1+maxiter;
istep=0; % indice de l'étape courante
setappdata(hbar,'canceling',0) % état= pas cancelé

%% Calculer la dérivée numérique de la réponse au modèle en chacun des
% points
istep=istep+1;
waitbar(istep/nsteps,hbar, 'Compute the derivates of the model response in each of the points');
% Les bornes admissibles de la réponse sont determinées par les
% plages de variation de certains parametres, selon le modele
% Oter les eventuels  blancs dans le nom du modele
lemodele = strrep(modelepop,' ', '');
% Oter les eventuels  tirets dans le nom du modele
lemodele = strrep(lemodele,'-', '');
valmin=1.0e-37; valmax=1.0e+37;

der=deriv1p(lemodele, reseau, theta0, paramfixes, valmin, valmax);
% Check for Cancel button press


%  quand on passe des tests, evnt is non null
if isempty(evnt)
    if getappdata(hbar,'canceling') || get(obj,'userdata')==0
        delete(hbar);
        hm=msgbox(['Step ', num2str(istep), ' stopped']);
        waitfor(hm)
        return
    end
end



%% Appeler l'algo de Tornsey

[ evoldet, dx, proba, iter, msgerr ] = tornsey(der, reseau, epscal, maxiter, ...
    nsteps, istep, hbar, obj, evnt);
%% Oter la barre de progression
delete(hbar); % a faire avant les graphiques

if ~isempty(msgerr)
    % il y a eu un pbe
    hm=msgbox(msgerr);
    waitfor(hm)
end

%% Limiter les sorties aux lignes utiles
if iter >0
    evoldet=evoldet(1:iter, :);
end

%% Check for Cancel button press
if isempty(evnt)
    if  get(obj,'userdata')==0
        texte=['Step ', num2str(istep), ' stopped at iteration ', ...
            num2str(iter)];
        if iter >1
            texte=[texte '. Please, wait for the graphics'];
        end
        hm=msgbox(texte);
        waitfor(hm)
    end
end



%% Préparer les graphes
if iter==0 || ~ishandle(data.hpanel_work) % il y a eu une interruption via quitter
    
    return
end

if iter >1
    % il peut y avoir moins d'iterations si on a interrompu ou sortie
    % anticipée
    % il faut au moins 2 iter pour les graphes
    % Preparer le titre
    % ne pas mettre de simples quotes dans le titre a cause de sauve_hp
    titredeb = [ ' Model: ', modelepop '. ', ...
        ' D-optimal design method'];
    %titrecond = ['; Number of iterations: ' num2str(iter)   ...
    %		'; Number of times: '   num2str(length(reseau))];
    titrecond =''; % on ne remet pas les parametres de l'etude dans les titres
    
    %% 1ier panel
    indice_panel=1;
    tag=['panel' num2str(indice_panel) '_tag'];
    hp1=uipanel('parent',data.hpanel_work,...
        'tag',tag,...
        'BorderType', 'none', ...
        'BackgroundColor',[1 1 1],...
        'Position',[0 0 1 1]);
    
    hp2=uipanel('parent',hp1,...
        'BackgroundColor',[1 1 1],...
        'BorderType', 'none', ...
        'Position',[0 0.12 1 0.88]);
    % panel blanc pour cacher la liste des optima
    uicontrol('parent',hp1,...
        'BackgroundColor','w',...
        'Position',[0 0.02 1 0.1]);
    
    
    subplot(2,1,1, 'parent',hp2);
    
    subplot(2,1,1); % se positionner sur le panel du haut
    plot(1:iter, evoldet(:,2))
    title([' {\bf{Log determinant vs iterations}} - ', titredeb, titrecond]);
    xlabel('iterations')
    ylabel('log(det)')
    set(gca,'buttondownfcn',@dessin1_simul_tornsey);
    
    
    subplot(2, 1,2); % se positionner sur le panel du bas
    plot(reseau, proba)
    xlim([min(reseau) max(reseau)])
    title([ ' {\bf{D-optimal measure}} - ', titredeb, titrecond])
    xlabel(['times (' uniteT_libelle ')'])
    set(gca,'buttondownfcn',@dessin1_simul_tornsey);
    
    %% 2ieme panel
    indice_panel=indice_panel+1;
    tag=['panel' num2str(indice_panel) '_tag'];
    hp1=uipanel('parent',data.hpanel_work,...
      'tag',tag,...
      'BorderType', 'none', ...
        'BackgroundColor',[1 1 1],...
        'Position',[0 0 1 1]);
    hp2=uipanel('parent',hp1,...
        'BorderType', 'none', ...
        'BackgroundColor',[1 1 1],...
        'Position',[0 0.12 1 0.88]);
    
    
    h=subplot(1,1,1, 'parent',hp2);
    
    
    couleur={'k'}; % couleur=noire
    ydeb=-1; % pour amorcer la recherche d'optima
    [optima ignore plateaux]=calcOptima(reseau, dx, 'Tornsey', ydeb, seuil, nf-sum(paramfixes), couleur, h);
    
    %% On met une ligne la ou devraient etre les y des optima
    yline=repmat((nf-sum(paramfixes)), size(reseau));
    line(reseau, yline , 'LineStyle', '--');
    hold on
    
    %% S'il y a des plateaux, proposer d'ajouter des points dedans
    for i=1:length(plateaux)
        % marquer le plateau si c'est un plateau proche ou egal a nf
        if plateaux{i}(3) < (nf-0.1)
            continue
        end
        plinf=plateaux{i}(1);
        plsup=plateaux{i}(2);
        plot(plinf, plateaux{i}(3), ['s' 'g']);
        plot(plsup, plateaux{i}(3), ['s' 'g']);
        
               
        
        if isempty(evnt)
                      
            % cas interactif
            message=sprintf('%s\n%s%6.2f%s%6.2f%s\n\n%s\n\n%s\n%s\n%s\n%s\n\n%s\n%s\n%s\n%s\n%s\n', ...
                'The variance function shows at least one plateau.',...
                'It is delimited by the green points between the time ', ...
                plinf, ' and the time ', plsup, '.' ,...
                'You have two choices: ',...
                '1. You can add one or more experiment support points on this plateau. ', ...
                'To do this: ', ...
                '  - Click to select locations on the plateau at the level of the required abscissa.', ...
                '  - Finally hit the Return or Enter key on your keyboard. ', ...
                '2. You do not want to add any experiment support points. ', ...
                'To do this: ', ...
                '  - Click on a location outside of the plateau range. ', ...
                '  - Finally hit the Return or Enter key on your keyboard. ');
            hm = msgbox(message);
            
            %  Les points en-dehors du plateau seront ignorés.
            waitfor(hm)
            [a b]=ginput;
            %  suppression des points qui ne sont pas dans le plateau
            a(a<plateaux{i}(1) | a>plateaux{i}(2))=[];
            if ~isempty(a)
                % Ajout de ces points sur le graphe
                plot(a, plateaux{i}(3), ['s' couleur{1}]);
                % On les rajoute a la liste des optima
                optima= [optima transpose(a)];
                
            end
        end % fin interactif
    end % fin i
    
    
    
    
    optima=sort(unique(optima));
    %% annotation du graphe
    titregraphe= ' {\bf{Evolution of the variance function}} - ';
    titregraphe=[titregraphe, titredeb, titrecond];
    nomparam={}; %pas besoin du nom des parametres en légende
    ylab = 'variance function';
    xlab=['times (' uniteT_libelle ')'];
    annotGraphe(optima, nomparam, titregraphe,xlab, ylab, h, hp1);
    
    %% Mettre dans une structure 'filtrexplot' situé dans 'base'
    % ce qui est nécessaire aux graphiques de façon à pouvoir
    % les retracer si clic gauche dessus
    sauve_hp('filtrexplot', 1,  'reseau',  transpose(reseau), ...
        'iter', iter, 'evoldet', evoldet(:,2), ...
        'proba', proba, ...
        'modelepop', modelepop, ...
        'dx', transpose(dx), 'optima', optima, ...
        'nf', nf, ...
        'titregraphe', titregraphe);
    
    set(gca,'buttondownfcn',@dessin_simul_tornsey);
    
    
    soustitre= [titredeb, titrecond];
end %fin iter >1



end %fin calcStrategieOptTornsey


