function [ der ] = deriv1p(lemodele, reseau, param0, paramfixes, valmin, valmax)
%deriv1p Calcul des dérivées premières par différences finies des réponses
% du modèle par rapport aux paramètres, en 1 point de calcul
% Appelé par la méthode D-OPTIMAL (Tornsey)
% INPUT
% lemodele: nom du modele
% reseau: points en lequel on demande le calcul des dérivées (des temps)
% param0: vecteur des paramètres
% paramfixes: vecteur de même longueur que param0, paramfixes(i)=1 si le param i
% est cte
% OUTPUT
% der: vecteur des dérivées aux points t (length(t), length(param0))
% TEST
% reseau=0:500; lemodele='LnBaranyiRoberts';  param=[0.05 40 230 4e+8];
% paramfixes=zeros(1,4); valmin=1.0e-37; valmax=1.0e+37;
% deriv1p(lemodele, reseau, param, paramfixes, valmin, valmax)
%% =======================================================================

p=length(param0);
k=1/3;  eps=1e-18^k;
h=param0*eps;
param=param0;
nx=length(reseau);

der=zeros(nx, p- sum(paramfixes));

programme = ['C', lemodele];

ider=0;
for j=1:p
    param(j)=param0(j)+h(j);
    %rep1: nx valeurs
    rep1=zeros(1, nx);
    eval([ programme, '(double(param), double(reseau), double(valmin), double(valmax), double(rep1))']);
    
    param(j)=param0(j)-h(j);
    rep2=zeros(1, nx);
    eval([ programme, '(double(param), double(reseau), double(valmin), double(valmax), double(rep2))']);
    


%% Ramener a des valeurs valides
	  rep1(rep1<0) =0.0;
	  rep2(rep2<0) =0.0;

    if paramfixes(j) ~= 1
        ider=ider+1;
        der(:,ider) = (rep1-rep2)/(2*h(j));
    end
    % reinit du param modifié avant de passer au suivant
    param(j)=param0(j);
end

end % fin deriv1p

