function dessin_simul_tornsey(obj, evt)
%dessin_simul_tornsey Tracé graphique du 2ieme plot de D-optimal
% dans une fenêtre graphique Matlab ou en cas de restauration
% INPUT
% obj: ignore si le sp est appele via un clic sur le graphe, 
  % sinon, c'est que le sp est appele par restore-tornsey et
  % obj est le uipanel ou il faut dessiner le graphe
  % evt: ignore  si le sp est appele via un clic sur le graphe,
  % sinon, c'est que le sp est appele par restore-tornsey et
% evt est la structure data
%% ======================================================
  if ~isstruct(evt)
% appele via un clic sur le graphe
donnees = evalin('base', 'filtrexplot');
hfig=figure('Name', 'SIMULATION OF AN OPTIMAL SAMPLING BY METHOD TORNSEY');
hp2=subplot(1,1,1, 'parent',hfig);
 else
   hfig=obj;
donnees=evt;


    hp11=uipanel('parent',hfig,...
        'BackgroundColor',[1 1 1],...
		 'BorderType', 'none', ...
        'Position',[0 0.12 1 0.88]);
    hp2=subplot(1,1,1, 'parent',hp11);
end



reseau=reshape(donnees.reseau, 1, max(size(donnees.reseau)));
dx=reshape(donnees.dx,1, max(size(donnees.dx)));



ymin=min(dx);
ymax=max(dx);
eps=(ymax-ymin)/10;



plot(hp2, reseau, dx);
xlim([min(reseau) max(reseau)])
ylim([ymin-eps ymax+eps])
hold on
[Lia,Locb] = ismember(donnees.optima,reseau);
% trace les points qui sont dans le reseau
optima=donnees.optima(Lia>0);
Locb=Locb(Locb>0);
 plot(hp2, optima ,dx(Locb), ['s' 'k']);
 hold on
% Rajouter les points qui ont ete rajoutes par clic
optima=donnees.optima(Lia==0);
dx=repmat(max(dx), 1, length(optima));
 plot(hp2, optima , dx, ['s' 'k']);
 hold on
 % On met une ligne la ou devraient etre les y des optima
yline=repmat(donnees.nf, size(reseau));
 line(reseau, yline , 'LineStyle', '--');
        hold on

nomparam={}; %pas besoin du nom des parametres en légende
ylab = 'variance function';
  if ~isstruct(evt)
xlab=[ 'OPTIMA:  ' num2str(donnees.optima, '%10.2f') ];
annotGraphe(donnees.optima, nomparam, donnees.titregraphe,xlab, ylab, hp2);
  else
xlab='times';
annotGraphe(donnees.optima, nomparam, donnees.titregraphe,xlab, ylab, hp2, hfig);
end



end % fin dessin_simul_tornsey




