function  [indice_panel, data] = ecrire_optima(data, indice_panel,  soustitre, hpanel_work)
%ecrire_optima Ecrire les abscisses des optima dans un panel fils de
%hpanel_work
% Les abscisses sont dans data.optima
%% ======================================================

%% Effacer les sorties précédentes, sauf la partie qui contient la liste
%des optima
fils=allchild(hpanel_work);
for i =1:length(fils)
    tag=get(fils(i), 'tag');
    if ~strcmp(tag, 'tps_tag')
        set(fils(i), 'visible','off')
    end
end

%% determiner si les optima sont des entiers
testi=rem(data.optima*10,10);
if any(testi) ~=0
    format='%6.2f';
else
    format='%6d';
end
 
 
%%Initialisation des panels

no_par_p =16; % nbre de resultats par  panel
no_par_l=1; % nbre de resultats par ligne
nb_items = length(data.optima);
pasecr = min(no_par_p, nb_items); % nombre de lignes max par panel
n_p = idivide(nb_items,int32(no_par_p),'floor');% nombre de panels nécessaires
if  mod(nb_items,no_par_p) >0
    n_p=n_p+1;
end

htutile=0.85;% hauteur du panel, sans le titre
httitre=0.03;% hauteur de chaque ligne titre
htmaintitle=0.05;
htsoustitre=0.03;
% decaler le debut du tableau
htdeb=htutile-0.05;
pasy=0.05; % decalage entre chaque ligne


%% Boucle sur les panels
i_p=0; % indice du panel courant parmi les nb_p
for jdeb=1:pasecr:nb_items
    
    jfin=min(jdeb+pasecr-1, nb_items); %indice du dernier elt a ecrire
    
    indice_panel=indice_panel+1;
    i_p=i_p+1;
     
    tag=['panel' num2str(indice_panel) '_tag'];
    % On laisse une marge en bas pour les no de panels
    hp2=uipanel('parent',hpanel_work,...
'BorderType', 'none', ...
        'tag',tag,...
        'BackgroundColor','white',...
        'Position',[0 .05 1 0.95]);
    data.(tag) =hp2;
    
    %% Titre
    hp22=uicontrol('parent', hp2,...
        'BackgroundColor','white',...
        'fontsize',12,...
        'foregroundcolor',[0 0 0],...
        'units','normalized',...
        'Position',[0 htutile+htmaintitle 1 htmaintitle], ...
        'style','text',...
        'fontweight','bold');
    titrehp22={'OPTIMAL TIMES '};
%    if isfield(data, 'uniteT_pourcalcul_libelle')
%        titrehp22{1} = [titrehp22{1} '(' data.uniteT_pourcalcul_libelle ')'];
%    end
    if n_p > 1
        titrehp22{1}= [titrehp22{1} '(' num2str(i_p)  '/'  num2str(n_p) ')'];
    end
    set(hp22, 'string',  titrehp22);
    
    % Ecrire le sous-titre
    uicontrol('parent', hp2,...
        'BackgroundColor','white',...
        'units','normalized',...
        'fontsize',12,...
        'position',[0 htutile+htsoustitre 1 htsoustitre ],...
        'style','text',...
        'string', soustitre);
    
    % Ecrire le nombre total d'optima
    nbopt=length(data.optima);
    uicontrol('parent', hp2,...
        'BackgroundColor','white',...
        'units','normalized',...
        'fontsize',12,...
        'position',[0 htutile 1 httitre],...
        'style','text',...
        'string',['Number of selected optimal times: ' num2str(nbopt)]);
    
    
    
    ilig=1; %indice de ligne dans le panel courant
   
    for j=jdeb:no_par_l:jfin
               debuty=htdeb-ilig*pasy;
        icolpred=0;
        for ji=j:(j+no_par_l -1)
            
            if ji> nb_items
                break
            end
            
            uicontrol('parent', hp2,...
                'units','normalized',...
                'fontsize',15,...
                'position',[0.42 debuty 0.08 pasy],...
                'style','edit',...
                'HorizontalAlignment', 'left', ...
		      'string', ['time#' num2str(ji)]); ...

          
          uicontrol('parent', hp2,...
                'units','normalized',...
                'fontsize',15,...
                'position',[0.5 debuty 0.08 pasy],...
                'style','edit',...
                'HorizontalAlignment', 'right', ...
		      'string',  num2str(data.optima(ji), format));
                
            icolpred=icolpred+1;
        end
        
        ilig=ilig+1;
    end % fin j
    if jfin>= nb_items
        break;
    end
end % fin jdeb




%% Compléter le panel pour cacher le panel tps_tag qui contient la liste de tous les optima
% uicontrol('parent',hpanel_work,...
%     'units','normalized',...
%    'position',[0 0.02 1 .02],...
%    'backgroundcolor',[1 1 1],...
%    'style','text',...
%     'tag', 'complet_tag', ...
%   'string', '');


end

