function [ matA matB ] = generABDP( nmoda, nf,  binf, bsup, meth)
%generABDP Genere 2 matrices de nombres aléatoires par Space Filling
%Design 
% INPUT
%   nmoda: nombre de modalités
%   nf: nombre de facteurs
%   binf, bsup: bornes des facteurs (vecteurs de longueur = nf)
%    meth: 1 si on genere le lhd en triant des pseudorandom integer values
%          2 si on genere le lhd en utilisant sobolset
% OUTPUT
%   matA, matB: 2 plans LHS (nmoda x nf)
% TEST 1
%  nmoda=5; nf=2; binf=[12, 16]; bsup=[20, 24];
% [ matA matB ] =generABDP( nmoda, nf,  binf, bsup)
% TEST 2: correspond aux plages de validite des parametres de Baranyi
% nmoda=5; nf=4; binf=[0.001, 0.1, 20, 1e+6]; bsup=[5, 500,1000, 1e+12];
% [ matA matB ] =generABDP( nmoda, nf,  binf, bsup)
% TEST 2: correspond aux plages JP des parametres de Baranyi
%  nmoda=5; nf=4; 
%  binf=[0.01,  10, 140, 5e+7]; bsup=[0.09, 110, 260, 1e+9];
% [ matA matB ] =generABDP( nmoda, nf,  binf, bsup)
% % ecrire les resultats
% for i=1:nf
%   matA(:,i)
% end
% ==========================================================================

pas= (bsup - binf)/(nmoda-1);
%% Creation de la matrice A
lhd= createlhd( nmoda, nf , meth);
alea= rand( nmoda, nf, 'double');
matA= zeros(nmoda, nf);
CcalibSDP(nmoda, nf, pas, alea, binf, lhd, matA);
%% Creation de la matrice B
lhd= createlhd( nmoda, nf , meth);
alea= rand( nmoda, nf, 'double');
matB= zeros(nmoda, nf);
% CcalibSDP: programme C
CcalibSDP(nmoda, nf, pas, alea, binf, lhd, matB);

end %fin generABDP
%% =========================================================================
function  lhd  = createlhd( nmoda, nf, meth)
%createlhd Calcul d'un plan LHD
%   - les bornes inférieures sont toutes égales à 1
%   - les bornes supérieures sont toutes égales au nombre de modalités du
%   LHD
% INPUT
%   nmoda: nombre de modalités
%   nf: nombre de facteurs
%    meth: 1 si on genere le lhd en triant des pseudorandom integer values
%          2 si on genere le lhd en utilisant sobolset
% OUTPUT
%   lhd: plan LHD (nmoda x nf)
% REFERENCE
%   programme SAS lhd1 de JPG
% TEST
%  nf=3; nmoda=100;
% createlhd( nmoda, nf)
% =========================================================================


if meth==1
    % generer une matrice nmoda x nf de pseudorandom integer values dans
    % 1:nmoda
    lhd= randi(nmoda, nmoda, nf);
else
    p=sobolset(nf);
    p = scramble(p,'MatousekAffineOwen');
    lhd=p(1:nmoda,:);
end

% pour chaque colonne, indices des lignes des elts triés 
% On ne s'interresse qu'aux indices, pas aux valeurs elles-mêmes
[~, ix]=sort(lhd);
[~,  lhd]=sort(ix);


end % fin createlhd
%% =========================================================================



    
        

