function Fstruct=init_Simul()
%init_Simul Initialisation des parametres de simulation de stratégie
% par les valeurs par défaut
%% ======================================================
% Les parametres communs aux méthodes
Simul.chaines0={'METHOD'};
Simul.nomparam0 = {  'methode'};
% leurs bornes de validité:
Simul.DF0= {  {'1', '2'}};
% leurs valeurs par défaut:
Simul.valparam0 = {  '1'};
% Les parametres de la methode 1 (Sobol) et 2 (Tornsey) et 3 (SIVIP)
Simul.chaines= { {'MAXIMAL TIME', 'SEED', 'LHS','THRESHOLD', 'TIME STEP'}, ...
    {'MAXIMAL TIME','NUMBER OF TIMES', 'MAXIMAL NUMBER OF ITERATIONS', 'EPSILON', ...
    'MINIMAL LAPSE OF CONSTANT VARIANCE'}, ...
		 { 'POLYNOME DEGREE', 'POLYNOME TYPE', ...
    '% MINIMUM BETWEEN 2 OPTIMA', ...
    'NUMBER OF COMPONENTS', ...
    '% THRESHOLD', 'PLOTS'} };
%% Leur ordre de présentation sur les panels
% Exemple: le 2ieme parametre, SEED, de Sobol sera ecrit en 5ieme position
Simul.ipres={[1 5 3 4 2], ... % Sobol
	     [1 2 4 5 3], ... D-opt
	     1:length(Simul.chaines{1})};


Simul.nomparamD={{'tempsmaxsobol', 'graineAleaS', 'LHS',  'seuilsobol', 'stepsobol'}, ...
    {'tempsmaxtornsey','nbtemps', 'maxiter', 'eps', 'seuiltornsey'}, ...
		 {'degre', 'polytype',...
 'diffmax',  'hmax', 'seuilsivip', 'graphiques'}
    };
% leurs bornes de validité:
Simul.DF= {{{'1', '10000'}, {'11' '99999', 'CLOCK'}, {'1.0e3', '1.0e9'},{'0', '30'}, {'0.01' '100'}}, ...
    {{'1', '10000'}, {'100', '10000'}, {'100', '100000'}, {'1e-15', '1e-5'}, {'0.01', '500'}}, ...
    {{'2', '4'}, {'1', '5'},  ...
    {'0', '100'}, {'1', '5'}, {'0', '100'}, {'1', '3'}} ...
    };

% les bornes et la valeur par defaut du temps maxi sont ignorees pour sivip
% leurs valeurs par défaut:
Simul.valparamD = {{'-', 'CLOCK','1.0e4','5', '1'}, ...
    {'-','1000', '1000', '1e-10', '100'}, ...
		   { 1, 1,  5, 2, 5, 1} ...
    };


Fstruct=Simul;
end
