
function [fileSave]= go(obj,evnt)
% go
% Pilot computations according to the chosen task
% INPUT
% The property 'value' of 'obj' contains the number of the required task.
% 'evnt' is ignored except for tasks 10 and 11, i.e
% when a series of tests is run in non-interactive mode.
% In this case, it is the name of a file which contains the results
% of an execution.
%% ======================================================
choice=get(obj,'value');
% Nothing chosen?
if isempty(choice)
    return
end
switch choice
    case 1
        close all
        main_identification
    case 2
        close all
        main_modelcompar
    case 3
        close all
        main_strategysim
    case 4
        close all
        main_datasim
    case 5
        close all
        return % quit filtrex
    case 6
        close all
        exit % quit matlab
    case 7
        about
        
        
    case 8
        close all
        return
        % Available to add a task
    case 9
        % Case where tests are executing in non-interactive mode.
        %  A file, whose name is in 'evnt', and which contains
        % previously stored results is restored. Execution of
        % the Parameter Identification task will
        % be launched, its results saved, and finally compared
        % to those of the initial restored file.
        close all
       main_identification(obj,evnt);
        objet= uicontrol('visible', 'off',   'userdata', {0});
        fileSave= sauver_modele(objet,evnt);
        close all;
        
    case 10
        %  same as previous choice to compar results of the task
        % Models Comparison
        close all
        main_modelcompar(obj,evnt);
         objet= uicontrol('visible', 'off',   'userdata', {1});
        fileSave= sauver_modele(objet,evnt);
        close all;
    case 11
        %  same as previous choice to compar results of the task
        % Simulation of an optimal sequential sampling
        close all
        main_strategysim(obj,evnt);
        objet= uicontrol('visible', 'off');
        fileSave= saveStrat(objet,evnt);
        close all;
        
end
end % fin go
