# : ### FICHIER all.equal.nls2.s ###
# ----------------------------------------------------------
# compnls2: comparaison de composants non hierarchiques
#           de 2 nls2.objects
# ----------------------------------------------------------
compnls2 <- function(target, current, nom, ...)
{
	if (! is.null(target) && !is.null(current))	 {

	if ( !is.null(target) && is.null(current))
  {
  cat("Component", nom,"does not exist in 'current'\n", fill=T)
  return(FALSE)
  }

if (all(is.na(target)) && !all(is.na(current)))
  {
  cat("Component", nom,"present in 'current' and not in 'target'\n", fill=T)
  return(FALSE)
  }
if (!all(is.na(target)) && all(is.na(current)))
  {
  cat("Component", nom,"not present in 'current' and present in 'target'\n", fill=T)
  return(FALSE)
  }

if (is.vector(target) && (length(target) != length(current)))
  {
  cat("Differences in length of components", nom,"\n", fill=T)
  return(FALSE)
  }

if (is.matrix(target) && ( (ncol(target) != ncol(current)) || 
                                (nrow(target) != nrow(current)) ))
  {
  cat("Differences in dimension of components", nom,"\n", fill=T)
    return(FALSE)
  }

if (is.array(target) && any(dim(target) != dim(current)))
  {
  cat("Differences in dimension of components", nom,"\n", fill=T)
  return(FALSE)
  }


targp <- target[!is.na(target)]
curp <- current[!is.na(current)]

if ( (is.null(targp) && !is.null(curp)))
  {
  cat("Component", nom,"valued in 'current' and not in 'target'\n", fill=T)
  return(FALSE)
  }
if   ((!is.null(targp) && is.null(curp)))
  {
  cat("Component", nom,"not valued in 'current' and valued in 'target'\n", fill=T)
  return(FALSE)
  }
	# On compare aux names prs
	names(targp) <- NULL
	names(curp) <- NULL
	dimnames(targp) <- dimnames(curp) <- NULL
if (!is.null(targp) && (all.equal(targp , curp, ...) !=T))
  {
  cat("Differences in components", nom,"\n", fill=T)
  return(FALSE)
  }

	} # fin les 2 pas nuls
	
return(TRUE)
}

# ------------------------------------------------------
# all.equal.nls2: comparaison de 2 nls2.objects
# Les composants "call" and "model$file" ne sont pas compares
# Renvoie T si les objects sont identiques, F sinon
# Les arguments ...:	 voir ceux de la fonction R all.equal.numeric
# -----------------------------------------------------------              
all.equal.nls2<-function(target, current, ...)
{
if (is.null(class(current)) || (class(current) !="nls2") )
  {
  cat("'current' is not a 'nls2.object'\n", fill=T)
  return(F)
  }

target$call <-  current$call <-  NULL
target$model$file  <-  current$model$file  <-  NULL

Code  <-  TRUE

for (e in names(target))
  {
  if (!is.recursive(target[[e]]))
    Code  <-   compnls2(target[[e]], current[[e]],e, ...) && Code
  else
    {
    if (is.null(current[[e]]))
      {
      cat("Component", e,"does not exist in 'current'\n", fill=T)
      Code <- F
      }
    else
      {
      for (ee in names(target[[e]]))
        {
        if (!is.recursive(target[[e]][[ee]]))
          Code  <-   compnls2(target[[e]][[ee]], current[[e]][[ee]],
	        paste(e,"$",ee,sep=""), ...) && Code
        else
          {
          if (is.null(current[[e]][[ee]]))
            {
            cat("Component", paste(e,"$",ee,sep=""),"does not exist in 'current'\n", fill=T)
            Code <- F
            }
          else
            for (eee in names(target[[e]][[ee]]))
              Code  <-   compnls2(target[[e]][[ee]][[eee]],
	        current[[e]][[ee]][[eee]],
	         paste(e,"$",ee,"$",eee,sep=""), ...) && Code
          } # fin du else
        } # fin du for ee
      } # fin du else
    } # fin du else
  } # fin du for (e)
return(Code)
}
