# : ### FICHIER calcmodnls2.s ###

# ---------------------------------------------------------------------
# verifmodnls2:
# Verification function
# ---------------------------------------------------------------------
verifmodnls2 <- function(data, theta=NULL, beta=NULL, gamf=NULL, gamv=NULL,
                      integ.ctx=NULL,
                      file=NULL, func="f")
{
if(is.numeric(data))
   data <- sys.frame(data)

# Ne pas mettre:
# class(data) <- NULL

if (!inherits(data,"data.frame"))
   stop("\nThe 'data' must be a 'data.frame'\n")


if (!is.null(theta))
  {
  if (!is.numeric(theta))
    stop("\nThe argument 'theta' is not numeric\n")
  nbt <- as.integer(length(theta))
  }
else
  {
  theta <- as.double(0)
  nbt <- 0
  }

  
if (!is.null(beta))
  {
  if (!is.numeric(beta))
    stop("\nThe argument 'beta' is not numeric\n")
  nbb <- as.integer(length(beta))
  }
else
  {
  beta <- as.double(0)
  nbb <- 0
  }

if (!is.null(gamf))
  {
  if (!is.numeric(gamf))
    stop("\nThe argument 'gamf' is not numeric\n")
  nbgf <- as.integer(length(gamf))
  }
else
  {
  gamf <- as.double(0)
  nbgf <- 0
  }

if (!is.null(gamv))
  {
  if (!is.numeric(gamv))
    stop("\nThe argument 'gamv' is not numeric\n")
  nbgv <- as.integer(length(gamv))
  }
else
  {
  gamv <- as.double(0)
  nbgv <- 0
  }


# Verification that the model description corresponds if any:
# ----------------------------------------------------------
if (!is.character(file))
    stop("\nThe 'file' argument must be the name of the file containing the formal expression of the model\n")

# Generation de l'arbre de calcul du modele
# ------------------------------------------
RetModel <-  CrArbnls2(file, integ.ctx)

if ((func=="f") && (RetModel$CasSedo ==1) )
  stop("\n'func=\"f\"' cannot be used on differential equations systems: use 'func=\"phi\"'\n")
if ((func=="phi") && (RetModel$CasSedo ==0) )
  stop("\n'func=\"phi\"' can be used only on differential equations systems: use 'func=\"f\"'\n")
if ((func=="odes") && (RetModel$CasSedo ==0) )
  stop("\n'func=\"odes\"' can be used only on differential equations systems: use 'func=\"f\"'\n")

if ( (func!="v") && (RetModel$NbGamF != nbgf))
  stop(paste("\n The length of the argument 'gamf':", nbgf,
     "\n is not equal to the number of the parameters in the model description file:", RetModel$NbGamF,"\n"))

if ((func=="v") && (RetModel$NbGamV != nbgv))
  stop(paste("\n The length of the argument 'gamv':", nbgv,
     "\n is not equal to the number of the parameters in the file:", RetModel$NbGamV,"\n"))

# nbl: nombre d'observations lues
nbl <-  dim(data)[1]

Ret <- list(nbt=nbt, nbb=nbb, nbl=nbl,
        NbGamF= nbgf, NbGamV=nbgv, 
        Theta= theta, Beta=beta, GamF=gamf,GamV=gamv,
        RetModel=RetModel)

return(Ret)

}
# --------------- End of verifmodnls2 ---------------------------------------


calcfnls2 <- function(data, file, theta, gamf=NULL)
{
# -------------------------------------------------------------------------
# calcfnls2: call the program calcf <-  that evaluates the model
# on given values of the parameters and of the data
# -------------------------------------------------------------------------
# Input arguments:
#  data: data frame of the observations to study
#  theta: values of the parameters theta
# file: name of the formal description file
#  gamf: values of the second level parameters of f

# Return object:
# a list that contains the components:
# - response: the values of f
# - d.resp: the values of the derivatives of f
#
# Constraint:
# a previous call to loadnls2("model.o") is required
# and the model should be explicitly defined
#
# -------------------------------------------------------------------------

# Verification 
# -------------
RetVerif <- verifmodnls2(data, theta=theta, gamf=gamf, file=file,func="f")

# INITIALISATION DES STRUCTURES par les valeurs et tailles par defaut
# ------------------------------
.C("debutCalcnls2")

# Creation des donnees:
# -------------------

don <- crDatanls2(data,RetVerif$RetModel$NomX, RetVerif$RetModel$NomY)
# Verification
if ( (RetVerif$RetModel$NbTheta * don$NbCourbe) != RetVerif$nbt)
  stop(paste("\n The length of the argument 'Theta':", RetVerif$nbt,
     "\n is not equal to the number of the parameters in the file:", RetVerif$RetModel$NbTheta,
     "\n multiplied by the number of curves:", don$NbCourbe, "\n"))

# Creation de la trace et des donnees
# ---------------------------------
# "initCalcnls2" renvoie les elements qui  permettront de dimensionner les sorties
k <- as.integer(0)
RetDim <- .C("initCalcnls2",
   k=as.integer(k))

# APPEL DU CALCUL
# ------------
le <- 0
ie <- 0
f <- vector(mode="double", length=RetDim$k)
df <- vector(mode="double", length=(RetDim$k * RetVerif$RetModel$NbTheta))

Ret <- .C("calcfnls2", 
   pbase=as.integer(RetVerif$RetModel$NbTheta),
   nbgf=as.integer(RetVerif$NbGamF),
   Theta=as.double(RetVerif$Theta),
   GamF=as.double(RetVerif$GamF),
   f=as.double(f), df=as.double(df),
   le=as.integer(le), ie=as.integer(ie))

if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"
  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }

# Recuperation de ce qui concerne les donnees
# pour avoir les labels des k observations
# -------------------------------------------
# recuperer le code des val. manquantes
codeNa  <-  as.double(0)
codeNa  <-  .C("recupCodeNa", as.double(codeNa))[[1]]
	
RetDon <- recupDatanls2(RetDim$k, RetVerif$nbl, codeNa, T)

# Desallouer les structures C creees:
# ----------------------------------
.C("delCalcnls2")


# Transform df into a matrix
# --------------------------

if(all(Ret$df ==0)) Ret$df  <- NA
else Ret$df <- matrix(Ret$df, ncol=RetVerif$RetModel$NbTheta, byrow=T,
          dimnames=list(RetDon$NomObs, RetVerif$RetModel$NomTheta))


if(all(Ret$f==0)) Ret$f  <- NA
else names(Ret$f) <- RetDon$NomObs


return(list(response=Ret$f, d.resp=Ret$df))
}
# ----------------------------------------
# ----------- end function calcfnls2 ----------
# ----------------------------------------


calcvnls2 <- function(data, file, response=NULL, d.resp=NULL, theta=NULL, beta=NULL, gamv=NULL)
{
# -------------------------------------------------------------------------
# calcvnls2: call the program calcv <-  that evaluates the model
# on given values of the parameters and of the data
# -------------------------------------------------------------------------
# Input arguments:
#  data: data frame of the observations to study
#  response, d.resp: fitted values of function f and of its derivatives
#  theta: values of the parameters theta
#  beta: values of the parameters beta
#  gamv: values of the second level parameters of v
# file: name of the formal description file

# Return object:
# a list that contains the components:
# - d.theta.vari: the values of the derivatives of v against theta
# - d.beta.vari: the values of the derivatives of v against beta
#
# Constraint:
# a previous call to loadnls2("model.o") required
#
# -------------------------------------------------------------------------

# Verification 
# -------------
RetVerif <- verifmodnls2(data, theta=theta, beta=beta, gamv=gamv, file=file,func="v")

if (!is.null(response) && !is.numeric(response))
  stop("\nThe argument 'response' is not numeric\n")

# INITIALISATION DES STRUCTURES par les valeurs et tailles par defaut
# ------------------------------
.C("debutCalcnls2")

# Creation des donnees:
# -------------------
don <- crDatanls2(data,RetVerif$RetModel$NomX, RetVerif$RetModel$NomY)

# Verification
if ( !is.null(theta) && ((RetVerif$RetModel$NbTheta * don$NbCourbe) != RetVerif$nbt))
  stop(paste("\n The length of the argument 'Theta':", RetVerif$nbt,
     "\n is not equal to the number of the parameters in the file:", RetVerif$RetModel$NbTheta,
     "\n multiplied by the number of curves:", don$NbCourbe, "\n"))
if ( (RetVerif$RetModel$NbBeta * don$NbCourbe) != RetVerif$nbb)
  stop(paste("\n The length of the argument 'Beta':", RetVerif$nbb,
     "\n is not equal to the number of the parameters in the file:", RetVerif$RetModel$NbBeta,
     "\n multiplied by the number of curves:", don$NbCourbe, "\n"))

# Creation de la trace et des donnees
# ---------------------------------
k <- as.integer(0)
RetDim <- .C("initCalcnls2",
   k=as.integer(k))

# Other verifications
if  (!is.null(response))
  {
  # on a besoin des valeurs de f pour calculer v
  if (length(response) != RetDim$k)
    stop(paste("\nThe length of the argument 'response':", length(response),
      "\n doesn't fit the length of the data:", RetDim$k,"\n"))
  }
else
  {
  # on n' a pas besoin des valeurs de f pour calculer v
  # creation d'un vecteur de la longueur requise par le programme C
  response <- rep(0, RetDim$k) 
  }


if  (!is.null(d.resp))
  {
   # on a besoin des derivees de f pour calculer v
  if( !is.numeric(d.resp))
    stop("\nThe argument 'd.resp' is not numeric\n")
  if (is.matrix(d.resp))
    {
    if ((nrow(d.resp) != RetDim$k) || (ncol(d.resp) != RetVerif$RetModel$NbTheta))
      stop(paste("\nThe number of rows of 'd.resp':", nrow(d.resp),
     " doesn't fit the length of the data:", RetDim$k,
     "\nor the number of its columns:", ncol(d.resp),
     "doesn't fit the number of theta parameters:", RetVerif$RetModel$NbTheta,"\n"))
    }
  else
    {
    if (length(d.resp) != RetDim$k)
     stop(paste("\nThe length of the argument 'd.resp':", length(d.resp),
        "\n doesn't fit the length of the data:", RetDim$k,"\n"))
    }
  }
else
  {
  # on n' a pas besoin des derivees de f pour calculer v
# creation d'un vecteur de la longueur requise par le programme C
  d.resp <- rep(0, RetDim$k)
  }

# APPEL DU CALCUL
# ------------
le <- 0
ie <- 0
v <- vector(mode="double", length=RetDim$k)
dtv <- vector(mode="double", length=(RetDim$k * RetVerif$RetModel$NbTheta))
dbv <- vector(mode="double", length=(RetDim$k * RetVerif$RetModel$NbBeta))

Ret <- .C("calcvnls2", 
   pbase=as.integer(RetVerif$RetModel$NbTheta),
   qbase=as.integer(RetVerif$RetModel$NbBeta),
   nbgv=as.integer(RetVerif$NbGamV),
   Theta= as.double(RetVerif$Theta), Beta=as.double(RetVerif$Beta), 
   GamV=as.double(RetVerif$GamV),
   f=as.double(response), df=as.double(d.resp),
   v=as.double(v), dtv=as.double(dtv), dbv=as.double(dbv),
   le=as.integer(le), ie=as.integer(ie))

if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"
  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))

  }
# Recuperation de ce qui concerne les donnees
# pour avoir les labels des k observations
# -------------------------------------------
# recuperer le code des val. manquantes
codeNa  <-  as.double(0)
codeNa  <-  .C("recupCodeNa", as.double(codeNa))[[1]]

	
RetDon <- recupDatanls2(RetDim$k, RetVerif$nbl, codeNa, T)


# Desallouer les structures C creees:
# ----------------------------------
.C("delCalcnls2")

# Transformation of the outputs:
# ---------------------------
if (all(Ret$v ==0)) Ret$v <- NA
  else names(Ret$v) <- RetDon$NomObs
# Transform dv into a matrix
if (all(Ret$dtv==0)) Ret$dtv <- NA
  else Ret$dtv <- matrix(Ret$dtv, ncol=RetVerif$RetModel$NbTheta, byrow=T,
         dimnames=list(RetDon$NomObs, RetVerif$RetModel$NomTheta))

if (RetVerif$RetModel$NbBeta>0)
  {
  if(all(Ret$dbv ==0)) Ret$dbv <- NA 
    else   Ret$dbv <- matrix(Ret$dbv, ncol=RetVerif$RetModel$NbBeta, byrow=T,
                dimnames=list(RetDon$NomObs, RetVerif$RetModel$NomBeta))
  }
else
  {
  Ret$dbv <- NA
  }

return(list(v=Ret$v, d.theta.v=Ret$dtv, d.beta.v=Ret$dbv))
}
# ----------------------------------------
# ----------- end function calcvnls2 ----------
# ----------------------------------------

calcphinls2 <- function(data,file, theta, FOdes, d.FOdes, gamf=NULL, integ.ctx=NULL)
{
# -------------------------------------------------------------------------
# calcphinls2: call the program calcphi <-  that evaluates the model
# on given values of the parameters, of sedo and of the data

# Input arguments:
#  data: data frame of the observations to study
# file: name of the formal description file
#  theta: values of the parameters theta
# FOdes, d.FOdes: values of the sedo and of its derivatives
#  gamf: values of the second level parameters of f
# Return object:
# a list that contains the components:
# - response: the values of f
# - d.resp: the values of the derivatives of f
#
# Constraint:
# a previous call to loadnls2("model.o") required
# model  defined by a odes
#
# -------------------------------------------------------------------------

# Verification 
# -------------
RetVerif <- verifmodnls2(data, theta=theta, gamf=gamf, integ.ctx=integ.ctx, file=file,func="phi")

# INITIALISATION DES STRUCTURES par les valeurs et tailles par defaut
# ------------------------------
.C("debutCalcnls2")

# Creation des donnees:
# -------------------
don <- crDatanls2(data,RetVerif$RetModel$NomX, RetVerif$RetModel$NomY)
# Verification
if ( (RetVerif$RetModel$NbTheta * don$NbCourbe) != RetVerif$nbt)
  stop(paste("\n The length of the argument 'Theta':", RetVerif$nbt,
     "\n is not equal to the number of the parameters in the file:", RetVerif$RetModel$NbTheta,
     "\n multiplied by the number of curves:", don$NbCourbe, "\n"))

# Creation de la trace et des donnees
# ---------------------------------
# "initCalcnls2" renvoie les elements qui  permettront de dimensionner les sorties
k <- as.integer(0)
RetDim <- .C("initCalcnls2",
   k=as.integer(k))

# other verifications 
if ((dim(FOdes)[1] != RetDim$k) || (dim(d.FOdes)[1] != RetDim$k))
  stop(paste(
"\nThe first dimension of the arguments FOdes or d.FOdes:",
dim(FOdes)[1], "and",dim(d.FOdes)[1],"\n",
"are not equal to the number of observations:",
RetDim$k,"\n"))

if ((dim(FOdes)[2] != RetVerif$RetModel$NbJ) || (dim(d.FOdes)[2] != RetVerif$RetModel$NbJ))
  stop(paste(
"\nThe  second dimension of the arguments FOdes or d.FOdes:",
dim(FOdes)[2], "and",dim(d.FOdes)[2],"\n",
"are not equal to the number of integration values:",
RetVerif$RetModel$NbJ,"\n"))

if (dim(FOdes)[3] != RetVerif$RetModel$NbEq)
  stop(paste(
"\nThe third dimension of the argument  FOdes:", dim(FOdes)[3], "\n",
"is not equal to the number of equations:", RetVerif$RetModel$NbEq,"\n"))

if (RetVerif$RetModel$IndicCi==0)
  long <-  RetVerif$RetModel$NbEq * (1+RetVerif$RetModel$NbThetaSedo)
else
  long <-  RetVerif$RetModel$NbEq * (1+ RetVerif$RetModel$NbEq + RetVerif$RetModel$NbThetaSedo)
long <-  long - RetVerif$RetModel$NbEq
if (dim(d.FOdes)[3] != long)
  stop(paste(
"\nThe third dimension of the argument  d.FOdes:",
dim(d.FOdes)[3], "should be:",long,"\n"))


# APPEL DU CALCUL
# ------------
le <- 0
ie <- 0
tFOdes <- aperm(FOdes, c(3,2,1))
td.FOdes <- aperm(d.FOdes, c(3,2,1))
f <- vector(mode="double", length=RetDim$k)
df <- vector(mode="double", length=(RetDim$k * RetVerif$RetModel$NbTheta))

Ret <- .C("calcphinls2", 
               RetVerif$RetModel$NbTheta, RetVerif$NbGamF,
               as.integer(RetVerif$RetModel$NbJ), as.integer(RetVerif$RetModel$NbEq), as.integer(long),
               as.double(RetVerif$Theta), as.double(RetVerif$GamF),
               as.double(tFOdes), as.double(td.FOdes),
               f=as.double(f), df=as.double(df),
               le=as.integer(le), ie=as.integer(ie))

if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")

  if (Ret$le <= length(coderr))
    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"
  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }

# Recuperation de ce qui concerne les donnees
# pour avoir les labels des k observations
# -------------------------------------------
# recuperer le code des val. manquantes
codeNa  <-  as.double(0)
codeNa  <-  .C("recupCodeNa", as.double(codeNa))[[1]]
	
RetDon <- recupDatanls2(RetDim$k, RetVerif$nbl, codeNa, T)


# Desallouer les structures C creees:
# ----------------------------------
.C("delCalcnls2")

# Transform df into a matrix
# ---------------------------
if(all(Ret$df ==0)) Ret$df  <- NA
else Ret$df <- matrix(Ret$df, ncol=RetVerif$RetModel$NbTheta, byrow=T,
          dimnames=list(RetDon$NomObs, RetVerif$RetModel$NomTheta))
if(all(Ret$f==0)) Ret$f  <- NA
else names(Ret$f) <- RetDon$NomObs


return(list(response=Ret$f, d.resp=Ret$df))
}
# ----------------------------------------
# ----------- end function calcphinls2 ----------
# ----------------------------------------

calcodesnls2 <- function(data,file, theta, integ.ctx, gamf=NULL) 
{
# -------------------------------------------------------------------------
# calcOdesnls2: call the program ModSedo of NL that evaluates the model
# on given values of the parameters and of the data
# -------------------------------------------------------------------------

# Verification
# -------------
RetVerif <- verifmodnls2(data, theta=theta, gamf=gamf, integ.ctx=integ.ctx,
                file=file,func="odes")
integ.ctx$nb.theta.odes <- RetVerif$RetModel$NbThetaSedo

# INITIALISATION DES STRUCTURES par les valeurs et tailles par defaut
.C("debutOdesnls2")

# Creation des donnees:
# -------------------
don <- crDatanls2(data,RetVerif$RetModel$NomX, RetVerif$RetModel$NomY)

# Verification
if ( (RetVerif$RetModel$NbTheta * don$NbCourbe) != RetVerif$nbt)
  stop(paste("\n The length of the argument 'Theta':", RetVerif$nbt,
     "\n is not equal to the number of the parameters in the file:", RetVerif$RetModel$NbTheta,
     "\n multiplied by the number of curves:", don$NbCourbe, "\n"))
#  Creation du contexte d'integration:
# -------------------------------------
crCtxIntegnls2(don$NbCourbe, don$n, RetVerif$RetModel, integ.ctx)
.Fortran("initlsoda")

# Creation de la trace et verification des structures crees
# et creation des structures de sortie
# ---------------------------------
# "initOdesnls2" renvoie les elements qui  permettront de dimensionner les sorties
k <- as.integer(0)
LgDSedo <- as.integer(0)
RetDim <- .C("initOdesnls2",
   pbase=as.integer(RetVerif$RetModel$NbTheta),
   k=as.integer(k),
   LgDSedo=as.integer(LgDSedo))


# APPEL DU CALCUL
# ------------
le <- 0
ie <- 0
Ret <- .C("callOdesnls2",
   pbase=as.integer(RetVerif$RetModel$NbTheta),
   nbgf=as.integer(RetVerif$NbGamF),
   Theta=as.double(RetVerif$Theta),
   GamF=as.double(RetVerif$GamF),
   le=as.integer(le), ie=as.integer(ie))


if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"
  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }

# Recuperation de ce qui concerne les donnees
# pour avoir les labels des k observations
# -------------------------------------------
# recuperer le code des val. manquantes
codeNa  <-  as.double(0)
codeNa  <-  .C("recupCodeNa", as.double(codeNa))[[1]]
	
RetDon <- recupDatanls2(RetDim$k, RetVerif$nbl, codeNa, T)

# Recuperation du sedo
# ---------------------
RetSedo  <-  recupSedonls2(1,
         RetDim$k, RetVerif$RetModel$NbEq, RetVerif$RetModel$NbJ, 
         RetVerif$RetModel$NbDF, RetDim$LgDSedo, RetDon$NomObs,
         RetVerif$RetModel$NomTheta, RetVerif$RetModel$NomValInt, 
         RetVerif$RetModel$NomLesF, RetVerif$RetModel$NomLesDF, codeNa)


# Recuperation de f et df:
# -----------------------
Valf <- vector(mode="double", length= RetDim$k)
DValf <- vector(mode="double", length= RetDim$k * RetVerif$RetModel$NbTheta)

Ret <-  .C("recupfdfnls2", as.integer(RetDim$k), as.integer(RetVerif$RetModel$NbTheta),
             f= as.double(Valf), df=as.double(DValf))


# Desallouer les structures C creees:
# ----------------------------------
.C("delOdesnls2")

# Labeller et mettre sous bonne dimension f, df:
# -----------------------------------------------
if(all(Ret$df ==0)) Ret$df  <- NA
else Ret$df <- matrix(Ret$df, ncol=RetVerif$RetModel$NbTheta, byrow=T,
          dimnames=list(RetDon$NomObs, RetVerif$RetModel$NomTheta))


if(all(Ret$f==0)) Ret$f  <- NA
else names(Ret$f) <- RetDon$NomObs

return(list(FOdes=RetSedo$FSedo, d.FOdes= RetSedo$DFSedo, response=Ret$f, d.resp=Ret$df))
}
# ----------------------------------------
# ----------- end function calcodesnls2 ----------
# ----------------------------------------

calcmodnls2 <- function(data, file,
                     theta=NULL, beta=NULL,  gamf=NULL, gamv=NULL,
                     response=NULL, d.resp=NULL,
                     FOdes=NULL,d.FOdes=NULL, 
                     integ.ctx=NULL, func="f")
{
# -------------------------------------------------------------------------
# calcmodnls2:  evaluates the model
# on given values of the parameters and of the data
# -------------------------------------------------------------------------

# Initialisation de GNLControle en ce qui concerne les messages
# -------------------------------------------------------------
check <-  options()$check
warn <-  options()$warn
.C("initcrolenls2",  as.integer(check), as.integer(warn))

switch(func,
  f = Ret <- calcfnls2(data, file,theta=theta, gamf=gamf),
  v =  Ret <- calcvnls2(data, file, response=response, d.resp=d.resp, 
                                 theta=theta, beta=beta, gamv=gamv),
  phi =  Ret <- calcphinls2(data, file, theta=theta, FOdes=FOdes, d.FOdes=d.FOdes,
                                     gamf=gamf,integ.ctx=integ.ctx),
  odes=  Ret <- calcodesnls2(data, file, theta=theta, integ.ctx=integ.ctx, gamf=gamf),
  stop("Invalid argument 'func' "))
return(Ret)
}


# ----------------------------------------
# ----------- end function calcmodnls2 ----------
# ----------------------------------------
