# : ### FICHIER createnls2.s ###
# -----------------------------------------------------
# FONCTIONS DE CREATION DES ARGUMENTS EN ENTREE DE NL
# ------------------------------------------------
# -------------------------------------------
# nbtuplesnls2: compte le nombre de tuples diffrents
# -------------------------------------------
nbtuplesnls2 <-
  function(x)
{
        k <- 1
        if(nrow(x) > 1) {
                for(i in 2:nrow(x))
                        for(j in 1:ncol(x)) {
                                if(x[i, j] != x[i - 1, j]) {
                                  k <- k + 1
                                  break
                                }
                        }
        }
        return(k)
}


# -------------------------------------------
# crDatanls2: Fonction de creation des donnees
#
# Arguments d'entree:
#   donnees: le data.frame des donnees
#   NomX: vecteur des noms des va. explicatives
#         lus dans le fichier de description 
#         formelle du modele
#   NomY: nom de la va. reponse lu dans le fichier 
#         de description formelle du modele
# Fonction appelante:
#         nls2
# Fonction appelee:
#         nbtuplesnls2
# Programmes C appeles:
# crDatanls2,crvectstrnls2,crvectnls2
# crvectstrznls2, crvectznls2
# -------------------------------------------
crDatanls2 <-  function(donnees, NomX, NomY)
{
# Construire une matrice des variables explicatives:
lvar <- pmatch(NomX, names(donnees))
if (any(is.na(lvar)))
  {
    cat("\n The names of the vectors containing the independent variables in the data are:\n")
    print ( names(donnees))
    cat("\n The names of the independent variables in the file model are:\n")
    print(NomX)
stop("\n They are not identical!\n")
  }

XObsT  <-  data.matrix(donnees)
n <-  nrow(XObsT)
XObsT  <-  matrix(XObsT[, lvar],nrow=n, byrow=F)

# Construire un vecteur de la reponse:
ValY <-  as.vector(donnees[[NomY]], mode="double")
if (length(ValY)!=n)
  stop(
       paste("The response vector must have length",
             n,
             " instead of",
             length(ValY),
             ".\n"))

# Creation des composants obligatoires et des noms de variables
# dans la structure de Donnees de NL

.C("crDatanls2", as.double(XObsT),
                as.double(ValY),
                as.character(NomX),
                as.character(NomY),
              m=as.integer(ncol(XObsT)),
              n=as.integer(n))


# Arguments facultatifs
#  zero et bidonstr servent a appeler les programmes de creation de vecteurs
#  avec nbele=0
bidonstr <- " "
zero  <- 0

# Creation de NomCT:
if (is.list(donnees) && !is.null(donnees$curves))
  {
  .C("crvectstrnls2", as.character("NomCT"),
                as.character(donnees[["curves"]]),
                n=as.integer(n))
  XObsT  <-  cbind(XObsT, donnees[["curves"]])
  NbCourbe  <-  length(unique(donnees[["curves"]]))
  }
else
  {
   # creation d'un vecteur avec nbele=0:
  .C("crvectstrnls2", as.character("NomCT"),
                as.character(bidonstr),
                n=as.integer(zero))
  NbCourbe <- 1
  }
 

# Creation de PoidsT:
if (is.list(donnees) && !is.null(donnees[["weights"]]))
  {
  .C("crvectnls2",  as.character("PoidsT"),
                 as.double(donnees[["weights"]]),
                 n=as.integer(n))
  XObsT  <-  cbind(XObsT, donnees[["weights"]])
  }
else
  {
  .C("crvectnls2",  as.character("PoidsT"),
                 as.double(zero),
                 n=as.integer(zero))
  }

# Calcul de k: nombre de tuples differents
k <-  nbtuplesnls2(XObsT)


# Creation de NomObsT:
if (!is.null(attr(donnees,"row.names")))
  {
  .C("crvectstrnls2", as.character("NomObsT"),
                as.character(attr(donnees,"row.names")),
                n=as.integer(n))
  }
else
  {
  .C("crvectstrnls2", as.character("NomObsT"),
                as.character(bidon),
                n=as.integer(zero))
  }


invisible()
return(list(n=n, NbCourbe=NbCourbe))

}
# ----------- FIN FONCTION crDatanls2 ---------------------------


# -------------------------------------------
# crCtxPussnls2: Fonction de creation de ctxpuss
#
# Arguments d'entree:
#   ctxpuss fourni par l'utilisateur
#   NbTheta, NbBeta: nombre de parametres de base
#   NbEtapes: nombre d'etapes demande
#   NomX:	le nom des va explicatives lues dans le modele
# Fonction appelante:
#         nls2
# Programmes C appeles:
# crvectnls2, crintnls2, crdblenls2
# -------------------------------------------
crCtxPussnls2 <-  function(ctxpuss, NbTheta, NbBeta, NbEtapes, NomX)
{
un <-  1
#  zero sert a appeler les programmes de creation de vecteurs
#  avec nbele=0
zero  <- 0

# Creation du composant obligatoire Theta0:
if (!is.list(ctxpuss)) ctxpuss=list(theta.start=ctxpuss)

  .C("crvectnls2",  as.character("Theta0"),
                 as.double(ctxpuss$theta.start),
                 n=as.integer(length(ctxpuss$theta.start)))

# Creation de NbEtapes:
.C("crintnls2", as.character("NbEtapes"), as.integer(NbEtapes))


# Creation de Beta0:
if (NbBeta >0)
  {
  .C("crvectnls2",  as.character("Beta0"),
                 as.double(ctxpuss$beta.start),
                 n=as.integer(length(ctxpuss$beta.start)))
  }
else
  {
  .C("crvectnls2",  as.character("Beta0"),
                 as.double(zero),
                 n=as.integer(zero))
  }

# Creation de 'Famille'
index <- 0
if (is.list(ctxpuss) && !is.null(ctxpuss$family))
  {
	if (!is.character(ctxpuss$family))
		stop("The family in the context must be character!\n")
	
 lesfamilles <- c("gaussian","poisson","binomial", "bernoulli", "multinomial")
	
  index <- match(ctxpuss$family, lesfamilles)
  if (any(is.na(index))) {
    cat(
"\nThe 'family'  component of the context argument is not correct: the value must be one value among:\n")
	print(lesfamilles)
	stop("Sorry!\n")
	}	
  .C("crintnls2", as.character("Famille"), as.integer(index))
  }
else
  {
   index <- 1
  .C("crintnls2", as.character("Famille"), as.integer(index))
  }

#	/* Creation de NomN */
if (is.list(ctxpuss) && !is.null(ctxpuss$nameN))
	{	
lvar <- pmatch( ctxpuss$nameN, NomX)
if (any(is.na(lvar)))
  {
    cat("\n The name of the variable N in the context is:\n")
    cat(ctxpuss$nameN)
    cat("\n The names of the independent variables in the file model are:\n")
    print(NomX)
stop("\n The variable N is not included!\n")
  }

# /* Stocker son indice */
	.C("crintnls2", as.character("IndiceN"), as.integer(lvar))
} # fin if (!is.null(ctxpuss$nameN))

	
		
	# Attention: rentrer mu.type avant les mu sinon
# confusion lors des tests "is.null", S ne discriminant que
# sur les 1iers caracteres

# Creation de TypeMu:
index <- 0
if (is.list(ctxpuss) && !is.null(ctxpuss$mu.type))
  {
  index <- match(ctxpuss$mu.type,c("KNOWN","MUGAUSS","MURES","MURESREP"))
  if (any(is.na(index)))
    stop(paste(
"\nThe 'mu.type'  component of the context argument is not correct: the value must be one value among:\n",
"KNOWN, MUGAUSS, MURES, MURESREP\n"))
  .C("crintnls2", as.character("TypeMu"), as.integer(index))
  }
else
  {
  if (is.list(ctxpuss) && !is.null(ctxpuss$mu3)) index <- 1
  .C("crintnls2", as.character("TypeMu"), as.integer(index))
  }

# Creation des Mu:
if(index ==1)
  {
  if (is.null(ctxpuss$mu3) || is.null(ctxpuss$mu4) ||
      is.na(as.double(ctxpuss$mu3)) || is.na(as.double(ctxpuss$mu4)))
    stop("\nThe values of the 3sd and 4th order moments must be given\n")
  .C("crvectnls2",  as.character("Mu3"),
                 as.double(ctxpuss$mu3),
                 n=as.integer(length(ctxpuss$mu3)))
  .C("crvectnls2",  as.character("Mu4"),
                 as.double(ctxpuss$mu4),
                 n=as.integer(length(ctxpuss$mu4)))
  }
else
  {
  .C("crvectnls2",  as.character("Mu3"),
                 as.double(zero),
                 n=as.integer(zero))
  .C("crvectnls2",  as.character("Mu4"),
                 as.double(zero),
                 n=as.integer(zero))
  }

# Attention: rentrer sigma2.type avant sigma2 sinon
# confusion lors des tests "is.null", S ne discriminant que
# sur les 1iers caracteres
# Creation de TypeSigma:
index <- 0
if (is.list(ctxpuss) && !is.null(ctxpuss$sigma2.type))
  {
  index <- match( ctxpuss$sigma2.type,c("KNOWN","VARREP","VARRESID","IGNORED","VARINTRA"))
  if (any(is.na(index)))
    stop(paste(
"\nThe 'sigma2.type'  component of the context argument is not correct: the value must be one value among:\n",
"KNOWN, VARREP, VARRESID, IGNORED, VARINTRA\n"))
  .C("crintnls2", as.character("TypeSigma"), as.integer(index))
  }
else
  {
  if (is.list(ctxpuss) && !is.null(ctxpuss$sigma2)) index <- 1
  .C("crintnls2", as.character("TypeSigma"), as.integer(index))
  }

# Creation de Sigma:
if(index ==1)
  {
  if(is.list(ctxpuss) && (is.null(ctxpuss$sigma2) || is.na(as.double(ctxpuss$sigma2))))
    stop("\nThe value of sigma2 must be given\n")
  .C("crdblenls2", as.character("Sigma2"),
                  as.double(ctxpuss$sigma2))
  }

# Creation de DirecC
if (is.list(ctxpuss) && !is.null(ctxpuss$omega.c1))
  .C("crdblenls2", as.character("DirecC"),
                  as.double(ctxpuss$omega.c1))
# Creation de Lambda0
if (is.list(ctxpuss) && !is.null(ctxpuss$lambda.start))
  .C("crdblenls2", as.character("Lambda0"),
                  as.double(ctxpuss$lambda.start))
# Creation de LambdaC1
if (is.list(ctxpuss) && !is.null(ctxpuss$lambda.c1))
  .C("crdblenls2", as.character("LambdaC1"),
                  as.double(ctxpuss$lambda.c1))
# Creation de LambdaC2
if (is.list(ctxpuss) && !is.null(ctxpuss$lambda.c2))
  .C("crdblenls2", as.character("LambdaC2"),
                  as.double(ctxpuss$lambda.c2))
# Creation de MaxCritArret
if (is.list(ctxpuss) && !is.null(ctxpuss$max.stop.crit))
  .C("crdblenls2", as.character("MaxCritArret"),
                  as.double(ctxpuss$max.stop.crit))
# Creation de MaxLambda
if (is.list(ctxpuss) && !is.null(ctxpuss$max.lambda))
  .C("crdblenls2", as.character("MaxLambda"),
                  as.double(ctxpuss$max.lambda))
# Creation de OmegaPas
if (is.list(ctxpuss) && !is.null(ctxpuss$omega.c2))
  .C("crdblenls2", as.character("OmegaPas"),
                  as.double(ctxpuss$omega.c2))

# Creation de MaxIter:
if (is.list(ctxpuss) && !is.null(ctxpuss$max.iters))
  .C("crintnls2", as.character("MaxIter"),
                  as.integer(ctxpuss$max.iters))

# Creation de MaxErr:
if (is.list(ctxpuss) && !is.null(ctxpuss$max.err.c1))
  .C("crintnls2", as.character("MaxErr"),
                  as.integer(ctxpuss$max.err.c1))

# Creation de MaxDeb:
if (is.list(ctxpuss) && !is.null(ctxpuss$max.err.c2))
  .C("crintnls2", as.character("MaxDeb"),
                  as.integer(ctxpuss$max.err.c2))


# Creation de Algo:
if (is.list(ctxpuss) && !is.null(ctxpuss$algorithm))
  {
  index <- match(ctxpuss$algorithm,c("GN","GM"))
  if (any(is.na(index)))
    stop(paste(
"\nThe 'algorithm' component of the context argument is not correct: the value must be one value among:\n",
"GN, GM\n"))
  .C("crintnls2", as.character("Algo"), as.integer(index))
  }


invisible()
return()

}
# ----------- FIN FONCTION crCtxPussnls2 ---------------------------



# -------------------------------------------
# crControlnls2: Fonction de creation de GNLControle
#
# Arguments d'entree:
#   controle: l'argument control fourni par l'utilisateur
# Fonction appelante:
#         nls2
# Fonction appelee:

# Programmes C appeles:
# crintnls2
# -------------------------------------------
crControlnls2 <-  function(controle)
{

# Creation de VouluIp

  if (is.list(controle) && !is.null(controle$fitted))
    {
    .C("crintnls2", as.character("IpAjustes"),
                  as.integer(controle$fitted))
    }
  if (is.list(controle) && !is.null(controle$est.eq))
    {
    .C("crintnls2", as.character("IpEquN"),
                  as.integer(controle$est.eq))
    }
  if (is.list(controle) && !is.null(controle$estim))
    {
    .C("crintnls2", as.character("IpEstim"),
                  as.integer(controle$estim))
    }
  if (is.list(controle) && !is.null(controle$deriv.fct))
    {
    .C("crintnls2", as.character("IpFctSensib"),
                  as.integer(controle$deriv.fct))
    }
  if (is.list(controle) && !is.null(controle$iter))
    {
    .C("crintnls2", as.character("IpNbIter"),
                  as.integer(controle$iter))
    }
  if (is.list(controle) && !is.null(controle$num.res))
    {
    .C("crintnls2", as.character("IpResNum"),
                  as.integer(controle$num.res))
    }
  if (is.list(controle) && !is.null(controle$odes))
    {
    .C("crintnls2", as.character("IpSedo"),
                  as.integer(controle$odes))
    }
 # fin de wanted.print



# Creation de Voulu
crVeuxnls2(controle) ;


# Creation de EtapeIt:
if (is.list(controle) && !is.null(controle$it.steps))
  {
  .C("crStepItnls2", as.integer(controle$it.steps),
                      as.integer(length(controle$it.steps)))
  }


# Creation de VouluIt

  if (is.list(controle) && !is.null(controle$it.fitted))
    {
    .C("crintnls2", as.character("ItAjustes"),
                  as.integer(controle$it.fitted))
    }

  if (is.list(controle) && !is.null(controle$it.estim))
    {
    .C("crintnls2", as.character("ItEstim"),
                  as.integer(controle$it.estim))
    }
  if (is.list(controle) && !is.null(controle$it.iter))
    {
    .C("crintnls2", as.character("ItNbIter"),
                  as.integer(controle$it.iter))
    }
  if (is.list(controle) && !is.null(controle$it.num.res))
    {
    .C("crintnls2", as.character("ItResNum"),
                  as.integer(controle$it.num.res))
    }
  if (is.list(controle) && !is.null(controle$it.odes))
    {
    .C("crintnls2", as.character("ItSedo"),
                  as.integer(controle$it.odes))
    }

if (is.list(controle) && !is.null(controle$it.est.eq))
    {
    .C("crintnls2", as.character("ItEquN"),
                  as.integer(controle$it.est.eq))
    }

if (is.list(controle) && !is.null(controle$it.deriv.fct))
    {
    .C("crintnls2", as.character("ItFctSensib"),
                  as.integer(controle$it.deriv.fct))
    }

# fin de VouluIt

# Creation de LgTrace
if (is.list(controle) && !is.null(controle$lg.trace))
  .C("crintnls2", as.character("LgTrace"),
                  as.integer(controle$lg.trace))

# Creation de FreqIp
if (is.list(controle) && !is.null(controle$freq))
  .C("crintnls2", as.character("FreqIp"),
                  as.integer(controle$freq))

# Creation de NbWAnaly
if (is.list(controle) && !is.null(controle$anal.warn))
  .C("crintnls2", as.character("NbWAnaly"),
                  as.integer(controle$anal.warn))
# Creation de NbWInteg
if (is.list(controle) && !is.null(controle$integ.warn))
  .C("crintnls2", as.character("NbWInteg"),
                  as.integer(controle$integ.warn))
# Creation de NbWMethe
if (is.list(controle) && !is.null(controle$meth.warn))
  .C("crintnls2", as.character("NbWMethe"),
                  as.integer(controle$meth.warn))
# Creation de NbWNumer
if (is.list(controle) && !is.null(controle$num.warn))
  .C("crintnls2", as.character("NbWNumer"),
                  as.integer(controle$num.warn))
# Creation de NbWTotal
if (is.list(controle) && !is.null(controle$all.warn))
  .C("crintnls2", as.character("NbWTotal"),
                  as.integer(controle$all.warn))

invisible()
return()

}
# ----------- FIN FONCTION crControlnls2 ---------------------------






# -------------------------------------------
# crVeuxnls2: Fonction de creation de GNLControle$Voulu
#
# Arguments d'entree:
#   control: l'argument control fourni par l'utilisateur
# Fonction appelante:
#     crControlenls2, (programme C) et les fonctions    renls2, rexnls2
# Fonction appelee:
# Programmes C appeles:
# crintnls2
# -------------------------------------------
crVeuxnls2 <-  function(control)
{

# Creation de Voulu
if (!is.null(control)&& is.list(control))
  {
  if ( !is.null(control$sv.fitted))
    {
    .C("crintnls2", as.character("VeuxAjustes"),
                  as.integer(control$sv.fitted))
    }
    
  if ( !is.null(control$sv.as.var))
    {
    .C("crintnls2", as.character("VeuxAsVar"),
                  as.integer(control$sv.as.var))
    }

  if ( !is.null(control$sv.B.varZ.B))
    {
    .C("crintnls2", as.character("VeuxBVarZBP"),
                  as.integer(control$sv.B.varZ.B))
    }
  if ( !is.null(control$sv.correlation))
    {
    .C("crintnls2", as.character("VeuxCorr"),
                  as.integer(control$sv.correlation))
    }

  if ( !is.null(control$sv.data))
    {
    .C("crintnls2", as.character("VeuxData"),
                  as.integer(control$sv.data))
    }

	
  if (!is.null(control$sv.est.eq))
    {
    .C("crintnls2", as.character("VeuxEquN"),
                  as.integer(control$sv.est.eq))
    }

	
  if (!is.null(control$sv.estim))
    {
    .C("crintnls2", as.character("VeuxEstim"),
                  as.integer(control$sv.estim))
    }

  if (!is.null(control$sv.deriv.fct))
    {
    .C("crintnls2", as.character("VeuxFctSensib"),
                  as.integer(control$sv.deriv.fct))
    }
	
  if (!is.null(control$sv.mu))
    {
    .C("crintnls2", as.character("VeuxMu"),
                  as.integer(control$sv.mu))
    }

  if (!is.null(control$sv.num.res))
    {
    .C("crintnls2", as.character("VeuxResNum"),
                  as.integer(control$sv.num.res))
    }
  if (!is.null(control$sv.residuals))
    {
    .C("crintnls2", as.character("VeuxResidus"),
                  as.integer(control$sv.residuals))
    }
  if (!is.null(control$sv.odes))
    {
    .C("crintnls2", as.character("VeuxSedo"),
                  as.integer(control$sv.odes))
    }

  if (!is.null(control$sv.W))
    {
    .C("crintnls2", as.character("VeuxValW"),
                  as.integer(control$sv.W))
    }
  
    if (!is.null(control$sv.Z))
    {
    .C("crintnls2", as.character("VeuxZ"),
                  as.integer(control$sv.Z))
    }

} # fin !is.null(control)

invisible()
return()

}
# ----------- FIN FONCTION crVeuxnls2 ---------------------------
  
# -------------------------------------------
# crModelnls2: Fonction de creation du modele
#
# Arguments d'entree:
#   modele: l'argument modele fourni par l'utilisateur
#   RetModel: la structure renvoyee par analDer
# Fonction appelante:
#         nls2
# Programmes C appeles:
#  crModelnls2, crintnls2, crvectnls2, crvectintnls2,
#  crvectNAnls2
# -------------------------------------------
# -------------------------------------------
# Fonction de creation du modele
# -------------------------------------------
crModelnls2 <-  function(modele, RetModel)
{

# On met les composants lus sur le fichier formel
# dans la structure globale Modele, structure  qui sera l'argument de NL
.C("crModelnls2",
                as.character(RetModel$NomTheta),
                as.character(RetModel$NomBeta),
                as.character(RetModel$NomGamF),
                as.character(RetModel$NomGamV),
                as.integer(RetModel$CasSedo),
                as.integer(RetModel$YaCalcV),
                as.integer(RetModel$NbTheta),
                as.integer(RetModel$NbBeta),
                as.integer(RetModel$NbGamF),
                as.integer(RetModel$NbGamV)
)


# Arguments facultatifs
# Creation de Vari:

if (is.list(modele) && !is.null(modele$vari))
  {
  index <- match(modele$vari,c("CST","SW","VST","VB","VSB","VSTB","VTB","VI"))
  if (any(is.na(index)))
    stop(paste(
"\nThe 'vari' component of the 'model' argument is not correct: the value must be one value among:\n",
"CST, SW, VST, VB, VSB, VSTB, VTB, VI\n"))
  .C("crintnls2", as.character("Vari"), as.integer(index))
  }
else
  .C("crintnls2", as.character("Vari"), as.integer(-1))


#  zero sert a appeler les programmes de creation de vecteurs
#  avec nbele=0
zero  <- 0

# Creation de GamF:
if (is.list(modele) && !is.null(modele$gamf))
  {
  .C("crvectnls2", as.character("GamF"), as.double(modele$gamf),
                  as.integer(RetModel$NbGamF))
  }
else
  {
  .C("crvectnls2", as.character("GamF"), as.double(zero),
                  as.integer(zero))
  }


# Creation de GamV:
if (is.list(modele) && !is.null(modele$gamv))
  {
  .C("crvectnls2", as.character("GamV"), as.double(modele$gamv),
                  as.integer(RetModel$NbGamV))
  }
else
  {
  .C("crvectnls2", as.character("GamV"), as.double(zero),
                  as.integer(zero))
  }


# Creation des contraintes sur Theta:
if (is.list(modele) && !is.null(modele$eqp.theta))
  {
  .C("crvectintnls2", as.character("EquPTheta"), as.integer(modele$eqp.theta),
                  as.integer(length(modele$eqp.theta)))
  }
else
  {
  .C("crvectintnls2", as.character("EquPTheta"), as.integer(zero),
                  as.integer(zero))
  }

if (is.list(modele) && !is.null(modele$eq.theta))
  {
  # comme on ne peut pas transmettre des valeurs en entree d'un programme C qui
  # soient egales a NaN, on remplace celles-ci par 0 
  # et on passe au programme C , un vecteur ayant 1 aux emplacements correspondants
  indNA <- is.na(modele$eq.theta)
  modele$eq.theta[indNA]  <-  as.double(0)
  .C("crvectNAnls2", as.character("EquNTheta"), as.double(modele$eq.theta),
                  as.integer(indNA),
                  as.integer(length(modele$eq.theta)))
  }
else
  {
  .C("crvectnls2", as.character("EquNTheta"), as.double(zero),
                  as.integer(zero))
  }

if (is.list(modele) && !is.null(modele$inf.theta))
  {
  indNA <- is.na(modele$inf.theta)
  modele$inf.theta[indNA]  <-  as.double(0)
  .C("crvectNAnls2", as.character("InfTheta"), as.double(modele$inf.theta),
                  as.integer(indNA),
                  as.integer(length(modele$inf.theta)))
  }
else
  {
  .C("crvectnls2", as.character("InfTheta"), as.double(zero),
                  as.integer(zero))
  }

if (is.list(modele) && !is.null(modele$sup.theta))
  {
  indNA <- is.na(modele$sup.theta)
  modele$sup.theta[indNA]  <-  as.double(0)
  .C("crvectNAnls2", as.character("SupTheta"), as.double(modele$sup.theta),
                  as.integer(indNA),
                  as.integer(length(modele$sup.theta)))
  }
else
  {
  .C("crvectnls2", as.character("SupTheta"), as.double(zero),
                  as.integer(zero))
  }


# Creation des contraintes sur Beta:
if (is.list(modele) && !is.null(modele$eqp.beta))
  {
  .C("crvectintnls2", as.character("EquPBeta"), as.integer(modele$eqp.beta),
                  as.integer(length(modele$eqp.beta)))
  }
else
  {
  .C("crvectintnls2", as.character("EquPBeta"), as.integer(zero),
                  as.integer(zero))
  }

if (is.list(modele) && !is.null(modele$eq.beta))
  {
  indNA <- is.na(modele$eq.beta)
  modele$eq.beta[indNA]  <-  as.double(0)
  .C("crvectNAnls2", as.character("EquNBeta"), as.double(modele$eq.beta),
                  as.integer(indNA),
                  as.integer(length(modele$eq.beta)))
  }
else
  {
  .C("crvectnls2", as.character("EquNBeta"), as.double(zero),
                  as.integer(zero))
  }

if (is.list(modele) && !is.null(modele$inf.beta))
  {
  indNA <- is.na(modele$inf.beta)
  modele$inf.beta[indNA]  <-  as.double(0)
  .C("crvectNAnls2", as.character("InfBeta"), as.double(modele$inf.beta),
                  as.integer(indNA),
                  as.integer(length(modele$inf.beta)))
  }
else
  {
  .C("crvectnls2", as.character("InfBeta"), as.double(zero),
                  as.integer(zero))
  }


if (is.list(modele) &&!is.null(modele$sup.beta))
  {
  indNA <- is.na(modele$sup.beta)
  modele$sup.beta[indNA]  <-  as.double(0)
  .C("crvectNAnls2", as.character("SupBeta"), as.double(modele$sup.beta),
                  as.integer(indNA),
                  as.integer(length(modele$sup.beta)))
  }
else
  {
  .C("crvectnls2", as.character("SupBeta"), as.double(zero),
                  as.integer(zero))
  }


invisible()
return()

}
# ----------- FIN FONCTION crModelnls2 ---------------------------

# -------------------------------------------
#  crMyOwnnls2: Fonction de creation quand l'estimateur est MYOWN
# Cree CtxNum.NbZ, Symm et Effic
# Programmes C appeles: crMyOwnnls2
# -------------------------------------------
crMyOwnnls2 <-  function(step, nbz, effic, W.type, fit.type)
{
  if (!is.numeric(nbz))
    stop("The argument 'num.ctx$nh' must be an integer value\n")
  if (!is.logical(effic))
    stop("The argument 'num.ctx$effic' must be a logical value\n")

  index <- match(W.type,c("SYM","SYMBLOCK","NONSYM"))
  if (any(is.na(index)))
    stop(paste(
"\nThe 'W.type' component of argument 'num.ctx' is not correct: the value must be one or several values among:\n",
"SYM, SYMBLOCK, NONSYM\n"))

  index2 <-  match(fit.type, c("LOGV", "STOPCRIT", "NWSST", "VWSS", "IVWSS",
                          "NWSSB", "SIGMA2", "MYOWN"))
   if (any(is.na(index2)))
    stop(paste(
"\nThe 'fitting.crit.type' component of argument 'num.ctx' is not correct: the value must be one or several values among:\n",
"LOGV, STOPCRIT, NWSST, VWSS, IVWSS, NWSSB, SIGMA2, MYOWN\n"))
   if (index2==8) index2 <- 14
  .C("crMyOwnnls2", as.integer(step), as.integer(nbz), as.integer(effic), as.integer(index), as.integer(index2))
invisible()
}
# ----------- FIN FONCTION crMyOwnnls2 ---------------------------


# -------------------------------------------
# crCtxNumnls2: Fonction de creation des contextes numeriques
#
# Arguments d'entree:
#   estim: les estimateurs demandes par l'utilisateur
# Fonction appelante:
#         nls2
# Programmes C appeles:
# crEstimnls2
# -------------------------------------------
crCtxNumnls2 <-  function(estim)
{
  index <- match(estim,c("MLTB","MLSTB","ERR","MLT","WLST","OLST","MLST","VITWLS","OLSB","MLSB", "QLTB","QLT","QLB","MYOWN"))
  if (any(is.na(index)))
    stop(paste(
"\nThe 'method' argument is not correct: the value must be one or several values among:\n",
"MLTB, MLSTB, ERR, MLT, WLST, OLST, MLST, VITWLS, OLSB, MLSB, QLTB, QLT, QLB, MYOWN\n"))

# Note:	 Les mthodes quasi-likelihood sont quivalentes aux MLS
	# mais on garde les methodes originales pour les messages
#estim[estim=="QLTB"] <- "MLSTB"
#estim[estim=="QLT"] <- "MLST"
#estim[estim=="QLB"] <- "MLSB"
  n <-  length(index)
  .C("crEstimnls2", as.integer(index),
              as.integer(n))
invisible()
return(n)

}
# ----------- FIN FONCTION crCtxNumnls2 ---------------------------



# -------------------------------------------
# crCtxIntegnls2: Fonction de creation du contexte d'integration
#
# Arguments d'entree:
#   NbCourbe: le nombre e courbes
#   NbObsT: le nombre total d'observations
#   RetModel: la structure retournee par analDer
#   ctxinteg: le contexte d'integration fourni
#            par l'utilisateur
# Fonction appelante:
#         nls2
# Programmes C appeles:
#  crIntegnls2
# -------------------------------------------
crCtxIntegnls2 <-  function(NbCourbe, NbObsT,
                         RetModel, ctxinteg)
{

  IndicTj <- match(RetModel$NomValInt, RetModel$NomX)
  IndicTj <-  IndicTj[!is.na(IndicTj)]
  NbIndicTj  <- length(IndicTj)

  if (is.null(ctxinteg$print))
    ctxinteg$print <- 0
  else
    ctxinteg$print <- 1
  if (is.null(ctxinteg$jacobian.meth))
    ctxinteg$Pjt <- 0
  else
    ctxinteg$Pjt <- 1
  if (is.null(ctxinteg$itol))
    ctxinteg$Pitol <- 0 # NLVCtxInteg se dbrouillera */
  else ctxinteg$Pitol <- 1
  if (is.null(ctxinteg$atol))
    {
    Nbatol  <-  0
    ctxinteg$atol <-  vector(mode="double", length=1)
    }
  else
    {
    Nbatol <-  length(ctxinteg$atol)
    }
  if (is.null(ctxinteg$rtol))
    {
    Nbrtol  <-  0
    ctxinteg$rtol <-  vector(mode="double", length=1)
    }
  else
    {
    Nbrtol <-  length(ctxinteg$rtol)
    }
  if (is.null(ctxinteg$iopt))
    {
    Nbiwork  <-  0
    ctxinteg$iopt <-  vector(mode="integer", length=1)
    }
  else
    {
    Nbiwork <-  length(ctxinteg$iopt)
    }
  if (is.null(ctxinteg$ropt))
    {
    Nbrwork  <-  0
    ctxinteg$ropt <-  vector(mode="double", length=1)
    }
  else
    {
    Nbrwork <-  length(ctxinteg$ropt)
    }

  if (is.null(ctxinteg$start))
     stop("\nThe integration context must contain a 'start' component (the values of the initial times)\n")
  NbT0T  <-  length(ctxinteg$start)

  if (is.null(ctxinteg$integ.values))
    {
    NbTj  <- 0
    ctxinteg$integ.values  <-  vector(mode="double", length=1)
    }
  else
    {
    if (is.matrix(ctxinteg$integ.values))
      {
      if ((nrow(ctxinteg$integ.values) != NbCourbe) || (ncol(ctxinteg$integ.values) != RetModel$NbJ))
        stop(paste("\nThe component 'integ.values' of the integration context\n",
                     "must be a matrix of",  NbCourbe,
                      "rows (number of curves) and of", RetModel$NbJ, "columns\n"))

      NbTj  <-  nrow(ctxinteg$integ.values) * ncol(ctxinteg$integ.values)
      }
    else
      {
      if (is.vector(ctxinteg$integ.values))
        {
        if (NbCourbe > 1)
stop(paste("\nThe component 'integ.values' of the integration context\n",
"must be a matrix of",  NbCourbe,
"rows (number of curves) and of", RetModel$NbJ, "columns\n"))

        if (length(ctxinteg$integ.values) != RetModel$NbJ)
stop(paste("\nThe component 'integ.values' of the integration context\n",
"must be a vector of length", RetModel$NbJ, "\n"))
        NbTj  <-  length(ctxinteg$integ.values)
        } 
      else
        stop("\nThe component 'integ.values' of the integration context\n",
"must be a vector, or, if several curves, a matrix\n")
      }
    }


  if (is.null(ctxinteg$cond.start))
    {
    NbCondInit  <- 0
    ctxinteg$cond.start  <-  vector(mode="double", length=1)
    }
  else
    {
    if (is.matrix(ctxinteg$cond.start))
      {
      if ((nrow(ctxinteg$cond.start) != NbCourbe) || (ncol(ctxinteg$cond.start) != RetModel$NbEq))
        stop(paste("\nThe component 'cond.start' of the integration context\n",
"must be a matrix of",  NbCourbe,
"rows (number of curves) and of", RetModel$NbEq, "columns\n"))
      NbCondInit  <-  nrow(ctxinteg$cond.start) * ncol(ctxinteg$cond.start)
      }
    else
      {
      if (is.vector(ctxinteg$cond.start))
        {
        if (NbCourbe > 1)
          stop(paste("\nThe component 'cond.start' of the integration context\n",
"must be a matrix of",  NbCourbe,
"rows (number of curves) and of", RetModel$NbEq, "columns\n"))
        if (length(ctxinteg$cond.start) != RetModel$NbEq)
          stop(paste("\nThe component 'cond.start' of the integration context\n",
"must be a vector of length", RetModel$NbEq, "\n"))
        NbCondInit  <-  length(ctxinteg$cond.start)
        } 
      else
        stop("\nThe component 'cond.start' of the integration context\n",
"must be a vector, or, if several curves, a matrix\n")
      }
    }


  Code  <- 0

  z <- .C("crIntegnls2", 
     as.integer(NbCourbe),
     as.integer(NbObsT),
     as.integer(RetModel$NbThetaSedo),
     as.integer(RetModel$NbEq),
     as.integer(RetModel$NbJ),
     as.integer(RetModel$IndicCi),
     as.integer(RetModel$IndicX),
     as.integer(ctxinteg$print),
     as.integer(ctxinteg$ImpInteg),
     as.integer(ctxinteg$Pjt),
     as.integer(ctxinteg$jacobian.meth),
     as.integer(ctxinteg$Pitol),
     as.integer(ctxinteg$itol),
     as.integer(NbIndicTj),
     as.integer(NbT0T),
     as.integer(NbTj),
     as.integer(NbCondInit),
     as.integer(Nbatol),
     as.integer(Nbrtol),
     as.integer(Nbiwork),
     as.integer(Nbrwork),
     as.integer(IndicTj),
     as.double(ctxinteg$start),
     as.double(ctxinteg$integ.values),
     as.double(ctxinteg$cond.start),
     as.double(ctxinteg$atol),
     as.double(ctxinteg$rtol),
     as.integer(ctxinteg$iopt),
     as.double(ctxinteg$ropt),
     Code=as.integer(Code))

  if (z$Code != 0)
    stop("\nThe integration context is not correct\n")

invisible()
return()

}
# ----------- FIN FONCTION crCtxIntegnls2 ---------------------------

