# : ### FICHIER ellips.nls2.s ###
ellips <- function(x, ...)
  UseMethod("ellips")

ellips.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }


# --------------------------------------------------------------------
# initpsinls2: verifier que les axis sont contenus dans names(vect.psi)
# et renvoyer la valeur de psi et std.error correspondante
# -------------------------------------------------------------------------

initpsinls2 <- function(axis.n, vect.psi , vect.std.error)
{
  psi  <- vect.psi[axis.n]
  if (is.null(psi) || is.na(psi))
     stop(paste("The function or variable", axis.n,"does not exist\n"))
return(list(nu=psi, std.error=vect.std.error[axis.n]))
}
# ------------------ fin fonction initpsinls2 ------------------------------

# --------------------------------------------------------------------
# ellcovarnls2: renvoyer la covariance
# -------------------------------------------------------------------------
ellcovarnls2  <-  function(nls2.object, is.theta)
{
        if(is.null(nls2.object$step1$as.var)) {
                return(nls2.object$as.var)
        }
        if(!is.null(nls2.object$step3$as.var) && is.theta) {
                return(nls2.object$step3$as.var)
        }
        if(!is.null(nls2.object$step2$as.var) && !is.theta) {
                return(nls2.object$step2$as.var)
        }
        if(!is.null(nls2.object$step1$as.var)) {
                return(nls2.object$step1$as.var)
        }
        stop("The nls2.object should contain the component 'as.var'")
        
}

# ------------------ fin fonction ellcovarnls2 ------------------------------


# ------------------------------------------------------------------------
 ellips.nls2 <- function(nls2.object, axis,
                    file=NULL,
                    pbispsi= c(nls2.object$model$gamf,nls2.object$model$gamv),
                    varpsi=NULL,
                    extends=matrix(3,nrow=2,ncol=length(axis)),
                     density=matrix(12,nrow=2,ncol=length(axis)),
                     bounds=matrix(0,nrow=2,ncol=length(axis)))
{
# -------------------------------------------------------------------------
# function that calculates the grid of confidence ellipsoides
# on functions of parameters of a given nls2.object
# -------------------------------------------------------------------------
if (!is.vector(axis) || length(axis) != 2)
  stop("The argument 'axis' must be a vector of length 2\n")
if (!is.numeric(extends) || !is.matrix(extends) || (ncol(extends) != length(axis)) || (nrow(extends) != 2))
  stop("The argument 'extends' must be a numerical matrix, number of columns is the length of 'axis' and number of rows is 2\n")
if (!is.numeric(density) || !is.matrix(density) || (ncol(density) != length(axis)) || (nrow(density) != 2))
  stop("The argument 'density' must be a numerical matrix, number of columns is the length of 'axis' and number of rows is 2\n")


if (any(density<=0))
  stop("The argument 'density' must contain values greater than 0\n")
if (!is.numeric(bounds) || !is.matrix(bounds) || (ncol(bounds) != length(axis)) || (nrow(bounds) != 2))
  stop("The argument 'bounds' must be a numerical matrix, number of columns is the length of 'axis' and number of rows is 2\n")

if (!is.null(file))
  {
  RetW <-  wald(nls2.object, file, pbispsi, varpsi)
  # verifier que les axis sont contenus dans names(RetW$psi) si character
  # et sont inferieurs a length(RetW$psi) si numeriques
  # et renvoyer la valeur de psi et std.error correspondante
  RetNu1 <-  initpsinls2(axis[1], RetW$psi, RetW$std.error)
  RetNu2 <-  initpsinls2(axis[2], RetW$psi, RetW$std.error)
  }
else
  {
  cc <- coef(nls2.object)
  RetNu1  <-  initaxisnls2(axis[1],cc)
  RetNu2  <-  initaxisnls2(axis[2],cc)
  
  if (RetNu1$is.theta != RetNu2$is.theta)
    stop("Error in the 'axis' argument: you cannot mix regression and variance parameters\n")
  
  covar <- ellcovarnls2(nls2.object, RetNu1$is.theta)
  if (all(is.na(covar)))
    stop("No as.var in the nls2.object\n")
  }

if (!all(bounds==0))
  {
  if ( (bounds[1,1] >= RetNu1$nu) || (bounds[2,1] <= RetNu1$nu))
    stop(paste("The bounds on axis",
      axis[1],
   "should be respectively less and greater than the value of the parameter or function:",
        RetNu1$nu))

  if ( (bounds[1,2] >= RetNu2$nu) || (bounds[2,2] <= RetNu2$nu))
    stop(paste("The bounds on axis",
      axis[2],
   "should be respectively less and greater than the value of the parameter or function:",
        RetNu2$nu))
  }

if (!is.null(file))
  {
  asvar12 <-  RetW$var.psi[axis[1], axis[2]]
  asvar1 <-  RetW$var.psi[axis[1], axis[1]]
  asvar2 <-  RetW$var.psi[axis[2], axis[2]]
  cor12 <- asvar12 / (sqrt(asvar1) * sqrt(asvar2))
  }
else
  {
  RetNu1$std.error <- cc$std.error[names(c(cc$theta, cc$beta))==names(RetNu1$nu)]
  RetNu2$std.error <- cc$std.error[names(c(cc$theta, cc$beta))==names(RetNu2$nu)]
  if(is.na(RetNu1$std.error))
    stop(paste("You cannot specify a parameter with numerical equality constraint:",
       names(RetNu1$nu),"\n"))
  if(is.na(RetNu2$std.error))
    stop(paste("You cannot specify a parameter with numerical equality constraint:",
       names(RetNu2$nu),"\n"))
  asvar12 <-  covar[names(c(cc$theta, cc$beta))==names(RetNu1$nu),
                     names(c(cc$theta, cc$beta))==names(RetNu2$nu)]
  asvar1 <-  covar[names(c(cc$theta, cc$beta))==names(RetNu1$nu),
                 names(c(cc$theta, cc$beta))==names(RetNu1$nu)]
  asvar2 <-  covar[names(c(cc$theta, cc$beta))==names(RetNu2$nu),
                names(c(cc$theta, cc$beta))==names(RetNu2$nu)]
  cor12 <-  asvar12 / (sqrt(asvar1) * sqrt(asvar2))
  }
  
x <- vector(mode="double", length=(density[1,1]+ density[2,1]))
y <- vector(mode="double", length=(density[1,2]+ density[2,2]))
z <- vector(mode="double", length(x)*length(y))


Ret <-  .C("ellipsnls2", 
      theta1=as.double(RetNu1$nu), theta2=as.double(RetNu2$nu),
      cor12=as.double(cor12),
      se1=as.double(RetNu1$std.error),se2=as.double(RetNu2$std.error),
      nbpoints=as.integer(as.vector(density)), extends=as.double(as.vector(extends)),
      bounds=as.double(bounds),
      x=as.double(x), y=as.double(y),
      z=as.double(z))
z <- matrix(Ret$z, ncol=length(x), nrow=length(y))

return(list(x=Ret$x, y=Ret$y, z=t(z),call=match.call()))
}

# ----------------------------------------
# ----------- end function ellips.nls2 ----------
# ----------------------------------------
