# : ### FICHIER iso.nls2.s ###
iso <- function(x, ...)
  UseMethod("iso")

iso.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

examnls2 <- function(nls2.object)
{
if (!is.null(nls2.object$step3$sigma2))
  {
  sumy <- list(stat.crit.type=nls2.object$step3$stat.crit.type,
         sigma2=nls2.object$step3$sigma2,  stat.crit=nls2.object$step3$stat.crit,loglik=nls2.object$step3$loglik)
  }
else
  {
    # step3 null
if (!is.null(nls2.object$step2$sigma2))
  {
  sumy <- list(stat.crit.type=nls2.object$step2$stat.crit.type,
        sigma2=nls2.object$step2$sigma2,   stat.crit=nls2.object$step2$stat.crit,loglik=nls2.object$step2$loglik)
  }
else
  {
   # step3 null et step2 null
    if (!is.null(nls2.object$step1))
  {
  sumy <- list(stat.crit.type=nls2.object$step1$stat.crit.type,
        sigma2=nls2.object$step1$sigma2,   stat.crit=nls2.object$step1$stat.crit,loglik=nls2.object$step1$loglik)
  }
    else
      {
        # step3 null et step2 null et step1 null
  sumy <- list(stat.crit.type=nls2.object$stat.crit.type,
     sigma2=nls2.object$sigma2,  stat.crit=nls2.object$stat.crit, loglik=nls2.object$loglik)
  }
  }}
  return(sumy)


}

# ----- end function examnls2 ---------------------------------

initaxisnls2 <- function(axis.n,cc )
{
is.theta  <- TRUE

if (is.numeric(axis.n))
  {
  # les axes sont indiques par leur numero d'ordre
  if (axis.n > length(cc$theta))
    {
    # il s'agit d'un parametre de la variance
    is.theta  <- FALSE
    axis.n <-  axis.n - length(cc$theta)
    nu  <- cc$beta[axis.n]
    }
  else
    {
    # il s'agit d'un parametre de la regression
    nu <-  cc$theta[axis.n]
    }
  if (is.null(nu) || is.na(nu))
     stop("One of the specified parameters does not exist\n")
  }
else
  {
  # les axes sont indiques par leur nom
  nu <-  cc$theta[axis.n]
  if (is.null(nu) || is.na(nu))
    {
    is.theta  <-  FALSE
    nu  <- cc$beta[axis.n]
    }
  if (is.null(nu) || is.na(nu))
     stop(paste("The parameter", axis.n,"does not exist\n"))
  }
return(list(nu=nu, is.theta=is.theta))
}
# ------------------ fin fonction initaxisnls2 ------------------------------

initisonls2 <- function(nls2.object, Sigma2)
{
  data <- plsplitoutnls2(nls2.object)

# Decodage du fichier formel pour avoir les noms des variables et de la reponse
# et generation de l'arbre de calcul du modele
# ------------------------------------------
RetModel <-  CrArbnls2(nls2.object$model, nls2.object$integ.ctx)


# Initialisation de GNLControle en ce qui concerne les messages
# -------------------------------------------------------------
check <-  options()$check
warn <-  options()$warn
.C("initcrolenls2",  as.integer(check), as.integer(warn))

# INITIALISATION DES STRUCTURES par les valeurs et tailles par defaut
# ------------------------------
.C("debutOdesnls2")

# Creation de la structure modele  en argument de NL:
# --------------------------------------------------
crModelnls2(nls2.object$model,RetModel )

# Creation des donnees:
# -------------------
don <- crDatanls2(data,RetModel$NomX, RetModel$NomY)
 
# Creation de la trace et des donnees
# ---------------------------------
k <- as.integer(0)
if (nls2.object$is.odes)
  {
  #  Creation du contexte d'integration:
  # -------------------------------------
  crCtxIntegnls2(don$NbCourbe, don$n, RetModel, nls2.object$integ.ctx)
  .Fortran("initlsoda")
  LgDSedo <- as.integer(0)
  RetDim <- .C("initOdesnls2",
   pbase=as.integer(RetModel$NbTheta),
   k=as.integer(k),
   LgDSedo=as.integer(LgDSedo))
  }
else
  {
  RetDim <- .C("initCalcnls2",
    k=as.integer(k))
  }

# Creation de ResStat (ce qu'on a besoin:ajustes et fctsensib )
# creation de ResStat.Sedo   et autres initialisations
TypeSigma <- match( nls2.object$stat.ctx$sigma2.type,c("KNOWN","VARREP","VARRESID","IGNORED","VARINTRA"))
.C("initIsonls2",
   TypeSigma=as.integer(TypeSigma),
   Sigma2=as.double(Sigma2))
	   
return(don$n)
}
# ------------------------------------------------------------------------
 iso.nls2 <- function(nls2.object, axis,
                     extends=matrix(3,nrow=2,ncol=length(axis)),
                     density=matrix(12,nrow=2,ncol=length(axis)),
                     bounds=matrix(0,nrow=2,ncol=length(axis)))
{
# -------------------------------------------------------------------------
# function that calculates the grid of likelihood contours
# on a given nls2.object
# -------------------------------------------------------------------------
if (!is.vector(axis) || length(axis) != 2)
  stop("The argument 'axis' must be a vector of length 2\n")
if (!is.numeric(extends) || !is.matrix(extends) || (ncol(extends) != length(axis)) || (nrow(extends) != 2))
  stop("The argument 'extends' must be a numerical matrix, number of columns is the length of 'axis' and number of rows is 2\n")
if (!is.numeric(density) || !is.matrix(density) || (ncol(density) != length(axis)) || (nrow(density) != 2))
  stop("The argument 'density' must be a numerical matrix, number of columns is the length of 'axis' and number of rows is 2\n")

if (!is.numeric(bounds) || !is.matrix(bounds) || (ncol(bounds) != length(axis)) || (nrow(bounds) != 2))
  stop("The argument 'bounds' must be a numerical matrix, number of columns is the length of 'axis' and number of rows is 2\n")


if (any(density<=0))
  stop("The argument 'density' must contain values greater than 0\n")

cc <- examnls2(nls2.object)
if (is.null(cc$stat.crit))
  stop("The nls2.object should contain the numerical results\n")

if (cc$stat.crit.type != "equal to -2log(likelihood)/n")
  warning(paste("Be careful: the statistical criterion is not equal to -2log(likelihood).",
   "It is:", cc$stat.crit.type,
      "\n We calculate here -2log(likelihood) without coherence verification\n"))

if (is.null(cc$loglik) || is.na(cc$loglik))
  {
  # cas ou le nls2.object est une sortie de renls2 et que loglik n'a pas ete demande
  if (cc$stat.crit.type != "equal to -2log(likelihood)/n")
    stop("The component 'loglik' (-2log(likelihood)/n) has not been calculated in the nls2.object")
  cc$loglik <-  cc$stat.crit
  }

# On a besoin de calculer le critere statistique=-2log(vrais) (non divise par n!)
# pour diverses valeurs des parametres
# pour cela, if faut calculer f et Variance pour les valeurs des parametres
# dans l'intervalle considere donc recuperer les donnees , etc...
nbobs <- initisonls2(nls2.object, cc$sigma2)
coe <- coef(nls2.object)
if (is.null(coe$theta))
  stop("The nls2.object should contain the estimated values of the parameters")

cc$theta <- coe$theta
cc$beta <- coe$beta
cc$std.error <- coe$std.error
RetNu1  <-  initaxisnls2(axis[1],cc)
RetNu2  <-  initaxisnls2(axis[2],cc)
	
if (RetNu1$is.theta != RetNu2$is.theta)
  stop("Error in the 'axis' argument: you cannot mix regression and variance parameters\n")


if (!all(bounds==0))
  {
  if ( (bounds[1,1] >= RetNu1$nu) || (bounds[2,1] <= RetNu1$nu))
    stop(paste("The bounds on axis", 
      axis[1],
   "should be respectively less and greater than the estimated value of the parameter:",
        RetNu1$nu))

  if ( (bounds[1,2] >= RetNu2$nu) || (bounds[2,2] <= RetNu2$nu))
    stop(paste("The bounds on axis", 
      axis[2],
   "should be respectively less and greater than the estimated value of the parameter:",
        RetNu2$nu))
  }

se1 <- cc$std.error[names(c(cc$theta, cc$beta))==names(RetNu1$nu)]
se2 <- cc$std.error[names(c(cc$theta, cc$beta))==names(RetNu2$nu)]

if(is.na(se1))
  stop(paste("You cannot specify a parameter with numerical equality constraint:",
     names(RetNu1$nu),"\n"))
if(is.na(se2))
  stop(paste("You cannot specify a parameter with numerical equality constraint:",
     names(RetNu2$nu),"\n"))

x <- vector(mode="double", length=(density[1,1]+ density[2,1]))
y <- vector(mode="double", length=(density[1,2]+ density[2,2]))
z <- vector(mode="double", length(x)*length(y))

if(RetNu1$is.theta)
  {
  axe1 <- match(names(RetNu1$nu), names(cc$theta))
  axe2 <- match(names(RetNu2$nu), names(cc$theta))
  }
else
  {
  axe1 <- match(names(RetNu1$nu), names(cc$beta))
  axe2 <- match(names(RetNu2$nu), names(cc$beta))
  }


code <- as.integer(0)
if (is.null(cc$beta)) cc$beta <- 0
	
Ret <- .C("calclognls2", as.double(cc$theta), as.double(cc$beta), 
         as.double(extends), as.double(bounds), as.integer(density), 
         as.integer(RetNu1$is.theta),
         as.integer(axe1), as.integer(axe2),
         as.double(se1),as.double(se2),
         x=as.double(x),y=as.double(y),
         loglik=as.double(z), code=as.integer(code))


if (Ret$code !=0)
  stop("Error in the program 'calclognls2'\n")

#  detruire ce qu'on a cree:
.C("delIsonls2")
z <-  (Ret$loglik- cc$loglik) * nbobs
z <- matrix(z,nrow=length(y), ncol=length(x))

return(list(x=Ret$x, y=Ret$y, z=t(z),call=match.call()))
}

# ----------------------------------------
# ----------- end function iso.nls2 ----------
# ----------------------------------------
