# : ### FICHIER nls2.s ###
nls2 <- function(data=sys.parent(), model, stat.ctx,  
              method=NULL, integ.ctx=NULL, control=NULL,
              renls2=F, num.ctx=NULL)
{
# -------------------------------------------------------------------------
# nls2: Fonction d'appel a la bibliotheque NL
# Arguments d'entree:
#  les arguments necessaires a l'appel de NL
#   (voir notice nls2)
# renls2: TRUE, si on veut appeler renls2 ensuite
# num.ctx: ne sert que quand on definit son propre estimateur (method="MYOWN")
# list(dim.Z=<1,2,3...>, 
#      effic=<T,F>, 
#      W.type=<"SYM","SYMBLOC","NONSYM">,
#      stat.crit.code=<"LOGV", "STOPCRIT", "NWSST", "VWSS", "IVWSS",
#                          "NWSSB", "SIGMA2", "MYOWN">
# Dans ce cas, l'utilisateur doit remplir le fichier ToMyOwn.c par ses propres
# programmes, et le compiler et le loader
# Retour fonction:
#   un nls2.object: voir notice nls2
# Appelee par l'utilisateur
# Fonctions appelees:
#  analDernls2, analFilenls2,
#  crModelnls2,crDatanls2,crCtxNumnls2,crCtxPussnls2,
#  crCtxIntegnls2,
#  recupDonnls2,recupCtxnls2,recupPnls2,recupNumnls2,
#  recupStatnls2,recupDivnls2,recupSedonls2
#  recupItnls2, makeListnls2, delnls2
# Programmes C appeles:
#  initnls2, crControlnls2, callNLnls2
# Programmes Fortran appeles:
# initlsoda <- 
# -------------------------------------------------------------------------

# VERIFICATION DES ARGUMENTS
# --------------------------
if(is.numeric(data))
   data <- sys.frame(data)


# Ne pas mettre:
# class(data) <- NULL

if (!inherits(data,"data.frame"))
   stop("\nThe 'data' must be a 'data.frame'\n")

if (!is.list(model) && !is.character(model))
  stop("\nThe 'model' must be in a 'list' or in a 'character' structure\n")

if (!is.list(stat.ctx) && !is.numeric(stat.ctx))
  stop("\nThe 'context' must be in a 'list' or in a 'numeric' structure\n")
  
if (!is.null(method) && !is.character(method))
  stop("\nThe 'method' must be in a 'character' structure\n")

if (!is.null(integ.ctx) && !is.list(integ.ctx) && !is.numeric(integ.ctx))
  stop("\nThe integration context must be in a 'list' or in a 'numeric' structure\n")

if (!is.null(control) && !is.list(control) && !is.numeric(control))
  stop("\nThe 'control' (control arguments) must be in a 'list' or in a 'numeric' structure\n")

# INITIALISATION DES STRUCTURES EN ARGUMENTS DE NL
# -----------------------------------------------
# Appel de NLDebut:
check <-  options()$check
warn <-  options()$warn

if (!is.null(control) && !is.null(control$lg.trace) && (control$lg.trace  >0))
  PTrace <- 1
else  PTrace <- 0

RetCode <- as.integer(0)
Ret <- .C("initnls2", 
                  as.integer(check), as.integer(warn), as.integer(PTrace),
                  RetCode= as.integer(RetCode))
if(Ret$RetCode !=0)
  stop("\nError in the execution of the estimation program: no valid returned value\n")

# DECODER LE FICHIER FORMEL ET CREER LES ARBBRES SI BESOIN:	
# --------------------------------------------------------		
RetModel <- CrArbnls2(model, integ.ctx)

if (RetModel$CasSedo ==1)
  integ.ctx$nb.theta.odes <- RetModel$NbThetaSedo
  
# CREATION DES ARGUMENTS EN ENTREE DE NL
# --------------------------------------
# Creation de la structure modele  en argument de NL:
# --------------------------------------------------
crModelnls2(model,RetModel )

# Creation des donnees:
# -------------------
don <- crDatanls2(data,RetModel$NomX, RetModel$NomY)

#  Creation des contextes numeriques:
# ----------------------------------
if (!is.null(method)) 
  {
  NbEtapes  <-  crCtxNumnls2(method)

  if (any(method == "MYOWN"))
    {
    if (is.null(num.ctx) || !is.list(num.ctx))
      stop("When method is your own, you must provide a list-argument 'num.ctx'")
    j <- 1
    for (step in 1:length(method))
      {
      if (method[step] == "MYOWN") 
        {
        if (is.null(num.ctx$nh[j]) || is.null(num.ctx$effic[j]) || is.null(num.ctx$W.type[j]))
          stop(
               "The argument 'num.ctx' must contain components 'nh, effic, W.type'\nvectors of length equal to the number of 'MYOWN' values in argument 'method'\n")
        if (is.null(num.ctx$stat.crit.code[j])) stat.crit.code <- "MYOWN"
             else stat.crit.code <- num.ctx$stat.crit.code[j]
        crMyOwnnls2(step, num.ctx$nh[j], num.ctx$effic[j], 
	num.ctx$W.type[j], stat.crit.code)
        j <-  j+1
        }
      } 
    } #fin de (method == "MYOWN")
  } # fin de !is.null(method)
else
  {
  NbEtapes <- 1
  }


#  Creation du contexte du puss:
# ------------------------------
crCtxPussnls2(stat.ctx, RetModel$NbTheta, RetModel$NbBeta, NbEtapes, RetModel$NomX)

#  Creation des arguments de controle:
# ------------------------------------

if ( is.null(control))
  {
	# on force a VRAI les elements recuperes dans le nls2.object
	control  <-  list(sv.fitted=T, sv.as.var=T, sv.B.varZ.B=T,
	     sv.correlation=T, sv.data=T, sv.est.eq=T, sv.estim=T, sv.deriv.fct=T,
	     sv.mu=T, sv.residuals=T, sv.num.res=T, sv.odes=T, sv.W=T, sv.Z=T)
	# on force les nos des etapes dont on garde les resultats
	control$sv.steps  <-  seq(1,  NbEtapes)

  } # fin if ( is.null(control))
else
	{
          # le control n'est pas nul
          if (is.null(control$sv.steps))
            {
             # on force les nos des etapes dont on garde les resultats
              control$sv.steps  <-  seq(1,  NbEtapes)
            }

          # mettre a vrai les composants non mentionns dans wanted.sv
          if (is.null(control$sv.fitted))
            control$sv.fitted <- T
          if (is.null(control$sv.as.var))
            control$sv.as.var <- T
          if (is.null(control$sv.B.varZ.B))
            control$sv.B.varZ.B <- T
          if (is.null(control$sv.correlation))
            control$sv.correlation <- T
          if (is.null(control$sv.data))
            control$sv.data <- T
          if (is.null(control$sv.est.eq))
            control$sv.est.eq <- T
          if (is.null(control$sv.estim))
            control$sv.estim <- T
          if (is.null(control$sv.deriv.fct))
            control$sv.deriv.fct <- T
          if (is.null(control$sv.mu))
            control$sv.mu <- T
          if (is.null(control$sv.residuals))
             control$sv.residuals <- T
          if (is.null(control$sv.num.res))
            control$sv.num.res <- T
          if (is.null(control$sv.odes))
            control$sv.odes <- T
          if (is.null(control$sv.W))
            control$sv.W <- T
          if (is.null(control$sv.Z))
            control$sv.Z <- T

	}

	 crControlnls2(control)

# On force a VRAI les calculs supplementaires
# car certains ont besoin des autres, et si ceux-ci
# ne sont pas calculs , a plante
.C("crControlnls2")

#  Creation du contexte d'integration:
# -------------------------------------

if (RetModel$CasSedo)
  {
  crCtxIntegnls2(don$NbCourbe, don$n, RetModel, integ.ctx)
  .Fortran("initlsoda")
  }


# Creation des arguments de sortie de appelnls2
# ---------------------------------------
# 'callNLnls2' renvoie le code d'execution de NL et les
# elements qui  permettront de dimensionner les sorties de nls2
k <- as.integer(0)
n <- as.integer(0)
NbObsLu <- as.integer(0)
NbCourbe <-  as.integer(0)
pmult <- as.integer(0)
qmult <- as.integer(0)
NbJ <- as.integer(0)
NbEq <- as.integer(0)
LgDSedo <- as.integer(0)
vouluit <- vector(mode="integer", length=7)
nbitsv <- vector(mode="integer", length=NbEtapes)
pact <- vector(mode="integer", length=NbEtapes)
qact <- vector(mode="integer", length=NbEtapes)
nh <- vector(mode="integer", length=NbEtapes)

# APPEL DE NL:
# ------------

RetDim <- .C("callNLnls2",
   NbEtapes=as.integer(NbEtapes), NbCourbe=as.integer(NbCourbe),
   k=as.integer(k), n=as.integer(n), NbObsLu=as.integer(NbObsLu),
   pmult=as.integer(pmult),qmult=as.integer(qmult),
   NbJ=as.integer(NbJ), NbEq=as.integer(NbEq),
   LgDSedo=as.integer(LgDSedo),
   vouluit=as.integer(vouluit), nbitsv=as.integer(nbitsv),
   pact=as.integer(pact),qact=as.integer(qact),
   nh=as.integer(nh),
   RetCode=as.integer(RetCode))

if(RetDim$RetCode !=0)
  stop("\n Error in the execution of 'nls2': no valid returned value\n")

# Recuperation de ce qui concerne les donnees:
# -------------------------------------------
# recuperer le code des val. manquantes
codeNa  <-  as.double(0)
codeNa  <-  .C("recupCodeNa", as.double(codeNa))[[1]]
RetDon <- recupDatanls2(RetDim$k, RetDim$NbObsLu, codeNa, control$sv.data)

# Preparer les labels des sorties:
# -------------------------------
labelcb <- NULL
if (RetDim$NbCourbe > 1)
  {
  labelct  <-  paste(rep(RetModel$NomTheta,RetDim$NbCourbe),
                  rep(seq(1:RetDim$NbCourbe), rep(RetModel$NbTheta,RetDim$NbCourbe)),
                  sep="_c")

  if (RetDim$qmult >0)
    labelcb  <-  paste(rep(RetModel$NomBeta,RetDim$NbCourbe), rep(seq(1:RetDim$NbCourbe),
                 rep(RetModel$NbBeta,RetDim$NbCourbe)),sep="_c")
  }
else
  {
  labelct <- RetModel$NomTheta
  if (RetDim$qmult >0)
    labelcb <- RetModel$NomBeta
  }


# Recuperation de ce qui concerne CtxPuss:
# -------------------------------------------
	RetCtx <-  recupCtxnls2(codeNa)

# Recuperation du mode de calcul de la variance
# -------------------------------------------
RetVari <-  recupVarinls2()

# Initialisation de la structure retournee par la fonction nls2:
# ------------------------------------------------------------
if (!is.list(model))
  model <- list(file=model)
model$vari.type <-  RetVari$Vari

if (length(RetModel$NomGamF)==0)
  model$gamf <- NULL
if (length(RetModel$NomGamV)==0)
  model$gamv <- NULL

if (!is.null(model$gamf))
  names(model$gamf) <-  RetModel$NomGamF
if ( !is.null(model$gamv))
  names(model$gamv) <-  RetModel$NomGamV

nls2.object  <-  list(call=match.call(), model=model,
               response.name=RetModel$NomY, X.names=RetModel$NomX,
               is.odes=RetModel$CasSedo, nb.steps=RetDim$NbEtapes,
               stat.ctx= RetCtx, integ.ctx=integ.ctx)

if ( !is.null(control$sv.data) && (control$sv.data == T))
	{
	nls2.object$data.stat   <-  list(Y1=RetDon$Y1, Y2=RetDon$Y2, S2=RetDon$S2)
	nls2.object$replications  <-  RetDon$NbRepet
	}
	

# Recuperation des resultats par etape:
# ------------------------------------
for (ietap in seq(1:RetDim$NbEtapes))
  {
  # Recuperation des valeurs estimees des parametres:
  # -------------------------------------------------
  if ( !is.null(control$sv.estim) && (control$sv.estim == T) &&
      (any(control$sv.steps == ietap)))
	{	
	  RetP <-  recupPnls2(ietap,RetDim$pmult,RetDim$qmult, labelct,labelcb, codeNa)
	}
  else
	RetP <-  NULL	
  
  # Recuperation de ResNum:
  # ----------------------
	if (!is.list(stat.ctx)) stat.ctx=list(theta.start=stat.ctx)
	if (is.null(stat.ctx$family)) stat.ctx$family<- "gaussian"
  RetNumrecup <-  recupNumnls2(ietap, RetDim$n, stat.ctx$family, codeNa)
  # ce qu'on garde toujours
  RetNum   <-  list(CodePuss=RetNumrecup$CodePuss, message= RetNumrecup$message,
                  NbIter=RetNumrecup$NbIter)
  # On rajoute le reste seulement si requis
  if (!is.null(control$sv.num.res) && (control$sv.num.res==T) &&
          (any(control$sv.steps == ietap)))
{
      for (comp in names(RetNumrecup))
        {
         RetNum[[comp]]  <-   RetNumrecup[[comp]]
       }
    }
  
    
  # Recuperation de ResStat:
  # -----------------------
  if  (any(control$sv.steps == ietap ))
     RetStat <-  recupStatnls2(control,
                         ietap, RetDim$k, RetDim$n,
                         RetModel$NbTheta, RetModel$NbBeta,
                         RetDim$pmult,RetDim$qmult,RetDim$pact[ietap],RetDim$qact[ietap],
                         RetDim$nh[ietap],
                         RetDon$PoidsT, RetDon$NomObs, RetDon$NomObsT, 
                         RetModel$NomTheta, RetModel$NomBeta,
                         labelct, labelcb, codeNa)

  # Recuperations diverses:
  # ---------------------
  RetDiv <-  recupDivnls2(ietap)
	# Rajouter ce qui ne dpend pas de l'tape:	
if (!is.null(RetDiv$IndiceN) && (RetDiv$IndiceN>0)) {
	nls2.object$nb.N <- RetDiv$IndiceN
	nls2.object$N.name <- RetModel$NomX[RetDiv$IndiceN]
	}
	
  # Recuperations des valeurs du Sedo:
  # ----------------------------------
  if ( (RetModel$CasSedo) && !is.null(control$sv.odes) &&
             (control$sv.odes ==T) &&
      (any(control$sv.steps == ietap)))
    {
    RetSedo  <-  recupSedonls2(ietap,
           RetDim$k, RetDim$NbEq, RetDim$NbJ, RetModel$NbDF, RetDim$LgDSedo, RetDon$NomObs, 
           RetModel$NomTheta, RetModel$NomValInt, RetModel$NomLesF, RetModel$NomLesDF, codeNa)
  }
  
  # Recuperations des resultats par iteration:
  # -----------------------------------------
  if (RetDim$nbitsv[ietap]>0)
    {
    RetIt  <- recupItnls2(ietap,
            RetDim$k, RetModel$NbTheta, RetModel$NbBeta,
            RetDim$pmult,RetDim$qmult,RetDim$pact[ietap],RetDim$qact[ietap],
            RetDim$nh[ietap],
            RetDim$NbEq, RetDim$NbJ,
            RetDim$nbitsv[ietap], RetDim$vouluit,
            RetDon$NomObs, RetModel$NomTheta, RetModel$NomBeta,
            RetModel$NomValInt, RetModel$NomLesF,
            labelct, labelcb, codeNa)
  
    }


  # Mettre les recuperations de l'etape dans le nls2.objet:
  # -------------------------------------------------------
  if (RetDim$NbEtapes == 1)
    {
    RetSorties <- makeListnls2(RetModel$CasSedo, RetDim$nbitsv[ietap],
                              RetDiv,RetNum, RetP, RetStat, RetSedo, RetIt)
    nom <- attributes(RetSorties)$names
    for (i in  1:length(nom))
      {
      nls2.object[[nom[i]]] <- RetSorties[[nom[i]]]
      }
    } # fin du cas 1 etape

  else
    {
    labstep <- paste("step",ietap,sep="")
    nls2.object[[labstep]] <- 
        makeListnls2(RetModel$CasSedo, RetDim$nbitsv[ietap],
                              RetDiv,RetNum, RetP, RetStat, RetSedo, RetIt)
    nom <- attributes(nls2.object[[labstep]])$names
    for (i in  1:length(nom))
      {
      nls2.object[[labstep]][[nom[i]]]  <-  nls2.object[[labstep]][[nom[i]]]
      }

  } # fin etape non unique

  } # fin boucle sur ietap


if (renls2==FALSE)
  {
  # Desallouer les structures creees dans NL:
#  delnls2()
  }
else
  {
  # mettre dans la structure C globale RetModele ce qui est
  # contenu dans la structure S car la structure C n'a pas ete
  # affectee quand evaluation par programme et renls2 en a besoin
  .C("affectModnls2", 
                as.character(RetModel$NomTheta),
                as.character(RetModel$NomBeta),
                as.character(RetModel$NomGamF),
                as.character(RetModel$NomGamV),
                as.character(RetModel$NomValInt),
                as.character(RetModel$NomLesF),
                as.character(RetModel$NomLesDF),
                as.integer(RetModel$CasSedo),
                as.integer(RetModel$YaCalcV),
                as.integer(RetModel$NbTheta),
                as.integer(RetModel$NbBeta),
                as.integer(RetModel$NbGamF),
                as.integer(RetModel$NbGamV),
                as.integer(RetDim$NbJ),
                as.integer(RetDim$NbEq))
  }


class(nls2.object) <- "nls2"

return(nls2.object)
invisible()
}
# ----------------------------------------
# ----------- fin fonction nls2 ----------
# ----------------------------------------

makeListnls2 <- function(CasSedo, 
		nbitsv,  RetDiv,RetNum, RetP, RetStat, RetSedo, RetIt)

# -------------------------------------------
# makeListnls2: fonction de creation de la liste des resultats
#            par etape a retourner dans le nls2.object
#
# Fonctions appelantes:
#         nls2, renls2
# -------------------------------------------
{
sorties <- list(
                 code=RetNum$CodePuss,
                 message= RetNum$message,
                 stop.crit=RetNum$CritArret,
                 stat.crit=RetNum$CritStat,
                 lambda=RetNum$Lambda,
                 loglik=RetNum$Log,
                 logfamily=RetNum$LogFamille,
	         deviance =RetNum$Deviance,
	         dev.residuals =RetNum$ResidusDev, 
                 nb.iters=RetNum$NbIter,
                 norm=RetNum$Norme,
                 rss=RetNum$Scr,
                 rss.unweighted=RetNum$ScrNP,
                 sigma2=RetNum$Sigma,
                 method=RetDiv$Estim,
                 stat.crit.type=RetDiv$TypeCritStat,
                 stat.crit.code=RetDiv$CodeCritStat,
                 nh=RetDiv$NbZ,
                 effic=RetDiv$Effic,
                 W.type=RetDiv$Symm,
                 theta=RetP$Theta,
                 beta=RetP$Beta,
                 response=RetStat$Valf,
                 variance=RetStat$VarY,
                 as.var=RetStat$AsVar,
                 B.varZ.B=RetStat$BVarZBP,
                 correlation=RetStat$Corr,
                 B=RetStat$ValB,
                 D=RetStat$ValD,
                 Eta=RetStat$ValEta,
                 d.resp=RetStat$DValf,
                 d.theta.vari=RetStat$DVarYTheta,
                 d.beta.vari=RetStat$DVarYBeta,
                 mu3=RetStat$Mu3,
                 mu4=RetStat$Mu4,
                 residuals=RetStat$Residus,
                 s.residuals=RetStat$ResidusR,
                 W=RetStat$ValW,
                 Z= RetStat$ValZ)

	# Appeler logfamily selon le nom effectif de la famille */
switch (RetDiv$Famille,
	 GAUSS =  { sorties$log.gaussian <- sorties$logfamily; },
	 POISSON =  { sorties$log.poisson <- sorties$logfamily; },
	 BINOM =  { sorties$log.binomial <- sorties$logfamily; },
	 BERNOULLI =  { sorties$log.bernoulli <- sorties$logfamily; },
	 MULTINOM =  { sorties$log.multinomial <- sorties$logfamily; }
	)
	
sorties$logfamily<- NULL;
if 	(RetDiv$Famille != "GAUSS")
	sorties$loglik <- NULL
	
	
if (CasSedo)
  {
  sorties$FOdes  <- RetSedo$FSedo
  sorties$d.FOdes  <- RetSedo$DFSedo
  }

if (nbitsv>0)
  {
  sorties$iters.sv  <- RetIt
  }

return(sorties)
}
# ----------------------------------------
# ----------- fin fonction makeListnls2 ----------
# ----------------------------------------
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
#  CrArbnls2:
# Creer l'arbre de calcul de f
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	

CrArbnls2 <- function(model, integ.ctx)
{	
# DECODAGE DU CONTENU DU FICHIER FORMEL DU MODELE
# -----------------------------------------------
if (is.character(model))
  {
  FicModel <-  model
  }
else
  {
  if (!is.character(model$file))
    stop("\nThe 'file' component of the 'model' must be the name of the file containing the formal expression of the model\n")
  FicModel <-  model$file
  }

RetModel <-  analFilenls2(FicModel)

# GENERATION DE L'ARBRE DE CALCUL DU MODELE
# ------------------------------------------
# Appel de analDer si pas de programme fourni
#  verifier que calcf est loade
pload <-  as.integer(0)

if (.C("ploadnls2",pload=pload)$pload==0)
  { #modele non charge
  if (RetModel$YaSubr==0)
    stop("\nThe model description file doesn't include expressions: you must provide the model evaluation programs\n")
  RetModel$NbThetaSedo <- analDernls2(FicModel)
  }
else
  {
  if (RetModel$CasSedo ==1) 
    {
    if (is.null(integ.ctx$nb.theta.odes))
      stop("\nThe component 'nb.theta.odes' is missing in the integration context\n")
    RetModel$NbThetaSedo  <-  integ.ctx$nb.theta.odes
    }
  }

return(RetModel)
}
# ----------- fin de 	CrArbnls2 ------------------------
				
