# : ### FICHIER plit.nls2.s ###
plit <- function(x, ...)
  UseMethod("plit")

plit.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

plrnls2<-function(iscreen, res, NbIter,  nbscreens, figs, NomRes, 
	title,ask.pause,ask.modify,...)
{
#***************************************************************************
# plrnls2:
# trace graphique d'un resultat numerique en fonction des iterations
# fonction appelee par plit.nls2
#***************************************************************************
  screen(nbscreens[iscreen]) 
  cat(paste("\nPlot of",NomRes,"against iterations\n"),fill=T)

  plot(NbIter,res,
         title=title, xlab="iterations",ylab=NomRes,
         type="b",...)


   if (ask.modify)
      {
      plmodifynls2()
      }
    iscreen  <-  iscreen+1

  if  (iscreen > length(nbscreens))
    {
    if (ask.pause)
      {
      cat("Hit 'return' to erase the display and see the next plot\n",fill=T)
      z <- scan(n=1,what="any")
      }
#    erase.screen(0) # on efface les graphes precedents
     close.screen(all=TRUE)
     split.screen(figs)
     iscreen <- 1
    }
  return(iscreen)
}
# ---------------- fin fonction plrnls2 --------------------------


plpnls2<-function(Param, NbIter, nbpoints,figsE,ask.pause,ask.modify,...) 
{
#***************************************************************************
# plpnls2:
# trace graphique d'un parametre en fonction des iterations
# et de ses variations en fonction des iterations.
# fonction appelee par plit.nls2
#***************************************************************************
    varp <- Param[1:(nbpoints-1),]
    varp[varp==0] <- NA
    varp <-  (100*(Param[2:nbpoints,] - varp))/ varp
    varp[is.na(varp)]  <- 0
    varp <- matrix(varp, ncol=ncol(Param))
    # si peu de variation au cours des iterations, ne pas tracer le parametre
    l <- apply(varp,2,function(x) {all(x==0)})

    if (any(l))
      cat("\nThe parameters '", 
         dimnames(Param)[[2]][l],
         "' do not appear because they don't vary\n",fill=T)

    if (all(l))
       return(); # aucun parametre ne varie

    varp <- matrix(varp[,!l], nrow=nbpoints-1)
    Paramnoms <- dimnames(Param)[[2]][!l]

    # on fait 2 figures sur l'ecran: 1 pour mettre le graphique
    # l'autre pour la legende:
    close.screen(all=TRUE)
    nbscreens <- split.screen(figs=matrix(c(0,0.71,0.7,1,0,0,1,1),ncol=4))

    cat("\n Plots of % variation of the parameters against iterations\n",fill=T)
    screen(nbscreens[1])
    matplot(matrix(NbIter[2:nbpoints], ncol=1), varp, type = "l",
                                  xlab = "iterations", ylab = "% variation ", 
                                  lty = 1:ncol(varp), ...)
    screen(nbscreens[2])
    y <- c( rep(min(varp),nbpoints-2), max(varp))
    plot(NbIter[2:nbpoints],y, xlab = "", ylab = "", axes=F,type = "n", ...)
    legend(NbIter[2], max(varp), legend = Paramnoms, cex=1.8,
                            lty = 1:ncol(varp) , col=1:ncol(varp))

   if (ask.modify)
      {
      while(TRUE)
        {
        cat("\nHit an expression  for modifying the plot or 'return'\n",fill=T)
        l <- scan(n=1, what="character", sep="\n")
        if (length(l)==0)
          break
        eval(parse(text=l))
        }
      }

    if (ask.pause)
      {
      cat("Hit 'return' to erase the display and see the next plot\n",fill=T)
      z <- scan(n=1,what="any")
      }

    # on efface les graphes precedents:
#    erase.screen(0) # on efface les graphes precedents
     close.screen(all=TRUE)


    nbscreens <- split.screen(figs=c(1,1))
    cat("\n Plots of % variation of each parameter between 2 iterations\n",fill=T)
    screen(nbscreens[1])

    tvar <- t(varp)
	if (is.R()) {
    stars((abs(tvar) - min(abs(tvar)))/(max(abs(
                                        tvar)) - min(abs(tvar))), scale = F,
                                        labels = Paramnoms,
                                        main =
                                        "% variation of each parameter between 2 iterations"
                                        ) } else {
	    stars((abs(tvar) - min(abs(tvar)))/(max(abs(
                                        tvar)) - min(abs(tvar))), scale = F,
                                        labels = Paramnoms,
                                        head =
                                        "% variation of each parameter between 2 iterations"
                                        ) }

	     if (ask.modify)
        {
        while(TRUE)
          {
          cat("\nHit an expression  for modifying the plot or 'return'\n",fill=T)
          l <- scan(n=1, what="character", sep="\n")
          if (length(l)==0)
            break
          eval(parse(text=l))
          }
        }

    if (ask.pause)
      {
      cat("Hit 'return' to erase the display and see the next plot\n",fill=T)
      z <- scan(n=1,what="any")
      }
#     erase.screen(0)

    close.screen(all=TRUE)

    nbscreens <- split.screen(figs=figsE)
    iscreen <- 1
    cat("\n Plots of the parameters and the percentage of their variation against iterations\n",fill=T)

    for(i in 1:ncol(varp))
      {
      screen(nbscreens[iscreen])

      plot(NbIter, Param[,Paramnoms[i]],
                  type ="b", ylab = paste("values of",Paramnoms[i]), xlab = "iterations", ...)

     if (ask.modify)
        {
        while(TRUE)
          {
          cat("\nHit an expression  for modifying the plot or 'return'\n",fill=T)
          l <- scan(n=1, what="character", sep="\n")
          if (length(l)==0)
            break
          eval(parse(text=l))
          }
        }
      iscreen  <-  iscreen+1
      if  (iscreen > length(nbscreens))
        {
        if (ask.pause)
          {
          cat("Hit 'return' to erase the display and see the next plot\n",fill=T)
          z <- scan(n=1,what="any")
          }
#      erase.screen(0) # on efface les graphes precedents
       close.screen(all=TRUE)
       split.screen(figsE)	
        iscreen <- 1
        }

      screen(nbscreens[iscreen])
      plot(NbIter[2:nbpoints], tvar[i, ], 
                  type = "b", ylab = paste("% variation of",  Paramnoms[i]), xlab = "iterations", ...)
      if (ask.modify)
        {
        while(TRUE)
          {
          cat("\nHit an expression  for modifying the plot or 'return'\n",fill=T)
          l <- scan(n=1, what="character", sep="\n")
          if (length(l)==0)
            break
          eval(parse(text=l))
          }
        }
      iscreen  <-  iscreen+1

      if  (iscreen > length(nbscreens))
        {
        if (ask.pause)
          {
          cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
          z <- scan(n=1,what="any")
          }
#      erase.screen(0) # on efface les graphes precedents
       close.screen(all=TRUE)
       split.screen(figsE)
        iscreen <- 1
        }
      } # fin boucle sur le nombre de parametres

  if ((ask.pause) && (iscreen !=1))
    {
    cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
    z <- scan(n=1,what="any")
#      erase.screen(0) # on efface les graphes precedents
       close.screen(all=TRUE)
    }
}
# ---------------- fin fonction plpnls2 -------------------------------------

iternls2<-function(iterlist)
{
#***************************************************************************
# iternls2:
# extraire les composants d'une liste 'iters.sv' d'un 'nls2.object'
# fonction appelee par plit.nls2
#***************************************************************************

return(list(
  NbItSv=iterlist$nb.iters.sv,
  NbIter=iterlist$iter,
  CritStat=iterlist$stat.crit, CritArret=iterlist$stop.crit,
  Lambda=iterlist$lambda, Theta=iterlist$theta, Beta=iterlist$beta))
}

# ------------- fin fonction iternls2 -------------------------


plit.nls2<-function(nls2.object,
         step=nls2.object$nb.steps,
         wanted=list(num.res=T, estim=T),
         start=0,
         title="",
         figsR=c(3,1),figsE=c(1,2),ask.pause=T,ask.modify=F, ...)

{
#***************************************************************************
# FONCTION:
# representations graphiques en vue d'une etude des resultats
# de chaque iteration
#
# ARGUMENTS:
# nls2.object: une sortie de la fonction nls2
# step: numero de l'etape (a partir de 1), en estimation alternee
# start: numero de l'iteration (Attention, no et non pas l'indice)
#       a partir duquel on fait les traces graphiques
# num.res:T si trace de Lambda , CritArret, et si different de CritArret, CritStat
# estim: trace des parametres: si il y a plusieurs etapes, les theta 
# ne sont traces qu'aux etapes impaires et les Beta, qu'aux etapes paires
# title= titre des graphiques
# figsR= decoupage de l'ecran pour les traces des num.res
# figsE=decoupage de l'ecran pour les parametres
# autres parametres: voir pld
# 
#***************************************************************************


# Verification des arguments:
# --------------------------
if ( !missing(step) && ( (step <= 0) || (step > nls2.object$nb.steps)))
  stop(paste("\nThe requested step",
               step, "and the effective number of steps", nls2.object$nb.steps,
               "does not match \n"))

# Obtention des resultats par iteration:
# --------------------------------------
if (nls2.object$nb.steps>1) 
  {
  labetap <-  paste("step",step, sep="")
  if (is.null(nls2.object[[labetap]]$iters.sv)) 
    stop(paste("\n There is no iteration results in the 'nls2.object' for the step", step, "\n"))
  Iter <-  iternls2(nls2.object[[labetap]]$iters.sv)
  }
  
if (nls2.object$nb.steps==1)
  {
  if (is.null(nls2.object$iters.sv))
    stop("\n There is no iteration results in the 'nls2.object'\n")
  Iter  <- iternls2(nls2.object$iters.sv)
  }

# on met start dans une variable avec un autre nom
# sinon confusion avec la fonction Old-S de meme nom
starti <-  start
# les iterations a representer:
NbIter <- Iter$NbIter[Iter$NbIter>=starti]
nbpoints <- length(NbIter)
if (nbpoints==0)
  stop(paste("\n The 'start' parameter (",starti,
    ") must be greater than the last iteration number saved in the 'nls2.object' (",
     Iter$NbIter[Iter$NbItSv],")",sep=""))

if(nbpoints <=2)
  stop("\n The number of iterations to plotted must be greater than 2\n")


# Appel des fonctions de traces graphiques:
# ----------------------------------------

# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()

# On efface les graphes precedents:
close.screen(all=TRUE)

# Trace des resultats numeriques
# ------------------------------
if (!is.null(wanted$num.res) && wanted$num.res && (!is.null(Iter$Lambda) || !is.null(Iter$CritArret) || !is.null(Iter$CritStat)) )
  {
  nbscreens <- split.screen(figs=figsR)
  iscreen <- 1

  # LAMBDA:
  if (!is.null(Iter$Lambda))
    {
    iscreen <- plrnls2(iscreen=iscreen,res=Iter$Lambda[Iter$NbIter>=starti],
            NbIter=NbIter,  nbscreens=nbscreens, figsR,NomRes="lambda", 
            title=title, ask.pause=ask.pause,ask.modify=ask.modify,...)
    } # fin Lambda
  
  # CRITARRET:
  if (!is.null(Iter$CritArret))
    {
    iscreen <- plrnls2(iscreen=iscreen,res=Iter$CritArret[Iter$NbIter>=starti],
            NbIter=NbIter,  nbscreens=nbscreens, figsR, NomRes="stop.crit", 
            title=title, ask.pause=ask.pause,ask.modify=ask.modify,...)
    } # fin CritArret
  
  #CRITSTAT:
  if (!is.null(Iter$CritStat) && (all(Iter$CritStat!=Iter$CritArret)))
    {
    iscreen <- plrnls2(iscreen=iscreen,res=Iter$CritStat[Iter$NbIter>=starti],
            NbIter=NbIter,  nbscreens=nbscreens, figsR,NomRes="stat.crit", 
            title=title, ask.pause=ask.pause,ask.modify=ask.modify,...)
    } # fin CritStat

  if ((ask.pause) && (iscreen !=1))
    {
    cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
    z <- scan(n=1,what="any")
#    erase.screen(0) # on efface les graphes precedents
# Pas besoin de faire close.screen, cf ci-dessous
    }

  } # fin num.res

# on efface les graphes precedents:
close.screen(all=TRUE)

if (!is.null(wanted$estim) && wanted$estim)
  {
  # THETA
  if ((step !=2) && !is.null(Iter$Theta))
    {
    Theta <- matrix(Iter$Theta[Iter$NbIter>=starti,],ncol=ncol(Iter$Theta))
    dimnames(Theta) <-  list(dimnames(Iter$Theta)[[1]][Iter$NbIter>=starti],
                         dimnames(Iter$Theta)[[2]])
    plpnls2(Theta,
                    NbIter, nbpoints,figsE, ask.pause,ask.modify,...)
    }
  # BETA
  if ( ( (step ==2) || ((step==1) && (nls2.object$nb.steps==1))) &&
       all(!is.na(Iter$Beta)) && !is.null(Iter$Beta) )
    {
    Beta <- matrix(Iter$Beta[Iter$NbIter>=starti,],ncol=ncol(Iter$Beta))
    dimnames(Beta) <-  list(dimnames(Iter$Beta)[[1]][Iter$NbIter>=starti],
                         dimnames(Iter$Beta)[[2]])
    plpnls2(Beta,
                    NbIter, nbpoints,figsE, ask.pause,ask.modify,...)
    }
  } # Fin estim

# on efface les graphes precedents:
# erase.screen(0)
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}
