# : ### FICHIER plres.nls2.s ###
plres <- function(x, ...)
  UseMethod("plres")

plres.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

plres.nls2<-function(nls2.object,
         step=nls2.object$nb.steps,
         wanted=list(F.R=T, R.R=T, I.R=F, X.R=F, V.R2=F),
         absolute=F, st=F,
         smooth=F, labels=NULL,
         title="",
         figs=c(2,2),ask.pause=T, ask.modify=F, ...)
{
#***************************************************************************
# FONCTION:
# representations graphiques en vue d'une etude des residus
# relative a des donnees etudiees par nls2:
#
# ARGUMENTS:
# nls2.object: une sortie de la fonction nls2
# step: numero de l'etape (a partir de 1), en estimation alternee
# F.R: TRUE  si on plit.nls2.s veut le graphe des residus
#      en fonction des valeurs observees de reponse
# R.R: TRUE  si on veut le graphe des residus(i)
#      en fonction des residus(i-1)
# I.R: TRUE  si on veut le graphe des residus(i)
#      en fonction de i
# X.R: TRUE  si on veut le graphe des residus(i)
#      en fonction des variables explicatives 
# V.R2: TRUE  si on veut le graphe des carres des residus
#      en fonction des  valeurs de la variance
# (pas valable avec l'option 'st')
# absolute: TRUE si, pour les graphes correspondant a F.R, I.R, X.R, on veut
#         representer les valeurs absolues des residus 
# st: TRUE  si on veut representer les valeurs des residus reduits
# smooth: TRUE si on veut un lissage des points (cf fonction S: lowess)
#         relatifs aux valeurs ajustees
# labels, title, figs, ask, ... :voir fonction 'pld'
#***************************************************************************

# Verification des arguments:
# --------------------------
if ( !missing(step) && ( (step <= 0) || (step > nls2.object$nb.steps)))
  stop(paste("\nThe requested step", 
               step, "and the effective number of steps", nls2.object$nb.steps,
               "does not match\n "))



# determination des divers elements constituant les donnees:
# --------------------------------------------------------
  data <- plsplitoutnls2(nls2.object)

z <- plsplitdnls2(data, nls2.object$response.name, nls2.object$X.names, labels=labels)
# On obtient:
# z$dmat:  matrice des va explicatives
# z$y: vecteur reponse,
# z$va.names: noms des variables explicatives
# z$response.name: nom du vecteur reponse,
# z$curve: noms des n indices indices de courbe
# z$labels: les labels sans ceux correspondant a des poids nuls

# Mise en dimension n des ajustes:
# --------------------------------

if ( !is.null(wanted$F.R) && wanted$F.R)
  {
    if (missing(step))
      {
        fittedf <-  fitted.nls2(nls2.object)$response
      }
  else
    {
      fittedf <-  nls2.object[[paste("step",step,sep="")]]$response
    }
    
  fittedf <- rep(fittedf, nls2.object$replications)
		  	
    if ( is.null(fittedf) || !is.numeric(fittedf)
        ||  is.null(nls2.object$replications))
      stop("The nls2.object should contain the fitted values of the response, and the vector of replications")
  } # fin F.R

if ( !is.null(wanted$V.R2) && wanted$V.R2)
  {
  if (missing(step))
    fittedv <-  fitted(nls2.object)$variance
  else
    fittedv <-  nls2.object[[paste("step",step,sep="")]]$variance

  fittedv <- rep(fittedv, nls2.object$replications)
  }


# Preparation des ordonnees:
ordlab <- "residuals"

if (st)
  {
  ordlab <- paste("standardized", ordlab)
  if (missing(step))
    residus <- residuals(nls2.object)$s.residuals
  else
    residus <-  nls2.object[[paste("step",step,sep="")]]$s.residuals
  }
else
  {
    if (missing(step))
    residus <- residuals(nls2.object)$residuals
  else
    residus <-  nls2.object[[paste("step",step,sep="")]]$residuals
  }
if (is.null(residus))
  stop("The nls2.object should contain the residuals")

n <- length(residus)
if (n != length(z$y))
  stop("\nThe 'nls2.object' and the data does not match\n")

if (absolute)
  {
  ordlabA <- paste("absolute", ordlab)
  residusA <- abs(residus)
  }


# Les identificateurs des points:
if (is.null(z$labels))
  z$labels <- rep("*", length(z$y))
else
  {
  if (length(z$labels) != length(z$y))
    stop("\n The length of the label vector does not match ")
  }

if (ask.modify)
  ask.pause <- T

# Appel des fonctions de traces graphiques:
# ----------------------------------------

# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()
	

# On efface les graphes precedents:
close.screen(all=TRUE)

# Argu qui ne servent pas ici:
xfit <- yfit <- curvefit <- NULL
		
if (!is.null(wanted$F.R) && wanted$F.R)
  {
  cat("\nPlots asked by the F.R option\n", fill=T)
  plnls2(as.matrix(fittedf), residus, z$labels,z$curve,
	 xfit, yfit, curvefit,
         title,
         "fitted values of the regression function",
         ordlab,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)

  if (absolute)
    plnls2(as.matrix(fittedf), residusA, z$labels,z$curve,
	 xfit, yfit, curvefit,
         title,
         "fitted values of the regression function",
         ordlabA,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
  }

if (!is.null(wanted$R.R) && wanted$R.R)
  {
  cat("\nPlots asked by the R.R option\n", fill=T)
  plnls2(as.matrix(residus), residus,  z$labels,z$curve,
	 xfit, yfit, curvefit,
        title,
         paste("preceding",ordlab),
         ordlab,
	jump=T,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
  }


if (!is.null(wanted$I.R) && wanted$I.R)
  {
  cat("\nPlots asked by the I.R option\n", fill=T)
  plnls2(as.matrix(1:n), residus, z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         "residuals order",
         ordlab,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
         figs, ...)
  if(absolute)
    plnls2(as.matrix(1:n), residusA,z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         "residuals order",
         ordlabA,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
         figs, ...)
  }

if (!is.null(wanted$X.R) && wanted$X.R)
  {
  cat("\nPlots asked by the X.R option\n", fill=T)
  plnls2(as.matrix(z$dmat), residus, z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         z$va.names,
         ordlab,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
  if(absolute)
    plnls2(as.matrix(z$dmat), residusA,z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         z$va.names,
         ordlabA,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
  }

if (!is.null(wanted$V.R2) && wanted$V.R2)
  {
  cat("\nPlots asked by the V.R2 option\n", fill=T)
  if (st)
    {
    cat("  cannot be asked with the 'st' option\n", fill=T)
    }
  else
    {
    plnls2(as.matrix(fittedv), (residus*residus), z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         "fitted variance",
         ordlab,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
    }
  }

# on efface les graphes precedents:
#erase.screen(0) 
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}


