# : ### FICHIER print.calibnls2.s ###
print.calibnls2<-
	function(calibnls2.object, digits = NULL, ...)
{
#
# fonction d'impression d'un calibnls2.object
	        if(!missing(digits)) {
                if((length(digits) != 1 || digits < 1))
                        stop("Bad value for digits argument")
                d <- options(digits = digits)
                on.exit(options(d))
        }
if (!is.null(calibnls2.object$x))	
  cat(" least squares estimator of the abscissa:",
	calibnls2.object$x, fill=T)

if (!is.null(calibnls2.object$S.message))
	cat(calibnls2.object$S.message, fill=T)
if (!is.null(calibnls2.object$S.conf.int))	
  cat(paste(" S confidence interval:  [",
	calibnls2.object$S.conf.int[1],
	",",calibnls2.object$S.conf.int[2], "]",sep=""), fill=T)

if (is.null(calibnls2.object$call$conf.bounds))
  {
  # le R interval n'a pas de sens quand les quantiles sont donnes		
  if (!is.null(calibnls2.object$R.message))
  	cat(calibnls2.object$R.message, fill=T)
  if (!is.null(calibnls2.object$R.conf.int))	
    cat(paste(" R confidence interval:  [",
  	calibnls2.object$R.conf.int[1],
  	",",calibnls2.object$R.conf.int[2], "]",sep=""), fill=T)
  	
  if (!is.null(calibnls2.object$R.conf.set))
    {	
    cat(" points in the R confidence set: ",fill=T)
    print(calibnls2.object$R.conf.set)	
    }
  }
			
invisible()
}	
