# : ### FICHIER print.coef.nls2.s ###
print.coef.nls2<-
function(object, ...)
{
# ecrire un coef.nls2.object
  mat <- NULL
  if (!is.null(object$theta))
    {
        mat <- matrix(object$theta, ncol=1)
        noms <- names(object$theta)
        if (!is.null(object$beta) &&
            !all(is.na(object$beta)))
          {
          mat <- rbind(mat, matrix(object$beta,ncol=1))
          noms <- c(noms, names(object$beta))
          }
      } # fin if (!is.null(object$theta))
  if (!is.null(object$std.error) && (!is.null(mat)) )
    {
        if (!all(is.na(object$std.error))) 
          {
        mat <- cbind(mat, object$std.error)
          t.value <-  mat[,1]/mat[,2]
          mat <- cbind(mat, t.value)
          dimnames(mat) <- list(noms, c("Value","Std. Error","t value"))
          }
        else
          {
          dimnames(mat) <- list(noms, c("Value"))
         }
        
      } # fin  if (!is.null(object$std.error))
  if (!is.null(object$theta) || !is.null(object$std.error))
    {
        print(mat,...)
      }
  else
  warning("No fitting values of the parameters or std.error in the nls2.object")
  
invisible()

}
