# : ### FICHIER recupnls2.s ###

# -----------------------------------------------------
# FONCTIONS DE RECUPERATION DES ARGUMENTS EN SORTIE DE NL
# ------------------------------------------------


# -------------------------------------------
# recupDatanls2: Fonction de recuperation de ce 
#   qui concerne les donnees
#
# Arguments d'entree:
#   k: nombre de tuples differents
#   NbObsLu: nombre d'observations+nombre de poids nuls
#   codeNa:	code des valeurs manquantes adopte dans les 
#	programmes C
#   wanted:	 Vrai si on veut recuperer les data.stat et nbrepet
# Dans tous les cas, il faut renvoyer PoidsT, NomObs, NomObsT
# Fonctions appelantes:
#         nls2, renls2
# Programmes C appeles:
#   recupDatals2
# -------------------------------------------
recupDatanls2  <- function(k,NbObsLu, codeNa, wanted)
{
NomObs <-  vector(mode="character", length=k)
# initialisation des vecteurs des noms d'observations:
# c'est necessaire pour le cas ou les noms ont plus
# d'1 caractere: on les initialise a la longueur maxi
# fixee pour les noms, en l'occurrence,
# on fixe cette limite a 15
NomObs <- rep("              ", k)
NomObsT <-  vector(mode="character", length=NbObsLu)
NomObsT <- rep("              ",NbObsLu)
PoidsT <- vector(mode="double", length=NbObsLu)
if ( !is.null(wanted) && (wanted==T))
	{
	kdim  <-  k
	}
else
	{
	kdim  <- 1
	}
		
NbRepet <-  vector(mode="integer", length=kdim)
Y1 <-  vector(mode="double", length=kdim)
Y2 <-  vector(mode="double", length=kdim)
S2 <-  vector(mode="double", length=kdim)


RetDon <- .C("recupDatanls2",
	  wanted=as.integer(wanted),
          k=as.integer(k),
          NbObsLu=as.integer(NbObsLu),
          NomObs=as.character(NomObs),
          NomObsT=as.character(NomObsT),
          NbRepet=as.integer(NbRepet),
          PoidsT=as.double(PoidsT),
          Y1=as.double(Y1), Y2=as.double(Y2),S2=as.double(S2))

if ( !is.null(wanted) && (wanted==T))
	{	
RetDon$Y1 <- as.vector(RetDon$Y1)
RetDon$Y2 <- as.vector(RetDon$Y2)
RetDon$S2 <- as.vector(RetDon$S2)
names(RetDon$Y1) <- RetDon$NomObs
names(RetDon$Y2) <- RetDon$NomObs
names(RetDon$S2) <- RetDon$NomObs
# Transformation des valeurs manquantes
RetDon$Y1[RetDon$Y1== codeNa]  <-  NA
RetDon$Y2[RetDon$Y2== codeNa]  <-  NA
RetDon$S2[RetDon$S2== codeNa]  <-  NA

	} # fin if (wanted == T)
	
RetDon$PoidsT <- as.vector(RetDon$PoidsT)
names(RetDon$PoidsT) <- RetDon$NomObsT
RetDon$PoidsT[RetDon$PoidsT== codeNa]  <-  NA
	
return(RetDon)
}



# -------------------------------------------
# recupCtxnls2: Fonction de recuperation de ce qui 
#               concerne CtxPuss
#
# Fonction appelante:
#         nls2
# Programmes C appeles:
#  recupCtxnls2
# -------------------------------------------

recupCtxnls2 <- function(codeNa)
{
Algo <- as.integer(0)
DirecC <- as.double(0)
Lambda0 <- as.double(0)
LambdaC1 <- as.double(0)
LambdaC2 <- as.double(0)
MaxCritArret <- as.double(0)
MaxDeb <- as.integer(0)
MaxErr <- as.integer(0)
MaxIter <- as.integer(0)
MaxLambda <- as.double(0)
OmegaPas <- as.double(0)
TypeMu <- as.integer(0)
TypeSigma <- as.integer(0)
Famille <- as.integer(0)
RetCtx <- .C("recupCtxnls2",
                   algorithm=as.integer(Algo),
                   omega.c1=as.double(DirecC),
                   lambda.start=as.double(Lambda0),
                   lambda.c1=as.double(LambdaC1),
                   lambda.c2=as.double( LambdaC2),
                   max.stop.crit=as.double(MaxCritArret),
                   max.err.c2=as.integer(MaxDeb),
                   max.err.c1=as.integer(MaxErr),
                   max.iters=as.integer(MaxIter),
                   max.lambda=as.double(MaxLambda),
                   omega.c2=as.double(OmegaPas),
                   mu.type=as.integer(TypeMu),
                   sigma2.type=as.integer(TypeSigma),
	           famille=as.integer(Famille))

# Pour mettre en caracteres les codes numeriques en sortie:
listeAlgo <- c("GN","GM")
listeTypeMu <- c("KNOWN","MUGAUSS","MURES","MURESREP")
listeTypeSigma <- c("KNOWN","VARREP","VARRESID","IGNORED","VARINTRA")
listeFamille <- c("gaussian","poisson","binomial", "bernoulli", "multinomial")
RetCtx$algorithm  <-  listeAlgo[RetCtx$algorithm]
RetCtx$mu.type  <-  listeTypeMu[RetCtx$mu.type]
RetCtx$sigma2.type  <-  listeTypeSigma[RetCtx$sigma2.type]
RetCtx$family <-  listeFamille[RetCtx$famille]
	RetCtx$famille <- NULL
	
# Transformation des valeurs manquantes
if (RetCtx$omega.c1 == codeNa) RetCtx$omega.c1 <- NA
if (RetCtx$lambda.start== codeNa) RetCtx$lambda.start <- NA
if (RetCtx$lambda.c1 == codeNa) RetCtx$lambda.c1  <- NA
if (RetCtx$lambda.c2== codeNa) RetCtx$lambda.c2  <- NA
if (RetCtx$max.stop.crit== codeNa) RetCtx$max.stop.crit <- NA
if (RetCtx$max.lambda== codeNa) RetCtx$max.lambda <- NA
if (RetCtx$omega.c2== codeNa) RetCtx$omega.c2 <- NA

return(RetCtx)
}



# -------------------------------------------
# recupPnls2: Fonction de recuperation des
#         valeurs estimees des parametres
#
# Arguments d'entree:
#    ietap: numero de l'etape courante
#   pmult,qmult: nombre de parametres multiples
#   labelct, labelcb: labels des  parametres multiples
# Fonctions appelantes:
#         nls2, renls2
# Programmes C appeles:
#  recupPnls2
# -------------------------------------------
recupPnls2 <- function(ietap,pmult,qmult, labelct, labelcb, codeNa)
{
Theta <- vector(mode="double", length=pmult)
Beta <- vector(mode="double", length=qmult)
RetP <- .C("recupPnls2",
           ietap=as.integer(ietap), 
           pmult=as.integer(pmult),
           qmult=as.integer(qmult),
           Theta=as.double(Theta), Beta=as.double(Beta))


		RetP[["Theta"]] <- as.vector(RetP[["Theta"]])
		 names(RetP[["Theta"]])  <-  labelct
	
RetP[["Theta"]][RetP[["Theta"]]==codeNa]  <-  NA
  if (qmult >0)
    {
                RetP[["Beta"]] <- as.vector(RetP[["Beta"]])
		 names(RetP[["Beta"]])  <-  labelcb
               RetP[["Beta"]][RetP[["Beta"]]==codeNa]  <-  NA
    }
  else
    RetP[["Beta"]]  <-  NULL

return(RetP)
}



# -------------------------------------------
# recupNumnls2: Fonction de recuperation de ResNum
#
# Arguments d'entree:
#    ietap: numero de l'etape courante
# Fonctions appelantes:
#         nls2, renls2
# Programmes C appeles:
#  recupNumnls2
# -------------------------------------------
recupNumnls2 <- function(ietap,n, famille,  codeNa)
{
CodePuss <- as.integer(0)
CritArret <- as.double(0)
CritStat <- as.double(0)
Lambda <- as.double(0)
Log  <- as.double(0)
LogFamille  <- Deviance <- as.double(0)
NbIter <- as.integer(0)
Norme  <- as.double(0)
Scr <- as.double(0)
ScrNP <- as.double(0)
Sigma <-  as.double(0)
ResidusDev <-  vector(mode="double", length=n)

RetNum <- .C("recupNumnls2",
                   ietap=as.integer(ietap),
                   CodePuss=as.integer(CodePuss),
                   CritArret=as.double(CritArret),
                   CritStat=as.double(CritStat),
                   Lambda=as.double(Lambda),
                   Log=as.double(Log),
                   LogFamille=as.double(LogFamille),
                   Deviance=as.double(Deviance),
                   NbIter=as.integer(NbIter),
                   Norme=as.double(Norme),
                   Scr=as.double(Scr),
                   ScrNP=as.double(ScrNP),
                   Sigma=as.double(Sigma),
	           ResidusDev = as.double(ResidusDev)		
	)

if ( RetNum$CritArret == codeNa) RetNum$CritArret  <-  NA
if (RetNum$CritStat == codeNa) RetNum$CritStat  <-  NA
if (RetNum$Lambda == codeNa) RetNum$Lambda  <-  NA
if (RetNum$Log == codeNa) RetNum$Log  <-  NA
if (RetNum$LogFamille == codeNa) RetNum$LogFamille  <-  NULL
if (RetNum$Deviance == codeNa) RetNum$Deviance  <-  NULL
if (RetNum$Norme == codeNa) RetNum$Norme  <-  NA
if (RetNum$Scr == codeNa) RetNum$Scr  <-  NA
if (RetNum$ScrNP == codeNa) RetNum$ScrNP  <-  NA
if (RetNum$Sigma == codeNa) RetNum$Sigma  <- NA
if ( (famille == "gaussian")	 ||	(famille == "multinomial"))
	    RetNum[["ResidusDev"]]  <-  NULL
	else
	{
	RetNum[["ResidusDev"]] <- as.vector(RetNum[["ResidusDev"]])
	RetNum[["ResidusDev"]][RetNum[["ResidusDev"]]==codeNa]  <- NA
	}

CodeMsg <- c(0,200,156,157,21,22,23,145,158,112,120,150,307,61)

#  TexteMsg <- c(
#  "Tout s'est bien passe", 
#  "Processus non execute: voir les messages ", 
#  "Calcul de f impossible pour les valeurs initiales",
#  "Calcul de v impossible pour les valeurs initiales",
#  "Convergence non atteinte",
#  "Nombre maximum d'iterations atteint",
#  "Probleme de direction de descente",
#  "Une valeur calculee par la fonction v est negative ou nulle",
#  "Une valeur calculee par la fonction v est negative ou nulle a la 1iere iteration",
#  "Longueur de trace erronee",
#  "Erreur dans les entrees: voir les messages ",
#  "Erreur de calcul numerique",
#  "Erreur dans le calcul du modele a integrer")

TexteMsg <- c(
"No errors during execution", 
"The estimation process has not been run: see the warnings ", 
"The regression function could not be calculated at the initial values of the parameters",
"The variance function could not be calculated at the initial values of the parameters",
"Convergence has not been reached",
"The maximum number of iterations has been reached",
"An error has occurred when calculating the direction",
"One value returned by the variance function is negative or null",
"One value returned by the variance function is negative or null at the first iteration",
"Invalid trace length",
"Invalid input arguments: see the warnings",
"A numerical error has occurred",
"An error has occurred when calculating the integration system",
"The minimisation criterions are equal at the 3 points of calculation")

# Le message qui correspond a CodePuss:
  RetNum$message <-  TexteMsg[CodeMsg==RetNum$CodePuss]
  if (length(RetNum$message) == 0) RetNum$message <- "An error has occured"

return(RetNum)
}


# -------------------------------------------
# recupStatnls2: Fonction de recuperation de ResStat
#
# Arguments d'entree:
#   control :	 list indiquant ce qu'on souhaite	
#   voir notice NL
#   labelct, labelcb: labels des  parametres multiples
# Fonctions appelantes:
#         nls2, renls2
# Programmes C appeles:
#  recupStatnls2
# -------------------------------------------
recupStatnls2 <- function(control,
	               ietap,k,n,
                       pbase,qbase,pmult,qmult,pact,qact,nh,
                       PoidsT, NomObs, NomObsT, NomTheta, NomBeta,
                       labelct, labelcb, codeNa)
{

multtot <-  pmult+ qmult

acttot <-  pact+ qact

if ( !is.null(control$sv.fitted) && (control$sv.fitted==T))
	{
	Valf <- vector(mode="double", length= k)
	VarY <- vector(mode="double", length= k)
	}
else
	{
	Valf <- vector(mode="double", length=1)
	VarY <- vector(mode="double", length=1)
	}

if ( !is.null(control$sv.as.var) && (control$sv.as.var==T))
	AsVar <-  vector(mode="double", length= multtot * multtot)
else
	AsVar <-  vector(mode="double", length=1)


if ( !is.null(control$sv.B.varZ.B) && (control$sv.B.varZ.B==T))
  BVarZBP <-  vector(mode="double", length= acttot * acttot)
else
  BVarZBP <-  vector(mode="double", length=1)

if ( !is.null(control$sv.correlation) && (control$sv.correlation ==T))
  Corr <-  vector(mode="double", length= multtot * multtot)
else
  Corr <-  vector(mode="double", length=1)
if ( !is.null(control$sv.est.eq) && (control$sv.est.eq==T))
  {
  ValB <- vector(mode="double", length=nh * acttot)
  ValD <- vector(mode="double", length=nh * acttot)
  ValEta <- vector(mode="double", length= nh)
  }
else
  {
  ValB <- vector(mode="double", length=1)
  ValD <- vector(mode="double", length=1)
  ValEta <- vector(mode="double", length=1)
  }


if ( !is.null(control$sv.deriv.fct) && (control$sv.deriv.fct ==T))
  {
  DValf <- vector(mode="double", length=k * pbase)
  DVarYTheta <- vector(mode="double", length=k * pbase)
  DVarYBeta <- vector(mode="double", length=k * qbase)
}
else
  {
   DValf <- vector(mode="double", length=1)
   DVarYTheta <- vector(mode="double", length=1)
   DVarYBeta <- vector(mode="double", length=1)
 }

if ( !is.null(control$sv.mu) && (control$sv.mu ==T))
  {
    Mu3 <- vector(mode="double", length=k)
    Mu4 <- vector(mode="double", length=k)
  }
else
  {
   Mu3 <- vector(mode="double", length=1)
   Mu4 <- vector(mode="double", length=1)
 }

if ( !is.null(control$sv.residuals) && (control$sv.residuals == T))
  {
    Residus <-  vector(mode="double", length=n)
    ResidusR <-  vector(mode="double", length=n)
  }
else
  {
    Residus <-  vector(mode="double", length=1)
    ResidusR <-  vector(mode="double", length=1)
  }


if ( !is.null(control$sv.W) && (control$sv.W ==T))
  ValW <-  vector(mode="double", length= acttot * acttot)
else
  ValW <-  vector(mode="double", length=1)

if ( !is.null(control$sv.Z) && (control$sv.Z==T))
  ValZ <- vector(mode="double", length= nh)
else
  ValZ <- vector(mode="double", length=1)


RetStat1 <- .C("recupStat1nls2",
           wfitted=as.integer(control$sv.fitted),
           wasvar=as.integer(control$sv.as.var),
           wbvarzb=as.integer(control$sv.B.varZ.B),
           wcorrelation=as.integer(control$sv.correlation),
                   ietap=as.integer(ietap),
                   k=as.integer(k),
                   n=as.integer(n),
                   pbase=as.integer(pbase),qbase=as.integer(qbase),
                   pmult=as.integer(pmult),qmult=as.integer(qmult),
                   pact=as.integer(pact),qact=as.integer(qact),
                   nh=as.integer(nh),
                   Valf=as.double(Valf),  VarY=as.double(VarY),
                   AsVar=as.double(AsVar),BVarZBP=as.double(BVarZBP),
                   Corr=as.double(Corr))

RetStat=list()
for (i in 1:length(RetStat1))
  RetStat[[i]] = RetStat1[[i]]
names(RetStat) = names(RetStat1)

if (control$sv.est.eq == TRUE) {
RetStat1 <- .C("recupEquNnls2",
                   ietap=as.integer(ietap),
                   k=as.integer(k),
                   n=as.integer(n),
                   pbase=as.integer(pbase),qbase=as.integer(qbase),
                   pmult=as.integer(pmult),qmult=as.integer(qmult),
                   pact=as.integer(pact),qact=as.integer(qact),
                   nh=as.integer(nh),
                   ValB=as.double(ValB), ValD=as.double(ValD), ValEta=as.double(ValEta))

for (i in c("ValB", "ValD", "valEta")) {
  RetStat[[i]] = RetStat1[[i]]
}
}

RetStat1 <- .C("recupStat2nls2",
           wderivfct=as.integer(control$sv.deriv.fct),
           wmu=as.integer(control$sv.mu),
           wresiduals=as.integer(control$sv.residuals),
           ww=as.integer(control$sv.W),
           wz=as.integer(control$sv.Z),
                   ietap=as.integer(ietap),
                   k=as.integer(k),
                   n=as.integer(n),
                   pbase=as.integer(pbase),qbase=as.integer(qbase),
                   pmult=as.integer(pmult),qmult=as.integer(qmult),
                   pact=as.integer(pact),qact=as.integer(qact),
                   nh=as.integer(nh),
                   DValf=as.double(DValf),
                   DVarYTheta=as.double(DVarYTheta), DVarYBeta=as.double(DVarYBeta),
                   Mu3=as.double(Mu3),  Mu4=as.double(Mu4),
                   Residus=as.double(Residus), ResidusR=as.double(ResidusR),
                   ValW=as.double(ValW),
                   ValZ=as.double(ValZ))


for (i in c("DValf", "DVarYTheta","DVarYBeta","Mu3", "Mu4", "Residus",
            "ResidusR", "ValW", "ValZ")) {
  RetStat[[i]] = RetStat1[[i]]
}


# Mise selon les bonnes dimensions des sorties:
# --------------------------------------------
  if( is.null(RetStat[["Valf"]]) || all(RetStat[["Valf"]] == 0)
      || all(is.na(RetStat[["Valf"]])))
    RetStat[["Valf"]]  <-  NULL
   else
	{
        RetStat[["Valf"]] <- as.vector(RetStat[["Valf"]])
        names(RetStat[["Valf"]])  <-  NomObs
	RetStat[["Valf"]][RetStat[["Valf"]]==codeNa]  <- NA
	}


if (is.null(RetStat[["VarY"]]) || all(RetStat[["VarY"]]  == 0)
      || all(is.na(RetStat[["VarY"]])))
    RetStat[["VarY"]]  <-  NULL
     else
	{
        RetStat[["VarY"]] <- as.vector(RetStat[["VarY"]])
  	names(RetStat[["VarY"]])  <-  NomObs
	RetStat[["VarY"]][RetStat[["VarY"]]==codeNa]  <- NA
	}

  if (is.null(RetStat[["AsVar"]]) ||  all(RetStat[["AsVar"]] == 0)
      || all(is.na(RetStat[["AsVar"]])))
    RetStat[["AsVar"]]  <-  NULL
	else
	{
	RetStat[["AsVar"]][RetStat[["AsVar"]]==codeNa]  <- NA
	  RetStat[["AsVar"]] <-  matrix(RetStat$AsVar,
       ncol=multtot, byrow=TRUE,
       dimnames=list(c(labelct, labelcb),c(labelct, labelcb)))
      }

  if (is.null(RetStat[["BVarZBP"]]) ||  all(RetStat[["BVarZBP"]] == 0)
      || all(is.na(RetStat[["BVarZBP"]])))
    RetStat[["BVarZBP"]]  <-  NULL
	else
	{
	RetStat[["BVarZBP"]][RetStat[["BVarZBP"]]==codeNa]  <- NA
	  RetStat[["BVarZBP"]] <-  matrix(RetStat$BVarZBP,
       ncol=acttot, byrow=TRUE)
	}


  if (is.null(RetStat[["Corr"]]) || all(RetStat[["Corr"]] == 0)
      || all(is.na(RetStat[["Corr"]])))
    RetStat[["Corr"]]  <-  NULL
	else
	{
	RetStat[["Corr"]][RetStat[["Corr"]]==codeNa]  <- NA
	  RetStat[["Corr"]] <-  matrix(RetStat$Corr,
       ncol=multtot, byrow=TRUE,
       dimnames=list(c(labelct, labelcb),c(labelct, labelcb)))
	}


  if (is.null(RetStat[["ValB"]]) || all(RetStat[["ValB"]] == 0)
      || all(is.na(RetStat[["ValB"]])))
    RetStat[["ValB"]]  <-  NULL
	else
	{
	RetStat[["ValB"]][RetStat[["ValB"]]==codeNa]  <- NA
	  RetStat[["ValB"]] <-  matrix(RetStat$ValB,
       ncol=acttot, byrow=TRUE)
	}

  if (is.null(RetStat[["ValD"]]) ||  all(RetStat[["ValD"]] == 0)
      || all(is.na(RetStat[["ValD"]])))
    RetStat[["ValD"]]  <-  NULL
	else
	{
	RetStat[["ValD"]][RetStat[["ValD"]]==codeNa]  <- NA
	  RetStat[["ValD"]] <-  matrix(RetStat$ValD,
       ncol=acttot, byrow=TRUE)
	}

  if (is.null(RetStat[["ValEta"]]) ||  all(RetStat[["ValEta"]] == 0)
      || all(is.na(RetStat[["ValEta"]])))
    RetStat[["ValEta"]]  <-  NULL
     else
	{
	RetStat[["ValEta"]][RetStat[["ValEta"]]==codeNa]  <- NA
	RetStat[["ValEta"]] <- as.vector(RetStat[["ValEta"]])
	names(RetStat[["ValEta"]]) <-  rep(NomObs, (nh/k))
	}

  if (is.null(RetStat[["DValf"]]) || all(RetStat[["DValf"]] == 0)
      || all(is.na(RetStat[["DValf"]])))
    RetStat[["DValf"]]  <-  NULL
	else
	{
	RetStat[["DValf"]][RetStat[["DValf"]]==codeNa]  <- NA
	  RetStat[["DValf"]] <-  matrix(RetStat$DValf,
         ncol=pbase, byrow=TRUE, 
         dimnames=list(NomObs,NomTheta))
	}

  if (is.null(RetStat[["DVarYTheta"]]) ||  all(RetStat[["DVarYTheta"]] == 0)
      || all(is.na(RetStat[["DVarYTheta"]])))
    RetStat[["DVarYTheta"]]  <-  NULL
	else
	{
	 RetStat[["DVarYTheta"]][ RetStat[["DVarYTheta"]]==codeNa]  <- NA
	  RetStat[["DVarYTheta"]] <-  matrix(RetStat$DVarYTheta,
         ncol=pbase, byrow=TRUE,
         dimnames=list(NomObs,NomTheta))
	}

  if ( (qmult>0) && !is.null(RetStat[["DVarYBeta"]]))
    {
    if (all( RetStat[["DVarYBeta"]]==0) ||
        all(is.na(RetStat[["DVarYBeta"]])))
      RetStat[["DVarYBeta"]]  <-  NULL
	else
	{
	RetStat[["DVarYBeta"]][RetStat[["DVarYBeta"]]==codeNa]  <- NA
	     RetStat[["DVarYBeta"]] <-  matrix(RetStat$DVarYBeta,
         ncol=qbase, byrow=TRUE,
         dimnames=list(NomObs,NomBeta))
	}
    }
else
  RetStat[["DVarYBeta"]]  <-  NULL

  if (is.null(RetStat[["Mu3"]]) || all(RetStat[["Mu3"]] == 0)
      || all(is.na(RetStat[["Mu3"]])))
    RetStat[["Mu3"]]  <-  NULL
	else
	{
	RetStat[["Mu3"]] <- as.vector(RetStat[["Mu3"]])
	RetStat[["Mu3"]][RetStat[["Mu3"]]==codeNa]  <- NA
 	names(RetStat[["Mu3"]])  <-  NomObs
	}

  if (is.null(RetStat[["Mu4"]]) || all(RetStat[["Mu4"]] == 0)
      || all(is.na(RetStat[["Mu4"]])))
    RetStat[["Mu4"]]  <-  NULL
	else
	{
	RetStat[["Mu4"]] <- as.vector(RetStat[["Mu4"]])
	RetStat[["Mu4"]][RetStat[["Mu4"]]==codeNa]  <- NA
	names(RetStat[["Mu4"]])  <-  NomObs
	}

  if (is.null(RetStat[["Residus"]]) || all(RetStat[["Residus"]] == 0)
      || all(is.na(RetStat[["Residus"]])))
    RetStat[["Residus"]]  <-  NULL
	else
	{
	RetStat[["Residus"]] <- as.vector(RetStat[["Residus"]])
	RetStat[["Residus"]][RetStat[["Residus"]]==codeNa]  <- NA
	names(RetStat[["Residus"]])  <-  NomObsT[PoidsT!=0]
	}

  if (is.null(RetStat[["ResidusR"]]) || all(RetStat[["ResidusR"]]==0)
      || all(is.na(RetStat[["ResidusR"]])))
    RetStat[["ResidusR"]]  <-  NULL
	else
	{
	RetStat[["ResidusR"]] <- as.vector(RetStat[["ResidusR"]])
	RetStat[["ResidusR"]][RetStat[["ResidusR"]]==codeNa]  <- NA
        names(RetStat[["ResidusR"]])  <-  NomObsT[PoidsT!=0]
	}

  if (is.null(RetStat[["ValW"]]) || all(RetStat[["ValW"]] == 0)
      || all(is.na(RetStat[["ValW"]])))
    RetStat[["ValW"]]  <-  NULL
	else
	{
	RetStat[["ValW"]][RetStat[["ValW"]]==codeNa]  <- NA
	  RetStat[["ValW"]] <-  matrix(RetStat$ValW,
       ncol=acttot, byrow=TRUE)
	}

  if (is.null(RetStat[["ValZ"]]) || all(RetStat[["ValZ"]] == 0)
      || all(is.na(RetStat[["ValZ"]])))
    RetStat[["ValZ"]]  <-  NULL
     else
	{
	RetStat[["ValZ"]] <- as.vector(RetStat[["ValZ"]])
	RetStat[["ValZ"]][RetStat[["ValZ"]]==codeNa]  <- NA
        names(RetStat[["ValZ"]]) <-  rep(NomObs, (nh/k))
	}


return(RetStat)
}





# -------------------------------------------
# recupItnls2: Fonction de recuperation des resultats
# par iterations
#
# Arguments d'entree:
# nbitsv: nombre d'iterations sauvegardees pour l'etape
#   voir notice NL
#   labelct, labelcb: labels des  parametres multiples
# Fonctions appelantes:
#         nls2, renls2
# Programmes C appeles:
#  recupItnls2 recupItSedonls2
# -------------------------------------------
recupItnls2 <- function(ietap, k, pbase,qbase,pmult,qmult,pact,qact,nh,
                     NbEq, NbJ,
                       nbitsv, vouluit,
                       NomObs, NomTheta, NomBeta,
                       NomValInt, NomLesF,
                       labelct, labelcb, codeNa)
{
    VRAI <- 1
    acttot <- pact+qact
    LgSedo  <-  k*NbJ*NbEq
    names(vouluit) <- c("Ajustes",
                 "EquN","Estim","FctSensib","NbIter", "ResNum","Sedo")

    NbIter <-  vector(mode="integer", length=nbitsv)

    if (vouluit["Ajustes"]==VRAI)
      {
      Valf <- vector(mode="double", length=nbitsv*k)
      VarY <- vector(mode="double", length=nbitsv*k)
      }
    else
      {
      Valf <-  vector(mode="double", length=0)
      VarY <-  vector(mode="double", length=0)
      }

    if (vouluit["EquN"]==VRAI)
      {
      ValB <- vector(mode="double", length=nbitsv*nh * acttot)
      ValD <- vector(mode="double", length=nbitsv*nh * acttot)
      ValEta <- vector(mode="double", length= nbitsv*nh)
      }
    else
      {
      ValB <-  vector(mode="double", length=0)
      ValD <-  vector(mode="double", length=0)
      ValEta <-  vector(mode="double", length=0)
      }


    if (vouluit["Estim"]==VRAI)
      {
      Theta <-  vector(mode="double", length=nbitsv*pmult)
      Beta <-  vector(mode="double", length=nbitsv*qmult)
      }
    else
      {
      Theta <-  vector(mode="double", length=0)
      Beta <-  vector(mode="double", length=0)
      }

    if (vouluit["ResNum"]==VRAI)
      {
      Direc <-  vector(mode="double", length=nbitsv*acttot)
      Omega <-  vector(mode="double", length=nbitsv)
      Lambda <-  vector(mode="double", length=nbitsv)
      CritArret <-  vector(mode="double", length=nbitsv)
      CritStat <-  vector(mode="double", length=nbitsv)
      Sigma <-  vector(mode="double", length=nbitsv)
      }
    else
      {
      Direc <-  vector(mode="double", length=0)
      Omega <-  vector(mode="double", length=0)
      Lambda <-  vector(mode="double", length=0)
      CritArret <-  vector(mode="double", length=0)
      CritStat <-  vector(mode="double", length=0)
      Sigma <-  vector(mode="double", length=0)
      }

    if (vouluit["FctSensib"]==VRAI)
      {
      DValf <- vector(mode="double", length=nbitsv*k * pbase)
      DVarYTheta <- vector(mode="double", length=nbitsv*k * pbase)
      DVarYBeta <- vector(mode="double", length=nbitsv*k * qbase)
      }
   else
      {
      DValf <-  vector(mode="double", length=0)
      DVarYTheta <-  vector(mode="double", length=0)
      DVarYBeta <-  vector(mode="double", length=0)
      }

    RetIter <- .C("recupItnls2",
                   ietap=as.integer(ietap),
                   k=as.integer(k),
                   pbase=as.integer(pbase),qbase=as.integer(qbase),
                   pmult=as.integer(pmult),qmult=as.integer(qmult),
                   pact=as.integer(pact),qact=as.integer(qact),
                   nh=as.integer(nh), nbitsv=as.integer(nbitsv),
                   CritArret=as.double(CritArret), CritStat=as.double(CritStat),
                   Lambda=as.double(Lambda), NbIter=as.integer(NbIter),
                   Sigma=as.double(Sigma),
                   Theta=as.double(Theta), Beta=as.double(Beta),
                   Valf=as.double(Valf),  VarY=as.double(VarY),
                   ValB=as.double(ValB), ValD=as.double(ValD), ValEta=as.double(ValEta),
                   DValf=as.double(DValf),
                   DVarYTheta=as.double(DVarYTheta), DVarYBeta=as.double(DVarYBeta),
                   Direc=as.double(Direc), Omega=as.double(Omega))

 if (vouluit["Sedo"]==VRAI)
   {
   FSedo <- vector(mode="double", length= (nbitsv * LgSedo))
   RetItSedo <- .C("recupItSedonls2",
               ietap=as.integer(ietap),
               k=as.integer(k),
               NbEq=as.integer(NbEq),
               NbJ=as.integer(NbJ),
               nbitsv=as.integer(nbitsv),
               FSedo=as.double(FSedo))
   }



# initialisation de la structure en sortie:
# -----------------------------------------
Iter <- list(nb.iters.sv=nbitsv, iter=as.vector(RetIter$NbIter))
lab <- paste("iter", RetIter$NbIter, sep="")
names(Iter[["iter"]]) <- lab

# Suite du remplissage de la sortie:
# --------------------------------
	if (vouluit["Ajustes"]==VRAI)
  {
  if(all(RetIter$Valf==0)) Iter[["response"]]  <-  NULL
	else
	{
	RetIter$Valf[RetIter$Valf == codeNa] <- NA
	  Iter[["response"]]  <- matrix(RetIter$Valf, nrow=nbitsv, byrow=TRUE,
          dimnames=list( lab,NomObs))
	}

  if(all(RetIter$VarY ==0)) Iter[["variance"]]  <-  NULL
	else
	{
	RetIter$VarY[RetIter$VarY == codeNa] <- NA
    Iter[["variance"]] <- matrix(RetIter$VarY,nrow=nbitsv,byrow=TRUE,
          dimnames=list(lab, NomObs))
	}
   }

if (vouluit["EquN"]==VRAI)
  {
  if (all(RetIter$ValB==0)) Iter[["B"]]  <-  NULL
	else
	{
	RetIter$ValB[RetIter$ValB == codeNa] <- NA
        Iter[["B"]] <-  array(RetIter$ValB, dim=c(acttot, nh,nbitsv),
         dimnames=list(NULL,NULL, lab))
	Iter[["B"]] <- aperm(Iter[["B"]], c(3,2,1))
	}
  
  if (all(RetIter$ValD==0)) Iter[["D"]]  <-  NULL
	else
	{
	RetIter$ValD[RetIter$ValD == codeNa] <- NA
	Iter[["D"]] <-  array(RetIter$ValD,dim=c(acttot, nh,nbitsv),
         dimnames=list(NULL,NULL, lab))
	Iter[["D"]] <- aperm(Iter[["D"]], c(3,2,1))
	}
  
  if(all(RetIter$ValEta==0)) Iter[["Eta"]]  <-  NULL
	else
	{
	RetIter$ValEta[RetIter$ValEta  == codeNa] <- NA
	  Iter[["Eta"]] <- matrix(RetIter$ValEta, nrow=nbitsv,byrow=TRUE,
          dimnames=list( lab, rep(NomObs, (nh/k))))
	}
  }
  
if (vouluit["Estim"]==VRAI)
    {
  if(all(RetIter$Theta==0)) Iter[["theta"]]  <-  NULL
	else
	{
	RetIter$Theta[RetIter$Theta  == codeNa] <- NA
	 Iter[["theta"]]  <- matrix(RetIter$Theta,nrow=nbitsv,byrow=TRUE,
          dimnames=list( lab,labelct))
	}



  if (qmult >0)
    {
    if(all(RetIter$Beta==0)) Iter[["beta"]]  <-  NULL
	else
	{
	RetIter$Beta[RetIter$Beta  == codeNa] <- NA
      Iter[["beta"]]  <- matrix(RetIter$Beta,nrow=nbitsv,byrow=TRUE,
          dimnames=list( lab,labelcb))
	}
  }
  else
   Iter[["beta"]]  <-  NULL 

  }

if (vouluit["ResNum"]==VRAI)
  {
  if(all(RetIter$Direc==0)) Iter[["direction"]]  <-  NULL
	else
	{
	RetIter$Direc[RetIter$Direc  == codeNa] <- NA
	Iter[["direction"]]  <- matrix(RetIter$Direc,nrow=nbitsv,byrow=TRUE,
          dimnames=list( lab,NULL))
        # a la 1iere iteration, pas de valeur
	  Iter[["direction"]][1,] <- NA
	}

  Iter[["omega"]] <- as.vector(RetIter$Omega)
  Iter[["omega"]][Iter[["omega"]]  == codeNa] <- NA	
  # a la 1iere iteration, pas de valeur
  Iter[["omega"]][1] <- NA
  names(Iter[["omega"]]) <- lab
  Iter[["lambda"]] <- as.vector(RetIter$Lambda)
  Iter[["lambda"]][Iter[["lambda"]]  == codeNa] <- NA	
  names(Iter[["lambda"]]) <- lab
  Iter[["stop.crit"]] <- as.vector(RetIter$CritArret)
  Iter[["stop.crit"]][Iter[["stop.crit"]]  == codeNa]  <- NA
  names(Iter[["stop.crit"]]) <- lab
  Iter[["stat.crit"]] <- as.vector(RetIter$CritStat)
  Iter[["stat.crit"]][Iter[["stat.crit"]] == codeNa]  <- NA
  names(Iter[["stat.crit"]]) <- lab
  Iter[["sigma2"]] <- as.vector(RetIter$Sigma)
  Iter[["sigma2"]][Iter[["sigma2"]]  == codeNa]  <- NA
  names(Iter[["sigma2"]]) <- lab
  }

if (vouluit["FctSensib"]==VRAI)
  {
  if (all(RetIter$DValf==0)) Iter[["d.resp"]]  <-  NULL
	else
	{
	RetIter$DValf[RetIter$DValf  == codeNa] <- NA	
         Iter[["d.resp"]] <-  array(RetIter$DValf,dim=c(pbase, k,nbitsv),
           dimnames=list(NomTheta,NomObs,lab))
          Iter[["d.resp"]] <- aperm(Iter[["d.resp"]], c(3,2,1))
	}

  if (all(RetIter$DVarYTheta==0))Iter[["d.theta.vari"]]  <-  NULL
	else
	{
	RetIter$DVarYTheta[RetIter$DVarYTheta  == codeNa] <- NA
	  Iter[["d.theta.vari"]] <-  array(RetIter$DVarYTheta,dim=c(pbase, k,nbitsv),
           dimnames=list(NomTheta,NomObs,lab))
	  Iter[["d.theta.vari"]] <- aperm(Iter[["d.theta.vari"]], c(3,2,1))
	}

  
  if(qmult>0)
    {
    if(all(RetIter$DVarYBeta ==0))  Iter[["d.beta.vari"]]   <- NULL
	else
	{
	RetIter$DVarYBeta[RetIter$DVarYBeta == codeNa]  <- NA
        Iter[["d.beta.vari"]] <-  array(RetIter$DVarYBeta,dim=c(qbase, k,nbitsv),
           dimnames=list(NomBeta,NomObs,lab))
        Iter[["d.beta.vari"]] <- aperm(Iter[["d.beta.vari"]], c(3,2,1))
	}
    }
  else
    Iter[["d.beta.vari"]]   <- NULL
  }


if (vouluit["Sedo"]==VRAI)
  {
  if(all(RetItSedo$FSedo==0)) Iter[["FOdes"]]  <-  NULL
	else
	{
	RetItSedo$FSedo[RetItSedo$FSedo == codeNa]  <- NA
	  Iter[["FOdes"]]  <- array(RetItSedo$FSedo,
       dim=c( NbEq,NbJ, k,nbitsv),
       dimnames=list(NomLesF,NomValInt,NomObs,lab))
	  Iter[["FOdes"]]  <- aperm(Iter[["FOdes"]], c(4,3,2,1))
	}
  }
return(Iter)
}

# -------------------------------------------
# recupDivnls2: Fonction de recuperations diverses
#
# Arguments d'entree:
#    ietap: numero de l'etape courante
# Fonctions appelantes:
#         nls2, renls2
# Programmes C appeles:
# recupDivnls2
# -------------------------------------------
recupDivnls2 <- function(ietap)
{
# Recuperations diverses:
# ---------------------
Estim <- as.integer(0)
TypeCritStat <- Famille <- as.integer(0)
NbZ <- as.integer(0)
Effic <- as.integer(0)
Symm <- as.integer(0)
IndiceN <- as.integer(0)
	
RetDiv <- .C("recupDivnls2",
  ietap=as.integer(ietap),
  Estim=as.integer(Estim),
  TypeCritStat=as.integer(TypeCritStat),
  Famille=as.integer(Famille),
	IndiceN=as.integer(IndiceN),
  NbZ=as.integer(NbZ),
  Effic=as.integer(Effic),
  Symm=as.integer(Symm)	)

  listeEstim <- c("MLTB","MLSTB","ERR","MLT","WLST","OLST","MLST","VITWLS","OLSB","MLSB", "QLTB","QLT","QLB","MYOWN")
#	listeEstim <- c("MLTB","MLSTB","ERR","MLT","WLST","OLST","MLST","VITWLS","OLSB","MLSB","MYOWN")
	
listeTypeCritStat <- c(
"equal to -2log(likelihood)", 
"equal to the stopping criterion",
"equal to the non-weighted sum of squares",
"equal to the variance-weighted sum of squares",
"equal to the sum of squares weighted by the intra-repetitions-variance",
"equal to the non-weighted sum of squares in the context of the variance estimation, divided by n",
"equal to sigma**2",
	"", "", "",
"personal criterion")
listeCodeCritStat <-  c("LOGV", "STOPCRIT", "NWSST", "VWSS", "IVWSS",
                          "NWSSB", "SIGMA2","", "", "", "MYOWN")
listeSymm  <-  c("SYM","SYMBLOCK","NONSYM")	
listeFamille <-  c("GAUSS", "POISSON", "BINOM", "BERNOULLI", "MULTINOM")
	
RetDiv$Estim  <-  listeEstim[RetDiv$Estim]
RetDiv$Famille <- listeFamille [RetDiv$Famille]
	lecode <- RetDiv$TypeCritStat
RetDiv$TypeCritStat  <-  listeTypeCritStat[lecode]
RetDiv$CodeCritStat  <-  listeCodeCritStat[lecode]
RetDiv$Symm  <-  listeSymm[RetDiv$Symm]
RetDiv$Effic  <-  as.logical(RetDiv$Effic)
		 
return(RetDiv)
}




# -------------------------------------------
# recupVarinls2: Fonction de recuperation de Vari
#
# Fonctions appelantes:
#         nls2, renls2
# Programmes C appeles:
# recupVarinls2
# -------------------------------------------
recupVarinls2 <- function()
{
# Recuperations diverses:
# ---------------------
Vari <- as.integer(0)
RetVari <- .C("recupVarinls2",
  Vari=as.integer(Vari))

listeVari <- c("CST","SW","VST","VB","VSB","VSTB","VTB","VI")

RetVari$Vari  <-  listeVari[RetVari$Vari]

return(RetVari)
}



# -------------------------------------------
# recupSedonls2: Fonction de recuperation du sedo
#
# Arguments d'entree:
#  voir notice NL et analDer
# Fonctions appelantes:
#         nls2, renls2
# Programmes C appeles:
#  recupSedonls2
# -------------------------------------------
recupSedonls2  <-  function(
         ietap, k, NbEq, NbJ, NbDF, LgDSedo, NomObs, NomTheta, NomValInt, NomLesF, NomLesDF, codeNa)
{
FSedo <- vector(mode="double", length= ( k * NbJ * NbEq))
DFSedo <- vector(mode="double", length= ( k * NbJ * LgDSedo))
  

RetSedo <- .C("recupSedonls2",
                   ietap=as.integer(ietap),
                   k=as.integer(k),
                   NbEq=as.integer(NbEq),
                   NbJ=as.integer(NbJ),
                   Lg=as.integer(LgDSedo),
                   FSedo=as.double(FSedo),
                   DFSedo=as.double(DFSedo))

# Mise selon les bonnes dimensions des sorties:
# --------------------------------------------
NbParam <-  LgDSedo/ NbDF

lab <-  paste(rep(NomLesDF, rep(NbParam, NbDF)),"/", NomTheta[1:NbParam], sep="")

  if(all(RetSedo[["FSedo"]]==0)) RetSedo[["FSedo"]]  <-  NULL
	else
	{
	RetSedo[["FSedo"]][RetSedo[["FSedo"]] == codeNa]  <- NA
	  RetSedo[["FSedo"]] <-  array(RetSedo$FSedo,
       dim=c(NbEq,NbJ,k),
       dimnames=list(NomLesF,NomValInt,NomObs))
	  RetSedo[["FSedo"]] <- aperm(RetSedo[["FSedo"]], c(3,2,1))
	}

  if(all(RetSedo[["DFSedo"]]==0)) RetSedo[["DFSedo"]]  <-  NULL
	else
	{
	RetSedo[["DFSedo"]][RetSedo[["DFSedo"]] == codeNa]  <- NA
	  RetSedo[["DFSedo"]] <-  array(RetSedo$DFSedo,
       dim=c(LgDSedo, NbJ, k),
       dimnames=list( lab,NomValInt,NomObs))
	  RetSedo[["DFSedo"]] <- aperm(RetSedo[["DFSedo"]], c(3,2,1))
	}
return(RetSedo)
}

