# : ### FICHIER renls2.s ###
# ---------------------------------------------------------------
# wantedrenls2: Fonction de mise a jour dans GNLControle
# des indicateurs des calculs supplementaires desires
# 
# Arguments d'entree:
#  control: indique les calculs suppelemntaires desires
#
# Retour fonction:
#  rien
# Appelee par la fonction S: renls2
# Programmes C appeles:
#  crintnls2
# -------------------------------------------------------------------------

wantedrenls2 <-  function(wanted)
{
          #  mettre a faux les composants non mentionns
             
          if (is.null(wanted$sv.fitted))
            wanted$sv.fitted <- F
          if (is.null(wanted$sv.as.var))
            wanted$sv.as.var <- F
          if (is.null(wanted$sv.B.varZ.B))
            wanted$sv.B.varZ.B <- F
          if (is.null(wanted$sv.correlation))
            wanted$sv.correlation <- F
          if (is.null(wanted$sv.data))
            wanted$sv.data <- F
          if (is.null(wanted$sv.est.eq))
            wanted$sv.est.eq <- F

             
          if (is.null(wanted$sv.estim))
            wanted$sv.estim <- F
          if (is.null(wanted$sv.deriv.fct))
            wanted$sv.deriv.fct <- F
          if (is.null(wanted$sv.mu))
            wanted$sv.mu <- F
          if (is.null(wanted$sv.residuals))
             wanted$sv.residuals <- F
          if (is.null(wanted$sv.num.res))
            wanted$sv.num.res <- F
          if (is.null(wanted$sv.odes))
            wanted$sv.odes <- F
          if (is.null(wanted$sv.W))
            wanted$sv.W <- F
          if (is.null(wanted$sv.Z))
            wanted$sv.Z <- F

          crVeuxnls2(wanted)
          return(wanted)

}
# ----------- FIN FONCTION wantedrenls2 ---------------------------


# ---------------------------------------------------------------
# renls2: fonction qui relance NL, sur des valeurs eventuellement
#         differentes de la reponse et des valeurs initiales des
#         parametres
# 
# Arguments d'entree:
#  nls2.object: le retour de l'appel precedent a nls2
#  response: les nouvelles valeurs de la reponse
#  theta.start, beta.start: les nouvelles valeurs initiales des
#         parametres
#  wanted: indique les calculs supplementaires desires
#
# Retour fonction:
#   un nls2.object: voir notice nls2
# Appelee par l'utilisateur
# Fonctions appelees:
#  wantedrenls2
#  recupDatanls2,recupPnls2,recupNumnls2,
#  recupStatnls2,recupDivnls2,recupSedonls2
# Programmes C appeles:
#  initrenls2,calcStatrenls2,steprenls2,otherrenls2
# -------------------------------------------------------------------------

renls2 <- function(nls2.object, 
                response=NULL,
                theta.start=NULL,
                beta.start=NULL,
                sv.fitted=T, sv.as.var=F, sv.B.varZ.B=F,
	     sv.correlation=F, sv.data=T, sv.est.eq=T, sv.estim=T,
                sv.deriv.fct=T,
	     sv.mu=F, sv.residuals=F, sv.num.res=T, sv.odes=T, sv.W=F, sv.Z=F,
                sv.steps=seq(1, nls2.object$nb.steps))
{

# ---------------------------------------------------------------
# Reinitialisation:
# - des structures contenant les valeurs de la reponse
# - des structures contenant les valeurs initiales des parametres
# et recuperation des dimensions
#  par defaut, theta et beta sont les valeurs estimees contenues dans
# le nls2.object
# et la reponse, les valeurs ajustees contenues dans le nls2.object
# et mises en dimension n
# ---------------------------------------------------------------
	
	init <- coef.nls2(nls2.object)
if (is.null(init$theta))
  stop("No estimated values for the parameters in the nls2.object")
if (is.null(theta.start))
  theta.start <- init$theta
if (is.null(beta.start))
  beta.start <- init$beta
if (is.null(beta.start))
  beta.start <- c(0)
if (is.null(response))
   {
# On teste la response par rapport a numeric car si null
# considre response.name

     if (is.null(fitted.nls2(nls2.object)$response) ||
         !is.numeric(fitted.nls2(nls2.object)$response) ||
         is.null(nls2.object$replications))
       stop("The nls2.object contains no fitted values for the response nor data-replications indicator")
   response <-  rep(fitted.nls2(nls2.object)$response, nls2.object$replications)
   verifresp <-  0
   }
else
  verifresp <- 1
LgValY <-  length(response)
NbObsLu <- as.integer(0)
k <- as.integer(0)
n <- as.integer(0)
NbTheta <- as.integer(0)
NbBeta <- as.integer(0)
NbGamF <- as.integer(0)
NbGamV <- as.integer(0)
pmult <- as.integer(0)
qmult <- as.integer(0)
NbEq <- as.integer(0)
NbJ <- as.integer(0)
NbDF <- as.integer(0)
LgDSedo <- as.integer(0)


RetInit <- .C("initrenls2",
   ValY=as.double(response),
   ThetaInit=as.double(theta.start),
   BetaInit=as.double(beta.start),
   LgValY=as.integer(LgValY),
   NbObsLu=as.integer(NbObsLu),
   k=as.integer(k), n=as.integer(n), 
   NbTheta=as.integer(NbTheta),
   NbBeta=as.integer(NbBeta),
   NbGamF=as.integer(NbGamF),
   NbGamV=as.integer(NbGamV),
   pmult=as.integer(pmult),
   qmult=as.integer(qmult),
   NbEq=as.integer(NbEq),
   NbJ=as.integer(NbJ), 
   NbDF=as.integer(NbDF), 
   LgDSedo=as.integer(LgDSedo))


if ( (verifresp==1) && (RetInit$NbObsLu != length(response)))
  stop(paste(
"\nThe length of the response vector (", length(response),
") must be the same than in the last call of the function 'nls2', i.e:",
RetInit$NbObsLu,"\n"))

if (RetInit$pmult != length(theta.start))
  stop(paste(
"\nThe length of 'theta.start' (",length(theta.start),
")  must be the same than in the last call of the function 'nls2', i.e:",
RetInit$pmult,"\n"))

if (RetInit$qmult != 0 && RetInit$qmult != length(beta.start))
  stop(paste(
"\nThe length of 'beta.start' (",length(beta.start),
")  must be the same than in the last call of the function 'nls2', i.e:",
RetInit$qmult,"\n"))


# ---------------------------------------------------------------
#  Repositionnement des indicateurs des calculs supplementaires
#  desires: par defaut, ils ne sont pas effectues
# ---------------------------------------------------------------
	jeveux <- list(sv.fitted= sv.fitted,
             sv.as.var= sv.as.var,
             sv.B.varZ.B=sv.B.varZ.B,
             sv.correlation=sv.correlation,
             sv.data=sv.data,
             sv.est.eq=sv.est.eq,
             sv.estim= sv.estim,
             sv.deriv.fct=sv.deriv.fct,
             sv.mu=sv.mu,
             sv.residuals=sv.residuals,
             sv.num.res=sv.num.res,
             sv.odes=sv.odes,
             sv.W=sv.W,
             sv.Z=sv.Z)
          
wanted <- wantedrenls2(jeveux)

# ---------------------------------------------------------------
# On recalcule les statistiques elementaires:
# Appel de calcStatrenls2:
# ---------------------------------------------------------------
Code <- as.integer(0)
RetStatDon <- .C("calcStatrenls2",
   Code=as.integer(Code))

if(RetStatDon$Code !=0)
  stop(paste("\nError", RetStatDon$Code, 
"in the execution of the program 'calcStatrenls2': no result\n"))


# ---------------------------------------------------------------
# On relance l'estimation de toutes les etapes:
# Appel de steprenls2
# ---------------------------------------------------------------
NbEtapes <- as.integer(0)
vouluit <- vector(mode="integer", length=7)
nbitsv <- vector(mode="integer", length=nls2.object$nb.steps)
pact <-  vector(mode="integer", length=nls2.object$nb.steps)
qact <-  vector(mode="integer", length=nls2.object$nb.steps)
nh <-  vector(mode="integer", length=nls2.object$nb.steps)
NomTheta <- rep("              ",RetInit$NbTheta)
NomBeta <- rep("              ",RetInit$NbBeta)
NomGamF <-  rep("              ", RetInit$NbGamF)
NomGamV  <- rep("              ", RetInit$NbGamV)
NomValInt     <- rep("              ", RetInit$NbJ)
NomLesF     <- rep("              ", RetInit$NbEq)
NomLesDF     <- rep("              ", RetInit$NbDF)


RetStep <- .C("steprenls2",
        NbEtapes=as.integer(NbEtapes),
        vouluit=as.integer(vouluit), nbitsv=as.integer(nbitsv),
        pact=as.integer(pact), qact=as.integer(qact),
        nh=as.integer(nh),
        NomTheta=as.character(NomTheta), NomBeta=as.character(NomBeta),
        NomGamF=as.character(NomGamF), NomGamV=as.character(NomGamV),
        NomValInt=as.character(NomValInt), NomLesF=as.character(NomLesF),
        NomLesDF=as.character(NomLesDF),
        Code=as.integer(Code))


if(RetStep$Code !=0)
  {
  warning(paste("\nError", RetStep$Code, 
"in the execution of the program 'steprenls2': no result\n"))
  return(NULL)
  }

# ---------------------------------------------------------------
# On fait les calculs supplementaires
# Appel de otherrenls2
# ---------------------------------------------------------------

Ret  <-  .C("otherrenls2", Code=as.integer(Code))

if(Ret$Code !=0)
  {
  warning(paste("\nError", Ret$Code,
"in the execution of the program 'otherrenls2': no result\n"))
  return(NULL)
  }


# ---------------------------------------------------------------
# Recuperation des resultats
# ---------------------------------------------------------------

# Recuperation de ce qui concerne les donnees:
# recuperer le code des val. manquantes
codeNa  <-  as.double(0)
codeNa  <-  .C("recupCodeNa", as.double(codeNa))[[1]]

RetDon <- recupDatanls2(RetInit$k, RetInit$NbObsLu, codeNa, wanted$sv.data)
#  PoidsT, NomObs et NomObsT toujours renvoys car necessaire pour recupStat


# Preparation des labels des vecteurs des valeurs estimees des parametres:
labelct  <-  names(theta.start)
if (RetInit$qmult>0)
  labelcb <-  names(beta.start)
else
  labelcb <- NULL

	
# Initialisation de la structure retournee par la fonction renls2:
# ------------------------------------------------------------
renls2.object  <-  list(call=match.call(), 
               response.name=nls2.object$response.name, X.names=nls2.object$X.names,
                  model=nls2.object$model,
                  is.odes=nls2.object$is.odes,
                  nb.steps=RetStep$NbEtapes,
                  stat.ctx=nls2.object$stat.ctx, integ.ctx=nls2.object$integ.ctx)

if (wanted$sv.data == T)
  {
    renls2.object$data.stat  <-  list(Y1=RetDon$Y1, Y2=RetDon$Y2, S2=RetDon$S2)
    renls2.object$replications  <-  RetDon$NbRepet
  }

# Recuperation des resultats par etape:
# ------------------------------------
for (ietap in seq(1:RetStep$NbEtapes))
  {
  # Recuperation des parametres:
    if ( !is.null(wanted$sv.estim) && (wanted$sv.estim == T) &&
        (any(sv.steps) == ietap))
	{
          RetP <-  recupPnls2(ietap,RetInit$pmult,RetInit$qmult, labelct,labelcb, codeNa)
        }
      else
	RetP <-  NULL
    
  # Recuperation de ResNum:
  RetNumrecup <-  recupNumnls2(ietap, RetInit$n, nls2.object$stat.ctx$family,codeNa)
  # ce qu'on garde toujours
  RetNum   <-  list(CodePuss=RetNumrecup$CodePuss, message= RetNumrecup$message,
                  NbIter=RetNumrecup$NbIter)
  # On rajoute le reste seulement si requis
  if (!is.null(wanted$sv.num.res) && (wanted$sv.num.res==T) &&
      (any(sv.steps) == ietap))
    {
      for (comp in names(RetNumrecup))
        {
         RetNum[[comp]]  <-   RetNumrecup[[comp]]
       }
    }
  
  # Recuperation de ResStat:
    if  (any(sv.steps) == ietap )
      RetStat <-  recupStatnls2(wanted, ietap, RetInit$k, RetInit$n,
                       RetInit$NbTheta, RetInit$NbBeta,
                       RetInit$pmult,RetInit$qmult,
                       RetStep$pact[ietap],RetStep$qact[ietap], RetStep$nh[ietap],
                       RetDon$PoidsT, RetDon$NomObs, RetDon$NomObsT, 
                       RetStep$NomTheta, RetStep$NomBeta,
                       labelct, labelcb, codeNa)

  # Recuperations diverses:
  RetDiv <-  recupDivnls2(ietap)

  # Recuperations des valeurs du Sedo:

  if (nls2.object$is.odes && (wanted$sv.odes == T ) &&
      (any(sv.steps) == ietap))
    {
    RetSedo  <-  recupSedonls2(ietap,
         RetInit$k, RetInit$NbEq, RetInit$NbJ, 
         RetInit$NbDF, RetInit$LgDSedo, RetDon$NomObs, 
         RetStep$NomTheta, RetStep$NomValInt, 
         RetStep$NomLesF, RetStep$NomLesDF, codeNa)
  }
  
  # Recuperations des resultats par iteration:
  if (RetStep$nbitsv[ietap]>0)
    {
    RetIt  <- recupItnls2(ietap,
            RetInit$k, RetInit$NbTheta, RetInit$NbBeta,
            RetInit$pmult,RetInit$qmult,RetStep$pact[ietap],RetStep$qact[ietap],
            RetStep$nh[ietap],
            RetInit$NbEq, RetInit$NbJ,
            RetStep$nbitsv[ietap], RetStep$vouluit,
            RetDon$NomObs, RetStep$NomTheta, RetStep$NomBeta,
            RetStep$NomValInt, RetStep$NomLesF,
            labelct, labelcb, codeNa)

    }

  # Mettre les recuperations de l'etape dans le renls2.objet:
  # -------------------------------------------------------
  if (RetStep$NbEtapes == 1)
    {
    RetSorties <- makeListnls2(nls2.object$is.odes, RetStep$nbitsv[ietap],
                              RetDiv,RetNum, RetP, RetStat, RetSedo, RetIt)
    nom <- attributes(RetSorties)$names
    for (i in  1:length(nom))
      {
      renls2.object[[nom[i]]] <- RetSorties[[nom[i]]]
      }
    } # fin du cas 1 etape

  else
    {
    labstep <- paste("step",ietap,sep="")
    renls2.object[[labstep]] <- 
        makeListnls2(nls2.object$is.odes, RetStep$nbitsv[ietap],
                              RetDiv,RetNum, RetP, RetStat, RetSedo, RetIt)
    nom <- attributes(renls2.object[[labstep]])$names
    for (i in  1:length(nom))
      {
      renls2.object[[labstep]][[nom[i]]]  <-  renls2.object[[labstep]][[nom[i]]]
      }
  } # fin etape non unique

  } # fin boucle sur ietap

class(renls2.object) <- "nls2"
return(renls2.object)
invisible()
}
