# : ### FICHIER rexnls2.s ###

# -------------------------------------------
# majRnls2: Fonction de maj des donnees
#
# Arguments d'entree:
#   donnees: le data.frame des donnees
#   NomX: vecteur des noms des va. explicatives
#   NomY: nom de la va. reponse lu dans le fichier 
#         de description formelle du modele
# -------------------------------------------
majRnls2 <-  function(donnees, NomX)
{
# Construire une matrice des variables explicatives:
XObsT  <-  data.matrix(donnees)
n <-  nrow(XObsT)


XObsT  <-  matrix(XObsT[, NomX],nrow=n, byrow=F)
NbObsLu <- as.integer(0)
Code <- as.integer(0)

# Creation  dans la structure de Donnees de NL
RetData <- .C("crDataRnls2", as.double(XObsT), NbLig=as.integer(n), NbCol=as.integer(ncol(XObsT)),
   NbObsLu=as.integer(NbObsLu), Code=as.integer(Code))


if( RetData$Code !=0)
  stop(paste("The length of the data:", n,"should be the same as in the nls2.object:", RetData$NbObsLu, "\n"))


# Arguments facultatifs
#  zero et bidonstr servent a appeler les programmes de creation de vecteurs
#  avec nbele=0
bidonstr <- " "
zero  <- 0
 

# Creation de PoidsT:
if (!is.null(donnees[["weights"]]))
  {
  .C("crvectnls2",  as.character("PoidsT"),
                 as.double(donnees[["weights"]]),
                 n=as.integer(n))
  XObsT  <-  cbind(XObsT, donnees[["weights"]])
  }
else
  {
  .C("crvectnls2",  as.character("PoidsT"),
                 as.double(zero),
                 n=as.integer(zero))
  }

k <- as.integer(0)
n <- as.integer(0)
NbCourbe <- as.integer(0)
NbTheta <- as.integer(0)
NbBeta <- as.integer(0)
NbGamF <- as.integer(0)
NbGamV <- as.integer(0)
pmult <- as.integer(0)
qmult <- as.integer(0)
NbEq <- as.integer(0)
NbJ <- as.integer(0)
NbDF <- as.integer(0)
LgDSedo <- as.integer(0)

# Retour des dimensions:
RetDim <- .C("RetDimnls2",
   k=as.integer(k), n=as.integer(n), 
   NbCourbe=as.integer(NbCourbe),
   NbTheta=as.integer(NbTheta),
   NbBeta=as.integer(NbBeta),
   NbGamF=as.integer(NbGamF),
   NbGamV=as.integer(NbGamV),
   pmult=as.integer(pmult),
   qmult=as.integer(qmult),
   NbEq=as.integer(NbEq),
   NbJ=as.integer(NbJ), 
   NbDF=as.integer(NbDF), 
   LgDSedo=as.integer(LgDSedo))

RetDim$NbObsLu <-  RetData$NbObsLu
return(RetDim)

}
# ----------- FIN FONCTION majRnls2 ---------------------------


# ---------------------------------------------------------------
# rexnls2: fonction qui relance NL, sur des valeurs 
#         differentes des data
# Contraintes:
#  meme nombre d'observations k
# 
# Arguments d'entree:
#  nls2.object: le retour de l'appel precedent a nls2
#  data: les nouvelles data
#  wanted: indique les calculs supplementaires desires
#
# Retour fonction:
#   un nls2.object: voir notice nls2
# -------------------------------------------------------------------------

rexnls2 <- function(nls2.object, data,
                sv.fitted=T, sv.as.var=F, sv.B.varZ.B=F,
	     sv.correlation=F, sv.data=T, sv.est.eq=T, sv.estim=T,
                 sv.deriv.fct=T,
	     sv.mu=F, sv.residuals=F, sv.num.res=T, sv.odes=T, sv.W=F, sv.Z=F,
                sv.steps=seq(1, nls2.object$nb.steps))
{
# ---------------------------------------------------------------
# Reinitialisation:
# - des structures contenant les data
# - des structures contenant les valeurs initiales des parametres
# et recuperation des dimensions
# ---------------------------------------------------------------
RetInit <- majRnls2(data, nls2.object$X.names)

# ---------------------------------------------------------------
#  Repositionnement des indicateurs des calculs supplementaires
#  desires: par defaut, ils ne sont pas effectues
# ---------------------------------------------------------------
wanted <- list(sv.fitted= sv.fitted,
             sv.as.var= sv.as.var,
             sv.B.varZ.B=sv.B.varZ.B,
             sv.correlation=sv.correlation,
             sv.data=sv.data,
             sv.est.eq=sv.est.eq,
             sv.estim= sv.estim,
             sv.deriv.fct=sv.deriv.fct,
             sv.mu=sv.mu,
             sv.residuals=sv.residuals,
             sv.num.res=sv.num.res,
             sv.odes=sv.odes,
             sv.W=sv.W,
             sv.Z=sv.Z)
          
wanted <- wantedrenls2(wanted)

# ---------------------------------------------------------------
# On verifie les donnees et recalcule les statistiques elementaires:
# Appel de nlvdonRnls2
# ---------------------------------------------------------------
Code <- as.integer(0)
RetDon <- .C("nlvdonRnls2",
   Code=as.integer(Code))

if(RetDon$Code !=0)
  stop(paste("\nError", RetDon$Code, 
"in the execution of the program 'nlvdonRnls2': no result\n"))


# ---------------------------------------------------------------
# On relance l'estimation de toutes les etapes:
# Appel de steprenls2
# ---------------------------------------------------------------
NbEtapes <- as.integer(0)
vouluit <- vector(mode="integer", length=7)
nbitsv <- vector(mode="integer", length=nls2.object$nb.steps)
pact <-  vector(mode="integer", length=nls2.object$nb.steps)
qact <-  vector(mode="integer", length=nls2.object$nb.steps)
nh <-  vector(mode="integer", length=nls2.object$nb.steps)
NomTheta <- rep("              ",RetInit$NbTheta)
NomBeta <- rep("              ",RetInit$NbBeta)
NomGamF <-  rep("              ", RetInit$NbGamF)
NomGamV  <- rep("              ", RetInit$NbGamV)
NomValInt     <- rep("              ", RetInit$NbJ)
NomLesF     <- rep("              ", RetInit$NbEq)
NomLesDF     <- rep("              ", RetInit$NbDF)


RetStep <- .C("steprenls2",
        NbEtapes=as.integer(NbEtapes),
        vouluit=as.integer(vouluit), nbitsv=as.integer(nbitsv),
        pact=as.integer(pact), qact=as.integer(qact),
        nh=as.integer(nh),
        NomTheta=as.character(NomTheta), NomBeta=as.character(NomBeta),
        NomGamF=as.character(NomGamF), NomGamV=as.character(NomGamV),
        NomValInt=as.character(NomValInt), NomLesF=as.character(NomLesF),
        NomLesDF=as.character(NomLesDF),
        Code=as.integer(Code))

if(RetStep$Code !=0)
  {
  warning(paste("\nError", RetStep$Code, 
"in the execution of the program 'steprenls2': no result\n"))
  return(NULL)
  }
# ---------------------------------------------------------------
# On fait les calculs supplementaires
# Appel de otherrenls2
# ---------------------------------------------------------------

Ret  <-  .C("otherrenls2", Code=as.integer(Code))

if(Ret$Code !=0)
  {
  warning(paste("\nError", Ret$Code,
"in the execution of the program 'otherrenls2': no result\n"))
  return(NULL)
  }


# ---------------------------------------------------------------
# Recuperation des resultats
# ---------------------------------------------------------------

# Recuperation de ce qui concerne les donnees:
# recuperer le code des val. manquantes
codeNa  <-  as.double(0)
codeNa  <-  .C("recupCodeNa", as.double(codeNa))[[1]]

RetDon <- recupDatanls2(RetInit$k, RetInit$NbObsLu, codeNa, wanted$sv.data)
#  PoidsT, NomObs et NomObsT toujours renvoys car necessaire pour recupStat

# Preparer les labels des sorties:
# -------------------------------
labelcb <- NULL
if (RetInit$NbCourbe > 1)
  {
  labelct  <-  paste(rep(RetStep$NomTheta,RetInit$NbCourbe),
                  rep(seq(1:RetInit$NbCourbe), rep(RetInit$NbTheta,RetInit$NbCourbe)),
                  sep="_c")

  if (RetInit$qmult >0)
    labelcb  <-  paste(rep(RetStep$NomBeta,RetInit$NbCourbe), rep(seq(1:RetInit$NbCourbe),
                 rep(RetInit$NbBeta,RetInit$NbCourbe)),sep="_c")
  }
else
  {
  labelct <- RetStep$NomTheta
  if (RetInit$qmult >0)
    labelcb <- RetStep$NomBeta
  }

# Initialisation de la structure retournee par la fonction:
# ------------------------------------------------------------
renls2.object  <-  list(call=match.call(), 
               response.name=nls2.object$response.name, X.names=nls2.object$X.names,
                  model=nls2.object$model,
                  is.odes=nls2.object$is.odes,
                  nb.steps=RetStep$NbEtapes,
                  stat.ctx=nls2.object$stat.ctx, integ.ctx=nls2.object$integ.ctx)

if (wanted$sv.data == T)
  {
    renls2.object$data.stat  <-  list(Y1=RetDon$Y1, Y2=RetDon$Y2, S2=RetDon$S2)
    renls2.object$replications  <-  RetDon$NbRepet
  }


# Recuperation des resultats par etape:
# ------------------------------------
for (ietap in seq(1:RetStep$NbEtapes))
  {
  # Recuperation des parametres:
    if ( !is.null(wanted$sv.estim) && (wanted$sv.estim == T) &&
        (any(sv.steps) == ietap))
	{
          RetP <-  recupPnls2(ietap,RetInit$pmult,RetInit$qmult, labelct,labelcb, codeNa)
        }
      else
	RetP <-  NULL

  # Recuperation de ResNum:
  RetNumrecup <-  recupNumnls2(ietap, RetInit$n, nls2.object$stat.ctx$family, codeNa)
	
  # ce qu'on garde toujours
  RetNum   <-  list(CodePuss=RetNumrecup$CodePuss, message= RetNumrecup$message,
                  NbIter=RetNumrecup$NbIter)
  # On rajoute le reste seulement si requis
  if (!is.null(wanted$sv.num.res) && (wanted$sv.num.res==T) &&
      (any(sv.steps) == ietap))
    {
      for (comp in names(RetNumrecup))
        {
         RetNum[[comp]]  <-   RetNumrecup[[comp]]
       }
    }
    

  # Recuperation de ResStat:
    if  (any(sv.steps) == ietap )
         RetStat <-  recupStatnls2(wanted, ietap, RetInit$k, RetInit$n,
                       RetInit$NbTheta, RetInit$NbBeta,
                       RetInit$pmult,RetInit$qmult,
                       RetStep$pact[ietap],RetStep$qact[ietap], RetStep$nh[ietap],
                       RetDon$PoidsT, RetDon$NomObs, RetDon$NomObsT, 
                       RetStep$NomTheta, RetStep$NomBeta,
                       labelct, labelcb, codeNa)

    
  # Recuperations diverses:
  RetDiv <-  recupDivnls2(ietap)

  # Recuperations des valeurs du Sedo:

  if (nls2.object$is.odes && (wanted$sv.odes == T ) &&
      (any(sv.steps) == ietap))
    {
    RetSedo  <-  recupSedonls2(ietap,
         RetInit$k, RetInit$NbEq, RetInit$NbJ, 
         RetInit$NbDF, RetInit$LgDSedo, RetDon$NomObs, 
         RetStep$NomTheta, RetStep$NomValInt, 
         RetStep$NomLesF, RetStep$NomLesDF, codeNa)
  }
    
  # Recuperations des resultats par iteration:
  if (RetStep$nbitsv[ietap]>0)
    {
    RetIt  <- recupItnls2(ietap,
            RetInit$k, RetInit$NbTheta, RetInit$NbBeta,
            RetInit$pmult,RetInit$qmult,RetStep$pact[ietap],RetStep$qact[ietap],
            RetStep$nh[ietap],
            RetInit$NbEq, RetInit$NbJ,
            RetStep$nbitsv[ietap], RetStep$vouluit,
            RetDon$NomObs, RetStep$NomTheta, RetStep$NomBeta,
            RetStep$NomValInt, RetStep$NomLesF,
            labelct, labelcb, codeNa)

    }

  # Mettre les recuperations de l'etape dans le renls2.objet:
  # -------------------------------------------------------
  if (RetStep$NbEtapes == 1)
    {
    RetSorties <- makeListnls2(nls2.object$is.odes, RetStep$nbitsv[ietap],
                              RetDiv,RetNum, RetP, RetStat, RetSedo, RetIt)
    
    nom <- attributes(RetSorties)$names
    for (i in  1:length(nom))
      {
      renls2.object[[nom[i]]] <- RetSorties[[nom[i]]]
      }
    } # fin du cas 1 etape

  else
    {
    labstep <- paste("step",ietap,sep="")
    renls2.object[[labstep]] <- 
        makeListnls2(nls2.object$is.odes, RetStep$nbitsv[ietap],
                              RetDiv,RetNum, RetP, RetStat, RetSedo, RetIt)
    nom <- attributes(renls2.object[[labstep]])$names
    for (i in  1:length(nom))
      {
      renls2.object[[labstep]][[nom[i]]]  <-  renls2.object[[labstep]][[nom[i]]]
      }
    } # fin etape non unique

  } # fin boucle sur ietap

class(renls2.object) <- "nls2"

return(renls2.object)
invisible()
}
