# : ### FICHIER summary.nls2.s ###

summarystepnls2 <- function(object)
{
#  Extraire les resultats principaux d'une etape  d'un nls2.object

sumy <- list(  message=object$message, 
               method=object$method, 
		stat.crit.type=object$stat.crit.type,
               nb.iters=object$nb.iters, stop.crit=object$stop.crit, 
               stat.crit=object$stat.crit,
	       deviance=object$deviance,
               lambda=object$lambda, sigma2=object$sigma2, 
               rss=object$rss, rss.unweighted=object$rss.unweighted,
               theta=object$theta, beta=object$beta)
	if ( !is.null(object$as.var) && !all(is.na(object$as.var)))
  {
  sumy$std.error <-sqrt(diag(object$as.var))
  names(sumy$std.error) <-  dimnames(object$as.var)[[1]]
  }
for (comp in names(sumy))
        {
        if (is.null(sumy[[comp]])) sumy[[comp]] <- NULL
       }

return(sumy)
invisible()
}


summary.nls2<-function(nls2.object)
{
#  Extraire les resultats principaux d'un nls2.object

  sumy <- list(
               algorithm=nls2.object$stat.ctx$algorithm,
               sigma2.type=nls2.object$stat.ctx$sigma2.type,
               vari.type=nls2.object$model$vari.type, 
               message=nls2.object$message, 
               method=nls2.object$method, family=nls2.object$stat.ctx$family,
		stat.crit.type=nls2.object$stat.crit.type,
               nb.iters=nls2.object$nb.iters, stop.crit=nls2.object$stop.crit, 
               stat.crit=nls2.object$stat.crit,
               lambda=nls2.object$lambda, sigma2=nls2.object$sigma2,
	       deviance=nls2.object$deviance,
               rss=nls2.object$rss, rss.unweighted=nls2.object$rss.unweighted,
               theta=nls2.object$theta, 
               beta=nls2.object$beta)


               if (!is.null(nls2.object$replications))
    {
      sumy$k  <-  length(nls2.object$replications)

      sumy$n  <-  sum(nls2.object$replications)
    }
  

 class(sumy) <- "summary.nls2"

if (nls2.object$nb.steps ==1)
  {
  if (!is.null(nls2.object$as.var) &&  !all(is.na(nls2.object$as.var)))
    {
    sumy$std.error <-sqrt(diag(nls2.object$as.var))
    names(sumy$std.error) <-  dimnames(nls2.object$as.var)[[1]]
    }
  }
else
  {
  for (i in (1:nls2.object$nb.steps))
    {
    switch(i,
      sumy[["step1"]] <- summarystepnls2(nls2.object$step1),
      sumy[["step2"]] <- summarystepnls2(nls2.object$step2),
      sumy[["step3"]] <- summarystepnls2(nls2.object$step3)
          )
     }
} # fin pls etapes
# On enleve les composants nuls
for (comp in names(sumy))
        {
        if (is.null(sumy[[comp]])) sumy[[comp]] <- NULL
       }
  
sumy
}
