      SUBROUTINE E04HBF(N,SFUN,X,NF,DELTA,HESL,LH,HESD,F,G,IW,LIW,W,LW,
     *                  IFAIL)
C
C     MARK 6 RELEASE NAG COPYRIGHT 1977
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C
C     **************************************************************
C
C     E04HBF COMPUTES A SENSIBLE SET OF FINITE-DIFFERENCE INTERVALS
C     FOR INPUT TO A QUASI-NEWTON MINIMIZATION ROUTINE WHICH DOES
C     NOT REQUIRE DERIVATIVES.
C
C     THE ROUTINE IS ESSENTIALLY IDENTICAL TO THE SUBROUTINE FRMDEL
C     IN THE NPL ALGORITHMS LIBRARY (REF. NO. E4/06/F). W(I), I = 1,
C     2, . . . , 2*N ARE USED AS WORKING SPACE. (NOTE THAT, FOR
C     CONSISTENCY WITH OTHER E04 DOCUMENTATION, THE NAME FUNCT IS
C     USED INSTEAD OF SFUN IN THE WRITE-UP.)
C
C     PHILIP E. GILL, ENID M. R. LONG, WALTER MURRAY, SUSAN M.
C     PICKEN, D.N.A.C., NATIONAL PHYSICAL LABORATORY, ENGLAND.
C
C     **************************************************************
C
C     SFUN
C
C     TEST TO CHECK CORRECT INPUT.
C
C     .. Parameters ..
      CHARACTER*6       SRNAME
      PARAMETER         (SRNAME='E04HBF')
C     .. Scalar Arguments ..
      DOUBLE PRECISION  F
      INTEGER           IFAIL, LH, LIW, LW, N, NF
C     .. Array Arguments ..
      DOUBLE PRECISION  DELTA(N), G(N), HESD(N), HESL(LH), W(LW), X(N)
      INTEGER           IW(LIW)
C     .. Subroutine Arguments ..
      EXTERNAL          SFUN
C     .. Local Scalars ..
      DOUBLE PRECISION  ABFMID, ABGI, CNCERR, DI, EPSMCH, ERRMAX,
     *                  ERRSUM, FBACK, FFORW, FMID, GI, GMAX, GSUM, H,
     *                  HTRY, RCNERR, RPGERR, XI
      INTEGER           I, N1, NWHY
C     .. Local Arrays ..
      CHARACTER*1       P01REC(1)
C     .. External Functions ..
      DOUBLE PRECISION  X02AJF
      INTEGER           P01ABF
      EXTERNAL          X02AJF, P01ABF
C     .. Intrinsic Functions ..
      INTRINSIC         ABS, SQRT
C     .. Executable Statements ..
      IF (N.GE.1 .AND. LW.GE.2*N .AND. LH.GE.N*(N-1)
     *    /2 .AND. LH.GT.0 .AND. LIW.GT.0) GO TO 20
      NWHY = 1
      GO TO 200
   20 CONTINUE
C
C     A MACHINE-DEPENDENT CONSTANT IS SET HERE. EPSMCH IS THE
C     SMALLEST POSITIVE REAL NUMBER SUCH THAT 1.0 + EPSMCH .GT. 1.0
C
      EPSMCH = X02AJF()
C
C     EVALUATE THE FUNCTION AT X
C
      NF = 1
      NWHY = 0
      CALL SFUN(NWHY,N,X,F,G,IW,LIW,W,LW)
      IF (NWHY.LT.0) GO TO 200
      FMID = F
      ERRSUM = 0.0D+0
      GSUM = 0.0D+0
      GMAX = 0.0D+0
      ERRMAX = 0.0D+0
      ABFMID = ABS(FMID)
C
C     COMPUTE TRIAL STEP FOR THE SECOND DERIVATIVES.
C
      HTRY = 3.0D+1*SQRT(EPSMCH*(4.0D+0*ABFMID+1.0D+0))
C
C     COMPUTE VECTOR G SUCH THAT G(I) = F(X + HTRY*EI) AND VECTOR IN
C     W SUCH THAT W(I) = F(X - HTRY*EI).
C
      DO 40 I = 1, N
         XI = X(I)
         X(I) = XI + HTRY
         NF = NF + 1
         NWHY = 0
         CALL SFUN(NWHY,N,X,G(I),W(N+1),IW,LIW,W,LW)
         IF (NWHY.LT.0) GO TO 200
         NF = NF + 1
         X(I) = XI - HTRY
         NWHY = 0
         CALL SFUN(NWHY,N,X,W(I),W(N+1),IW,LIW,W,LW)
         IF (NWHY.LT.0) GO TO 200
         X(I) = XI
   40 CONTINUE
C
C     BEGIN LOOP OVER N VARIABLES.
C
      DO 80 I = 1, N
         FFORW = G(I)
         FBACK = W(I)
C
C        COMPUTE THE ABSOLUTE VALUE OF THE FINITE-DIFFERENCE
C        APPROXIMATION TO THE SECOND DERIVATIVE.
C
         DI = ABS(FFORW+FBACK-2.0D+0*FMID)/(HTRY*HTRY)
         HESD(I) = DI
C
C        IF THE ESTIMATED SECOND DERIVATIVE IS LESS THAN 0.01 THEN 0.01
C        IS TAKEN AS A BOUND ON THE SECOND DERIVATIVE.
C
         IF (DI.GE.1.0D-2) GO TO 60
         DI = 1.0D-2
         HESD(I) = DI
C
C        COMPUTE THE CENTRAL-DIFFERENCE APPROXIMATION TO THE GRADIENT.
C
   60    GI = (FFORW-FBACK)/(HTRY+HTRY)
         G(I) = GI
C
C        COMPUTE OPTIMUM STEP WHICH APPROXIMATELY BALANCES CANCELLATION
C        ERROR AND TRUNCATION ERROR.
C
         H = SQRT(6.0D+0*EPSMCH*(4.0D+0*ABFMID+1.0D+0)/DI)
         DELTA(I) = H
C
C        COMPUTE THE ABSOLUTE CANCELLATION ERROR.
C
         CNCERR = EPSMCH*(3.0D+0*(2.0D+0*ABFMID+1.0D+0)/H+1.0D+0)
         W(I) = CNCERR
         ABGI = ABS(GI)
C
C        COMPUTE THE CONTRIBUTIONS TO THE ORDER OF MAGNITUDE AND
C        APPROXIMATE ABSOLUTE CANCELLATION ERROR IN THE PROJECTED
C        GRADIENT ASSOCIATED WITH THE FIRST ITERATION OF THE
C        QUASI-NEWTON METHOD.
C
         ERRSUM = ERRSUM + ABGI*CNCERR/DI
         GSUM = GSUM + GI*GI/DI
C
C        COMPUTE THE CONTRIBUTIONS TO THE INFINITY NORMS OF G AND THE
C        VECTOR OF CANCELLATION ERRORS.
C
         IF (ABGI.GT.GMAX) GMAX = ABGI
         IF (CNCERR.GT.ERRMAX) ERRMAX = CNCERR
   80 CONTINUE
C
C     COMPUTE THE OVERALL RELATIVE CANCELLATION ERROR IN THE
C     CENTRAL-DIFFERENCE APPROXIMATION TO THE GRADIENT. THIS ERROR
C     CANNOT BE GREATER THAN UNITY AND THIS FACT CAN BE USED TO
C     PREVENT OVERFLOW.
C
      IF (ERRMAX.LT.EPSMCH) ERRMAX = EPSMCH
      IF (ERRSUM.LT.EPSMCH) ERRSUM = EPSMCH
      GMAX = 2.0D+0*GMAX
      RCNERR = 1.0D+0
      IF (ERRMAX.LE.GMAX) RCNERR = ERRMAX/GMAX
      RPGERR = 1.0D+0
      IF (ERRSUM.LE.GSUM) RPGERR = ERRSUM/GSUM
C
C     IF THE RELATIVE CANCELLATION ERROR OR RELATIVE ERROR IN THE
C     PROJECTED GRADIENT IS GREATER THAN 0.1 THEN THE CENTRAL
C     DIFFERENCES ARE RECOMPUTED WITH A LARGER VALUE OF H.
C
      NWHY = 0
      IF (RCNERR.LE.1.0D-1 .AND. RPGERR.LE.1.0D-1) GO TO 140
C
C     SIGNIFICANT CANCELLATION ERROR HAS BEEN MADE. INCREASE THE
C     VALUE OF H AND COMPUTE NEW CENTRAL DIFFERENCES FOR THOSE
C     COMPONENTS WITH RELATIVE CANCELLATION ERROR GREATER THAN 0.1.
C
      ERRSUM = 0.0D+0
      GSUM = 0.0D+0
      GMAX = 0.0D+0
      ERRMAX = 0.0D+0
      DO 120 I = 1, N
         GI = G(I)
         ABGI = ABS(GI)
         DI = HESD(I)
         CNCERR = W(I)
         RCNERR = 1.0D+0
         IF (CNCERR.LE.ABGI) RCNERR = CNCERR/ABGI
         IF (RCNERR.LE.1.0D-1) GO TO 100
C
C        COMPUTE CENTRAL DIFFERENCES FOR THIS COMPONENT.
C
         H = DELTA(I)
         H = H**0.6666D+0
         XI = X(I)
         X(I) = XI + H
         NWHY = 0
         CALL SFUN(NWHY,N,X,F,G,IW,LIW,W,LW)
         IF (NWHY.LT.0) GO TO 200
         FFORW = F
         X(I) = XI - H
         NWHY = 0
         CALL SFUN(NWHY,N,X,F,G,IW,LIW,W,LW)
         IF (NWHY.LT.0) GO TO 200
         FBACK = F
         NF = NF + 2
         X(I) = XI
         GI = (FFORW-FBACK)/(H+H)
         G(I) = GI
         ABGI = ABS(GI)
C
C        RECOMPUTE THE CANCELLATION ERROR IN THE GRADIENT.
C
         CNCERR = EPSMCH*(3.0D+0*(2.0D+0*ABFMID+1.0D+0)/H+1.0D+0)
C
C        NOTE THAT THE VALUE OF DELTA(I) IS LEFT UNALTERED.
C
C        RECOMPUTE THE CONTRIBUTIONS TO THE ORDER OF MAGNITUDE AND
C        ERROR OF THE PROJECTED GRADIENT.
C
  100    ERRSUM = ERRSUM + ABGI*CNCERR/DI
         GSUM = GSUM + GI*GI/DI
         IF (ABGI.GT.GMAX) GMAX = ABGI
         IF (CNCERR.GT.ERRMAX) ERRMAX = CNCERR
  120 CONTINUE
      IF (ERRMAX.LT.EPSMCH) ERRMAX = EPSMCH
      IF (ERRSUM.LT.EPSMCH) ERRSUM = EPSMCH
      GMAX = 2.0D+0*GMAX
      RCNERR = 1.0D+0
      IF (ERRMAX.LE.GMAX) RCNERR = ERRMAX/GMAX
      RPGERR = 1.0D+0
      IF (ERRSUM.LE.GSUM) RPGERR = ERRSUM/GSUM
C
C     IF THE OVERALL CANCELLATION ERROR IN THE GRADIENT OR ERROR IN
C     THE PROJECTED GRADIENT IS STILL LARGER THAN 0.1 THEN SET THE
C     ERROR FLAG.
C
      NWHY = 0
      IF (RCNERR.LE.1.0D-1 .AND. RPGERR.LE.1.0D-1) GO TO 140
      NWHY = 2
  140 N1 = N*(N-1)/2
      IF (N1.EQ.0) GO TO 180
      DO 160 I = 1, N1
         HESL(I) = 0.0D+0
  160 CONTINUE
  180 F = FMID
  200 IF (NWHY.NE.0) GO TO 220
      IFAIL = 0
      RETURN
  220 IFAIL = P01ABF(IFAIL,NWHY,SRNAME,0,P01REC)
      RETURN
C
C     END OF E04HBF (FRMDEL)
C
      END
