# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("beetles")

cat("\n#------------------------------------------------------")
cat("\n# paragraphe 6.7")
cat("\n#------------------------------------------------------")

cat("\n ---------------------------")
cat("\n Beetles example ") 
cat("\n ---------------------------")
cat("\n Parameters estimation ") 
cat("\n\n") 

# ------------------------------------------------------------
# Creation of the model -evaluation programs
lesystem(paste(.Nls2dir, "/analDer ", beetles.m, " >beetles.m.c",  sep=""))
lesystem(paste(.Nls2dir, "/analDer ", beetles.mw, " >beetles.mw.c",  sep=""))
lesystem(paste(.Nls2dir, "/analDer ", beetles.mLD90, " >beetles.mLD90.c", sep=""))
# ------------------------------------------------------------

nomlib <- loadnls2("beetles.m.c")

ctx <- list(theta.start=c(0,0,1), sigma2.type="KNOWN", sigma2=1,
        nameN="n", family="binomial")
model <- list(file=beetles.m,eq.theta=c(NaN,NaN,1))
beetles.nl1 <- nls2(beetles, model,ctx,method="QLT",
	 control=list(freq=0))
cat( "\nResult of the estimation process:\n ")
print(summary(beetles.nl1))
cat( "\nvalue of the minimum deviance:\n ")
print(beetles.nl1$deviance)
ctx$theta.start <- beetles.nl1$theta
beetles.nl2 <- nls2(beetles, beetles.m, ctx, method="QLT",
	control=list(freq=0))
cat( ":\nLogit model:\n")
cat( "Result of the estimation process:\n")
print(summary(beetles.nl2))
cat( "\nvalue of the minimum deviance:\n ")
print(beetles.nl2$deviance)

cat( "\nTesting nested models")
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("beetles.mw.c")

ctx$theta.start <- c(0,0)
beetles.nl3 <- nls2(beetles, beetles.mw,ctx,method="QLT")
cat( ":\ncloglog model:\n")
cat( "Result of the estimation process:\n")
print(summary(beetles.nl3))
cat( "\nvalue of the minimum deviance:\n ")
print(beetles.nl3$deviance)


cat( "\nvalue of the minimum deviance\n ")
cat( "under the general hypothesis:\n ")
print(beetles.nl1$deviance)
cat( "\nvalue of the minimum deviance\n ")
cat( "under the logit hypothesis:\n ")
print(beetles.nl2$deviance)
cat( "SL:", 
    (beetles.nl1$deviance - beetles.nl2$deviance),
    "X2(0.95,1):",  qchisq(0.95,1), "\n\n")
cat( "\nvalue of the minimum deviance\n ")
cat( "under the cloglog hypothesis:\n ")
print(beetles.nl3$deviance)
cat( "SL:", 
    (beetles.nl1$deviance - beetles.nl3$deviance),
    "X2(0.95,1):",  qchisq(0.95,1), "\n\n")

cat("\nConfidence interval for the LD90\n")
ctx$theta.start <- c(70,0.2)
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
nomlib <- loadnls2("beetles.mLD90.c")
beetles.nl4 <- nls2(beetles, beetles.mLD90, ctx, method="QLT")
LD90 <- beetles.nl4$theta[1]
cat("\nEstimated value of LD90:", LD90,"\n" )
cat("Estimated value of S:", 
       summary(beetles.nl4)$std.error[1],"\n")
se.LD90 <- summary(beetles.nl4)$std.error[1]
grid <- seq(LD90-3*se.LD90,LD90+3*se.LD90,length=50)
Diff <- rep(0,length(grid))
options(warn=-1)
for (l in 1:length(grid)) {
  ctx$theta.start <- c(grid[l],beetles.nl4$theta[2])
  model <- list(file=beetles.mLD90, eq.theta=c(grid[l],NaN))
  Diff[l] <- nls2(beetles, model, ctx, method="QLT")$deviance
 }
ind1 <- 1:(length(grid)/2)
ind2 <- (length(grid)/2):length(grid)
LD90Inf <- approx( Diff[ind1]-beetles.nl3$deviance,
                     grid[ind1], xout=3.84)$y
LD90Sup <- approx( Diff[ind2]-beetles.nl3$deviance,
                     grid[ind2],xout=3.84)$y
cat("\n95% Confidence Interval:\n")
print(cbind(LD90Inf,LD90,LD90Sup))


cat("\n Some plot\n")

if (interactive()) {X11(); (ask.pause <- T)} else { postscript(file="beetles.ps"); (ask.pause <- F)  }
par (ask=ask.pause)

par(cex=1.5)
plot(grid, Diff-beetles.nl3$deviance,type="l",las=1,xlab="",ylab="")
abline(b=0,a=3.84,lty=2)
lines(rep(LD90Inf,2),c(-0.5,3.84))
lines(rep(LD90Sup,2),c(-0.5,3.84))
par(las=1)
if (is.R()) {
mtext(text=expression(italic(D)[bolditalic(l)]),side=2,cex=1.5,line=2,at=11)
mtext(text=expression(LD90[bolditalic(l)]),side=1,cex=1.5,line=3,at=69)
} else {
mtext(text="D(l)", side=2,cex=1.5,line=2,at=11)
mtext(text="LD90(l)", side=1,cex=1.5,line=3,at=69)
}
options(warn=0)
if (!interactive()) dev.off()
if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}

# End of file
# +++++++++++++++++++++++++++++++++++++++++++++

