# Acces the functions:
library(nls2,lib.loc="NLS2LOC")

# Access the data:
data("ej")


# --------------------------------------------------------------------
# - `ej': example of estimation on 3 models that have common parameters. 
#   Each model is calculated on a particular subset of data:
# 2 are calculated by C-programs automatically generated,
# the 3rd model is calculated by a Fortran program that calls
#  Nag subroutines. 
#   Used functions: 
#     . `nls2'
# A message is issued:
# An error has occurred when calculating the direction
# --------------------------------------------------------------------



#	The initial values of the "communs":	
#	-----------------------------------	
yinit <-
       c(0.057033469999999996, 0.0085287866666666681, 0.0084329133333333334, 
	0.0084027066666666674, 0.0067676066666666661, 0.0060334533333333334, 
	0.0048370066666666668, 0.0044817499999999996, 0.003291213333333333, 
	0.002894586666666667)
xa2 <- 66.66666667
xh <- 5.e-3

#	The initial values of the parameters:
#	-------------------------------------
theta0 <-c(0.5633981, 0.05859707, 1.96621, 0.3759443, 0.05703357, 0.003393206, 10100)
names(theta0) <- c("ka","r0", "k1", "kl", "l0", "ns", "alpha")


# ------------------------------------------------------

# ------------------------------------------------------------------------
lesprog <- paste(
	paste(ej.mod,".c", sep=""),
	paste(ej.modscat,".c", sep=""),
	paste(ej.modeli,".c", sep=""),
	paste(ej.inhib.m, ".f", sep=""),
	paste(ej.e04hbft, ".f", sep=""))

nomlib <- loadnls2(lesprog, lib="-L/usr/lib/fllux20dgl  -lnag -lpthread")
	
# ------------------------------------------------------
# nls2
# ---------------------------------------------------------------

  # Estimation for the three models together:
  # -----------------------------------------
  z<-.Fortran("initcommon",as.double(yinit), as.double(xh), as.double(xa2),
              as.integer(length(yinit))) 
  ej.nls2 <-nls2(ej,
     list(file=ej.mod, gamf=c(0.1, 0.2)),
     stat.ctx=list(theta.start=theta0, max.iters=100))
  print(ej.nls2)

if (!is.null(nomlib)) { if (is.R()) dyn.unload(nomlib) else dyn.close(nomlib)}
# End of file
# +++++++++++++++++++++++++++++++++++++++++++++
